"""Ajout bassin d’air

Revision ID: 12c481be6cd3
Revises: 95374aa73395
Create Date: 2021-05-26 14:32:50.061869

"""
from alembic import op
import sqlalchemy as sa
from itertools import groupby


# revision identifiers, used by Alembic.
revision = '12c481be6cd3'
down_revision = '95374aa73395'
branch_labels = None
depends_on = None


def upgrade():
    codes_bassins_dair = set([b['zone'] for b in bassins_dair])
    zone_table = sa.Table(
        "zone",
        sa.MetaData(),
        sa.Column("type", sa.String()),
        sa.Column("code", sa.Integer),
        schema="indice_schema"
    )
    op.bulk_insert(
        zone_table,
        [
            {
                "type": "bassin_dair",
                "code": code
            }
            for code in codes_bassins_dair
        ]
    )
    zones_bassins_dair = dict(op.get_bind().execute("SELECT code, id FROM indice_schema.zone WHERE type='bassin_dair'").fetchall())
    for code, insees in groupby(bassins_dair, lambda b: b['zone']):
        op.get_bind().execute(
            sa.text(
                """
                UPDATE indice_schema.commune
                SET zone_pollution_id = :zone
                WHERE insee = ANY(:communes)
                """
            ),
            zone=zones_bassins_dair[code],
            communes=[b['commune'] for b in insees]
        )
    op.execute(
        """
        UPDATE indice_schema.commune c
        SET zone_pollution_id = 
            (
                SELECT z.id 
                FROM indice_schema.zone z 
                    JOIN indice_schema.departement d 
                    ON z.code = d.code
                WHERE type = 'departement' AND d.id = c.departement_id
            )
        WHERE zone_pollution_id IS NULL
        """
    )
        



def downgrade():
    op.execute("UPDATE indice_schema.commune SET zone_pollution_id = NULL")
    op.execute("DELETE FROM indice_schema.zone WHERE type='bassin_dair'")

bassins_dair = [
    {'commune': '01001', 'zone': '2006'},
    {'commune': '01002', 'zone': '2006'},
    {'commune': '01004', 'zone': '2006'},
    {'commune': '01005', 'zone': '2006'},
    {'commune': '01006', 'zone': '2016'},
    {'commune': '01007', 'zone': '2006'},
    {'commune': '01008', 'zone': '2006'},
    {'commune': '01009', 'zone': '2016'},
    {'commune': '01010', 'zone': '2016'},
    {'commune': '01011', 'zone': '2016'},
    {'commune': '01012', 'zone': '2016'},
    {'commune': '01013', 'zone': '2016'},
    {'commune': '01014', 'zone': '2016'},
    {'commune': '01015', 'zone': '2016'},
    {'commune': '01016', 'zone': '2006'},
    {'commune': '01017', 'zone': '2016'},
    {'commune': '01019', 'zone': '2016'},
    {'commune': '01021', 'zone': '2006'},
    {'commune': '01022', 'zone': '2016'},
    {'commune': '01023', 'zone': '2006'},
    {'commune': '01024', 'zone': '2006'},
    {'commune': '01025', 'zone': '2006'},
    {'commune': '01026', 'zone': '2006'},
    {'commune': '01027', 'zone': '2006'},
    {'commune': '01028', 'zone': '2006'},
    {'commune': '01029', 'zone': '2006'},
    {'commune': '01030', 'zone': '2006'},
    {'commune': '01031', 'zone': '2016'},
    {'commune': '01032', 'zone': '2006'},
    {'commune': '01033', 'zone': '2001'},
    {'commune': '01034', 'zone': '2016'},
    {'commune': '01035', 'zone': '2016'},
    {'commune': '01036', 'zone': '2016'},
    {'commune': '01037', 'zone': '2016'},
    {'commune': '01038', 'zone': '2006'},
    {'commune': '01039', 'zone': '2016'},
    {'commune': '01040', 'zone': '2006'},
    {'commune': '01041', 'zone': '2006'},
    {'commune': '01042', 'zone': '2006'},
    {'commune': '01043', 'zone': '2006'},
    {'commune': '01044', 'zone': '2001'},
    {'commune': '01045', 'zone': '2006'},
    {'commune': '01046', 'zone': '2006'},
    {'commune': '01047', 'zone': '2006'},
    {'commune': '01049', 'zone': '2006'},
    {'commune': '01050', 'zone': '2006'},
    {'commune': '01051', 'zone': '2016'},
    {'commune': '01052', 'zone': '2006'},
    {'commune': '01053', 'zone': '2006'},
    {'commune': '01054', 'zone': '2006'},
    {'commune': '01056', 'zone': '2006'},
    {'commune': '01057', 'zone': '2006'},
    {'commune': '01058', 'zone': '2016'},
    {'commune': '01060', 'zone': '2016'},
    {'commune': '01061', 'zone': '2016'},
    {'commune': '01062', 'zone': '2006'},
    {'commune': '01063', 'zone': '2016'},
    {'commune': '01064', 'zone': '2016'},
    {'commune': '01065', 'zone': '2006'},
    {'commune': '01066', 'zone': '2016'},
    {'commune': '01067', 'zone': '2016'},
    {'commune': '01068', 'zone': '2006'},
    {'commune': '01069', 'zone': '2006'},
    {'commune': '01071', 'zone': '2001'},
    {'commune': '01072', 'zone': '2006'},
    {'commune': '01073', 'zone': '2016'},
    {'commune': '01074', 'zone': '2006'},
    {'commune': '01075', 'zone': '2006'},
    {'commune': '01076', 'zone': '2016'},
    {'commune': '01077', 'zone': '2006'},
    {'commune': '01078', 'zone': '2001'},
    {'commune': '01079', 'zone': '2016'},
    {'commune': '01080', 'zone': '2016'},
    {'commune': '01081', 'zone': '2001'},
    {'commune': '01082', 'zone': '2001'},
    {'commune': '01083', 'zone': '2006'},
    {'commune': '01084', 'zone': '2006'},
    {'commune': '01085', 'zone': '2006'},
    {'commune': '01087', 'zone': '2016'},
    {'commune': '01088', 'zone': '2006'},
    {'commune': '01089', 'zone': '2006'},
    {'commune': '01090', 'zone': '2006'},
    {'commune': '01092', 'zone': '2006'},
    {'commune': '01093', 'zone': '2006'},
    {'commune': '01094', 'zone': '2006'},
    {'commune': '01095', 'zone': '2006'},
    {'commune': '01096', 'zone': '2006'},
    {'commune': '01098', 'zone': '2016'},
    {'commune': '01099', 'zone': '2006'},
    {'commune': '01100', 'zone': '2016'},
    {'commune': '01101', 'zone': '2016'},
    {'commune': '01102', 'zone': '2006'},
    {'commune': '01103', 'zone': '2001'},
    {'commune': '01104', 'zone': '2001'},
    {'commune': '01105', 'zone': '2006'},
    {'commune': '01106', 'zone': '2006'},
    {'commune': '01107', 'zone': '2016'},
    {'commune': '01108', 'zone': '2006'},
    {'commune': '01109', 'zone': '2001'},
    {'commune': '01110', 'zone': '2016'},
    {'commune': '01111', 'zone': '2016'},
    {'commune': '01112', 'zone': '2016'},
    {'commune': '01113', 'zone': '2006'},
    {'commune': '01114', 'zone': '2001'},
    {'commune': '01115', 'zone': '2006'},
    {'commune': '01116', 'zone': '2016'},
    {'commune': '01117', 'zone': '2016'},
    {'commune': '01118', 'zone': '2016'},
    {'commune': '01121', 'zone': '2016'},
    {'commune': '01123', 'zone': '2006'},
    {'commune': '01124', 'zone': '2006'},
    {'commune': '01125', 'zone': '2006'},
    {'commune': '01127', 'zone': '2006'},
    {'commune': '01128', 'zone': '2006'},
    {'commune': '01129', 'zone': '2006'},
    {'commune': '01130', 'zone': '2006'},
    {'commune': '01133', 'zone': '2016'},
    {'commune': '01134', 'zone': '2006'},
    {'commune': '01135', 'zone': '2001'},
    {'commune': '01136', 'zone': '2006'},
    {'commune': '01138', 'zone': '2016'},
    {'commune': '01139', 'zone': '2006'},
    {'commune': '01140', 'zone': '2006'},
    {'commune': '01141', 'zone': '2016'},
    {'commune': '01142', 'zone': '2006'},
    {'commune': '01143', 'zone': '2001'},
    {'commune': '01145', 'zone': '2006'},
    {'commune': '01146', 'zone': '2006'},
    {'commune': '01147', 'zone': '2006'},
    {'commune': '01148', 'zone': '2016'},
    {'commune': '01149', 'zone': '2006'},
    {'commune': '01150', 'zone': '2006'},
    {'commune': '01151', 'zone': '2006'},
    {'commune': '01152', 'zone': '2016'},
    {'commune': '01153', 'zone': '2001'},
    {'commune': '01155', 'zone': '2016'},
    {'commune': '01156', 'zone': '2006'},
    {'commune': '01157', 'zone': '2006'},
    {'commune': '01158', 'zone': '2001'},
    {'commune': '01159', 'zone': '2006'},
    {'commune': '01160', 'zone': '2001'},
    {'commune': '01162', 'zone': '2016'},
    {'commune': '01163', 'zone': '2006'},
    {'commune': '01165', 'zone': '2006'},
    {'commune': '01166', 'zone': '2006'},
    {'commune': '01167', 'zone': '2006'},
    {'commune': '01169', 'zone': '2006'},
    {'commune': '01170', 'zone': '2016'},
    {'commune': '01171', 'zone': '2016'},
    {'commune': '01173', 'zone': '2001'},
    {'commune': '01174', 'zone': '2001'},
    {'commune': '01175', 'zone': '2006'},
    {'commune': '01177', 'zone': '2006'},
    {'commune': '01179', 'zone': '2006'},
    {'commune': '01180', 'zone': '2001'},
    {'commune': '01181', 'zone': '2016'},
    {'commune': '01183', 'zone': '2006'},
    {'commune': '01184', 'zone': '2006'},
    {'commune': '01185', 'zone': '2016'},
    {'commune': '01187', 'zone': '2016'},
    {'commune': '01188', 'zone': '2006'},
    {'commune': '01189', 'zone': '2001'},
    {'commune': '01190', 'zone': '2016'},
    {'commune': '01191', 'zone': '2016'},
    {'commune': '01192', 'zone': '2016'},
    {'commune': '01193', 'zone': '2016'},
    {'commune': '01194', 'zone': '2006'},
    {'commune': '01195', 'zone': '2006'},
    {'commune': '01196', 'zone': '2006'},
    {'commune': '01197', 'zone': '2006'},
    {'commune': '01198', 'zone': '2006'},
    {'commune': '01199', 'zone': '2006'},
    {'commune': '01200', 'zone': '2006'},
    {'commune': '01202', 'zone': '2006'},
    {'commune': '01203', 'zone': '2006'},
    {'commune': '01204', 'zone': '2016'},
    {'commune': '01206', 'zone': '2016'},
    {'commune': '01207', 'zone': '2006'},
    {'commune': '01208', 'zone': '2016'},
    {'commune': '01209', 'zone': '2001'},
    {'commune': '01210', 'zone': '2001'},
    {'commune': '01211', 'zone': '2006'},
    {'commune': '01212', 'zone': '2006'},
    {'commune': '01213', 'zone': '2006'},
    {'commune': '01214', 'zone': '2016'},
    {'commune': '01215', 'zone': '2001'},
    {'commune': '01216', 'zone': '2016'},
    {'commune': '01219', 'zone': '2016'},
    {'commune': '01224', 'zone': '2006'},
    {'commune': '01225', 'zone': '2006'},
    {'commune': '01227', 'zone': '2016'},
    {'commune': '01228', 'zone': '2016'},
    {'commune': '01229', 'zone': '2006'},
    {'commune': '01230', 'zone': '2006'},
    {'commune': '01231', 'zone': '2006'},
    {'commune': '01232', 'zone': '2006'},
    {'commune': '01233', 'zone': '2016'},
    {'commune': '01234', 'zone': '2016'},
    {'commune': '01235', 'zone': '2006'},
    {'commune': '01236', 'zone': '2006'},
    {'commune': '01237', 'zone': '2016'},
    {'commune': '01238', 'zone': '2006'},
    {'commune': '01239', 'zone': '2016'},
    {'commune': '01240', 'zone': '2016'},
    {'commune': '01241', 'zone': '2006'},
    {'commune': '01242', 'zone': '2006'},
    {'commune': '01243', 'zone': '2006'},
    {'commune': '01244', 'zone': '2006'},
    {'commune': '01245', 'zone': '2006'},
    {'commune': '01246', 'zone': '2006'},
    {'commune': '01247', 'zone': '2001'},
    {'commune': '01248', 'zone': '2006'},
    {'commune': '01249', 'zone': '2006'},
    {'commune': '01250', 'zone': '2006'},
    {'commune': '01252', 'zone': '2006'},
    {'commune': '01254', 'zone': '2006'},
    {'commune': '01255', 'zone': '2016'},
    {'commune': '01257', 'zone': '2001'},
    {'commune': '01258', 'zone': '2006'},
    {'commune': '01259', 'zone': '2006'},
    {'commune': '01260', 'zone': '2006'},
    {'commune': '01261', 'zone': '2006'},
    {'commune': '01262', 'zone': '2006'},
    {'commune': '01263', 'zone': '2006'},
    {'commune': '01264', 'zone': '2006'},
    {'commune': '01265', 'zone': '2016'},
    {'commune': '01266', 'zone': '2006'},
    {'commune': '01267', 'zone': '2016'},
    {'commune': '01268', 'zone': '2016'},
    {'commune': '01269', 'zone': '2016'},
    {'commune': '01272', 'zone': '2006'},
    {'commune': '01273', 'zone': '2006'},
    {'commune': '01274', 'zone': '2016'},
    {'commune': '01275', 'zone': '2006'},
    {'commune': '01276', 'zone': '2006'},
    {'commune': '01277', 'zone': '2016'},
    {'commune': '01279', 'zone': '2016'},
    {'commune': '01280', 'zone': '2016'},
    {'commune': '01281', 'zone': '2001'},
    {'commune': '01282', 'zone': '2016'},
    {'commune': '01283', 'zone': '2016'},
    {'commune': '01284', 'zone': '2006'},
    {'commune': '01285', 'zone': '2006'},
    {'commune': '01286', 'zone': '2016'},
    {'commune': '01288', 'zone': '2001'},
    {'commune': '01289', 'zone': '2006'},
    {'commune': '01290', 'zone': '2006'},
    {'commune': '01291', 'zone': '2006'},
    {'commune': '01293', 'zone': '2016'},
    {'commune': '01294', 'zone': '2016'},
    {'commune': '01295', 'zone': '2006'},
    {'commune': '01296', 'zone': '2006'},
    {'commune': '01297', 'zone': '2006'},
    {'commune': '01298', 'zone': '2001'},
    {'commune': '01299', 'zone': '2006'},
    {'commune': '01301', 'zone': '2006'},
    {'commune': '01302', 'zone': '2016'},
    {'commune': '01303', 'zone': '2006'},
    {'commune': '01304', 'zone': '2006'},
    {'commune': '01305', 'zone': '2006'},
    {'commune': '01306', 'zone': '2006'},
    {'commune': '01307', 'zone': '2016'},
    {'commune': '01308', 'zone': '2001'},
    {'commune': '01309', 'zone': '2006'},
    {'commune': '01310', 'zone': '2016'},
    {'commune': '01311', 'zone': '2016'},
    {'commune': '01313', 'zone': '2001'},
    {'commune': '01314', 'zone': '2006'},
    {'commune': '01317', 'zone': '2006'},
    {'commune': '01318', 'zone': '2006'},
    {'commune': '01319', 'zone': '2006'},
    {'commune': '01320', 'zone': '2006'},
    {'commune': '01321', 'zone': '2006'},
    {'commune': '01322', 'zone': '2006'},
    {'commune': '01323', 'zone': '2006'},
    {'commune': '01325', 'zone': '2006'},
    {'commune': '01328', 'zone': '2006'},
    {'commune': '01329', 'zone': '2016'},
    {'commune': '01330', 'zone': '2016'},
    {'commune': '01331', 'zone': '2006'},
    {'commune': '01332', 'zone': '2006'},
    {'commune': '01333', 'zone': '2006'},
    {'commune': '01334', 'zone': '2006'},
    {'commune': '01335', 'zone': '2006'},
    {'commune': '01336', 'zone': '2006'},
    {'commune': '01337', 'zone': '2006'},
    {'commune': '01338', 'zone': '2016'},
    {'commune': '01339', 'zone': '2006'},
    {'commune': '01342', 'zone': '2006'},
    {'commune': '01343', 'zone': '2006'},
    {'commune': '01344', 'zone': '2006'},
    {'commune': '01345', 'zone': '2006'},
    {'commune': '01346', 'zone': '2006'},
    {'commune': '01347', 'zone': '2006'},
    {'commune': '01348', 'zone': '2006'},
    {'commune': '01349', 'zone': '2006'},
    {'commune': '01350', 'zone': '2006'},
    {'commune': '01351', 'zone': '2006'},
    {'commune': '01352', 'zone': '2006'},
    {'commune': '01353', 'zone': '2006'},
    {'commune': '01354', 'zone': '2001'},
    {'commune': '01355', 'zone': '2006'},
    {'commune': '01356', 'zone': '2006'},
    {'commune': '01357', 'zone': '2001'},
    {'commune': '01358', 'zone': '2016'},
    {'commune': '01359', 'zone': '2006'},
    {'commune': '01360', 'zone': '2001'},
    {'commune': '01361', 'zone': '2006'},
    {'commune': '01362', 'zone': '2006'},
    {'commune': '01363', 'zone': '2006'},
    {'commune': '01364', 'zone': '2006'},
    {'commune': '01365', 'zone': '2006'},
    {'commune': '01366', 'zone': '2006'},
    {'commune': '01367', 'zone': '2006'},
    {'commune': '01368', 'zone': '2006'},
    {'commune': '01369', 'zone': '2006'},
    {'commune': '01371', 'zone': '2006'},
    {'commune': '01372', 'zone': '2016'},
    {'commune': '01373', 'zone': '2016'},
    {'commune': '01374', 'zone': '2006'},
    {'commune': '01375', 'zone': '2006'},
    {'commune': '01376', 'zone': '2006'},
    {'commune': '01378', 'zone': '2006'},
    {'commune': '01379', 'zone': '2006'},
    {'commune': '01380', 'zone': '2006'},
    {'commune': '01381', 'zone': '2006'},
    {'commune': '01382', 'zone': '2006'},
    {'commune': '01383', 'zone': '2006'},
    {'commune': '01384', 'zone': '2016'},
    {'commune': '01385', 'zone': '2006'},
    {'commune': '01386', 'zone': '2006'},
    {'commune': '01387', 'zone': '2006'},
    {'commune': '01388', 'zone': '2006'},
    {'commune': '01389', 'zone': '2006'},
    {'commune': '01390', 'zone': '2006'},
    {'commune': '01391', 'zone': '2006'},
    {'commune': '01392', 'zone': '2016'},
    {'commune': '01393', 'zone': '2006'},
    {'commune': '01396', 'zone': '2006'},
    {'commune': '01397', 'zone': '2001'},
    {'commune': '01398', 'zone': '2006'},
    {'commune': '01399', 'zone': '2001'},
    {'commune': '01400', 'zone': '2016'},
    {'commune': '01401', 'zone': '2001'},
    {'commune': '01402', 'zone': '2006'},
    {'commune': '01403', 'zone': '2016'},
    {'commune': '01404', 'zone': '2016'},
    {'commune': '01405', 'zone': '2006'},
    {'commune': '01406', 'zone': '2006'},
    {'commune': '01407', 'zone': '2016'},
    {'commune': '01408', 'zone': '2006'},
    {'commune': '01410', 'zone': '2016'},
    {'commune': '01411', 'zone': '2006'},
    {'commune': '01412', 'zone': '2006'},
    {'commune': '01415', 'zone': '2016'},
    {'commune': '01416', 'zone': '2016'},
    {'commune': '01418', 'zone': '2006'},
    {'commune': '01419', 'zone': '2001'},
    {'commune': '01420', 'zone': '2006'},
    {'commune': '01421', 'zone': '2016'},
    {'commune': '01422', 'zone': '2006'},
    {'commune': '01423', 'zone': '2006'},
    {'commune': '01424', 'zone': '2006'},
    {'commune': '01425', 'zone': '2006'},
    {'commune': '01426', 'zone': '2006'},
    {'commune': '01427', 'zone': '2006'},
    {'commune': '01428', 'zone': '2006'},
    {'commune': '01429', 'zone': '2006'},
    {'commune': '01430', 'zone': '2006'},
    {'commune': '01431', 'zone': '2006'},
    {'commune': '01432', 'zone': '2006'},
    {'commune': '01433', 'zone': '2006'},
    {'commune': '01434', 'zone': '2006'},
    {'commune': '01435', 'zone': '2001'},
    {'commune': '01436', 'zone': '2001'},
    {'commune': '01437', 'zone': '2006'},
    {'commune': '01441', 'zone': '2016'},
    {'commune': '01443', 'zone': '2006'},
    {'commune': '01444', 'zone': '2006'},
    {'commune': '01445', 'zone': '2006'},
    {'commune': '01446', 'zone': '2006'},
    {'commune': '01447', 'zone': '2006'},
    {'commune': '01448', 'zone': '2001'},
    {'commune': '01449', 'zone': '2006'},
    {'commune': '01450', 'zone': '2006'},
    {'commune': '01451', 'zone': '2006'},
    {'commune': '01452', 'zone': '2016'},
    {'commune': '01453', 'zone': '2016'},
    {'commune': '01454', 'zone': '2016'},
    {'commune': '01456', 'zone': '2016'},
    {'commune': '01457', 'zone': '2006'},
    {'commune': '03001', 'zone': '2020'},
    {'commune': '03002', 'zone': '2020'},
    {'commune': '03003', 'zone': '2020'},
    {'commune': '03004', 'zone': '2020'},
    {'commune': '03005', 'zone': '2020'},
    {'commune': '03006', 'zone': '2020'},
    {'commune': '03007', 'zone': '2020'},
    {'commune': '03008', 'zone': '2020'},
    {'commune': '03009', 'zone': '2020'},
    {'commune': '03010', 'zone': '2020'},
    {'commune': '03011', 'zone': '2020'},
    {'commune': '03012', 'zone': '2020'},
    {'commune': '03013', 'zone': '2020'},
    {'commune': '03014', 'zone': '2020'},
    {'commune': '03015', 'zone': '2020'},
    {'commune': '03016', 'zone': '2020'},
    {'commune': '03017', 'zone': '2020'},
    {'commune': '03018', 'zone': '2020'},
    {'commune': '03019', 'zone': '2020'},
    {'commune': '03020', 'zone': '2020'},
    {'commune': '03021', 'zone': '2020'},
    {'commune': '03022', 'zone': '2020'},
    {'commune': '03023', 'zone': '2020'},
    {'commune': '03024', 'zone': '2020'},
    {'commune': '03025', 'zone': '2020'},
    {'commune': '03026', 'zone': '2020'},
    {'commune': '03027', 'zone': '2020'},
    {'commune': '03028', 'zone': '2020'},
    {'commune': '03029', 'zone': '2020'},
    {'commune': '03030', 'zone': '2020'},
    {'commune': '03031', 'zone': '2020'},
    {'commune': '03032', 'zone': '2020'},
    {'commune': '03033', 'zone': '2020'},
    {'commune': '03034', 'zone': '2020'},
    {'commune': '03035', 'zone': '2020'},
    {'commune': '03036', 'zone': '2020'},
    {'commune': '03037', 'zone': '2020'},
    {'commune': '03038', 'zone': '2020'},
    {'commune': '03039', 'zone': '2020'},
    {'commune': '03040', 'zone': '2020'},
    {'commune': '03041', 'zone': '2020'},
    {'commune': '03042', 'zone': '2020'},
    {'commune': '03043', 'zone': '2020'},
    {'commune': '03044', 'zone': '2020'},
    {'commune': '03045', 'zone': '2020'},
    {'commune': '03046', 'zone': '2020'},
    {'commune': '03047', 'zone': '2020'},
    {'commune': '03048', 'zone': '2020'},
    {'commune': '03049', 'zone': '2020'},
    {'commune': '03050', 'zone': '2020'},
    {'commune': '03051', 'zone': '2020'},
    {'commune': '03052', 'zone': '2020'},
    {'commune': '03053', 'zone': '2020'},
    {'commune': '03054', 'zone': '2020'},
    {'commune': '03055', 'zone': '2020'},
    {'commune': '03056', 'zone': '2020'},
    {'commune': '03057', 'zone': '2020'},
    {'commune': '03058', 'zone': '2020'},
    {'commune': '03059', 'zone': '2020'},
    {'commune': '03060', 'zone': '2020'},
    {'commune': '03061', 'zone': '2020'},
    {'commune': '03062', 'zone': '2020'},
    {'commune': '03063', 'zone': '2020'},
    {'commune': '03064', 'zone': '2020'},
    {'commune': '03065', 'zone': '2020'},
    {'commune': '03066', 'zone': '2020'},
    {'commune': '03067', 'zone': '2020'},
    {'commune': '03068', 'zone': '2020'},
    {'commune': '03069', 'zone': '2020'},
    {'commune': '03070', 'zone': '2020'},
    {'commune': '03071', 'zone': '2020'},
    {'commune': '03072', 'zone': '2020'},
    {'commune': '03073', 'zone': '2020'},
    {'commune': '03074', 'zone': '2020'},
    {'commune': '03075', 'zone': '2020'},
    {'commune': '03076', 'zone': '2020'},
    {'commune': '03077', 'zone': '2020'},
    {'commune': '03078', 'zone': '2020'},
    {'commune': '03079', 'zone': '2020'},
    {'commune': '03080', 'zone': '2020'},
    {'commune': '03081', 'zone': '2020'},
    {'commune': '03082', 'zone': '2020'},
    {'commune': '03083', 'zone': '2020'},
    {'commune': '03084', 'zone': '2020'},
    {'commune': '03085', 'zone': '2020'},
    {'commune': '03086', 'zone': '2020'},
    {'commune': '03087', 'zone': '2020'},
    {'commune': '03088', 'zone': '2020'},
    {'commune': '03089', 'zone': '2020'},
    {'commune': '03090', 'zone': '2020'},
    {'commune': '03091', 'zone': '2020'},
    {'commune': '03092', 'zone': '2020'},
    {'commune': '03093', 'zone': '2020'},
    {'commune': '03094', 'zone': '2020'},
    {'commune': '03095', 'zone': '2020'},
    {'commune': '03096', 'zone': '2020'},
    {'commune': '03097', 'zone': '2020'},
    {'commune': '03098', 'zone': '2020'},
    {'commune': '03099', 'zone': '2020'},
    {'commune': '03100', 'zone': '2020'},
    {'commune': '03101', 'zone': '2020'},
    {'commune': '03102', 'zone': '2020'},
    {'commune': '03103', 'zone': '2020'},
    {'commune': '03104', 'zone': '2020'},
    {'commune': '03105', 'zone': '2020'},
    {'commune': '03106', 'zone': '2020'},
    {'commune': '03107', 'zone': '2020'},
    {'commune': '03108', 'zone': '2020'},
    {'commune': '03109', 'zone': '2020'},
    {'commune': '03110', 'zone': '2020'},
    {'commune': '03111', 'zone': '2020'},
    {'commune': '03112', 'zone': '2020'},
    {'commune': '03113', 'zone': '2020'},
    {'commune': '03114', 'zone': '2020'},
    {'commune': '03115', 'zone': '2020'},
    {'commune': '03116', 'zone': '2020'},
    {'commune': '03117', 'zone': '2020'},
    {'commune': '03118', 'zone': '2020'},
    {'commune': '03119', 'zone': '2020'},
    {'commune': '03120', 'zone': '2020'},
    {'commune': '03121', 'zone': '2020'},
    {'commune': '03122', 'zone': '2020'},
    {'commune': '03124', 'zone': '2020'},
    {'commune': '03125', 'zone': '2020'},
    {'commune': '03126', 'zone': '2020'},
    {'commune': '03127', 'zone': '2020'},
    {'commune': '03128', 'zone': '2020'},
    {'commune': '03129', 'zone': '2020'},
    {'commune': '03130', 'zone': '2020'},
    {'commune': '03131', 'zone': '2020'},
    {'commune': '03132', 'zone': '2020'},
    {'commune': '03133', 'zone': '2020'},
    {'commune': '03134', 'zone': '2020'},
    {'commune': '03135', 'zone': '2020'},
    {'commune': '03136', 'zone': '2020'},
    {'commune': '03137', 'zone': '2020'},
    {'commune': '03138', 'zone': '2020'},
    {'commune': '03139', 'zone': '2020'},
    {'commune': '03140', 'zone': '2020'},
    {'commune': '03141', 'zone': '2020'},
    {'commune': '03142', 'zone': '2020'},
    {'commune': '03143', 'zone': '2020'},
    {'commune': '03144', 'zone': '2020'},
    {'commune': '03145', 'zone': '2020'},
    {'commune': '03146', 'zone': '2020'},
    {'commune': '03147', 'zone': '2020'},
    {'commune': '03148', 'zone': '2020'},
    {'commune': '03149', 'zone': '2020'},
    {'commune': '03150', 'zone': '2020'},
    {'commune': '03151', 'zone': '2020'},
    {'commune': '03152', 'zone': '2020'},
    {'commune': '03154', 'zone': '2020'},
    {'commune': '03155', 'zone': '2020'},
    {'commune': '03156', 'zone': '2020'},
    {'commune': '03157', 'zone': '2020'},
    {'commune': '03158', 'zone': '2020'},
    {'commune': '03159', 'zone': '2020'},
    {'commune': '03160', 'zone': '2020'},
    {'commune': '03161', 'zone': '2020'},
    {'commune': '03162', 'zone': '2020'},
    {'commune': '03163', 'zone': '2020'},
    {'commune': '03164', 'zone': '2020'},
    {'commune': '03165', 'zone': '2020'},
    {'commune': '03166', 'zone': '2020'},
    {'commune': '03167', 'zone': '2020'},
    {'commune': '03168', 'zone': '2020'},
    {'commune': '03169', 'zone': '2020'},
    {'commune': '03170', 'zone': '2020'},
    {'commune': '03171', 'zone': '2020'},
    {'commune': '03172', 'zone': '2020'},
    {'commune': '03173', 'zone': '2020'},
    {'commune': '03174', 'zone': '2020'},
    {'commune': '03175', 'zone': '2020'},
    {'commune': '03176', 'zone': '2020'},
    {'commune': '03177', 'zone': '2020'},
    {'commune': '03178', 'zone': '2020'},
    {'commune': '03179', 'zone': '2020'},
    {'commune': '03180', 'zone': '2020'},
    {'commune': '03181', 'zone': '2020'},
    {'commune': '03182', 'zone': '2020'},
    {'commune': '03183', 'zone': '2020'},
    {'commune': '03184', 'zone': '2020'},
    {'commune': '03185', 'zone': '2020'},
    {'commune': '03186', 'zone': '2020'},
    {'commune': '03187', 'zone': '2020'},
    {'commune': '03188', 'zone': '2020'},
    {'commune': '03189', 'zone': '2020'},
    {'commune': '03190', 'zone': '2020'},
    {'commune': '03191', 'zone': '2020'},
    {'commune': '03192', 'zone': '2020'},
    {'commune': '03193', 'zone': '2020'},
    {'commune': '03194', 'zone': '2020'},
    {'commune': '03195', 'zone': '2020'},
    {'commune': '03196', 'zone': '2020'},
    {'commune': '03197', 'zone': '2020'},
    {'commune': '03198', 'zone': '2020'},
    {'commune': '03200', 'zone': '2020'},
    {'commune': '03201', 'zone': '2020'},
    {'commune': '03202', 'zone': '2020'},
    {'commune': '03203', 'zone': '2020'},
    {'commune': '03204', 'zone': '2020'},
    {'commune': '03205', 'zone': '2020'},
    {'commune': '03206', 'zone': '2020'},
    {'commune': '03207', 'zone': '2020'},
    {'commune': '03208', 'zone': '2020'},
    {'commune': '03209', 'zone': '2020'},
    {'commune': '03210', 'zone': '2020'},
    {'commune': '03211', 'zone': '2020'},
    {'commune': '03212', 'zone': '2020'},
    {'commune': '03213', 'zone': '2020'},
    {'commune': '03214', 'zone': '2020'},
    {'commune': '03215', 'zone': '2020'},
    {'commune': '03216', 'zone': '2020'},
    {'commune': '03217', 'zone': '2020'},
    {'commune': '03218', 'zone': '2020'},
    {'commune': '03219', 'zone': '2020'},
    {'commune': '03220', 'zone': '2020'},
    {'commune': '03221', 'zone': '2020'},
    {'commune': '03222', 'zone': '2020'},
    {'commune': '03223', 'zone': '2020'},
    {'commune': '03224', 'zone': '2020'},
    {'commune': '03225', 'zone': '2020'},
    {'commune': '03226', 'zone': '2020'},
    {'commune': '03227', 'zone': '2020'},
    {'commune': '03228', 'zone': '2020'},
    {'commune': '03229', 'zone': '2020'},
    {'commune': '03230', 'zone': '2020'},
    {'commune': '03231', 'zone': '2020'},
    {'commune': '03232', 'zone': '2020'},
    {'commune': '03233', 'zone': '2020'},
    {'commune': '03234', 'zone': '2020'},
    {'commune': '03235', 'zone': '2020'},
    {'commune': '03236', 'zone': '2020'},
    {'commune': '03237', 'zone': '2020'},
    {'commune': '03238', 'zone': '2020'},
    {'commune': '03239', 'zone': '2020'},
    {'commune': '03240', 'zone': '2020'},
    {'commune': '03241', 'zone': '2020'},
    {'commune': '03242', 'zone': '2020'},
    {'commune': '03243', 'zone': '2020'},
    {'commune': '03244', 'zone': '2020'},
    {'commune': '03245', 'zone': '2020'},
    {'commune': '03246', 'zone': '2020'},
    {'commune': '03247', 'zone': '2020'},
    {'commune': '03248', 'zone': '2020'},
    {'commune': '03249', 'zone': '2020'},
    {'commune': '03250', 'zone': '2020'},
    {'commune': '03251', 'zone': '2020'},
    {'commune': '03252', 'zone': '2020'},
    {'commune': '03253', 'zone': '2020'},
    {'commune': '03254', 'zone': '2020'},
    {'commune': '03255', 'zone': '2020'},
    {'commune': '03256', 'zone': '2020'},
    {'commune': '03257', 'zone': '2020'},
    {'commune': '03258', 'zone': '2020'},
    {'commune': '03259', 'zone': '2020'},
    {'commune': '03260', 'zone': '2020'},
    {'commune': '03261', 'zone': '2020'},
    {'commune': '03262', 'zone': '2020'},
    {'commune': '03263', 'zone': '2020'},
    {'commune': '03264', 'zone': '2020'},
    {'commune': '03265', 'zone': '2020'},
    {'commune': '03266', 'zone': '2020'},
    {'commune': '03267', 'zone': '2020'},
    {'commune': '03268', 'zone': '2020'},
    {'commune': '03269', 'zone': '2020'},
    {'commune': '03270', 'zone': '2020'},
    {'commune': '03271', 'zone': '2020'},
    {'commune': '03272', 'zone': '2020'},
    {'commune': '03273', 'zone': '2020'},
    {'commune': '03274', 'zone': '2020'},
    {'commune': '03275', 'zone': '2020'},
    {'commune': '03276', 'zone': '2020'},
    {'commune': '03277', 'zone': '2020'},
    {'commune': '03278', 'zone': '2020'},
    {'commune': '03279', 'zone': '2020'},
    {'commune': '03280', 'zone': '2020'},
    {'commune': '03281', 'zone': '2020'},
    {'commune': '03282', 'zone': '2020'},
    {'commune': '03283', 'zone': '2020'},
    {'commune': '03284', 'zone': '2020'},
    {'commune': '03285', 'zone': '2020'},
    {'commune': '03286', 'zone': '2020'},
    {'commune': '03287', 'zone': '2020'},
    {'commune': '03288', 'zone': '2020'},
    {'commune': '03289', 'zone': '2020'},
    {'commune': '03290', 'zone': '2020'},
    {'commune': '03291', 'zone': '2020'},
    {'commune': '03292', 'zone': '2020'},
    {'commune': '03293', 'zone': '2020'},
    {'commune': '03294', 'zone': '2020'},
    {'commune': '03295', 'zone': '2020'},
    {'commune': '03296', 'zone': '2020'},
    {'commune': '03297', 'zone': '2020'},
    {'commune': '03298', 'zone': '2020'},
    {'commune': '03299', 'zone': '2020'},
    {'commune': '03300', 'zone': '2020'},
    {'commune': '03301', 'zone': '2020'},
    {'commune': '03302', 'zone': '2020'},
    {'commune': '03303', 'zone': '2020'},
    {'commune': '03304', 'zone': '2020'},
    {'commune': '03305', 'zone': '2020'},
    {'commune': '03306', 'zone': '2020'},
    {'commune': '03307', 'zone': '2020'},
    {'commune': '03308', 'zone': '2020'},
    {'commune': '03309', 'zone': '2020'},
    {'commune': '03310', 'zone': '2020'},
    {'commune': '03311', 'zone': '2020'},
    {'commune': '03312', 'zone': '2020'},
    {'commune': '03313', 'zone': '2020'},
    {'commune': '03314', 'zone': '2020'},
    {'commune': '03315', 'zone': '2020'},
    {'commune': '03316', 'zone': '2020'},
    {'commune': '03317', 'zone': '2020'},
    {'commune': '03319', 'zone': '2020'},
    {'commune': '03320', 'zone': '2020'},
    {'commune': '03321', 'zone': '2020'},
    {'commune': '07001', 'zone': '2007'},
    {'commune': '07002', 'zone': '2007'},
    {'commune': '07003', 'zone': '2007'},
    {'commune': '07004', 'zone': '2007'},
    {'commune': '07005', 'zone': '2007'},
    {'commune': '07006', 'zone': '2007'},
    {'commune': '07007', 'zone': '2007'},
    {'commune': '07008', 'zone': '2009'},
    {'commune': '07009', 'zone': '2009'},
    {'commune': '07010', 'zone': '2007'},
    {'commune': '07011', 'zone': '2007'},
    {'commune': '07012', 'zone': '2007'},
    {'commune': '07013', 'zone': '2007'},
    {'commune': '07014', 'zone': '2007'},
    {'commune': '07015', 'zone': '2009'},
    {'commune': '07017', 'zone': '2007'},
    {'commune': '07018', 'zone': '2007'},
    {'commune': '07019', 'zone': '2007'},
    {'commune': '07020', 'zone': '2007'},
    {'commune': '07022', 'zone': '2009'},
    {'commune': '07023', 'zone': '2007'},
    {'commune': '07024', 'zone': '2007'},
    {'commune': '07025', 'zone': '2007'},
    {'commune': '07026', 'zone': '2007'},
    {'commune': '07027', 'zone': '2009'},
    {'commune': '07028', 'zone': '2007'},
    {'commune': '07029', 'zone': '2007'},
    {'commune': '07030', 'zone': '2007'},
    {'commune': '07031', 'zone': '2007'},
    {'commune': '07032', 'zone': '2007'},
    {'commune': '07033', 'zone': '2007'},
    {'commune': '07034', 'zone': '2007'},
    {'commune': '07035', 'zone': '2007'},
    {'commune': '07036', 'zone': '2007'},
    {'commune': '07037', 'zone': '2007'},
    {'commune': '07038', 'zone': '2007'},
    {'commune': '07039', 'zone': '2007'},
    {'commune': '07040', 'zone': '2009'},
    {'commune': '07041', 'zone': '2007'},
    {'commune': '07042', 'zone': '2009'},
    {'commune': '07044', 'zone': '2007'},
    {'commune': '07045', 'zone': '2007'},
    {'commune': '07047', 'zone': '2007'},
    {'commune': '07048', 'zone': '2007'},
    {'commune': '07049', 'zone': '2007'},
    {'commune': '07050', 'zone': '2007'},
    {'commune': '07051', 'zone': '2009'},
    {'commune': '07052', 'zone': '2007'},
    {'commune': '07053', 'zone': '2007'},
    {'commune': '07054', 'zone': '2007'},
    {'commune': '07055', 'zone': '2009'},
    {'commune': '07056', 'zone': '2007'},
    {'commune': '07058', 'zone': '2007'},
    {'commune': '07059', 'zone': '2009'},
    {'commune': '07060', 'zone': '2007'},
    {'commune': '07061', 'zone': '2007'},
    {'commune': '07062', 'zone': '2007'},
    {'commune': '07063', 'zone': '2009'},
    {'commune': '07064', 'zone': '2007'},
    {'commune': '07065', 'zone': '2007'},
    {'commune': '07066', 'zone': '2009'},
    {'commune': '07067', 'zone': '2007'},
    {'commune': '07068', 'zone': '2009'},
    {'commune': '07069', 'zone': '2007'},
    {'commune': '07070', 'zone': '2009'},
    {'commune': '07071', 'zone': '2007'},
    {'commune': '07072', 'zone': '2009'},
    {'commune': '07073', 'zone': '2007'},
    {'commune': '07074', 'zone': '2007'},
    {'commune': '07075', 'zone': '2007'},
    {'commune': '07076', 'zone': '2009'},
    {'commune': '07077', 'zone': '2007'},
    {'commune': '07078', 'zone': '2007'},
    {'commune': '07079', 'zone': '2007'},
    {'commune': '07080', 'zone': '2007'},
    {'commune': '07081', 'zone': '2007'},
    {'commune': '07082', 'zone': '2007'},
    {'commune': '07083', 'zone': '2007'},
    {'commune': '07084', 'zone': '2007'},
    {'commune': '07085', 'zone': '2007'},
    {'commune': '07086', 'zone': '2009'},
    {'commune': '07087', 'zone': '2007'},
    {'commune': '07088', 'zone': '2007'},
    {'commune': '07089', 'zone': '2007'},
    {'commune': '07090', 'zone': '2009'},
    {'commune': '07091', 'zone': '2007'},
    {'commune': '07092', 'zone': '2009'},
    {'commune': '07093', 'zone': '2007'},
    {'commune': '07094', 'zone': '2007'},
    {'commune': '07095', 'zone': '2007'},
    {'commune': '07096', 'zone': '2007'},
    {'commune': '07097', 'zone': '2009'},
    {'commune': '07098', 'zone': '2007'},
    {'commune': '07099', 'zone': '2007'},
    {'commune': '07100', 'zone': '2007'},
    {'commune': '07101', 'zone': '2007'},
    {'commune': '07102', 'zone': '2009'},
    {'commune': '07103', 'zone': '2007'},
    {'commune': '07104', 'zone': '2007'},
    {'commune': '07105', 'zone': '2007'},
    {'commune': '07106', 'zone': '2007'},
    {'commune': '07107', 'zone': '2007'},
    {'commune': '07108', 'zone': '2007'},
    {'commune': '07109', 'zone': '2007'},
    {'commune': '07110', 'zone': '2007'},
    {'commune': '07111', 'zone': '2007'},
    {'commune': '07112', 'zone': '2007'},
    {'commune': '07113', 'zone': '2007'},
    {'commune': '07114', 'zone': '2007'},
    {'commune': '07115', 'zone': '2007'},
    {'commune': '07116', 'zone': '2007'},
    {'commune': '07117', 'zone': '2007'},
    {'commune': '07118', 'zone': '2007'},
    {'commune': '07119', 'zone': '2007'},
    {'commune': '07120', 'zone': '2007'},
    {'commune': '07121', 'zone': '2007'},
    {'commune': '07122', 'zone': '2007'},
    {'commune': '07123', 'zone': '2007'},
    {'commune': '07124', 'zone': '2007'},
    {'commune': '07126', 'zone': '2007'},
    {'commune': '07127', 'zone': '2007'},
    {'commune': '07128', 'zone': '2007'},
    {'commune': '07129', 'zone': '2007'},
    {'commune': '07130', 'zone': '2007'},
    {'commune': '07131', 'zone': '2007'},
    {'commune': '07132', 'zone': '2007'},
    {'commune': '07133', 'zone': '2007'},
    {'commune': '07134', 'zone': '2007'},
    {'commune': '07136', 'zone': '2007'},
    {'commune': '07137', 'zone': '2007'},
    {'commune': '07138', 'zone': '2007'},
    {'commune': '07139', 'zone': '2007'},
    {'commune': '07140', 'zone': '2009'},
    {'commune': '07141', 'zone': '2007'},
    {'commune': '07142', 'zone': '2007'},
    {'commune': '07143', 'zone': '2009'},
    {'commune': '07144', 'zone': '2007'},
    {'commune': '07145', 'zone': '2007'},
    {'commune': '07146', 'zone': '2009'},
    {'commune': '07147', 'zone': '2007'},
    {'commune': '07148', 'zone': '2007'},
    {'commune': '07149', 'zone': '2007'},
    {'commune': '07150', 'zone': '2007'},
    {'commune': '07151', 'zone': '2007'},
    {'commune': '07152', 'zone': '2009'},
    {'commune': '07153', 'zone': '2007'},
    {'commune': '07154', 'zone': '2007'},
    {'commune': '07155', 'zone': '2007'},
    {'commune': '07156', 'zone': '2007'},
    {'commune': '07157', 'zone': '2009'},
    {'commune': '07158', 'zone': '2007'},
    {'commune': '07159', 'zone': '2007'},
    {'commune': '07160', 'zone': '2007'},
    {'commune': '07161', 'zone': '2007'},
    {'commune': '07162', 'zone': '2007'},
    {'commune': '07163', 'zone': '2007'},
    {'commune': '07165', 'zone': '2007'},
    {'commune': '07166', 'zone': '2007'},
    {'commune': '07167', 'zone': '2007'},
    {'commune': '07168', 'zone': '2007'},
    {'commune': '07169', 'zone': '2009'},
    {'commune': '07170', 'zone': '2007'},
    {'commune': '07171', 'zone': '2007'},
    {'commune': '07172', 'zone': '2007'},
    {'commune': '07173', 'zone': '2007'},
    {'commune': '07174', 'zone': '2009'},
    {'commune': '07175', 'zone': '2007'},
    {'commune': '07176', 'zone': '2007'},
    {'commune': '07177', 'zone': '2009'},
    {'commune': '07178', 'zone': '2007'},
    {'commune': '07179', 'zone': '2007'},
    {'commune': '07181', 'zone': '2009'},
    {'commune': '07182', 'zone': '2007'},
    {'commune': '07183', 'zone': '2007'},
    {'commune': '07184', 'zone': '2007'},
    {'commune': '07185', 'zone': '2007'},
    {'commune': '07186', 'zone': '2009'},
    {'commune': '07187', 'zone': '2007'},
    {'commune': '07188', 'zone': '2007'},
    {'commune': '07189', 'zone': '2007'},
    {'commune': '07190', 'zone': '2007'},
    {'commune': '07191', 'zone': '2009'},
    {'commune': '07192', 'zone': '2007'},
    {'commune': '07193', 'zone': '2007'},
    {'commune': '07194', 'zone': '2009'},
    {'commune': '07195', 'zone': '2007'},
    {'commune': '07196', 'zone': '2007'},
    {'commune': '07197', 'zone': '2007'},
    {'commune': '07198', 'zone': '2009'},
    {'commune': '07199', 'zone': '2007'},
    {'commune': '07200', 'zone': '2007'},
    {'commune': '07201', 'zone': '2007'},
    {'commune': '07202', 'zone': '2007'},
    {'commune': '07203', 'zone': '2007'},
    {'commune': '07204', 'zone': '2007'},
    {'commune': '07205', 'zone': '2007'},
    {'commune': '07206', 'zone': '2007'},
    {'commune': '07207', 'zone': '2007'},
    {'commune': '07208', 'zone': '2007'},
    {'commune': '07209', 'zone': '2007'},
    {'commune': '07210', 'zone': '2007'},
    {'commune': '07211', 'zone': '2007'},
    {'commune': '07212', 'zone': '2007'},
    {'commune': '07213', 'zone': '2007'},
    {'commune': '07214', 'zone': '2007'},
    {'commune': '07215', 'zone': '2007'},
    {'commune': '07216', 'zone': '2007'},
    {'commune': '07217', 'zone': '2009'},
    {'commune': '07218', 'zone': '2007'},
    {'commune': '07219', 'zone': '2009'},
    {'commune': '07220', 'zone': '2007'},
    {'commune': '07221', 'zone': '2007'},
    {'commune': '07222', 'zone': '2007'},
    {'commune': '07223', 'zone': '2007'},
    {'commune': '07224', 'zone': '2007'},
    {'commune': '07225', 'zone': '2007'},
    {'commune': '07226', 'zone': '2007'},
    {'commune': '07227', 'zone': '2007'},
    {'commune': '07228', 'zone': '2009'},
    {'commune': '07229', 'zone': '2007'},
    {'commune': '07230', 'zone': '2007'},
    {'commune': '07231', 'zone': '2007'},
    {'commune': '07232', 'zone': '2007'},
    {'commune': '07233', 'zone': '2007'},
    {'commune': '07234', 'zone': '2009'},
    {'commune': '07235', 'zone': '2007'},
    {'commune': '07236', 'zone': '2007'},
    {'commune': '07237', 'zone': '2007'},
    {'commune': '07238', 'zone': '2007'},
    {'commune': '07239', 'zone': '2007'},
    {'commune': '07240', 'zone': '2009'},
    {'commune': '07241', 'zone': '2007'},
    {'commune': '07242', 'zone': '2007'},
    {'commune': '07243', 'zone': '2004'},
    {'commune': '07244', 'zone': '2007'},
    {'commune': '07245', 'zone': '2009'},
    {'commune': '07247', 'zone': '2007'},
    {'commune': '07248', 'zone': '2007'},
    {'commune': '07249', 'zone': '2007'},
    {'commune': '07250', 'zone': '2007'},
    {'commune': '07251', 'zone': '2007'},
    {'commune': '07253', 'zone': '2007'},
    {'commune': '07254', 'zone': '2007'},
    {'commune': '07255', 'zone': '2009'},
    {'commune': '07257', 'zone': '2007'},
    {'commune': '07258', 'zone': '2007'},
    {'commune': '07259', 'zone': '2009'},
    {'commune': '07260', 'zone': '2009'},
    {'commune': '07261', 'zone': '2009'},
    {'commune': '07262', 'zone': '2007'},
    {'commune': '07263', 'zone': '2007'},
    {'commune': '07264', 'zone': '2009'},
    {'commune': '07265', 'zone': '2007'},
    {'commune': '07266', 'zone': '2007'},
    {'commune': '07267', 'zone': '2007'},
    {'commune': '07268', 'zone': '2009'},
    {'commune': '07269', 'zone': '2007'},
    {'commune': '07270', 'zone': '2009'},
    {'commune': '07272', 'zone': '2007'},
    {'commune': '07273', 'zone': '2007'},
    {'commune': '07274', 'zone': '2007'},
    {'commune': '07275', 'zone': '2007'},
    {'commune': '07276', 'zone': '2007'},
    {'commune': '07277', 'zone': '2007'},
    {'commune': '07278', 'zone': '2007'},
    {'commune': '07279', 'zone': '2009'},
    {'commune': '07280', 'zone': '2007'},
    {'commune': '07281', 'zone': '2009'},
    {'commune': '07282', 'zone': '2007'},
    {'commune': '07283', 'zone': '2009'},
    {'commune': '07284', 'zone': '2007'},
    {'commune': '07285', 'zone': '2007'},
    {'commune': '07286', 'zone': '2007'},
    {'commune': '07287', 'zone': '2007'},
    {'commune': '07288', 'zone': '2009'},
    {'commune': '07289', 'zone': '2007'},
    {'commune': '07290', 'zone': '2007'},
    {'commune': '07291', 'zone': '2007'},
    {'commune': '07292', 'zone': '2007'},
    {'commune': '07293', 'zone': '2007'},
    {'commune': '07294', 'zone': '2007'},
    {'commune': '07295', 'zone': '2007'},
    {'commune': '07296', 'zone': '2007'},
    {'commune': '07297', 'zone': '2007'},
    {'commune': '07298', 'zone': '2009'},
    {'commune': '07299', 'zone': '2007'},
    {'commune': '07300', 'zone': '2007'},
    {'commune': '07301', 'zone': '2007'},
    {'commune': '07302', 'zone': '2009'},
    {'commune': '07303', 'zone': '2007'},
    {'commune': '07304', 'zone': '2007'},
    {'commune': '07305', 'zone': '2007'},
    {'commune': '07306', 'zone': '2007'},
    {'commune': '07307', 'zone': '2007'},
    {'commune': '07308', 'zone': '2009'},
    {'commune': '07309', 'zone': '2007'},
    {'commune': '07310', 'zone': '2007'},
    {'commune': '07311', 'zone': '2007'},
    {'commune': '07312', 'zone': '2009'},
    {'commune': '07313', 'zone': '2009'},
    {'commune': '07314', 'zone': '2007'},
    {'commune': '07315', 'zone': '2007'},
    {'commune': '07316', 'zone': '2009'},
    {'commune': '07317', 'zone': '2009'},
    {'commune': '07318', 'zone': '2007'},
    {'commune': '07319', 'zone': '2009'},
    {'commune': '07321', 'zone': '2007'},
    {'commune': '07322', 'zone': '2007'},
    {'commune': '07323', 'zone': '2009'},
    {'commune': '07324', 'zone': '2009'},
    {'commune': '07325', 'zone': '2007'},
    {'commune': '07326', 'zone': '2007'},
    {'commune': '07327', 'zone': '2007'},
    {'commune': '07328', 'zone': '2007'},
    {'commune': '07329', 'zone': '2007'},
    {'commune': '07330', 'zone': '2007'},
    {'commune': '07331', 'zone': '2007'},
    {'commune': '07332', 'zone': '2007'},
    {'commune': '07333', 'zone': '2007'},
    {'commune': '07334', 'zone': '2007'},
    {'commune': '07335', 'zone': '2007'},
    {'commune': '07336', 'zone': '2007'},
    {'commune': '07337', 'zone': '2007'},
    {'commune': '07338', 'zone': '2007'},
    {'commune': '07339', 'zone': '2007'},
    {'commune': '07340', 'zone': '2009'},
    {'commune': '07341', 'zone': '2007'},
    {'commune': '07342', 'zone': '2007'},
    {'commune': '07343', 'zone': '2007'},
    {'commune': '07344', 'zone': '2007'},
    {'commune': '07345', 'zone': '2009'},
    {'commune': '07346', 'zone': '2009'},
    {'commune': '07347', 'zone': '2007'},
    {'commune': '07348', 'zone': '2007'},
    {'commune': '07349', 'zone': '2009'},
    {'commune': '15001', 'zone': '2019'},
    {'commune': '15002', 'zone': '2019'},
    {'commune': '15003', 'zone': '2019'},
    {'commune': '15004', 'zone': '2019'},
    {'commune': '15005', 'zone': '2019'},
    {'commune': '15006', 'zone': '2019'},
    {'commune': '15007', 'zone': '2019'},
    {'commune': '15008', 'zone': '2019'},
    {'commune': '15009', 'zone': '2019'},
    {'commune': '15010', 'zone': '2019'},
    {'commune': '15011', 'zone': '2019'},
    {'commune': '15012', 'zone': '2019'},
    {'commune': '15013', 'zone': '2019'},
    {'commune': '15014', 'zone': '2019'},
    {'commune': '15015', 'zone': '2019'},
    {'commune': '15016', 'zone': '2019'},
    {'commune': '15017', 'zone': '2019'},
    {'commune': '15018', 'zone': '2019'},
    {'commune': '15019', 'zone': '2019'},
    {'commune': '15020', 'zone': '2019'},
    {'commune': '15021', 'zone': '2019'},
    {'commune': '15022', 'zone': '2019'},
    {'commune': '15024', 'zone': '2019'},
    {'commune': '15025', 'zone': '2019'},
    {'commune': '15026', 'zone': '2019'},
    {'commune': '15027', 'zone': '2019'},
    {'commune': '15028', 'zone': '2019'},
    {'commune': '15029', 'zone': '2019'},
    {'commune': '15030', 'zone': '2019'},
    {'commune': '15032', 'zone': '2019'},
    {'commune': '15033', 'zone': '2019'},
    {'commune': '15034', 'zone': '2019'},
    {'commune': '15036', 'zone': '2019'},
    {'commune': '15037', 'zone': '2019'},
    {'commune': '15038', 'zone': '2019'},
    {'commune': '15040', 'zone': '2019'},
    {'commune': '15041', 'zone': '2019'},
    {'commune': '15042', 'zone': '2019'},
    {'commune': '15043', 'zone': '2019'},
    {'commune': '15045', 'zone': '2019'},
    {'commune': '15046', 'zone': '2019'},
    {'commune': '15048', 'zone': '2019'},
    {'commune': '15049', 'zone': '2019'},
    {'commune': '15050', 'zone': '2019'},
    {'commune': '15051', 'zone': '2019'},
    {'commune': '15052', 'zone': '2019'},
    {'commune': '15053', 'zone': '2019'},
    {'commune': '15054', 'zone': '2019'},
    {'commune': '15055', 'zone': '2019'},
    {'commune': '15056', 'zone': '2019'},
    {'commune': '15057', 'zone': '2019'},
    {'commune': '15058', 'zone': '2019'},
    {'commune': '15059', 'zone': '2019'},
    {'commune': '15060', 'zone': '2019'},
    {'commune': '15061', 'zone': '2019'},
    {'commune': '15063', 'zone': '2019'},
    {'commune': '15064', 'zone': '2019'},
    {'commune': '15065', 'zone': '2019'},
    {'commune': '15066', 'zone': '2019'},
    {'commune': '15067', 'zone': '2019'},
    {'commune': '15069', 'zone': '2019'},
    {'commune': '15070', 'zone': '2019'},
    {'commune': '15072', 'zone': '2019'},
    {'commune': '15073', 'zone': '2019'},
    {'commune': '15074', 'zone': '2019'},
    {'commune': '15075', 'zone': '2019'},
    {'commune': '15076', 'zone': '2019'},
    {'commune': '15077', 'zone': '2019'},
    {'commune': '15078', 'zone': '2019'},
    {'commune': '15079', 'zone': '2019'},
    {'commune': '15080', 'zone': '2019'},
    {'commune': '15081', 'zone': '2019'},
    {'commune': '15082', 'zone': '2019'},
    {'commune': '15083', 'zone': '2019'},
    {'commune': '15084', 'zone': '2019'},
    {'commune': '15085', 'zone': '2019'},
    {'commune': '15086', 'zone': '2019'},
    {'commune': '15087', 'zone': '2019'},
    {'commune': '15088', 'zone': '2019'},
    {'commune': '15089', 'zone': '2019'},
    {'commune': '15090', 'zone': '2019'},
    {'commune': '15091', 'zone': '2019'},
    {'commune': '15092', 'zone': '2019'},
    {'commune': '15093', 'zone': '2019'},
    {'commune': '15094', 'zone': '2019'},
    {'commune': '15095', 'zone': '2019'},
    {'commune': '15096', 'zone': '2019'},
    {'commune': '15097', 'zone': '2019'},
    {'commune': '15098', 'zone': '2019'},
    {'commune': '15100', 'zone': '2019'},
    {'commune': '15101', 'zone': '2019'},
    {'commune': '15102', 'zone': '2019'},
    {'commune': '15103', 'zone': '2019'},
    {'commune': '15104', 'zone': '2019'},
    {'commune': '15105', 'zone': '2019'},
    {'commune': '15106', 'zone': '2019'},
    {'commune': '15107', 'zone': '2019'},
    {'commune': '15108', 'zone': '2019'},
    {'commune': '15110', 'zone': '2019'},
    {'commune': '15111', 'zone': '2019'},
    {'commune': '15112', 'zone': '2019'},
    {'commune': '15113', 'zone': '2019'},
    {'commune': '15114', 'zone': '2019'},
    {'commune': '15116', 'zone': '2019'},
    {'commune': '15117', 'zone': '2019'},
    {'commune': '15118', 'zone': '2019'},
    {'commune': '15119', 'zone': '2019'},
    {'commune': '15120', 'zone': '2019'},
    {'commune': '15121', 'zone': '2019'},
    {'commune': '15122', 'zone': '2019'},
    {'commune': '15123', 'zone': '2019'},
    {'commune': '15124', 'zone': '2019'},
    {'commune': '15125', 'zone': '2019'},
    {'commune': '15126', 'zone': '2019'},
    {'commune': '15127', 'zone': '2019'},
    {'commune': '15128', 'zone': '2019'},
    {'commune': '15129', 'zone': '2019'},
    {'commune': '15130', 'zone': '2019'},
    {'commune': '15131', 'zone': '2019'},
    {'commune': '15132', 'zone': '2019'},
    {'commune': '15133', 'zone': '2019'},
    {'commune': '15134', 'zone': '2019'},
    {'commune': '15135', 'zone': '2019'},
    {'commune': '15137', 'zone': '2019'},
    {'commune': '15138', 'zone': '2019'},
    {'commune': '15139', 'zone': '2019'},
    {'commune': '15140', 'zone': '2019'},
    {'commune': '15141', 'zone': '2019'},
    {'commune': '15142', 'zone': '2019'},
    {'commune': '15143', 'zone': '2019'},
    {'commune': '15144', 'zone': '2019'},
    {'commune': '15146', 'zone': '2019'},
    {'commune': '15147', 'zone': '2019'},
    {'commune': '15148', 'zone': '2019'},
    {'commune': '15149', 'zone': '2019'},
    {'commune': '15151', 'zone': '2019'},
    {'commune': '15152', 'zone': '2019'},
    {'commune': '15153', 'zone': '2019'},
    {'commune': '15154', 'zone': '2019'},
    {'commune': '15155', 'zone': '2019'},
    {'commune': '15156', 'zone': '2019'},
    {'commune': '15157', 'zone': '2019'},
    {'commune': '15158', 'zone': '2019'},
    {'commune': '15159', 'zone': '2019'},
    {'commune': '15160', 'zone': '2019'},
    {'commune': '15161', 'zone': '2019'},
    {'commune': '15162', 'zone': '2019'},
    {'commune': '15163', 'zone': '2019'},
    {'commune': '15164', 'zone': '2019'},
    {'commune': '15165', 'zone': '2019'},
    {'commune': '15166', 'zone': '2019'},
    {'commune': '15167', 'zone': '2019'},
    {'commune': '15168', 'zone': '2019'},
    {'commune': '15169', 'zone': '2019'},
    {'commune': '15170', 'zone': '2019'},
    {'commune': '15172', 'zone': '2019'},
    {'commune': '15173', 'zone': '2019'},
    {'commune': '15174', 'zone': '2019'},
    {'commune': '15175', 'zone': '2019'},
    {'commune': '15176', 'zone': '2019'},
    {'commune': '15178', 'zone': '2019'},
    {'commune': '15179', 'zone': '2019'},
    {'commune': '15180', 'zone': '2019'},
    {'commune': '15181', 'zone': '2019'},
    {'commune': '15182', 'zone': '2019'},
    {'commune': '15183', 'zone': '2019'},
    {'commune': '15184', 'zone': '2019'},
    {'commune': '15185', 'zone': '2019'},
    {'commune': '15186', 'zone': '2019'},
    {'commune': '15187', 'zone': '2019'},
    {'commune': '15188', 'zone': '2019'},
    {'commune': '15189', 'zone': '2019'},
    {'commune': '15190', 'zone': '2019'},
    {'commune': '15191', 'zone': '2019'},
    {'commune': '15192', 'zone': '2019'},
    {'commune': '15194', 'zone': '2019'},
    {'commune': '15196', 'zone': '2019'},
    {'commune': '15198', 'zone': '2019'},
    {'commune': '15199', 'zone': '2019'},
    {'commune': '15200', 'zone': '2019'},
    {'commune': '15201', 'zone': '2019'},
    {'commune': '15202', 'zone': '2019'},
    {'commune': '15203', 'zone': '2019'},
    {'commune': '15204', 'zone': '2019'},
    {'commune': '15205', 'zone': '2019'},
    {'commune': '15206', 'zone': '2019'},
    {'commune': '15207', 'zone': '2019'},
    {'commune': '15208', 'zone': '2019'},
    {'commune': '15209', 'zone': '2019'},
    {'commune': '15211', 'zone': '2019'},
    {'commune': '15212', 'zone': '2019'},
    {'commune': '15213', 'zone': '2019'},
    {'commune': '15214', 'zone': '2019'},
    {'commune': '15215', 'zone': '2019'},
    {'commune': '15216', 'zone': '2019'},
    {'commune': '15217', 'zone': '2019'},
    {'commune': '15218', 'zone': '2019'},
    {'commune': '15219', 'zone': '2019'},
    {'commune': '15220', 'zone': '2019'},
    {'commune': '15221', 'zone': '2019'},
    {'commune': '15222', 'zone': '2019'},
    {'commune': '15223', 'zone': '2019'},
    {'commune': '15224', 'zone': '2019'},
    {'commune': '15225', 'zone': '2019'},
    {'commune': '15226', 'zone': '2019'},
    {'commune': '15228', 'zone': '2019'},
    {'commune': '15229', 'zone': '2019'},
    {'commune': '15230', 'zone': '2019'},
    {'commune': '15231', 'zone': '2019'},
    {'commune': '15232', 'zone': '2019'},
    {'commune': '15233', 'zone': '2019'},
    {'commune': '15234', 'zone': '2019'},
    {'commune': '15235', 'zone': '2019'},
    {'commune': '15236', 'zone': '2019'},
    {'commune': '15237', 'zone': '2019'},
    {'commune': '15238', 'zone': '2019'},
    {'commune': '15240', 'zone': '2019'},
    {'commune': '15241', 'zone': '2019'},
    {'commune': '15242', 'zone': '2019'},
    {'commune': '15243', 'zone': '2019'},
    {'commune': '15244', 'zone': '2019'},
    {'commune': '15245', 'zone': '2019'},
    {'commune': '15246', 'zone': '2019'},
    {'commune': '15247', 'zone': '2019'},
    {'commune': '15248', 'zone': '2019'},
    {'commune': '15249', 'zone': '2019'},
    {'commune': '15250', 'zone': '2019'},
    {'commune': '15251', 'zone': '2019'},
    {'commune': '15252', 'zone': '2019'},
    {'commune': '15253', 'zone': '2019'},
    {'commune': '15254', 'zone': '2019'},
    {'commune': '15255', 'zone': '2019'},
    {'commune': '15256', 'zone': '2019'},
    {'commune': '15257', 'zone': '2019'},
    {'commune': '15258', 'zone': '2019'},
    {'commune': '15259', 'zone': '2019'},
    {'commune': '15260', 'zone': '2019'},
    {'commune': '15261', 'zone': '2019'},
    {'commune': '15262', 'zone': '2019'},
    {'commune': '15263', 'zone': '2019'},
    {'commune': '15264', 'zone': '2019'},
    {'commune': '15265', 'zone': '2019'},
    {'commune': '15266', 'zone': '2019'},
    {'commune': '15267', 'zone': '2019'},
    {'commune': '15268', 'zone': '2019'},
    {'commune': '15269', 'zone': '2019'},
    {'commune': '26001', 'zone': '2005'},
    {'commune': '26002', 'zone': '2009'},
    {'commune': '26003', 'zone': '2005'},
    {'commune': '26004', 'zone': '2009'},
    {'commune': '26005', 'zone': '2009'},
    {'commune': '26006', 'zone': '2009'},
    {'commune': '26007', 'zone': '2009'},
    {'commune': '26008', 'zone': '2009'},
    {'commune': '26009', 'zone': '2009'},
    {'commune': '26010', 'zone': '2009'},
    {'commune': '26011', 'zone': '2005'},
    {'commune': '26012', 'zone': '2005'},
    {'commune': '26013', 'zone': '2005'},
    {'commune': '26014', 'zone': '2009'},
    {'commune': '26015', 'zone': '2005'},
    {'commune': '26016', 'zone': '2005'},
    {'commune': '26017', 'zone': '2005'},
    {'commune': '26018', 'zone': '2005'},
    {'commune': '26019', 'zone': '2005'},
    {'commune': '26020', 'zone': '2005'},
    {'commune': '26021', 'zone': '2005'},
    {'commune': '26022', 'zone': '2005'},
    {'commune': '26023', 'zone': '2009'},
    {'commune': '26024', 'zone': '2005'},
    {'commune': '26025', 'zone': '2005'},
    {'commune': '26026', 'zone': '2005'},
    {'commune': '26027', 'zone': '2005'},
    {'commune': '26028', 'zone': '2009'},
    {'commune': '26030', 'zone': '2005'},
    {'commune': '26031', 'zone': '2009'},
    {'commune': '26032', 'zone': '2005'},
    {'commune': '26033', 'zone': '2009'},
    {'commune': '26034', 'zone': '2009'},
    {'commune': '26035', 'zone': '2005'},
    {'commune': '26036', 'zone': '2005'},
    {'commune': '26037', 'zone': '2009'},
    {'commune': '26038', 'zone': '2009'},
    {'commune': '26039', 'zone': '2009'},
    {'commune': '26040', 'zone': '2005'},
    {'commune': '26041', 'zone': '2009'},
    {'commune': '26042', 'zone': '2009'},
    {'commune': '26043', 'zone': '2005'},
    {'commune': '26045', 'zone': '2005'},
    {'commune': '26046', 'zone': '2005'},
    {'commune': '26047', 'zone': '2005'},
    {'commune': '26048', 'zone': '2005'},
    {'commune': '26049', 'zone': '2009'},
    {'commune': '26050', 'zone': '2005'},
    {'commune': '26051', 'zone': '2005'},
    {'commune': '26052', 'zone': '2009'},
    {'commune': '26054', 'zone': '2009'},
    {'commune': '26055', 'zone': '2005'},
    {'commune': '26056', 'zone': '2005'},
    {'commune': '26057', 'zone': '2009'},
    {'commune': '26058', 'zone': '2009'},
    {'commune': '26059', 'zone': '2005'},
    {'commune': '26060', 'zone': '2005'},
    {'commune': '26061', 'zone': '2009'},
    {'commune': '26062', 'zone': '2005'},
    {'commune': '26063', 'zone': '2005'},
    {'commune': '26064', 'zone': '2009'},
    {'commune': '26065', 'zone': '2005'},
    {'commune': '26066', 'zone': '2005'},
    {'commune': '26067', 'zone': '2005'},
    {'commune': '26068', 'zone': '2009'},
    {'commune': '26069', 'zone': '2005'},
    {'commune': '26070', 'zone': '2009'},
    {'commune': '26071', 'zone': '2009'},
    {'commune': '26072', 'zone': '2009'},
    {'commune': '26073', 'zone': '2009'},
    {'commune': '26074', 'zone': '2005'},
    {'commune': '26075', 'zone': '2005'},
    {'commune': '26076', 'zone': '2005'},
    {'commune': '26077', 'zone': '2009'},
    {'commune': '26078', 'zone': '2005'},
    {'commune': '26079', 'zone': '2009'},
    {'commune': '26080', 'zone': '2005'},
    {'commune': '26081', 'zone': '2005'},
    {'commune': '26082', 'zone': '2005'},
    {'commune': '26083', 'zone': '2009'},
    {'commune': '26084', 'zone': '2009'},
    {'commune': '26085', 'zone': '2009'},
    {'commune': '26086', 'zone': '2005'},
    {'commune': '26087', 'zone': '2009'},
    {'commune': '26088', 'zone': '2009'},
    {'commune': '26089', 'zone': '2005'},
    {'commune': '26090', 'zone': '2005'},
    {'commune': '26091', 'zone': '2005'},
    {'commune': '26092', 'zone': '2009'},
    {'commune': '26093', 'zone': '2009'},
    {'commune': '26094', 'zone': '2009'},
    {'commune': '26095', 'zone': '2005'},
    {'commune': '26096', 'zone': '2009'},
    {'commune': '26097', 'zone': '2009'},
    {'commune': '26098', 'zone': '2005'},
    {'commune': '26099', 'zone': '2009'},
    {'commune': '26100', 'zone': '2005'},
    {'commune': '26101', 'zone': '2005'},
    {'commune': '26102', 'zone': '2009'},
    {'commune': '26103', 'zone': '2005'},
    {'commune': '26104', 'zone': '2005'},
    {'commune': '26105', 'zone': '2005'},
    {'commune': '26106', 'zone': '2009'},
    {'commune': '26107', 'zone': '2009'},
    {'commune': '26108', 'zone': '2005'},
    {'commune': '26110', 'zone': '2009'},
    {'commune': '26111', 'zone': '2005'},
    {'commune': '26112', 'zone': '2005'},
    {'commune': '26113', 'zone': '2005'},
    {'commune': '26114', 'zone': '2005'},
    {'commune': '26115', 'zone': '2005'},
    {'commune': '26116', 'zone': '2009'},
    {'commune': '26117', 'zone': '2005'},
    {'commune': '26118', 'zone': '2009'},
    {'commune': '26119', 'zone': '2009'},
    {'commune': '26121', 'zone': '2009'},
    {'commune': '26122', 'zone': '2005'},
    {'commune': '26123', 'zone': '2005'},
    {'commune': '26124', 'zone': '2009'},
    {'commune': '26125', 'zone': '2009'},
    {'commune': '26126', 'zone': '2005'},
    {'commune': '26127', 'zone': '2005'},
    {'commune': '26128', 'zone': '2005'},
    {'commune': '26129', 'zone': '2009'},
    {'commune': '26130', 'zone': '2005'},
    {'commune': '26131', 'zone': '2005'},
    {'commune': '26133', 'zone': '2009'},
    {'commune': '26134', 'zone': '2005'},
    {'commune': '26135', 'zone': '2005'},
    {'commune': '26136', 'zone': '2005'},
    {'commune': '26137', 'zone': '2005'},
    {'commune': '26138', 'zone': '2009'},
    {'commune': '26139', 'zone': '2009'},
    {'commune': '26140', 'zone': '2009'},
    {'commune': '26141', 'zone': '2005'},
    {'commune': '26142', 'zone': '2005'},
    {'commune': '26143', 'zone': '2009'},
    {'commune': '26144', 'zone': '2009'},
    {'commune': '26145', 'zone': '2009'},
    {'commune': '26146', 'zone': '2009'},
    {'commune': '26147', 'zone': '2005'},
    {'commune': '26148', 'zone': '2009'},
    {'commune': '26149', 'zone': '2009'},
    {'commune': '26150', 'zone': '2005'},
    {'commune': '26152', 'zone': '2005'},
    {'commune': '26153', 'zone': '2005'},
    {'commune': '26154', 'zone': '2005'},
    {'commune': '26155', 'zone': '2009'},
    {'commune': '26156', 'zone': '2009'},
    {'commune': '26157', 'zone': '2009'},
    {'commune': '26159', 'zone': '2005'},
    {'commune': '26160', 'zone': '2009'},
    {'commune': '26161', 'zone': '2005'},
    {'commune': '26162', 'zone': '2009'},
    {'commune': '26163', 'zone': '2005'},
    {'commune': '26164', 'zone': '2005'},
    {'commune': '26165', 'zone': '2009'},
    {'commune': '26166', 'zone': '2009'},
    {'commune': '26167', 'zone': '2005'},
    {'commune': '26168', 'zone': '2005'},
    {'commune': '26169', 'zone': '2009'},
    {'commune': '26170', 'zone': '2009'},
    {'commune': '26171', 'zone': '2005'},
    {'commune': '26172', 'zone': '2009'},
    {'commune': '26173', 'zone': '2009'},
    {'commune': '26174', 'zone': '2009'},
    {'commune': '26175', 'zone': '2005'},
    {'commune': '26176', 'zone': '2009'},
    {'commune': '26177', 'zone': '2009'},
    {'commune': '26178', 'zone': '2005'},
    {'commune': '26179', 'zone': '2009'},
    {'commune': '26180', 'zone': '2005'},
    {'commune': '26181', 'zone': '2005'},
    {'commune': '26182', 'zone': '2005'},
    {'commune': '26183', 'zone': '2005'},
    {'commune': '26185', 'zone': '2009'},
    {'commune': '26186', 'zone': '2005'},
    {'commune': '26188', 'zone': '2005'},
    {'commune': '26189', 'zone': '2005'},
    {'commune': '26190', 'zone': '2005'},
    {'commune': '26191', 'zone': '2009'},
    {'commune': '26192', 'zone': '2005'},
    {'commune': '26193', 'zone': '2005'},
    {'commune': '26194', 'zone': '2009'},
    {'commune': '26195', 'zone': '2005'},
    {'commune': '26196', 'zone': '2009'},
    {'commune': '26197', 'zone': '2009'},
    {'commune': '26198', 'zone': '2009'},
    {'commune': '26199', 'zone': '2005'},
    {'commune': '26201', 'zone': '2005'},
    {'commune': '26202', 'zone': '2005'},
    {'commune': '26203', 'zone': '2009'},
    {'commune': '26204', 'zone': '2005'},
    {'commune': '26205', 'zone': '2005'},
    {'commune': '26206', 'zone': '2009'},
    {'commune': '26207', 'zone': '2009'},
    {'commune': '26208', 'zone': '2009'},
    {'commune': '26209', 'zone': '2005'},
    {'commune': '26210', 'zone': '2009'},
    {'commune': '26211', 'zone': '2009'},
    {'commune': '26212', 'zone': '2009'},
    {'commune': '26213', 'zone': '2009'},
    {'commune': '26214', 'zone': '2005'},
    {'commune': '26215', 'zone': '2005'},
    {'commune': '26216', 'zone': '2009'},
    {'commune': '26217', 'zone': '2005'},
    {'commune': '26218', 'zone': '2009'},
    {'commune': '26219', 'zone': '2009'},
    {'commune': '26220', 'zone': '2009'},
    {'commune': '26221', 'zone': '2005'},
    {'commune': '26222', 'zone': '2005'},
    {'commune': '26223', 'zone': '2005'},
    {'commune': '26224', 'zone': '2005'},
    {'commune': '26225', 'zone': '2009'},
    {'commune': '26226', 'zone': '2005'},
    {'commune': '26227', 'zone': '2005'},
    {'commune': '26228', 'zone': '2005'},
    {'commune': '26229', 'zone': '2005'},
    {'commune': '26231', 'zone': '2009'},
    {'commune': '26232', 'zone': '2005'},
    {'commune': '26233', 'zone': '2005'},
    {'commune': '26234', 'zone': '2005'},
    {'commune': '26235', 'zone': '2009'},
    {'commune': '26236', 'zone': '2005'},
    {'commune': '26238', 'zone': '2005'},
    {'commune': '26239', 'zone': '2005'},
    {'commune': '26240', 'zone': '2005'},
    {'commune': '26241', 'zone': '2005'},
    {'commune': '26242', 'zone': '2005'},
    {'commune': '26243', 'zone': '2005'},
    {'commune': '26244', 'zone': '2005'},
    {'commune': '26245', 'zone': '2005'},
    {'commune': '26246', 'zone': '2005'},
    {'commune': '26247', 'zone': '2009'},
    {'commune': '26248', 'zone': '2005'},
    {'commune': '26249', 'zone': '2005'},
    {'commune': '26250', 'zone': '2009'},
    {'commune': '26251', 'zone': '2009'},
    {'commune': '26252', 'zone': '2009'},
    {'commune': '26253', 'zone': '2005'},
    {'commune': '26254', 'zone': '2005'},
    {'commune': '26255', 'zone': '2005'},
    {'commune': '26256', 'zone': '2005'},
    {'commune': '26257', 'zone': '2009'},
    {'commune': '26258', 'zone': '2005'},
    {'commune': '26259', 'zone': '2009'},
    {'commune': '26261', 'zone': '2009'},
    {'commune': '26262', 'zone': '2005'},
    {'commune': '26263', 'zone': '2005'},
    {'commune': '26264', 'zone': '2005'},
    {'commune': '26266', 'zone': '2005'},
    {'commune': '26267', 'zone': '2005'},
    {'commune': '26268', 'zone': '2005'},
    {'commune': '26269', 'zone': '2005'},
    {'commune': '26270', 'zone': '2005'},
    {'commune': '26271', 'zone': '2009'},
    {'commune': '26272', 'zone': '2009'},
    {'commune': '26273', 'zone': '2009'},
    {'commune': '26274', 'zone': '2005'},
    {'commune': '26275', 'zone': '2009'},
    {'commune': '26276', 'zone': '2005'},
    {'commune': '26277', 'zone': '2005'},
    {'commune': '26278', 'zone': '2005'},
    {'commune': '26279', 'zone': '2005'},
    {'commune': '26281', 'zone': '2009'},
    {'commune': '26282', 'zone': '2005'},
    {'commune': '26283', 'zone': '2005'},
    {'commune': '26284', 'zone': '2009'},
    {'commune': '26285', 'zone': '2005'},
    {'commune': '26286', 'zone': '2005'},
    {'commune': '26287', 'zone': '2005'},
    {'commune': '26288', 'zone': '2005'},
    {'commune': '26289', 'zone': '2005'},
    {'commune': '26290', 'zone': '2005'},
    {'commune': '26291', 'zone': '2005'},
    {'commune': '26292', 'zone': '2005'},
    {'commune': '26293', 'zone': '2009'},
    {'commune': '26294', 'zone': '2009'},
    {'commune': '26295', 'zone': '2009'},
    {'commune': '26296', 'zone': '2005'},
    {'commune': '26298', 'zone': '2009'},
    {'commune': '26299', 'zone': '2005'},
    {'commune': '26300', 'zone': '2005'},
    {'commune': '26301', 'zone': '2009'},
    {'commune': '26302', 'zone': '2005'},
    {'commune': '26303', 'zone': '2005'},
    {'commune': '26304', 'zone': '2005'},
    {'commune': '26305', 'zone': '2009'},
    {'commune': '26306', 'zone': '2005'},
    {'commune': '26307', 'zone': '2005'},
    {'commune': '26308', 'zone': '2005'},
    {'commune': '26309', 'zone': '2005'},
    {'commune': '26310', 'zone': '2009'},
    {'commune': '26311', 'zone': '2005'},
    {'commune': '26312', 'zone': '2009'},
    {'commune': '26313', 'zone': '2009'},
    {'commune': '26314', 'zone': '2009'},
    {'commune': '26315', 'zone': '2005'},
    {'commune': '26316', 'zone': '2005'},
    {'commune': '26317', 'zone': '2009'},
    {'commune': '26318', 'zone': '2005'},
    {'commune': '26319', 'zone': '2009'},
    {'commune': '26320', 'zone': '2005'},
    {'commune': '26321', 'zone': '2005'},
    {'commune': '26322', 'zone': '2005'},
    {'commune': '26323', 'zone': '2009'},
    {'commune': '26324', 'zone': '2009'},
    {'commune': '26325', 'zone': '2009'},
    {'commune': '26326', 'zone': '2009'},
    {'commune': '26327', 'zone': '2005'},
    {'commune': '26328', 'zone': '2005'},
    {'commune': '26329', 'zone': '2005'},
    {'commune': '26330', 'zone': '2009'},
    {'commune': '26331', 'zone': '2005'},
    {'commune': '26332', 'zone': '2009'},
    {'commune': '26333', 'zone': '2009'},
    {'commune': '26334', 'zone': '2005'},
    {'commune': '26335', 'zone': '2009'},
    {'commune': '26336', 'zone': '2005'},
    {'commune': '26337', 'zone': '2009'},
    {'commune': '26338', 'zone': '2009'},
    {'commune': '26339', 'zone': '2009'},
    {'commune': '26340', 'zone': '2005'},
    {'commune': '26341', 'zone': '2009'},
    {'commune': '26342', 'zone': '2009'},
    {'commune': '26343', 'zone': '2005'},
    {'commune': '26344', 'zone': '2005'},
    {'commune': '26345', 'zone': '2009'},
    {'commune': '26346', 'zone': '2005'},
    {'commune': '26347', 'zone': '2009'},
    {'commune': '26348', 'zone': '2005'},
    {'commune': '26349', 'zone': '2009'},
    {'commune': '26350', 'zone': '2005'},
    {'commune': '26351', 'zone': '2005'},
    {'commune': '26352', 'zone': '2009'},
    {'commune': '26353', 'zone': '2009'},
    {'commune': '26355', 'zone': '2009'},
    {'commune': '26356', 'zone': '2005'},
    {'commune': '26357', 'zone': '2009'},
    {'commune': '26358', 'zone': '2009'},
    {'commune': '26359', 'zone': '2005'},
    {'commune': '26360', 'zone': '2009'},
    {'commune': '26361', 'zone': '2005'},
    {'commune': '26362', 'zone': '2009'},
    {'commune': '26363', 'zone': '2005'},
    {'commune': '26364', 'zone': '2005'},
    {'commune': '26365', 'zone': '2005'},
    {'commune': '26367', 'zone': '2005'},
    {'commune': '26368', 'zone': '2005'},
    {'commune': '26369', 'zone': '2005'},
    {'commune': '26370', 'zone': '2005'},
    {'commune': '26371', 'zone': '2005'},
    {'commune': '26372', 'zone': '2005'},
    {'commune': '26373', 'zone': '2005'},
    {'commune': '26374', 'zone': '2005'},
    {'commune': '26375', 'zone': '2005'},
    {'commune': '26376', 'zone': '2005'},
    {'commune': '26377', 'zone': '2009'},
    {'commune': '26378', 'zone': '2005'},
    {'commune': '26379', 'zone': '2009'},
    {'commune': '26380', 'zone': '2009'},
    {'commune': '26381', 'zone': '2009'},
    {'commune': '26382', 'zone': '2009'},
    {'commune': '38001', 'zone': '2003'},
    {'commune': '38002', 'zone': '2013'},
    {'commune': '38003', 'zone': '2003'},
    {'commune': '38004', 'zone': '2003'},
    {'commune': '38005', 'zone': '2013'},
    {'commune': '38006', 'zone': '2013'},
    {'commune': '38008', 'zone': '2013'},
    {'commune': '38009', 'zone': '2003'},
    {'commune': '38010', 'zone': '2003'},
    {'commune': '38011', 'zone': '2003'},
    {'commune': '38012', 'zone': '2003'},
    {'commune': '38013', 'zone': '2003'},
    {'commune': '38015', 'zone': '2003'},
    {'commune': '38017', 'zone': '2003'},
    {'commune': '38018', 'zone': '2013'},
    {'commune': '38019', 'zone': '2003'},
    {'commune': '38020', 'zone': '2013'},
    {'commune': '38022', 'zone': '2003'},
    {'commune': '38023', 'zone': '2013'},
    {'commune': '38026', 'zone': '2003'},
    {'commune': '38027', 'zone': '2000'},
    {'commune': '38029', 'zone': '2003'},
    {'commune': '38030', 'zone': '2000'},
    {'commune': '38031', 'zone': '2013'},
    {'commune': '38032', 'zone': '2003'},
    {'commune': '38033', 'zone': '2003'},
    {'commune': '38034', 'zone': '2003'},
    {'commune': '38035', 'zone': '2003'},
    {'commune': '38036', 'zone': '2013'},
    {'commune': '38037', 'zone': '2003'},
    {'commune': '38038', 'zone': '2003'},
    {'commune': '38039', 'zone': '2000'},
    {'commune': '38040', 'zone': '2013'},
    {'commune': '38041', 'zone': '2003'},
    {'commune': '38042', 'zone': '2003'},
    {'commune': '38043', 'zone': '2003'},
    {'commune': '38044', 'zone': '2003'},
    {'commune': '38045', 'zone': '2000'},
    {'commune': '38046', 'zone': '2003'},
    {'commune': '38047', 'zone': '2003'},
    {'commune': '38048', 'zone': '2003'},
    {'commune': '38049', 'zone': '2003'},
    {'commune': '38050', 'zone': '2003'},
    {'commune': '38051', 'zone': '2003'},
    {'commune': '38052', 'zone': '2013'},
    {'commune': '38053', 'zone': '2003'},
    {'commune': '38054', 'zone': '2003'},
    {'commune': '38055', 'zone': '2003'},
    {'commune': '38056', 'zone': '2003'},
    {'commune': '38057', 'zone': '2000'},
    {'commune': '38058', 'zone': '2003'},
    {'commune': '38059', 'zone': '2000'},
    {'commune': '38060', 'zone': '2003'},
    {'commune': '38061', 'zone': '2000'},
    {'commune': '38062', 'zone': '2000'},
    {'commune': '38063', 'zone': '2003'},
    {'commune': '38064', 'zone': '2003'},
    {'commune': '38065', 'zone': '2003'},
    {'commune': '38066', 'zone': '2003'},
    {'commune': '38067', 'zone': '2003'},
    {'commune': '38068', 'zone': '2000'},
    {'commune': '38069', 'zone': '2003'},
    {'commune': '38070', 'zone': '2000'},
    {'commune': '38071', 'zone': '2000'},
    {'commune': '38072', 'zone': '2003'},
    {'commune': '38073', 'zone': '2013'},
    {'commune': '38074', 'zone': '2003'},
    {'commune': '38075', 'zone': '2000'},
    {'commune': '38076', 'zone': '2003'},
    {'commune': '38077', 'zone': '2003'},
    {'commune': '38078', 'zone': '2013'},
    {'commune': '38080', 'zone': '2003'},
    {'commune': '38081', 'zone': '2003'},
    {'commune': '38082', 'zone': '2003'},
    {'commune': '38083', 'zone': '2003'},
    {'commune': '38084', 'zone': '2000'},
    {'commune': '38085', 'zone': '2003'},
    {'commune': '38086', 'zone': '2003'},
    {'commune': '38087', 'zone': '2003'},
    {'commune': '38089', 'zone': '2003'},
    {'commune': '38090', 'zone': '2013'},
    {'commune': '38091', 'zone': '2003'},
    {'commune': '38092', 'zone': '2013'},
    {'commune': '38093', 'zone': '2003'},
    {'commune': '38094', 'zone': '2003'},
    {'commune': '38095', 'zone': '2003'},
    {'commune': '38097', 'zone': '2003'},
    {'commune': '38098', 'zone': '2003'},
    {'commune': '38099', 'zone': '2003'},
    {'commune': '38100', 'zone': '2000'},
    {'commune': '38101', 'zone': '2003'},
    {'commune': '38102', 'zone': '2003'},
    {'commune': '38103', 'zone': '2013'},
    {'commune': '38104', 'zone': '2003'},
    {'commune': '38105', 'zone': '2000'},
    {'commune': '38106', 'zone': '2013'},
    {'commune': '38107', 'zone': '2003'},
    {'commune': '38108', 'zone': '2013'},
    {'commune': '38109', 'zone': '2003'},
    {'commune': '38110', 'zone': '2003'},
    {'commune': '38111', 'zone': '2000'},
    {'commune': '38112', 'zone': '2013'},
    {'commune': '38113', 'zone': '2013'},
    {'commune': '38114', 'zone': '2003'},
    {'commune': '38115', 'zone': '2013'},
    {'commune': '38116', 'zone': '2013'},
    {'commune': '38117', 'zone': '2013'},
    {'commune': '38118', 'zone': '2003'},
    {'commune': '38120', 'zone': '2013'},
    {'commune': '38124', 'zone': '2003'},
    {'commune': '38126', 'zone': '2000'},
    {'commune': '38127', 'zone': '2013'},
    {'commune': '38128', 'zone': '2013'},
    {'commune': '38129', 'zone': '2013'},
    {'commune': '38130', 'zone': '2003'},
    {'commune': '38131', 'zone': '2003'},
    {'commune': '38132', 'zone': '2013'},
    {'commune': '38133', 'zone': '2000'},
    {'commune': '38134', 'zone': '2003'},
    {'commune': '38135', 'zone': '2003'},
    {'commune': '38136', 'zone': '2003'},
    {'commune': '38137', 'zone': '2003'},
    {'commune': '38138', 'zone': '2003'},
    {'commune': '38139', 'zone': '2003'},
    {'commune': '38140', 'zone': '2000'},
    {'commune': '38141', 'zone': '2003'},
    {'commune': '38144', 'zone': '2003'},
    {'commune': '38146', 'zone': '2003'},
    {'commune': '38147', 'zone': '2003'},
    {'commune': '38148', 'zone': '2003'},
    {'commune': '38149', 'zone': '2003'},
    {'commune': '38150', 'zone': '2000'},
    {'commune': '38151', 'zone': '2000'},
    {'commune': '38152', 'zone': '2003'},
    {'commune': '38153', 'zone': '2013'},
    {'commune': '38154', 'zone': '2013'},
    {'commune': '38155', 'zone': '2013'},
    {'commune': '38156', 'zone': '2003'},
    {'commune': '38157', 'zone': '2003'},
    {'commune': '38158', 'zone': '2000'},
    {'commune': '38159', 'zone': '2003'},
    {'commune': '38160', 'zone': '2003'},
    {'commune': '38161', 'zone': '2003'},
    {'commune': '38162', 'zone': '2003'},
    {'commune': '38163', 'zone': '2013'},
    {'commune': '38166', 'zone': '2000'},
    {'commune': '38167', 'zone': '2003'},
    {'commune': '38169', 'zone': '2000'},
    {'commune': '38170', 'zone': '2000'},
    {'commune': '38171', 'zone': '2003'},
    {'commune': '38172', 'zone': '2003'},
    {'commune': '38173', 'zone': '2013'},
    {'commune': '38174', 'zone': '2003'},
    {'commune': '38175', 'zone': '2000'},
    {'commune': '38176', 'zone': '2003'},
    {'commune': '38177', 'zone': '2013'},
    {'commune': '38179', 'zone': '2000'},
    {'commune': '38180', 'zone': '2003'},
    {'commune': '38181', 'zone': '2000'},
    {'commune': '38182', 'zone': '2003'},
    {'commune': '38183', 'zone': '2003'},
    {'commune': '38184', 'zone': '2003'},
    {'commune': '38185', 'zone': '2000'},
    {'commune': '38186', 'zone': '2013'},
    {'commune': '38187', 'zone': '2000'},
    {'commune': '38188', 'zone': '2000'},
    {'commune': '38189', 'zone': '2003'},
    {'commune': '38190', 'zone': '2003'},
    {'commune': '38191', 'zone': '2013'},
    {'commune': '38192', 'zone': '2013'},
    {'commune': '38193', 'zone': '2003'},
    {'commune': '38194', 'zone': '2003'},
    {'commune': '38195', 'zone': '2013'},
    {'commune': '38197', 'zone': '2003'},
    {'commune': '38198', 'zone': '2003'},
    {'commune': '38199', 'zone': '2003'},
    {'commune': '38200', 'zone': '2000'},
    {'commune': '38203', 'zone': '2013'},
    {'commune': '38204', 'zone': '2013'},
    {'commune': '38205', 'zone': '2013'},
    {'commune': '38206', 'zone': '2013'},
    {'commune': '38207', 'zone': '2013'},
    {'commune': '38208', 'zone': '2013'},
    {'commune': '38209', 'zone': '2003'},
    {'commune': '38210', 'zone': '2003'},
    {'commune': '38211', 'zone': '2003'},
    {'commune': '38212', 'zone': '2013'},
    {'commune': '38213', 'zone': '2003'},
    {'commune': '38214', 'zone': '2000'},
    {'commune': '38215', 'zone': '2003'},
    {'commune': '38216', 'zone': '2013'},
    {'commune': '38217', 'zone': '2013'},
    {'commune': '38218', 'zone': '2003'},
    {'commune': '38219', 'zone': '2003'},
    {'commune': '38221', 'zone': '2003'},
    {'commune': '38222', 'zone': '2003'},
    {'commune': '38223', 'zone': '2003'},
    {'commune': '38224', 'zone': '2013'},
    {'commune': '38225', 'zone': '2013'},
    {'commune': '38226', 'zone': '2013'},
    {'commune': '38228', 'zone': '2003'},
    {'commune': '38229', 'zone': '2000'},
    {'commune': '38230', 'zone': '2003'},
    {'commune': '38231', 'zone': '2003'},
    {'commune': '38232', 'zone': '2003'},
    {'commune': '38235', 'zone': '2013'},
    {'commune': '38236', 'zone': '2013'},
    {'commune': '38237', 'zone': '2013'},
    {'commune': '38238', 'zone': '2003'},
    {'commune': '38239', 'zone': '2000'},
    {'commune': '38240', 'zone': '2003'},
    {'commune': '38241', 'zone': '2013'},
    {'commune': '38242', 'zone': '2013'},
    {'commune': '38243', 'zone': '2013'},
    {'commune': '38244', 'zone': '2003'},
    {'commune': '38245', 'zone': '2003'},
    {'commune': '38246', 'zone': '2003'},
    {'commune': '38247', 'zone': '2003'},
    {'commune': '38248', 'zone': '2013'},
    {'commune': '38249', 'zone': '2000'},
    {'commune': '38250', 'zone': '2003'},
    {'commune': '38252', 'zone': '2000'},
    {'commune': '38253', 'zone': '2013'},
    {'commune': '38254', 'zone': '2013'},
    {'commune': '38255', 'zone': '2003'},
    {'commune': '38256', 'zone': '2003'},
    {'commune': '38257', 'zone': '2003'},
    {'commune': '38258', 'zone': '2013'},
    {'commune': '38259', 'zone': '2003'},
    {'commune': '38260', 'zone': '2003'},
    {'commune': '38261', 'zone': '2003'},
    {'commune': '38263', 'zone': '2003'},
    {'commune': '38264', 'zone': '2013'},
    {'commune': '38265', 'zone': '2013'},
    {'commune': '38266', 'zone': '2013'},
    {'commune': '38267', 'zone': '2003'},
    {'commune': '38268', 'zone': '2013'},
    {'commune': '38269', 'zone': '2013'},
    {'commune': '38270', 'zone': '2000'},
    {'commune': '38271', 'zone': '2000'},
    {'commune': '38272', 'zone': '2003'},
    {'commune': '38273', 'zone': '2013'},
    {'commune': '38275', 'zone': '2003'},
    {'commune': '38276', 'zone': '2003'},
    {'commune': '38277', 'zone': '2013'},
    {'commune': '38278', 'zone': '2003'},
    {'commune': '38279', 'zone': '2000'},
    {'commune': '38280', 'zone': '2013'},
    {'commune': '38281', 'zone': '2000'},
    {'commune': '38282', 'zone': '2003'},
    {'commune': '38283', 'zone': '2013'},
    {'commune': '38284', 'zone': '2003'},
    {'commune': '38285', 'zone': '2013'},
    {'commune': '38286', 'zone': '2013'},
    {'commune': '38287', 'zone': '2003'},
    {'commune': '38288', 'zone': '2003'},
    {'commune': '38289', 'zone': '2013'},
    {'commune': '38290', 'zone': '2003'},
    {'commune': '38291', 'zone': '2003'},
    {'commune': '38292', 'zone': '2003'},
    {'commune': '38294', 'zone': '2003'},
    {'commune': '38295', 'zone': '2003'},
    {'commune': '38296', 'zone': '2003'},
    {'commune': '38297', 'zone': '2003'},
    {'commune': '38298', 'zone': '2003'},
    {'commune': '38299', 'zone': '2013'},
    {'commune': '38300', 'zone': '2003'},
    {'commune': '38301', 'zone': '2013'},
    {'commune': '38303', 'zone': '2000'},
    {'commune': '38304', 'zone': '2013'},
    {'commune': '38307', 'zone': '2003'},
    {'commune': '38308', 'zone': '2003'},
    {'commune': '38309', 'zone': '2000'},
    {'commune': '38310', 'zone': '2003'},
    {'commune': '38311', 'zone': '2003'},
    {'commune': '38313', 'zone': '2013'},
    {'commune': '38314', 'zone': '2000'},
    {'commune': '38315', 'zone': '2003'},
    {'commune': '38316', 'zone': '2003'},
    {'commune': '38317', 'zone': '2000'},
    {'commune': '38318', 'zone': '2003'},
    {'commune': '38319', 'zone': '2013'},
    {'commune': '38320', 'zone': '2003'},
    {'commune': '38321', 'zone': '2013'},
    {'commune': '38322', 'zone': '2013'},
    {'commune': '38323', 'zone': '2003'},
    {'commune': '38324', 'zone': '2003'},
    {'commune': '38325', 'zone': '2013'},
    {'commune': '38326', 'zone': '2013'},
    {'commune': '38328', 'zone': '2013'},
    {'commune': '38329', 'zone': '2013'},
    {'commune': '38330', 'zone': '2003'},
    {'commune': '38331', 'zone': '2003'},
    {'commune': '38332', 'zone': '2000'},
    {'commune': '38333', 'zone': '2013'},
    {'commune': '38334', 'zone': '2013'},
    {'commune': '38335', 'zone': '2003'},
    {'commune': '38336', 'zone': '2003'},
    {'commune': '38337', 'zone': '2000'},
    {'commune': '38338', 'zone': '2013'},
    {'commune': '38339', 'zone': '2003'},
    {'commune': '38340', 'zone': '2003'},
    {'commune': '38341', 'zone': '2003'},
    {'commune': '38342', 'zone': '2013'},
    {'commune': '38343', 'zone': '2003'},
    {'commune': '38344', 'zone': '2003'},
    {'commune': '38345', 'zone': '2013'},
    {'commune': '38346', 'zone': '2003'},
    {'commune': '38347', 'zone': '2003'},
    {'commune': '38348', 'zone': '2003'},
    {'commune': '38349', 'zone': '2003'},
    {'commune': '38350', 'zone': '2013'},
    {'commune': '38351', 'zone': '2003'},
    {'commune': '38352', 'zone': '2003'},
    {'commune': '38353', 'zone': '2003'},
    {'commune': '38354', 'zone': '2003'},
    {'commune': '38355', 'zone': '2013'},
    {'commune': '38356', 'zone': '2013'},
    {'commune': '38357', 'zone': '2003'},
    {'commune': '38358', 'zone': '2003'},
    {'commune': '38359', 'zone': '2003'},
    {'commune': '38360', 'zone': '2003'},
    {'commune': '38361', 'zone': '2013'},
    {'commune': '38362', 'zone': '2013'},
    {'commune': '38363', 'zone': '2003'},
    {'commune': '38364', 'zone': '2013'},
    {'commune': '38365', 'zone': '2003'},
    {'commune': '38366', 'zone': '2013'},
    {'commune': '38368', 'zone': '2003'},
    {'commune': '38369', 'zone': '2003'},
    {'commune': '38370', 'zone': '2003'},
    {'commune': '38372', 'zone': '2003'},
    {'commune': '38373', 'zone': '2000'},
    {'commune': '38374', 'zone': '2003'},
    {'commune': '38375', 'zone': '2013'},
    {'commune': '38376', 'zone': '2013'},
    {'commune': '38377', 'zone': '2003'},
    {'commune': '38378', 'zone': '2003'},
    {'commune': '38379', 'zone': '2003'},
    {'commune': '38380', 'zone': '2003'},
    {'commune': '38381', 'zone': '2003'},
    {'commune': '38382', 'zone': '2000'},
    {'commune': '38383', 'zone': '2013'},
    {'commune': '38384', 'zone': '2003'},
    {'commune': '38386', 'zone': '2003'},
    {'commune': '38387', 'zone': '2003'},
    {'commune': '38388', 'zone': '2000'},
    {'commune': '38389', 'zone': '2003'},
    {'commune': '38390', 'zone': '2013'},
    {'commune': '38391', 'zone': '2013'},
    {'commune': '38392', 'zone': '2003'},
    {'commune': '38393', 'zone': '2003'},
    {'commune': '38394', 'zone': '2003'},
    {'commune': '38395', 'zone': '2013'},
    {'commune': '38396', 'zone': '2013'},
    {'commune': '38397', 'zone': '2000'},
    {'commune': '38398', 'zone': '2003'},
    {'commune': '38399', 'zone': '2003'},
    {'commune': '38400', 'zone': '2000'},
    {'commune': '38401', 'zone': '2003'},
    {'commune': '38402', 'zone': '2013'},
    {'commune': '38403', 'zone': '2013'},
    {'commune': '38404', 'zone': '2013'},
    {'commune': '38405', 'zone': '2013'},
    {'commune': '38406', 'zone': '2003'},
    {'commune': '38407', 'zone': '2013'},
    {'commune': '38408', 'zone': '2003'},
    {'commune': '38409', 'zone': '2013'},
    {'commune': '38410', 'zone': '2003'},
    {'commune': '38412', 'zone': '2013'},
    {'commune': '38413', 'zone': '2013'},
    {'commune': '38414', 'zone': '2013'},
    {'commune': '38415', 'zone': '2003'},
    {'commune': '38416', 'zone': '2003'},
    {'commune': '38417', 'zone': '2000'},
    {'commune': '38418', 'zone': '2013'},
    {'commune': '38419', 'zone': '2013'},
    {'commune': '38420', 'zone': '2003'},
    {'commune': '38421', 'zone': '2000'},
    {'commune': '38422', 'zone': '2000'},
    {'commune': '38423', 'zone': '2000'},
    {'commune': '38424', 'zone': '2013'},
    {'commune': '38425', 'zone': '2003'},
    {'commune': '38426', 'zone': '2013'},
    {'commune': '38427', 'zone': '2003'},
    {'commune': '38428', 'zone': '2013'},
    {'commune': '38429', 'zone': '2013'},
    {'commune': '38430', 'zone': '2013'},
    {'commune': '38431', 'zone': '2000'},
    {'commune': '38432', 'zone': '2013'},
    {'commune': '38433', 'zone': '2013'},
    {'commune': '38434', 'zone': '2003'},
    {'commune': '38436', 'zone': '2000'},
    {'commune': '38437', 'zone': '2003'},
    {'commune': '38438', 'zone': '2013'},
    {'commune': '38439', 'zone': '2013'},
    {'commune': '38440', 'zone': '2003'},
    {'commune': '38442', 'zone': '2013'},
    {'commune': '38443', 'zone': '2013'},
    {'commune': '38444', 'zone': '2013'},
    {'commune': '38445', 'zone': '2000'},
    {'commune': '38446', 'zone': '2013'},
    {'commune': '38448', 'zone': '2003'},
    {'commune': '38449', 'zone': '2003'},
    {'commune': '38450', 'zone': '2013'},
    {'commune': '38451', 'zone': '2003'},
    {'commune': '38452', 'zone': '2003'},
    {'commune': '38453', 'zone': '2013'},
    {'commune': '38454', 'zone': '2003'},
    {'commune': '38455', 'zone': '2003'},
    {'commune': '38456', 'zone': '2013'},
    {'commune': '38457', 'zone': '2003'},
    {'commune': '38458', 'zone': '2003'},
    {'commune': '38459', 'zone': '2003'},
    {'commune': '38460', 'zone': '2003'},
    {'commune': '38462', 'zone': '2013'},
    {'commune': '38463', 'zone': '2003'},
    {'commune': '38464', 'zone': '2003'},
    {'commune': '38465', 'zone': '2003'},
    {'commune': '38466', 'zone': '2000'},
    {'commune': '38467', 'zone': '2003'},
    {'commune': '38468', 'zone': '2003'},
    {'commune': '38469', 'zone': '2013'},
    {'commune': '38470', 'zone': '2013'},
    {'commune': '38471', 'zone': '2013'},
    {'commune': '38472', 'zone': '2013'},
    {'commune': '38473', 'zone': '2003'},
    {'commune': '38474', 'zone': '2000'},
    {'commune': '38475', 'zone': '2003'},
    {'commune': '38476', 'zone': '2003'},
    {'commune': '38478', 'zone': '2013'},
    {'commune': '38479', 'zone': '2003'},
    {'commune': '38480', 'zone': '2003'},
    {'commune': '38481', 'zone': '2003'},
    {'commune': '38483', 'zone': '2003'},
    {'commune': '38484', 'zone': '2003'},
    {'commune': '38485', 'zone': '2000'},
    {'commune': '38486', 'zone': '2000'},
    {'commune': '38487', 'zone': '2003'},
    {'commune': '38488', 'zone': '2003'},
    {'commune': '38489', 'zone': '2013'},
    {'commune': '38490', 'zone': '2003'},
    {'commune': '38492', 'zone': '2013'},
    {'commune': '38494', 'zone': '2003'},
    {'commune': '38495', 'zone': '2003'},
    {'commune': '38496', 'zone': '2003'},
    {'commune': '38497', 'zone': '2013'},
    {'commune': '38498', 'zone': '2003'},
    {'commune': '38499', 'zone': '2013'},
    {'commune': '38500', 'zone': '2003'},
    {'commune': '38501', 'zone': '2000'},
    {'commune': '38503', 'zone': '2000'},
    {'commune': '38504', 'zone': '2013'},
    {'commune': '38505', 'zone': '2003'},
    {'commune': '38507', 'zone': '2003'},
    {'commune': '38508', 'zone': '2003'},
    {'commune': '38509', 'zone': '2003'},
    {'commune': '38511', 'zone': '2000'},
    {'commune': '38512', 'zone': '2003'},
    {'commune': '38513', 'zone': '2013'},
    {'commune': '38514', 'zone': '2013'},
    {'commune': '38515', 'zone': '2003'},
    {'commune': '38516', 'zone': '2000'},
    {'commune': '38517', 'zone': '2000'},
    {'commune': '38518', 'zone': '2013'},
    {'commune': '38519', 'zone': '2003'},
    {'commune': '38520', 'zone': '2003'},
    {'commune': '38521', 'zone': '2013'},
    {'commune': '38522', 'zone': '2013'},
    {'commune': '38523', 'zone': '2003'},
    {'commune': '38524', 'zone': '2000'},
    {'commune': '38525', 'zone': '2003'},
    {'commune': '38526', 'zone': '2003'},
    {'commune': '38527', 'zone': '2013'},
    {'commune': '38528', 'zone': '2013'},
    {'commune': '38529', 'zone': '2000'},
    {'commune': '38530', 'zone': '2003'},
    {'commune': '38531', 'zone': '2003'},
    {'commune': '38532', 'zone': '2003'},
    {'commune': '38533', 'zone': '2000'},
    {'commune': '38535', 'zone': '2003'},
    {'commune': '38536', 'zone': '2003'},
    {'commune': '38537', 'zone': '2003'},
    {'commune': '38538', 'zone': '2000'},
    {'commune': '38539', 'zone': '2003'},
    {'commune': '38540', 'zone': '2000'},
    {'commune': '38542', 'zone': '2003'},
    {'commune': '38543', 'zone': '2003'},
    {'commune': '38544', 'zone': '2003'},
    {'commune': '38545', 'zone': '2000'},
    {'commune': '38546', 'zone': '2003'},
    {'commune': '38547', 'zone': '2000'},
    {'commune': '38548', 'zone': '2013'},
    {'commune': '38549', 'zone': '2013'},
    {'commune': '38550', 'zone': '2013'},
    {'commune': '38551', 'zone': '2013'},
    {'commune': '38552', 'zone': '2013'},
    {'commune': '38553', 'zone': '2003'},
    {'commune': '38554', 'zone': '2003'},
    {'commune': '38555', 'zone': '2003'},
    {'commune': '38556', 'zone': '2003'},
    {'commune': '38557', 'zone': '2003'},
    {'commune': '38558', 'zone': '2003'},
    {'commune': '38559', 'zone': '2003'},
    {'commune': '38560', 'zone': '2003'},
    {'commune': '38561', 'zone': '2003'},
    {'commune': '38562', 'zone': '2000'},
    {'commune': '38563', 'zone': '2000'},
    {'commune': '38564', 'zone': '2003'},
    {'commune': '38565', 'zone': '2000'},
    {'commune': '38566', 'zone': '2000'},
    {'commune': '38567', 'zone': '2013'},
    {'commune': '42001', 'zone': '2004'},
    {'commune': '42002', 'zone': '2004'},
    {'commune': '42003', 'zone': '2004'},
    {'commune': '42005', 'zone': '2002'},
    {'commune': '42006', 'zone': '2004'},
    {'commune': '42007', 'zone': '2004'},
    {'commune': '42008', 'zone': '2004'},
    {'commune': '42009', 'zone': '2004'},
    {'commune': '42010', 'zone': '2004'},
    {'commune': '42011', 'zone': '2004'},
    {'commune': '42012', 'zone': '2004'},
    {'commune': '42013', 'zone': '2004'},
    {'commune': '42014', 'zone': '2004'},
    {'commune': '42015', 'zone': '2004'},
    {'commune': '42016', 'zone': '2004'},
    {'commune': '42017', 'zone': '2004'},
    {'commune': '42018', 'zone': '2004'},
    {'commune': '42019', 'zone': '2004'},
    {'commune': '42020', 'zone': '2004'},
    {'commune': '42021', 'zone': '2004'},
    {'commune': '42022', 'zone': '2002'},
    {'commune': '42023', 'zone': '2004'},
    {'commune': '42025', 'zone': '2004'},
    {'commune': '42026', 'zone': '2004'},
    {'commune': '42027', 'zone': '2004'},
    {'commune': '42028', 'zone': '2004'},
    {'commune': '42029', 'zone': '2004'},
    {'commune': '42030', 'zone': '2004'},
    {'commune': '42031', 'zone': '2002'},
    {'commune': '42032', 'zone': '2002'},
    {'commune': '42033', 'zone': '2004'},
    {'commune': '42034', 'zone': '2004'},
    {'commune': '42035', 'zone': '2004'},
    {'commune': '42036', 'zone': '2002'},
    {'commune': '42037', 'zone': '2004'},
    {'commune': '42038', 'zone': '2004'},
    {'commune': '42039', 'zone': '2004'},
    {'commune': '42040', 'zone': '2018'},
    {'commune': '42041', 'zone': '2004'},
    {'commune': '42042', 'zone': '2004'},
    {'commune': '42043', 'zone': '2004'},
    {'commune': '42044', 'zone': '2002'},
    {'commune': '42045', 'zone': '2018'},
    {'commune': '42046', 'zone': '2004'},
    {'commune': '42047', 'zone': '2004'},
    {'commune': '42048', 'zone': '2004'},
    {'commune': '42049', 'zone': '2004'},
    {'commune': '42050', 'zone': '2004'},
    {'commune': '42051', 'zone': '2004'},
    {'commune': '42052', 'zone': '2004'},
    {'commune': '42053', 'zone': '2002'},
    {'commune': '42054', 'zone': '2004'},
    {'commune': '42055', 'zone': '2004'},
    {'commune': '42056', 'zone': '2004'},
    {'commune': '42058', 'zone': '2004'},
    {'commune': '42059', 'zone': '2004'},
    {'commune': '42060', 'zone': '2004'},
    {'commune': '42061', 'zone': '2004'},
    {'commune': '42062', 'zone': '2004'},
    {'commune': '42063', 'zone': '2004'},
    {'commune': '42064', 'zone': '2004'},
    {'commune': '42065', 'zone': '2004'},
    {'commune': '42066', 'zone': '2004'},
    {'commune': '42067', 'zone': '2004'},
    {'commune': '42068', 'zone': '2004'},
    {'commune': '42069', 'zone': '2004'},
    {'commune': '42070', 'zone': '2004'},
    {'commune': '42071', 'zone': '2004'},
    {'commune': '42072', 'zone': '2004'},
    {'commune': '42073', 'zone': '2004'},
    {'commune': '42074', 'zone': '2004'},
    {'commune': '42075', 'zone': '2004'},
    {'commune': '42076', 'zone': '2004'},
    {'commune': '42077', 'zone': '2004'},
    {'commune': '42078', 'zone': '2004'},
    {'commune': '42079', 'zone': '2004'},
    {'commune': '42081', 'zone': '2004'},
    {'commune': '42083', 'zone': '2002'},
    {'commune': '42084', 'zone': '2004'},
    {'commune': '42085', 'zone': '2002'},
    {'commune': '42086', 'zone': '2004'},
    {'commune': '42087', 'zone': '2004'},
    {'commune': '42088', 'zone': '2004'},
    {'commune': '42089', 'zone': '2004'},
    {'commune': '42090', 'zone': '2004'},
    {'commune': '42091', 'zone': '2004'},
    {'commune': '42092', 'zone': '2002'},
    {'commune': '42093', 'zone': '2002'},
    {'commune': '42094', 'zone': '2004'},
    {'commune': '42095', 'zone': '2002'},
    {'commune': '42096', 'zone': '2002'},
    {'commune': '42097', 'zone': '2002'},
    {'commune': '42098', 'zone': '2004'},
    {'commune': '42099', 'zone': '2002'},
    {'commune': '42100', 'zone': '2004'},
    {'commune': '42101', 'zone': '2004'},
    {'commune': '42102', 'zone': '2004'},
    {'commune': '42103', 'zone': '2002'},
    {'commune': '42104', 'zone': '2004'},
    {'commune': '42105', 'zone': '2004'},
    {'commune': '42106', 'zone': '2004'},
    {'commune': '42107', 'zone': '2004'},
    {'commune': '42108', 'zone': '2004'},
    {'commune': '42109', 'zone': '2004'},
    {'commune': '42110', 'zone': '2002'},
    {'commune': '42112', 'zone': '2004'},
    {'commune': '42113', 'zone': '2004'},
    {'commune': '42115', 'zone': '2004'},
    {'commune': '42116', 'zone': '2004'},
    {'commune': '42117', 'zone': '2004'},
    {'commune': '42118', 'zone': '2004'},
    {'commune': '42119', 'zone': '2004'},
    {'commune': '42120', 'zone': '2004'},
    {'commune': '42121', 'zone': '2004'},
    {'commune': '42122', 'zone': '2004'},
    {'commune': '42123', 'zone': '2002'},
    {'commune': '42124', 'zone': '2004'},
    {'commune': '42125', 'zone': '2004'},
    {'commune': '42126', 'zone': '2004'},
    {'commune': '42127', 'zone': '2004'},
    {'commune': '42128', 'zone': '2004'},
    {'commune': '42129', 'zone': '2004'},
    {'commune': '42130', 'zone': '2004'},
    {'commune': '42131', 'zone': '2004'},
    {'commune': '42132', 'zone': '2004'},
    {'commune': '42133', 'zone': '2002'},
    {'commune': '42134', 'zone': '2004'},
    {'commune': '42135', 'zone': '2004'},
    {'commune': '42136', 'zone': '2004'},
    {'commune': '42137', 'zone': '2004'},
    {'commune': '42138', 'zone': '2004'},
    {'commune': '42139', 'zone': '2004'},
    {'commune': '42140', 'zone': '2004'},
    {'commune': '42141', 'zone': '2004'},
    {'commune': '42142', 'zone': '2004'},
    {'commune': '42143', 'zone': '2004'},
    {'commune': '42145', 'zone': '2004'},
    {'commune': '42146', 'zone': '2004'},
    {'commune': '42147', 'zone': '2004'},
    {'commune': '42148', 'zone': '2004'},
    {'commune': '42149', 'zone': '2004'},
    {'commune': '42150', 'zone': '2004'},
    {'commune': '42151', 'zone': '2004'},
    {'commune': '42152', 'zone': '2004'},
    {'commune': '42153', 'zone': '2004'},
    {'commune': '42154', 'zone': '2004'},
    {'commune': '42155', 'zone': '2004'},
    {'commune': '42156', 'zone': '2004'},
    {'commune': '42157', 'zone': '2004'},
    {'commune': '42158', 'zone': '2004'},
    {'commune': '42159', 'zone': '2004'},
    {'commune': '42160', 'zone': '2004'},
    {'commune': '42161', 'zone': '2004'},
    {'commune': '42162', 'zone': '2004'},
    {'commune': '42163', 'zone': '2004'},
    {'commune': '42164', 'zone': '2004'},
    {'commune': '42165', 'zone': '2004'},
    {'commune': '42166', 'zone': '2004'},
    {'commune': '42167', 'zone': '2002'},
    {'commune': '42168', 'zone': '2004'},
    {'commune': '42169', 'zone': '2004'},
    {'commune': '42170', 'zone': '2004'},
    {'commune': '42171', 'zone': '2004'},
    {'commune': '42172', 'zone': '2004'},
    {'commune': '42173', 'zone': '2004'},
    {'commune': '42174', 'zone': '2004'},
    {'commune': '42175', 'zone': '2004'},
    {'commune': '42176', 'zone': '2004'},
    {'commune': '42177', 'zone': '2004'},
    {'commune': '42178', 'zone': '2004'},
    {'commune': '42179', 'zone': '2004'},
    {'commune': '42180', 'zone': '2004'},
    {'commune': '42181', 'zone': '2004'},
    {'commune': '42182', 'zone': '2004'},
    {'commune': '42183', 'zone': '2002'},
    {'commune': '42184', 'zone': '2004'},
    {'commune': '42185', 'zone': '2004'},
    {'commune': '42186', 'zone': '2002'},
    {'commune': '42187', 'zone': '2004'},
    {'commune': '42188', 'zone': '2004'},
    {'commune': '42189', 'zone': '2002'},
    {'commune': '42191', 'zone': '2004'},
    {'commune': '42192', 'zone': '2004'},
    {'commune': '42193', 'zone': '2004'},
    {'commune': '42194', 'zone': '2004'},
    {'commune': '42195', 'zone': '2004'},
    {'commune': '42196', 'zone': '2004'},
    {'commune': '42197', 'zone': '2004'},
    {'commune': '42198', 'zone': '2004'},
    {'commune': '42199', 'zone': '2004'},
    {'commune': '42200', 'zone': '2004'},
    {'commune': '42201', 'zone': '2004'},
    {'commune': '42202', 'zone': '2004'},
    {'commune': '42203', 'zone': '2004'},
    {'commune': '42204', 'zone': '2004'},
    {'commune': '42205', 'zone': '2004'},
    {'commune': '42206', 'zone': '2002'},
    {'commune': '42207', 'zone': '2002'},
    {'commune': '42208', 'zone': '2002'},
    {'commune': '42209', 'zone': '2004'},
    {'commune': '42210', 'zone': '2002'},
    {'commune': '42211', 'zone': '2002'},
    {'commune': '42212', 'zone': '2004'},
    {'commune': '42213', 'zone': '2004'},
    {'commune': '42214', 'zone': '2004'},
    {'commune': '42215', 'zone': '2004'},
    {'commune': '42216', 'zone': '2004'},
    {'commune': '42217', 'zone': '2004'},
    {'commune': '42218', 'zone': '2002'},
    {'commune': '42219', 'zone': '2004'},
    {'commune': '42220', 'zone': '2004'},
    {'commune': '42221', 'zone': '2004'},
    {'commune': '42222', 'zone': '2004'},
    {'commune': '42223', 'zone': '2002'},
    {'commune': '42224', 'zone': '2004'},
    {'commune': '42225', 'zone': '2002'},
    {'commune': '42226', 'zone': '2004'},
    {'commune': '42227', 'zone': '2004'},
    {'commune': '42228', 'zone': '2004'},
    {'commune': '42229', 'zone': '2004'},
    {'commune': '42230', 'zone': '2004'},
    {'commune': '42231', 'zone': '2004'},
    {'commune': '42232', 'zone': '2004'},
    {'commune': '42233', 'zone': '2004'},
    {'commune': '42234', 'zone': '2002'},
    {'commune': '42235', 'zone': '2004'},
    {'commune': '42236', 'zone': '2004'},
    {'commune': '42237', 'zone': '2002'},
    {'commune': '42238', 'zone': '2004'},
    {'commune': '42239', 'zone': '2004'},
    {'commune': '42240', 'zone': '2004'},
    {'commune': '42241', 'zone': '2004'},
    {'commune': '42242', 'zone': '2002'},
    {'commune': '42243', 'zone': '2004'},
    {'commune': '42245', 'zone': '2004'},
    {'commune': '42246', 'zone': '2004'},
    {'commune': '42247', 'zone': '2004'},
    {'commune': '42248', 'zone': '2004'},
    {'commune': '42249', 'zone': '2004'},
    {'commune': '42251', 'zone': '2004'},
    {'commune': '42252', 'zone': '2004'},
    {'commune': '42253', 'zone': '2004'},
    {'commune': '42254', 'zone': '2004'},
    {'commune': '42255', 'zone': '2004'},
    {'commune': '42256', 'zone': '2002'},
    {'commune': '42257', 'zone': '2004'},
    {'commune': '42259', 'zone': '2002'},
    {'commune': '42260', 'zone': '2004'},
    {'commune': '42261', 'zone': '2004'},
    {'commune': '42262', 'zone': '2004'},
    {'commune': '42264', 'zone': '2004'},
    {'commune': '42265', 'zone': '2004'},
    {'commune': '42266', 'zone': '2004'},
    {'commune': '42267', 'zone': '2004'},
    {'commune': '42268', 'zone': '2004'},
    {'commune': '42269', 'zone': '2004'},
    {'commune': '42270', 'zone': '2002'},
    {'commune': '42271', 'zone': '2002'},
    {'commune': '42272', 'zone': '2004'},
    {'commune': '42273', 'zone': '2004'},
    {'commune': '42274', 'zone': '2004'},
    {'commune': '42275', 'zone': '2002'},
    {'commune': '42276', 'zone': '2004'},
    {'commune': '42277', 'zone': '2004'},
    {'commune': '42278', 'zone': '2004'},
    {'commune': '42279', 'zone': '2002'},
    {'commune': '42280', 'zone': '2004'},
    {'commune': '42281', 'zone': '2004'},
    {'commune': '42282', 'zone': '2004'},
    {'commune': '42283', 'zone': '2002'},
    {'commune': '42284', 'zone': '2004'},
    {'commune': '42285', 'zone': '2004'},
    {'commune': '42286', 'zone': '2004'},
    {'commune': '42287', 'zone': '2004'},
    {'commune': '42288', 'zone': '2004'},
    {'commune': '42289', 'zone': '2004'},
    {'commune': '42290', 'zone': '2004'},
    {'commune': '42293', 'zone': '2004'},
    {'commune': '42294', 'zone': '2004'},
    {'commune': '42295', 'zone': '2004'},
    {'commune': '42296', 'zone': '2004'},
    {'commune': '42297', 'zone': '2004'},
    {'commune': '42298', 'zone': '2004'},
    {'commune': '42299', 'zone': '2004'},
    {'commune': '42300', 'zone': '2004'},
    {'commune': '42301', 'zone': '2004'},
    {'commune': '42302', 'zone': '2002'},
    {'commune': '42303', 'zone': '2004'},
    {'commune': '42304', 'zone': '2002'},
    {'commune': '42305', 'zone': '2002'},
    {'commune': '42306', 'zone': '2004'},
    {'commune': '42307', 'zone': '2002'},
    {'commune': '42308', 'zone': '2002'},
    {'commune': '42310', 'zone': '2004'},
    {'commune': '42311', 'zone': '2002'},
    {'commune': '42312', 'zone': '2004'},
    {'commune': '42313', 'zone': '2004'},
    {'commune': '42314', 'zone': '2004'},
    {'commune': '42315', 'zone': '2004'},
    {'commune': '42316', 'zone': '2002'},
    {'commune': '42317', 'zone': '2004'},
    {'commune': '42318', 'zone': '2004'},
    {'commune': '42319', 'zone': '2004'},
    {'commune': '42320', 'zone': '2002'},
    {'commune': '42321', 'zone': '2004'},
    {'commune': '42322', 'zone': '2002'},
    {'commune': '42323', 'zone': '2002'},
    {'commune': '42324', 'zone': '2004'},
    {'commune': '42325', 'zone': '2004'},
    {'commune': '42326', 'zone': '2004'},
    {'commune': '42327', 'zone': '2004'},
    {'commune': '42328', 'zone': '2004'},
    {'commune': '42329', 'zone': '2004'},
    {'commune': '42330', 'zone': '2002'},
    {'commune': '42331', 'zone': '2004'},
    {'commune': '42332', 'zone': '2004'},
    {'commune': '42333', 'zone': '2004'},
    {'commune': '42334', 'zone': '2004'},
    {'commune': '42335', 'zone': '2004'},
    {'commune': '42336', 'zone': '2004'},
    {'commune': '42337', 'zone': '2004'},
    {'commune': '42338', 'zone': '2004'},
    {'commune': '42339', 'zone': '2004'},
    {'commune': '43001', 'zone': '2017'},
    {'commune': '43002', 'zone': '2017'},
    {'commune': '43003', 'zone': '2017'},
    {'commune': '43004', 'zone': '2017'},
    {'commune': '43005', 'zone': '2017'},
    {'commune': '43006', 'zone': '2017'},
    {'commune': '43007', 'zone': '2017'},
    {'commune': '43008', 'zone': '2017'},
    {'commune': '43009', 'zone': '2017'},
    {'commune': '43010', 'zone': '2017'},
    {'commune': '43011', 'zone': '2017'},
    {'commune': '43012', 'zone': '2017'},
    {'commune': '43013', 'zone': '2017'},
    {'commune': '43014', 'zone': '2017'},
    {'commune': '43015', 'zone': '2017'},
    {'commune': '43016', 'zone': '2017'},
    {'commune': '43017', 'zone': '2017'},
    {'commune': '43018', 'zone': '2017'},
    {'commune': '43019', 'zone': '2017'},
    {'commune': '43020', 'zone': '2017'},
    {'commune': '43021', 'zone': '2017'},
    {'commune': '43022', 'zone': '2017'},
    {'commune': '43023', 'zone': '2017'},
    {'commune': '43024', 'zone': '2017'},
    {'commune': '43025', 'zone': '2017'},
    {'commune': '43026', 'zone': '2017'},
    {'commune': '43027', 'zone': '2017'},
    {'commune': '43028', 'zone': '2017'},
    {'commune': '43029', 'zone': '2017'},
    {'commune': '43030', 'zone': '2017'},
    {'commune': '43031', 'zone': '2017'},
    {'commune': '43032', 'zone': '2017'},
    {'commune': '43033', 'zone': '2017'},
    {'commune': '43034', 'zone': '2017'},
    {'commune': '43035', 'zone': '2017'},
    {'commune': '43036', 'zone': '2017'},
    {'commune': '43037', 'zone': '2017'},
    {'commune': '43038', 'zone': '2017'},
    {'commune': '43039', 'zone': '2017'},
    {'commune': '43040', 'zone': '2017'},
    {'commune': '43041', 'zone': '2017'},
    {'commune': '43042', 'zone': '2017'},
    {'commune': '43043', 'zone': '2017'},
    {'commune': '43044', 'zone': '2017'},
    {'commune': '43045', 'zone': '2017'},
    {'commune': '43046', 'zone': '2017'},
    {'commune': '43047', 'zone': '2017'},
    {'commune': '43048', 'zone': '2017'},
    {'commune': '43049', 'zone': '2017'},
    {'commune': '43050', 'zone': '2017'},
    {'commune': '43051', 'zone': '2017'},
    {'commune': '43052', 'zone': '2017'},
    {'commune': '43053', 'zone': '2017'},
    {'commune': '43054', 'zone': '2017'},
    {'commune': '43055', 'zone': '2017'},
    {'commune': '43056', 'zone': '2017'},
    {'commune': '43057', 'zone': '2017'},
    {'commune': '43058', 'zone': '2017'},
    {'commune': '43059', 'zone': '2017'},
    {'commune': '43060', 'zone': '2017'},
    {'commune': '43061', 'zone': '2017'},
    {'commune': '43062', 'zone': '2017'},
    {'commune': '43063', 'zone': '2017'},
    {'commune': '43064', 'zone': '2017'},
    {'commune': '43065', 'zone': '2017'},
    {'commune': '43066', 'zone': '2017'},
    {'commune': '43067', 'zone': '2017'},
    {'commune': '43068', 'zone': '2017'},
    {'commune': '43069', 'zone': '2017'},
    {'commune': '43070', 'zone': '2017'},
    {'commune': '43071', 'zone': '2017'},
    {'commune': '43072', 'zone': '2017'},
    {'commune': '43073', 'zone': '2017'},
    {'commune': '43074', 'zone': '2017'},
    {'commune': '43075', 'zone': '2017'},
    {'commune': '43076', 'zone': '2017'},
    {'commune': '43077', 'zone': '2017'},
    {'commune': '43078', 'zone': '2017'},
    {'commune': '43079', 'zone': '2017'},
    {'commune': '43080', 'zone': '2017'},
    {'commune': '43082', 'zone': '2017'},
    {'commune': '43083', 'zone': '2017'},
    {'commune': '43084', 'zone': '2017'},
    {'commune': '43085', 'zone': '2017'},
    {'commune': '43086', 'zone': '2017'},
    {'commune': '43087', 'zone': '2017'},
    {'commune': '43088', 'zone': '2017'},
    {'commune': '43089', 'zone': '2017'},
    {'commune': '43090', 'zone': '2017'},
    {'commune': '43091', 'zone': '2017'},
    {'commune': '43092', 'zone': '2017'},
    {'commune': '43093', 'zone': '2017'},
    {'commune': '43094', 'zone': '2017'},
    {'commune': '43095', 'zone': '2017'},
    {'commune': '43096', 'zone': '2017'},
    {'commune': '43097', 'zone': '2017'},
    {'commune': '43098', 'zone': '2017'},
    {'commune': '43099', 'zone': '2017'},
    {'commune': '43100', 'zone': '2017'},
    {'commune': '43101', 'zone': '2017'},
    {'commune': '43102', 'zone': '2017'},
    {'commune': '43103', 'zone': '2017'},
    {'commune': '43104', 'zone': '2017'},
    {'commune': '43105', 'zone': '2017'},
    {'commune': '43106', 'zone': '2017'},
    {'commune': '43107', 'zone': '2017'},
    {'commune': '43108', 'zone': '2017'},
    {'commune': '43109', 'zone': '2017'},
    {'commune': '43110', 'zone': '2017'},
    {'commune': '43111', 'zone': '2017'},
    {'commune': '43112', 'zone': '2017'},
    {'commune': '43113', 'zone': '2017'},
    {'commune': '43114', 'zone': '2017'},
    {'commune': '43115', 'zone': '2017'},
    {'commune': '43116', 'zone': '2017'},
    {'commune': '43117', 'zone': '2017'},
    {'commune': '43118', 'zone': '2017'},
    {'commune': '43119', 'zone': '2017'},
    {'commune': '43120', 'zone': '2017'},
    {'commune': '43121', 'zone': '2017'},
    {'commune': '43122', 'zone': '2017'},
    {'commune': '43123', 'zone': '2017'},
    {'commune': '43124', 'zone': '2017'},
    {'commune': '43125', 'zone': '2017'},
    {'commune': '43126', 'zone': '2017'},
    {'commune': '43127', 'zone': '2017'},
    {'commune': '43128', 'zone': '2017'},
    {'commune': '43129', 'zone': '2017'},
    {'commune': '43130', 'zone': '2017'},
    {'commune': '43131', 'zone': '2017'},
    {'commune': '43132', 'zone': '2017'},
    {'commune': '43133', 'zone': '2017'},
    {'commune': '43134', 'zone': '2017'},
    {'commune': '43135', 'zone': '2017'},
    {'commune': '43136', 'zone': '2017'},
    {'commune': '43137', 'zone': '2017'},
    {'commune': '43138', 'zone': '2017'},
    {'commune': '43139', 'zone': '2017'},
    {'commune': '43140', 'zone': '2017'},
    {'commune': '43141', 'zone': '2017'},
    {'commune': '43142', 'zone': '2017'},
    {'commune': '43143', 'zone': '2017'},
    {'commune': '43144', 'zone': '2017'},
    {'commune': '43145', 'zone': '2017'},
    {'commune': '43147', 'zone': '2017'},
    {'commune': '43148', 'zone': '2017'},
    {'commune': '43149', 'zone': '2017'},
    {'commune': '43150', 'zone': '2017'},
    {'commune': '43151', 'zone': '2017'},
    {'commune': '43152', 'zone': '2017'},
    {'commune': '43153', 'zone': '2017'},
    {'commune': '43154', 'zone': '2017'},
    {'commune': '43155', 'zone': '2017'},
    {'commune': '43156', 'zone': '2017'},
    {'commune': '43157', 'zone': '2017'},
    {'commune': '43158', 'zone': '2017'},
    {'commune': '43159', 'zone': '2017'},
    {'commune': '43160', 'zone': '2017'},
    {'commune': '43162', 'zone': '2017'},
    {'commune': '43163', 'zone': '2017'},
    {'commune': '43164', 'zone': '2017'},
    {'commune': '43165', 'zone': '2017'},
    {'commune': '43166', 'zone': '2017'},
    {'commune': '43167', 'zone': '2017'},
    {'commune': '43168', 'zone': '2017'},
    {'commune': '43169', 'zone': '2017'},
    {'commune': '43170', 'zone': '2017'},
    {'commune': '43171', 'zone': '2017'},
    {'commune': '43172', 'zone': '2017'},
    {'commune': '43173', 'zone': '2017'},
    {'commune': '43174', 'zone': '2017'},
    {'commune': '43175', 'zone': '2017'},
    {'commune': '43177', 'zone': '2017'},
    {'commune': '43178', 'zone': '2017'},
    {'commune': '43180', 'zone': '2017'},
    {'commune': '43181', 'zone': '2017'},
    {'commune': '43182', 'zone': '2017'},
    {'commune': '43183', 'zone': '2017'},
    {'commune': '43184', 'zone': '2017'},
    {'commune': '43185', 'zone': '2017'},
    {'commune': '43186', 'zone': '2017'},
    {'commune': '43187', 'zone': '2017'},
    {'commune': '43188', 'zone': '2017'},
    {'commune': '43189', 'zone': '2017'},
    {'commune': '43190', 'zone': '2017'},
    {'commune': '43191', 'zone': '2017'},
    {'commune': '43192', 'zone': '2017'},
    {'commune': '43193', 'zone': '2017'},
    {'commune': '43194', 'zone': '2017'},
    {'commune': '43195', 'zone': '2017'},
    {'commune': '43196', 'zone': '2017'},
    {'commune': '43197', 'zone': '2017'},
    {'commune': '43198', 'zone': '2017'},
    {'commune': '43199', 'zone': '2017'},
    {'commune': '43200', 'zone': '2017'},
    {'commune': '43201', 'zone': '2017'},
    {'commune': '43202', 'zone': '2017'},
    {'commune': '43203', 'zone': '2017'},
    {'commune': '43204', 'zone': '2017'},
    {'commune': '43205', 'zone': '2017'},
    {'commune': '43206', 'zone': '2017'},
    {'commune': '43207', 'zone': '2017'},
    {'commune': '43208', 'zone': '2017'},
    {'commune': '43210', 'zone': '2017'},
    {'commune': '43211', 'zone': '2017'},
    {'commune': '43212', 'zone': '2017'},
    {'commune': '43213', 'zone': '2017'},
    {'commune': '43214', 'zone': '2017'},
    {'commune': '43215', 'zone': '2017'},
    {'commune': '43216', 'zone': '2017'},
    {'commune': '43217', 'zone': '2017'},
    {'commune': '43218', 'zone': '2017'},
    {'commune': '43219', 'zone': '2017'},
    {'commune': '43220', 'zone': '2017'},
    {'commune': '43221', 'zone': '2017'},
    {'commune': '43222', 'zone': '2017'},
    {'commune': '43223', 'zone': '2017'},
    {'commune': '43224', 'zone': '2017'},
    {'commune': '43225', 'zone': '2017'},
    {'commune': '43226', 'zone': '2017'},
    {'commune': '43227', 'zone': '2017'},
    {'commune': '43228', 'zone': '2017'},
    {'commune': '43229', 'zone': '2017'},
    {'commune': '43230', 'zone': '2017'},
    {'commune': '43231', 'zone': '2017'},
    {'commune': '43232', 'zone': '2017'},
    {'commune': '43233', 'zone': '2017'},
    {'commune': '43234', 'zone': '2017'},
    {'commune': '43236', 'zone': '2017'},
    {'commune': '43237', 'zone': '2017'},
    {'commune': '43238', 'zone': '2017'},
    {'commune': '43239', 'zone': '2017'},
    {'commune': '43240', 'zone': '2017'},
    {'commune': '43241', 'zone': '2017'},
    {'commune': '43242', 'zone': '2017'},
    {'commune': '43244', 'zone': '2017'},
    {'commune': '43245', 'zone': '2017'},
    {'commune': '43246', 'zone': '2017'},
    {'commune': '43247', 'zone': '2017'},
    {'commune': '43249', 'zone': '2017'},
    {'commune': '43250', 'zone': '2017'},
    {'commune': '43251', 'zone': '2017'},
    {'commune': '43252', 'zone': '2017'},
    {'commune': '43253', 'zone': '2017'},
    {'commune': '43254', 'zone': '2017'},
    {'commune': '43256', 'zone': '2017'},
    {'commune': '43257', 'zone': '2017'},
    {'commune': '43258', 'zone': '2017'},
    {'commune': '43259', 'zone': '2017'},
    {'commune': '43260', 'zone': '2017'},
    {'commune': '43261', 'zone': '2017'},
    {'commune': '43262', 'zone': '2017'},
    {'commune': '43263', 'zone': '2017'},
    {'commune': '43264', 'zone': '2017'},
    {'commune': '43265', 'zone': '2017'},
    {'commune': '43267', 'zone': '2017'},
    {'commune': '43268', 'zone': '2017'},
    {'commune': '63001', 'zone': '2018'},
    {'commune': '63002', 'zone': '2018'},
    {'commune': '63003', 'zone': '2018'},
    {'commune': '63004', 'zone': '2018'},
    {'commune': '63005', 'zone': '2018'},
    {'commune': '63006', 'zone': '2018'},
    {'commune': '63007', 'zone': '2018'},
    {'commune': '63008', 'zone': '2018'},
    {'commune': '63009', 'zone': '2018'},
    {'commune': '63010', 'zone': '2018'},
    {'commune': '63011', 'zone': '2018'},
    {'commune': '63012', 'zone': '2018'},
    {'commune': '63013', 'zone': '2018'},
    {'commune': '63014', 'zone': '2018'},
    {'commune': '63015', 'zone': '2018'},
    {'commune': '63016', 'zone': '2018'},
    {'commune': '63017', 'zone': '2018'},
    {'commune': '63019', 'zone': '2018'},
    {'commune': '63020', 'zone': '2018'},
    {'commune': '63021', 'zone': '2018'},
    {'commune': '63022', 'zone': '2018'},
    {'commune': '63023', 'zone': '2018'},
    {'commune': '63024', 'zone': '2018'},
    {'commune': '63025', 'zone': '2018'},
    {'commune': '63026', 'zone': '2018'},
    {'commune': '63027', 'zone': '2018'},
    {'commune': '63028', 'zone': '2018'},
    {'commune': '63029', 'zone': '2018'},
    {'commune': '63030', 'zone': '2018'},
    {'commune': '63031', 'zone': '2018'},
    {'commune': '63032', 'zone': '2018'},
    {'commune': '63033', 'zone': '2018'},
    {'commune': '63034', 'zone': '2018'},
    {'commune': '63035', 'zone': '2018'},
    {'commune': '63036', 'zone': '2018'},
    {'commune': '63037', 'zone': '2018'},
    {'commune': '63038', 'zone': '2018'},
    {'commune': '63039', 'zone': '2018'},
    {'commune': '63040', 'zone': '2018'},
    {'commune': '63041', 'zone': '2018'},
    {'commune': '63042', 'zone': '2018'},
    {'commune': '63043', 'zone': '2018'},
    {'commune': '63044', 'zone': '2018'},
    {'commune': '63045', 'zone': '2018'},
    {'commune': '63046', 'zone': '2018'},
    {'commune': '63047', 'zone': '2018'},
    {'commune': '63048', 'zone': '2018'},
    {'commune': '63049', 'zone': '2018'},
    {'commune': '63050', 'zone': '2018'},
    {'commune': '63051', 'zone': '2018'},
    {'commune': '63052', 'zone': '2018'},
    {'commune': '63053', 'zone': '2018'},
    {'commune': '63054', 'zone': '2018'},
    {'commune': '63055', 'zone': '2018'},
    {'commune': '63056', 'zone': '2018'},
    {'commune': '63057', 'zone': '2018'},
    {'commune': '63058', 'zone': '2018'},
    {'commune': '63059', 'zone': '2018'},
    {'commune': '63060', 'zone': '2018'},
    {'commune': '63061', 'zone': '2018'},
    {'commune': '63062', 'zone': '2018'},
    {'commune': '63063', 'zone': '2018'},
    {'commune': '63064', 'zone': '2018'},
    {'commune': '63065', 'zone': '2018'},
    {'commune': '63066', 'zone': '2018'},
    {'commune': '63067', 'zone': '2018'},
    {'commune': '63069', 'zone': '2018'},
    {'commune': '63070', 'zone': '2018'},
    {'commune': '63071', 'zone': '2018'},
    {'commune': '63072', 'zone': '2018'},
    {'commune': '63073', 'zone': '2018'},
    {'commune': '63074', 'zone': '2018'},
    {'commune': '63075', 'zone': '2018'},
    {'commune': '63076', 'zone': '2018'},
    {'commune': '63077', 'zone': '2018'},
    {'commune': '63079', 'zone': '2018'},
    {'commune': '63080', 'zone': '2018'},
    {'commune': '63081', 'zone': '2018'},
    {'commune': '63082', 'zone': '2018'},
    {'commune': '63083', 'zone': '2018'},
    {'commune': '63084', 'zone': '2018'},
    {'commune': '63085', 'zone': '2018'},
    {'commune': '63086', 'zone': '2018'},
    {'commune': '63087', 'zone': '2018'},
    {'commune': '63088', 'zone': '2018'},
    {'commune': '63089', 'zone': '2018'},
    {'commune': '63090', 'zone': '2018'},
    {'commune': '63091', 'zone': '2018'},
    {'commune': '63092', 'zone': '2018'},
    {'commune': '63093', 'zone': '2018'},
    {'commune': '63094', 'zone': '2018'},
    {'commune': '63095', 'zone': '2018'},
    {'commune': '63096', 'zone': '2018'},
    {'commune': '63097', 'zone': '2018'},
    {'commune': '63098', 'zone': '2018'},
    {'commune': '63099', 'zone': '2018'},
    {'commune': '63100', 'zone': '2018'},
    {'commune': '63101', 'zone': '2018'},
    {'commune': '63102', 'zone': '2018'},
    {'commune': '63103', 'zone': '2018'},
    {'commune': '63104', 'zone': '2018'},
    {'commune': '63105', 'zone': '2018'},
    {'commune': '63106', 'zone': '2018'},
    {'commune': '63107', 'zone': '2018'},
    {'commune': '63108', 'zone': '2018'},
    {'commune': '63109', 'zone': '2018'},
    {'commune': '63110', 'zone': '2018'},
    {'commune': '63111', 'zone': '2018'},
    {'commune': '63112', 'zone': '2018'},
    {'commune': '63113', 'zone': '2018'},
    {'commune': '63114', 'zone': '2018'},
    {'commune': '63115', 'zone': '2018'},
    {'commune': '63116', 'zone': '2018'},
    {'commune': '63117', 'zone': '2018'},
    {'commune': '63118', 'zone': '2018'},
    {'commune': '63119', 'zone': '2018'},
    {'commune': '63120', 'zone': '2018'},
    {'commune': '63121', 'zone': '2018'},
    {'commune': '63122', 'zone': '2018'},
    {'commune': '63123', 'zone': '2018'},
    {'commune': '63124', 'zone': '2018'},
    {'commune': '63125', 'zone': '2018'},
    {'commune': '63126', 'zone': '2018'},
    {'commune': '63128', 'zone': '2018'},
    {'commune': '63129', 'zone': '2018'},
    {'commune': '63130', 'zone': '2018'},
    {'commune': '63131', 'zone': '2018'},
    {'commune': '63132', 'zone': '2018'},
    {'commune': '63134', 'zone': '2018'},
    {'commune': '63135', 'zone': '2018'},
    {'commune': '63136', 'zone': '2018'},
    {'commune': '63137', 'zone': '2018'},
    {'commune': '63138', 'zone': '2018'},
    {'commune': '63139', 'zone': '2018'},
    {'commune': '63140', 'zone': '2018'},
    {'commune': '63141', 'zone': '2018'},
    {'commune': '63142', 'zone': '2018'},
    {'commune': '63143', 'zone': '2018'},
    {'commune': '63144', 'zone': '2018'},
    {'commune': '63145', 'zone': '2018'},
    {'commune': '63146', 'zone': '2018'},
    {'commune': '63147', 'zone': '2018'},
    {'commune': '63148', 'zone': '2018'},
    {'commune': '63149', 'zone': '2018'},
    {'commune': '63150', 'zone': '2018'},
    {'commune': '63151', 'zone': '2018'},
    {'commune': '63152', 'zone': '2018'},
    {'commune': '63153', 'zone': '2018'},
    {'commune': '63154', 'zone': '2018'},
    {'commune': '63155', 'zone': '2018'},
    {'commune': '63156', 'zone': '2018'},
    {'commune': '63157', 'zone': '2018'},
    {'commune': '63158', 'zone': '2018'},
    {'commune': '63159', 'zone': '2018'},
    {'commune': '63160', 'zone': '2018'},
    {'commune': '63161', 'zone': '2018'},
    {'commune': '63162', 'zone': '2018'},
    {'commune': '63163', 'zone': '2018'},
    {'commune': '63164', 'zone': '2018'},
    {'commune': '63165', 'zone': '2018'},
    {'commune': '63166', 'zone': '2018'},
    {'commune': '63167', 'zone': '2018'},
    {'commune': '63168', 'zone': '2018'},
    {'commune': '63169', 'zone': '2018'},
    {'commune': '63170', 'zone': '2018'},
    {'commune': '63171', 'zone': '2018'},
    {'commune': '63172', 'zone': '2018'},
    {'commune': '63173', 'zone': '2018'},
    {'commune': '63174', 'zone': '2018'},
    {'commune': '63175', 'zone': '2018'},
    {'commune': '63176', 'zone': '2018'},
    {'commune': '63177', 'zone': '2018'},
    {'commune': '63178', 'zone': '2018'},
    {'commune': '63179', 'zone': '2018'},
    {'commune': '63180', 'zone': '2018'},
    {'commune': '63181', 'zone': '2018'},
    {'commune': '63182', 'zone': '2018'},
    {'commune': '63183', 'zone': '2018'},
    {'commune': '63184', 'zone': '2018'},
    {'commune': '63185', 'zone': '2018'},
    {'commune': '63186', 'zone': '2018'},
    {'commune': '63187', 'zone': '2018'},
    {'commune': '63188', 'zone': '2018'},
    {'commune': '63189', 'zone': '2018'},
    {'commune': '63190', 'zone': '2018'},
    {'commune': '63191', 'zone': '2018'},
    {'commune': '63192', 'zone': '2018'},
    {'commune': '63193', 'zone': '2018'},
    {'commune': '63194', 'zone': '2018'},
    {'commune': '63195', 'zone': '2018'},
    {'commune': '63196', 'zone': '2018'},
    {'commune': '63197', 'zone': '2018'},
    {'commune': '63198', 'zone': '2018'},
    {'commune': '63199', 'zone': '2018'},
    {'commune': '63200', 'zone': '2018'},
    {'commune': '63201', 'zone': '2018'},
    {'commune': '63202', 'zone': '2018'},
    {'commune': '63203', 'zone': '2018'},
    {'commune': '63204', 'zone': '2018'},
    {'commune': '63205', 'zone': '2018'},
    {'commune': '63206', 'zone': '2018'},
    {'commune': '63207', 'zone': '2018'},
    {'commune': '63208', 'zone': '2018'},
    {'commune': '63209', 'zone': '2018'},
    {'commune': '63210', 'zone': '2018'},
    {'commune': '63211', 'zone': '2018'},
    {'commune': '63212', 'zone': '2018'},
    {'commune': '63213', 'zone': '2018'},
    {'commune': '63214', 'zone': '2018'},
    {'commune': '63215', 'zone': '2018'},
    {'commune': '63216', 'zone': '2018'},
    {'commune': '63218', 'zone': '2018'},
    {'commune': '63219', 'zone': '2018'},
    {'commune': '63220', 'zone': '2018'},
    {'commune': '63221', 'zone': '2018'},
    {'commune': '63222', 'zone': '2018'},
    {'commune': '63223', 'zone': '2018'},
    {'commune': '63224', 'zone': '2018'},
    {'commune': '63225', 'zone': '2018'},
    {'commune': '63226', 'zone': '2018'},
    {'commune': '63227', 'zone': '2018'},
    {'commune': '63228', 'zone': '2018'},
    {'commune': '63229', 'zone': '2018'},
    {'commune': '63230', 'zone': '2018'},
    {'commune': '63231', 'zone': '2018'},
    {'commune': '63232', 'zone': '2018'},
    {'commune': '63233', 'zone': '2018'},
    {'commune': '63234', 'zone': '2018'},
    {'commune': '63235', 'zone': '2018'},
    {'commune': '63236', 'zone': '2018'},
    {'commune': '63237', 'zone': '2018'},
    {'commune': '63238', 'zone': '2018'},
    {'commune': '63239', 'zone': '2018'},
    {'commune': '63240', 'zone': '2018'},
    {'commune': '63241', 'zone': '2018'},
    {'commune': '63242', 'zone': '2018'},
    {'commune': '63243', 'zone': '2018'},
    {'commune': '63244', 'zone': '2018'},
    {'commune': '63245', 'zone': '2018'},
    {'commune': '63246', 'zone': '2018'},
    {'commune': '63247', 'zone': '2018'},
    {'commune': '63248', 'zone': '2018'},
    {'commune': '63249', 'zone': '2018'},
    {'commune': '63250', 'zone': '2018'},
    {'commune': '63251', 'zone': '2018'},
    {'commune': '63252', 'zone': '2018'},
    {'commune': '63253', 'zone': '2018'},
    {'commune': '63254', 'zone': '2018'},
    {'commune': '63255', 'zone': '2018'},
    {'commune': '63256', 'zone': '2018'},
    {'commune': '63257', 'zone': '2018'},
    {'commune': '63258', 'zone': '2018'},
    {'commune': '63259', 'zone': '2018'},
    {'commune': '63260', 'zone': '2018'},
    {'commune': '63261', 'zone': '2018'},
    {'commune': '63262', 'zone': '2018'},
    {'commune': '63263', 'zone': '2018'},
    {'commune': '63264', 'zone': '2018'},
    {'commune': '63265', 'zone': '2018'},
    {'commune': '63267', 'zone': '2018'},
    {'commune': '63268', 'zone': '2018'},
    {'commune': '63269', 'zone': '2018'},
    {'commune': '63270', 'zone': '2018'},
    {'commune': '63271', 'zone': '2018'},
    {'commune': '63272', 'zone': '2018'},
    {'commune': '63273', 'zone': '2018'},
    {'commune': '63274', 'zone': '2018'},
    {'commune': '63275', 'zone': '2018'},
    {'commune': '63276', 'zone': '2018'},
    {'commune': '63277', 'zone': '2018'},
    {'commune': '63278', 'zone': '2018'},
    {'commune': '63279', 'zone': '2018'},
    {'commune': '63280', 'zone': '2018'},
    {'commune': '63281', 'zone': '2018'},
    {'commune': '63282', 'zone': '2018'},
    {'commune': '63283', 'zone': '2018'},
    {'commune': '63284', 'zone': '2018'},
    {'commune': '63285', 'zone': '2018'},
    {'commune': '63286', 'zone': '2018'},
    {'commune': '63287', 'zone': '2018'},
    {'commune': '63288', 'zone': '2018'},
    {'commune': '63289', 'zone': '2018'},
    {'commune': '63290', 'zone': '2018'},
    {'commune': '63291', 'zone': '2018'},
    {'commune': '63292', 'zone': '2018'},
    {'commune': '63293', 'zone': '2018'},
    {'commune': '63294', 'zone': '2018'},
    {'commune': '63295', 'zone': '2018'},
    {'commune': '63296', 'zone': '2018'},
    {'commune': '63297', 'zone': '2018'},
    {'commune': '63298', 'zone': '2018'},
    {'commune': '63299', 'zone': '2018'},
    {'commune': '63300', 'zone': '2018'},
    {'commune': '63301', 'zone': '2018'},
    {'commune': '63302', 'zone': '2018'},
    {'commune': '63303', 'zone': '2018'},
    {'commune': '63304', 'zone': '2018'},
    {'commune': '63305', 'zone': '2018'},
    {'commune': '63306', 'zone': '2018'},
    {'commune': '63307', 'zone': '2018'},
    {'commune': '63308', 'zone': '2018'},
    {'commune': '63309', 'zone': '2018'},
    {'commune': '63310', 'zone': '2018'},
    {'commune': '63311', 'zone': '2018'},
    {'commune': '63312', 'zone': '2018'},
    {'commune': '63313', 'zone': '2018'},
    {'commune': '63314', 'zone': '2018'},
    {'commune': '63315', 'zone': '2018'},
    {'commune': '63317', 'zone': '2018'},
    {'commune': '63318', 'zone': '2018'},
    {'commune': '63319', 'zone': '2018'},
    {'commune': '63320', 'zone': '2018'},
    {'commune': '63321', 'zone': '2018'},
    {'commune': '63322', 'zone': '2018'},
    {'commune': '63323', 'zone': '2018'},
    {'commune': '63324', 'zone': '2018'},
    {'commune': '63325', 'zone': '2018'},
    {'commune': '63326', 'zone': '2018'},
    {'commune': '63327', 'zone': '2018'},
    {'commune': '63328', 'zone': '2018'},
    {'commune': '63329', 'zone': '2018'},
    {'commune': '63330', 'zone': '2018'},
    {'commune': '63331', 'zone': '2018'},
    {'commune': '63332', 'zone': '2018'},
    {'commune': '63333', 'zone': '2018'},
    {'commune': '63334', 'zone': '2018'},
    {'commune': '63335', 'zone': '2018'},
    {'commune': '63336', 'zone': '2018'},
    {'commune': '63337', 'zone': '2018'},
    {'commune': '63338', 'zone': '2018'},
    {'commune': '63339', 'zone': '2018'},
    {'commune': '63340', 'zone': '2018'},
    {'commune': '63341', 'zone': '2018'},
    {'commune': '63342', 'zone': '2018'},
    {'commune': '63343', 'zone': '2018'},
    {'commune': '63344', 'zone': '2018'},
    {'commune': '63345', 'zone': '2018'},
    {'commune': '63346', 'zone': '2018'},
    {'commune': '63347', 'zone': '2018'},
    {'commune': '63348', 'zone': '2018'},
    {'commune': '63349', 'zone': '2018'},
    {'commune': '63350', 'zone': '2018'},
    {'commune': '63351', 'zone': '2018'},
    {'commune': '63352', 'zone': '2018'},
    {'commune': '63353', 'zone': '2018'},
    {'commune': '63354', 'zone': '2018'},
    {'commune': '63355', 'zone': '2018'},
    {'commune': '63356', 'zone': '2018'},
    {'commune': '63357', 'zone': '2018'},
    {'commune': '63358', 'zone': '2018'},
    {'commune': '63359', 'zone': '2018'},
    {'commune': '63360', 'zone': '2018'},
    {'commune': '63362', 'zone': '2018'},
    {'commune': '63363', 'zone': '2018'},
    {'commune': '63364', 'zone': '2018'},
    {'commune': '63365', 'zone': '2018'},
    {'commune': '63366', 'zone': '2018'},
    {'commune': '63367', 'zone': '2018'},
    {'commune': '63368', 'zone': '2018'},
    {'commune': '63369', 'zone': '2018'},
    {'commune': '63370', 'zone': '2018'},
    {'commune': '63371', 'zone': '2018'},
    {'commune': '63372', 'zone': '2018'},
    {'commune': '63373', 'zone': '2018'},
    {'commune': '63374', 'zone': '2018'},
    {'commune': '63375', 'zone': '2018'},
    {'commune': '63376', 'zone': '2018'},
    {'commune': '63377', 'zone': '2018'},
    {'commune': '63378', 'zone': '2018'},
    {'commune': '63379', 'zone': '2018'},
    {'commune': '63380', 'zone': '2018'},
    {'commune': '63381', 'zone': '2018'},
    {'commune': '63382', 'zone': '2018'},
    {'commune': '63383', 'zone': '2018'},
    {'commune': '63384', 'zone': '2018'},
    {'commune': '63385', 'zone': '2018'},
    {'commune': '63386', 'zone': '2018'},
    {'commune': '63387', 'zone': '2018'},
    {'commune': '63388', 'zone': '2018'},
    {'commune': '63389', 'zone': '2018'},
    {'commune': '63390', 'zone': '2018'},
    {'commune': '63391', 'zone': '2018'},
    {'commune': '63392', 'zone': '2018'},
    {'commune': '63393', 'zone': '2018'},
    {'commune': '63394', 'zone': '2018'},
    {'commune': '63395', 'zone': '2018'},
    {'commune': '63396', 'zone': '2018'},
    {'commune': '63397', 'zone': '2018'},
    {'commune': '63398', 'zone': '2018'},
    {'commune': '63399', 'zone': '2018'},
    {'commune': '63400', 'zone': '2018'},
    {'commune': '63401', 'zone': '2018'},
    {'commune': '63402', 'zone': '2018'},
    {'commune': '63403', 'zone': '2018'},
    {'commune': '63404', 'zone': '2018'},
    {'commune': '63405', 'zone': '2018'},
    {'commune': '63406', 'zone': '2018'},
    {'commune': '63407', 'zone': '2018'},
    {'commune': '63408', 'zone': '2018'},
    {'commune': '63409', 'zone': '2018'},
    {'commune': '63410', 'zone': '2018'},
    {'commune': '63411', 'zone': '2018'},
    {'commune': '63412', 'zone': '2018'},
    {'commune': '63413', 'zone': '2018'},
    {'commune': '63414', 'zone': '2018'},
    {'commune': '63415', 'zone': '2018'},
    {'commune': '63416', 'zone': '2018'},
    {'commune': '63417', 'zone': '2018'},
    {'commune': '63418', 'zone': '2018'},
    {'commune': '63419', 'zone': '2018'},
    {'commune': '63420', 'zone': '2018'},
    {'commune': '63421', 'zone': '2018'},
    {'commune': '63422', 'zone': '2018'},
    {'commune': '63423', 'zone': '2018'},
    {'commune': '63424', 'zone': '2018'},
    {'commune': '63425', 'zone': '2018'},
    {'commune': '63426', 'zone': '2018'},
    {'commune': '63427', 'zone': '2018'},
    {'commune': '63428', 'zone': '2018'},
    {'commune': '63429', 'zone': '2018'},
    {'commune': '63430', 'zone': '2018'},
    {'commune': '63431', 'zone': '2018'},
    {'commune': '63432', 'zone': '2018'},
    {'commune': '63433', 'zone': '2018'},
    {'commune': '63434', 'zone': '2018'},
    {'commune': '63435', 'zone': '2018'},
    {'commune': '63436', 'zone': '2018'},
    {'commune': '63437', 'zone': '2018'},
    {'commune': '63438', 'zone': '2018'},
    {'commune': '63439', 'zone': '2018'},
    {'commune': '63440', 'zone': '2018'},
    {'commune': '63441', 'zone': '2018'},
    {'commune': '63442', 'zone': '2018'},
    {'commune': '63443', 'zone': '2018'},
    {'commune': '63444', 'zone': '2018'},
    {'commune': '63445', 'zone': '2018'},
    {'commune': '63446', 'zone': '2018'},
    {'commune': '63447', 'zone': '2018'},
    {'commune': '63448', 'zone': '2018'},
    {'commune': '63449', 'zone': '2018'},
    {'commune': '63450', 'zone': '2018'},
    {'commune': '63451', 'zone': '2018'},
    {'commune': '63452', 'zone': '2018'},
    {'commune': '63453', 'zone': '2018'},
    {'commune': '63454', 'zone': '2018'},
    {'commune': '63455', 'zone': '2018'},
    {'commune': '63456', 'zone': '2018'},
    {'commune': '63457', 'zone': '2018'},
    {'commune': '63458', 'zone': '2018'},
    {'commune': '63459', 'zone': '2018'},
    {'commune': '63460', 'zone': '2018'},
    {'commune': '63461', 'zone': '2018'},
    {'commune': '63462', 'zone': '2018'},
    {'commune': '63463', 'zone': '2018'},
    {'commune': '63464', 'zone': '2018'},
    {'commune': '63465', 'zone': '2018'},
    {'commune': '63466', 'zone': '2018'},
    {'commune': '63467', 'zone': '2018'},
    {'commune': '63468', 'zone': '2018'},
    {'commune': '63469', 'zone': '2018'},
    {'commune': '63470', 'zone': '2018'},
    {'commune': '63471', 'zone': '2018'},
    {'commune': '63472', 'zone': '2018'},
    {'commune': '63473', 'zone': '2018'},
    {'commune': '69001', 'zone': '2011'},
    {'commune': '69002', 'zone': '2011'},
    {'commune': '69003', 'zone': '2003'},
    {'commune': '69004', 'zone': '2011'},
    {'commune': '69005', 'zone': '2003'},
    {'commune': '69006', 'zone': '2011'},
    {'commune': '69007', 'zone': '2003'},
    {'commune': '69008', 'zone': '2011'},
    {'commune': '69009', 'zone': '2003'},
    {'commune': '69010', 'zone': '2003'},
    {'commune': '69012', 'zone': '2011'},
    {'commune': '69013', 'zone': '2003'},
    {'commune': '69014', 'zone': '2011'},
    {'commune': '69016', 'zone': '2011'},
    {'commune': '69017', 'zone': '2011'},
    {'commune': '69018', 'zone': '2011'},
    {'commune': '69019', 'zone': '2003'},
    {'commune': '69020', 'zone': '2003'},
    {'commune': '69021', 'zone': '2011'},
    {'commune': '69022', 'zone': '2011'},
    {'commune': '69023', 'zone': '2011'},
    {'commune': '69024', 'zone': '2011'},
    {'commune': '69026', 'zone': '2011'},
    {'commune': '69027', 'zone': '2003'},
    {'commune': '69028', 'zone': '2003'},
    {'commune': '69029', 'zone': '2003'},
    {'commune': '69030', 'zone': '2011'},
    {'commune': '69031', 'zone': '2011'},
    {'commune': '69032', 'zone': '2003'},
    {'commune': '69033', 'zone': '2003'},
    {'commune': '69034', 'zone': '2003'},
    {'commune': '69035', 'zone': '2011'},
    {'commune': '69036', 'zone': '2011'},
    {'commune': '69037', 'zone': '2011'},
    {'commune': '69038', 'zone': '2011'},
    {'commune': '69039', 'zone': '2011'},
    {'commune': '69040', 'zone': '2003'},
    {'commune': '69042', 'zone': '2011'},
    {'commune': '69043', 'zone': '2003'},
    {'commune': '69044', 'zone': '2003'},
    {'commune': '69045', 'zone': '2011'},
    {'commune': '69046', 'zone': '2003'},
    {'commune': '69047', 'zone': '2011'},
    {'commune': '69049', 'zone': '2003'},
    {'commune': '69050', 'zone': '2011'},
    {'commune': '69051', 'zone': '2003'},
    {'commune': '69052', 'zone': '2003'},
    {'commune': '69053', 'zone': '2011'},
    {'commune': '69054', 'zone': '2011'},
    {'commune': '69055', 'zone': '2003'},
    {'commune': '69056', 'zone': '2011'},
    {'commune': '69057', 'zone': '2011'},
    {'commune': '69058', 'zone': '2011'},
    {'commune': '69059', 'zone': '2003'},
    {'commune': '69060', 'zone': '2011'},
    {'commune': '69061', 'zone': '2011'},
    {'commune': '69062', 'zone': '2011'},
    {'commune': '69063', 'zone': '2003'},
    {'commune': '69064', 'zone': '2003'},
    {'commune': '69065', 'zone': '2003'},
    {'commune': '69066', 'zone': '2011'},
    {'commune': '69067', 'zone': '2011'},
    {'commune': '69068', 'zone': '2003'},
    {'commune': '69069', 'zone': '2003'},
    {'commune': '69070', 'zone': '2011'},
    {'commune': '69071', 'zone': '2003'},
    {'commune': '69072', 'zone': '2003'},
    {'commune': '69074', 'zone': '2003'},
    {'commune': '69075', 'zone': '2011'},
    {'commune': '69076', 'zone': '2003'},
    {'commune': '69077', 'zone': '2003'},
    {'commune': '69078', 'zone': '2011'},
    {'commune': '69080', 'zone': '2003'},
    {'commune': '69081', 'zone': '2003'},
    {'commune': '69082', 'zone': '2011'},
    {'commune': '69083', 'zone': '2003'},
    {'commune': '69084', 'zone': '2011'},
    {'commune': '69085', 'zone': '2003'},
    {'commune': '69086', 'zone': '2003'},
    {'commune': '69087', 'zone': '2003'},
    {'commune': '69088', 'zone': '2003'},
    {'commune': '69089', 'zone': '2003'},
    {'commune': '69090', 'zone': '2011'},
    {'commune': '69091', 'zone': '2003'},
    {'commune': '69092', 'zone': '2003'},
    {'commune': '69093', 'zone': '2011'},
    {'commune': '69094', 'zone': '2003'},
    {'commune': '69095', 'zone': '2011'},
    {'commune': '69096', 'zone': '2003'},
    {'commune': '69097', 'zone': '2003'},
    {'commune': '69098', 'zone': '2011'},
    {'commune': '69099', 'zone': '2011'},
    {'commune': '69100', 'zone': '2003'},
    {'commune': '69102', 'zone': '2011'},
    {'commune': '69103', 'zone': '2011'},
    {'commune': '69104', 'zone': '2011'},
    {'commune': '69105', 'zone': '2003'},
    {'commune': '69106', 'zone': '2011'},
    {'commune': '69107', 'zone': '2011'},
    {'commune': '69108', 'zone': '2003'},
    {'commune': '69109', 'zone': '2011'},
    {'commune': '69110', 'zone': '2011'},
    {'commune': '69111', 'zone': '2011'},
    {'commune': '69112', 'zone': '2003'},
    {'commune': '69113', 'zone': '2011'},
    {'commune': '69115', 'zone': '2003'},
    {'commune': '69116', 'zone': '2003'},
    {'commune': '69117', 'zone': '2003'},
    {'commune': '69118', 'zone': '2003'},
    {'commune': '69119', 'zone': '2003'},
    {'commune': '69120', 'zone': '2011'},
    {'commune': '69121', 'zone': '2003'},
    {'commune': '69122', 'zone': '2003'},
    {'commune': '69123', 'zone': '2003'},
    {'commune': '69124', 'zone': '2011'},
    {'commune': '69125', 'zone': '2003'},
    {'commune': '69126', 'zone': '2011'},
    {'commune': '69127', 'zone': '2003'},
    {'commune': '69130', 'zone': '2011'},
    {'commune': '69131', 'zone': '2003'},
    {'commune': '69132', 'zone': '2011'},
    {'commune': '69133', 'zone': '2003'},
    {'commune': '69134', 'zone': '2011'},
    {'commune': '69135', 'zone': '2011'},
    {'commune': '69136', 'zone': '2003'},
    {'commune': '69137', 'zone': '2011'},
    {'commune': '69138', 'zone': '2011'},
    {'commune': '69139', 'zone': '2011'},
    {'commune': '69140', 'zone': '2003'},
    {'commune': '69141', 'zone': '2003'},
    {'commune': '69142', 'zone': '2003'},
    {'commune': '69143', 'zone': '2003'},
    {'commune': '69145', 'zone': '2011'},
    {'commune': '69148', 'zone': '2003'},
    {'commune': '69149', 'zone': '2003'},
    {'commune': '69151', 'zone': '2011'},
    {'commune': '69152', 'zone': '2003'},
    {'commune': '69153', 'zone': '2003'},
    {'commune': '69154', 'zone': '2011'},
    {'commune': '69155', 'zone': '2011'},
    {'commune': '69156', 'zone': '2003'},
    {'commune': '69157', 'zone': '2011'},
    {'commune': '69159', 'zone': '2011'},
    {'commune': '69160', 'zone': '2011'},
    {'commune': '69161', 'zone': '2011'},
    {'commune': '69162', 'zone': '2011'},
    {'commune': '69163', 'zone': '2003'},
    {'commune': '69164', 'zone': '2011'},
    {'commune': '69165', 'zone': '2011'},
    {'commune': '69166', 'zone': '2003'},
    {'commune': '69167', 'zone': '2011'},
    {'commune': '69168', 'zone': '2003'},
    {'commune': '69169', 'zone': '2011'},
    {'commune': '69170', 'zone': '2011'},
    {'commune': '69171', 'zone': '2003'},
    {'commune': '69172', 'zone': '2011'},
    {'commune': '69173', 'zone': '2011'},
    {'commune': '69174', 'zone': '2011'},
    {'commune': '69175', 'zone': '2003'},
    {'commune': '69176', 'zone': '2003'},
    {'commune': '69177', 'zone': '2003'},
    {'commune': '69178', 'zone': '2011'},
    {'commune': '69179', 'zone': '2003'},
    {'commune': '69180', 'zone': '2011'},
    {'commune': '69181', 'zone': '2011'},
    {'commune': '69182', 'zone': '2011'},
    {'commune': '69183', 'zone': '2011'},
    {'commune': '69184', 'zone': '2011'},
    {'commune': '69186', 'zone': '2011'},
    {'commune': '69187', 'zone': '2011'},
    {'commune': '69188', 'zone': '2011'},
    {'commune': '69189', 'zone': '2003'},
    {'commune': '69190', 'zone': '2003'},
    {'commune': '69191', 'zone': '2003'},
    {'commune': '69192', 'zone': '2011'},
    {'commune': '69193', 'zone': '2003'},
    {'commune': '69194', 'zone': '2003'},
    {'commune': '69196', 'zone': '2011'},
    {'commune': '69197', 'zone': '2011'},
    {'commune': '69198', 'zone': '2011'},
    {'commune': '69199', 'zone': '2003'},
    {'commune': '69200', 'zone': '2011'},
    {'commune': '69201', 'zone': '2011'},
    {'commune': '69202', 'zone': '2003'},
    {'commune': '69203', 'zone': '2011'},
    {'commune': '69204', 'zone': '2003'},
    {'commune': '69205', 'zone': '2003'},
    {'commune': '69206', 'zone': '2003'},
    {'commune': '69207', 'zone': '2003'},
    {'commune': '69208', 'zone': '2003'},
    {'commune': '69209', 'zone': '2011'},
    {'commune': '69212', 'zone': '2003'},
    {'commune': '69214', 'zone': '2011'},
    {'commune': '69215', 'zone': '2011'},
    {'commune': '69216', 'zone': '2011'},
    {'commune': '69217', 'zone': '2011'},
    {'commune': '69218', 'zone': '2011'},
    {'commune': '69219', 'zone': '2003'},
    {'commune': '69220', 'zone': '2011'},
    {'commune': '69225', 'zone': '2011'},
    {'commune': '69227', 'zone': '2011'},
    {'commune': '69228', 'zone': '2003'},
    {'commune': '69229', 'zone': '2011'},
    {'commune': '69230', 'zone': '2011'},
    {'commune': '69231', 'zone': '2003'},
    {'commune': '69233', 'zone': '2003'},
    {'commune': '69234', 'zone': '2011'},
    {'commune': '69235', 'zone': '2003'},
    {'commune': '69236', 'zone': '2003'},
    {'commune': '69238', 'zone': '2011'},
    {'commune': '69239', 'zone': '2011'},
    {'commune': '69240', 'zone': '2011'},
    {'commune': '69241', 'zone': '2003'},
    {'commune': '69242', 'zone': '2003'},
    {'commune': '69243', 'zone': '2011'},
    {'commune': '69244', 'zone': '2003'},
    {'commune': '69245', 'zone': '2011'},
    {'commune': '69246', 'zone': '2011'},
    {'commune': '69248', 'zone': '2011'},
    {'commune': '69249', 'zone': '2003'},
    {'commune': '69250', 'zone': '2003'},
    {'commune': '69252', 'zone': '2003'},
    {'commune': '69253', 'zone': '2003'},
    {'commune': '69254', 'zone': '2011'},
    {'commune': '69255', 'zone': '2003'},
    {'commune': '69256', 'zone': '2003'},
    {'commune': '69257', 'zone': '2011'},
    {'commune': '69258', 'zone': '2011'},
    {'commune': '69259', 'zone': '2003'},
    {'commune': '69260', 'zone': '2003'},
    {'commune': '69261', 'zone': '2011'},
    {'commune': '69263', 'zone': '2011'},
    {'commune': '69264', 'zone': '2003'},
    {'commune': '69265', 'zone': '2011'},
    {'commune': '69266', 'zone': '2003'},
    {'commune': '69267', 'zone': '2011'},
    {'commune': '69268', 'zone': '2003'},
    {'commune': '69269', 'zone': '2011'},
    {'commune': '69270', 'zone': '2003'},
    {'commune': '69271', 'zone': '2003'},
    {'commune': '69272', 'zone': '2003'},
    {'commune': '69273', 'zone': '2003'},
    {'commune': '69275', 'zone': '2003'},
    {'commune': '69276', 'zone': '2003'},
    {'commune': '69277', 'zone': '2003'},
    {'commune': '69278', 'zone': '2003'},
    {'commune': '69279', 'zone': '2003'},
    {'commune': '69280', 'zone': '2003'},
    {'commune': '69281', 'zone': '2003'},
    {'commune': '69282', 'zone': '2003'},
    {'commune': '69283', 'zone': '2003'},
    {'commune': '69284', 'zone': '2003'},
    {'commune': '69285', 'zone': '2003'},
    {'commune': '69286', 'zone': '2003'},
    {'commune': '69287', 'zone': '2003'},
    {'commune': '69288', 'zone': '2003'},
    {'commune': '69289', 'zone': '2003'},
    {'commune': '69290', 'zone': '2003'},
    {'commune': '69291', 'zone': '2003'},
    {'commune': '69292', 'zone': '2003'},
    {'commune': '69293', 'zone': '2003'},
    {'commune': '69294', 'zone': '2003'},
    {'commune': '69295', 'zone': '2003'},
    {'commune': '69296', 'zone': '2003'},
    {'commune': '69297', 'zone': '2003'},
    {'commune': '69298', 'zone': '2003'},
    {'commune': '69299', 'zone': '2003'},
    {'commune': '73001', 'zone': '2014'},
    {'commune': '73003', 'zone': '2010'},
    {'commune': '73004', 'zone': '2014'},
    {'commune': '73005', 'zone': '2014'},
    {'commune': '73006', 'zone': '2010'},
    {'commune': '73007', 'zone': '2012'},
    {'commune': '73008', 'zone': '2012'},
    {'commune': '73010', 'zone': '2012'},
    {'commune': '73011', 'zone': '2012'},
    {'commune': '73012', 'zone': '2014'},
    {'commune': '73013', 'zone': '2014'},
    {'commune': '73014', 'zone': '2012'},
    {'commune': '73015', 'zone': '2014'},
    {'commune': '73017', 'zone': '2012'},
    {'commune': '73018', 'zone': '2012'},
    {'commune': '73019', 'zone': '2010'},
    {'commune': '73020', 'zone': '2014'},
    {'commune': '73021', 'zone': '2014'},
    {'commune': '73022', 'zone': '2014'},
    {'commune': '73023', 'zone': '2014'},
    {'commune': '73024', 'zone': '2014'},
    {'commune': '73025', 'zone': '2014'},
    {'commune': '73026', 'zone': '2014'},
    {'commune': '73027', 'zone': '2014'},
    {'commune': '73028', 'zone': '2014'},
    {'commune': '73029', 'zone': '2012'},
    {'commune': '73030', 'zone': '2012'},
    {'commune': '73031', 'zone': '2012'},
    {'commune': '73032', 'zone': '2010'},
    {'commune': '73033', 'zone': '2014'},
    {'commune': '73034', 'zone': '2014'},
    {'commune': '73036', 'zone': '2014'},
    {'commune': '73039', 'zone': '2014'},
    {'commune': '73040', 'zone': '2014'},
    {'commune': '73041', 'zone': '2014'},
    {'commune': '73042', 'zone': '2014'},
    {'commune': '73043', 'zone': '2012'},
    {'commune': '73047', 'zone': '2014'},
    {'commune': '73048', 'zone': '2014'},
    {'commune': '73049', 'zone': '2010'},
    {'commune': '73050', 'zone': '2014'},
    {'commune': '73051', 'zone': '2012'},
    {'commune': '73052', 'zone': '2014'},
    {'commune': '73053', 'zone': '2012'},
    {'commune': '73054', 'zone': '2010'},
    {'commune': '73055', 'zone': '2014'},
    {'commune': '73057', 'zone': '2014'},
    {'commune': '73058', 'zone': '2014'},
    {'commune': '73059', 'zone': '2012'},
    {'commune': '73061', 'zone': '2012'},
    {'commune': '73063', 'zone': '2010'},
    {'commune': '73064', 'zone': '2012'},
    {'commune': '73065', 'zone': '2012'},
    {'commune': '73067', 'zone': '2010'},
    {'commune': '73068', 'zone': '2012'},
    {'commune': '73069', 'zone': '2014'},
    {'commune': '73070', 'zone': '2014'},
    {'commune': '73071', 'zone': '2014'},
    {'commune': '73072', 'zone': '2014'},
    {'commune': '73073', 'zone': '2014'},
    {'commune': '73074', 'zone': '2010'},
    {'commune': '73075', 'zone': '2014'},
    {'commune': '73076', 'zone': '2014'},
    {'commune': '73077', 'zone': '2010'},
    {'commune': '73078', 'zone': '2014'},
    {'commune': '73079', 'zone': '2012'},
    {'commune': '73081', 'zone': '2014'},
    {'commune': '73082', 'zone': '2012'},
    {'commune': '73083', 'zone': '2010'},
    {'commune': '73084', 'zone': '2012'},
    {'commune': '73085', 'zone': '2014'},
    {'commune': '73086', 'zone': '2014'},
    {'commune': '73087', 'zone': '2012'},
    {'commune': '73088', 'zone': '2014'},
    {'commune': '73089', 'zone': '2014'},
    {'commune': '73090', 'zone': '2014'},
    {'commune': '73091', 'zone': '2014'},
    {'commune': '73092', 'zone': '2014'},
    {'commune': '73094', 'zone': '2014'},
    {'commune': '73095', 'zone': '2014'},
    {'commune': '73096', 'zone': '2012'},
    {'commune': '73097', 'zone': '2014'},
    {'commune': '73098', 'zone': '2014'},
    {'commune': '73099', 'zone': '2014'},
    {'commune': '73100', 'zone': '2014'},
    {'commune': '73101', 'zone': '2014'},
    {'commune': '73103', 'zone': '2012'},
    {'commune': '73104', 'zone': '2014'},
    {'commune': '73105', 'zone': '2014'},
    {'commune': '73106', 'zone': '2014'},
    {'commune': '73107', 'zone': '2014'},
    {'commune': '73109', 'zone': '2010'},
    {'commune': '73110', 'zone': '2010'},
    {'commune': '73113', 'zone': '2010'},
    {'commune': '73114', 'zone': '2014'},
    {'commune': '73116', 'zone': '2014'},
    {'commune': '73117', 'zone': '2010'},
    {'commune': '73119', 'zone': '2010'},
    {'commune': '73120', 'zone': '2012'},
    {'commune': '73121', 'zone': '2012'},
    {'commune': '73122', 'zone': '2014'},
    {'commune': '73123', 'zone': '2014'},
    {'commune': '73124', 'zone': '2012'},
    {'commune': '73128', 'zone': '2012'},
    {'commune': '73129', 'zone': '2012'},
    {'commune': '73130', 'zone': '2012'},
    {'commune': '73131', 'zone': '2010'},
    {'commune': '73132', 'zone': '2014'},
    {'commune': '73133', 'zone': '2014'},
    {'commune': '73135', 'zone': '2010'},
    {'commune': '73137', 'zone': '2012'},
    {'commune': '73138', 'zone': '2010'},
    {'commune': '73139', 'zone': '2014'},
    {'commune': '73140', 'zone': '2014'},
    {'commune': '73141', 'zone': '2012'},
    {'commune': '73142', 'zone': '2010'},
    {'commune': '73145', 'zone': '2014'},
    {'commune': '73146', 'zone': '2014'},
    {'commune': '73147', 'zone': '2014'},
    {'commune': '73149', 'zone': '2014'},
    {'commune': '73150', 'zone': '2010'},
    {'commune': '73151', 'zone': '2012'},
    {'commune': '73152', 'zone': '2014'},
    {'commune': '73153', 'zone': '2012'},
    {'commune': '73154', 'zone': '2012'},
    {'commune': '73155', 'zone': '2012'},
    {'commune': '73156', 'zone': '2014'},
    {'commune': '73157', 'zone': '2010'},
    {'commune': '73159', 'zone': '2012'},
    {'commune': '73160', 'zone': '2012'},
    {'commune': '73161', 'zone': '2010'},
    {'commune': '73162', 'zone': '2012'},
    {'commune': '73164', 'zone': '2014'},
    {'commune': '73166', 'zone': '2014'},
    {'commune': '73168', 'zone': '2010'},
    {'commune': '73170', 'zone': '2012'},
    {'commune': '73171', 'zone': '2012'},
    {'commune': '73173', 'zone': '2010'},
    {'commune': '73175', 'zone': '2010'},
    {'commune': '73176', 'zone': '2014'},
    {'commune': '73177', 'zone': '2010'},
    {'commune': '73178', 'zone': '2014'},
    {'commune': '73179', 'zone': '2012'},
    {'commune': '73180', 'zone': '2014'},
    {'commune': '73181', 'zone': '2010'},
    {'commune': '73182', 'zone': '2012'},
    {'commune': '73183', 'zone': '2012'},
    {'commune': '73184', 'zone': '2014'},
    {'commune': '73186', 'zone': '2014'},
    {'commune': '73187', 'zone': '2010'},
    {'commune': '73188', 'zone': '2012'},
    {'commune': '73189', 'zone': '2010'},
    {'commune': '73190', 'zone': '2010'},
    {'commune': '73191', 'zone': '2014'},
    {'commune': '73192', 'zone': '2014'},
    {'commune': '73193', 'zone': '2014'},
    {'commune': '73194', 'zone': '2010'},
    {'commune': '73196', 'zone': '2012'},
    {'commune': '73197', 'zone': '2014'},
    {'commune': '73200', 'zone': '2012'},
    {'commune': '73201', 'zone': '2014'},
    {'commune': '73202', 'zone': '2012'},
    {'commune': '73204', 'zone': '2014'},
    {'commune': '73205', 'zone': '2014'},
    {'commune': '73206', 'zone': '2014'},
    {'commune': '73207', 'zone': '2014'},
    {'commune': '73208', 'zone': '2012'},
    {'commune': '73210', 'zone': '2014'},
    {'commune': '73211', 'zone': '2014'},
    {'commune': '73212', 'zone': '2010'},
    {'commune': '73213', 'zone': '2012'},
    {'commune': '73214', 'zone': '2014'},
    {'commune': '73215', 'zone': '2014'},
    {'commune': '73216', 'zone': '2010'},
    {'commune': '73217', 'zone': '2014'},
    {'commune': '73218', 'zone': '2014'},
    {'commune': '73219', 'zone': '2014'},
    {'commune': '73220', 'zone': '2010'},
    {'commune': '73221', 'zone': '2014'},
    {'commune': '73222', 'zone': '2012'},
    {'commune': '73223', 'zone': '2010'},
    {'commune': '73224', 'zone': '2010'},
    {'commune': '73225', 'zone': '2012'},
    {'commune': '73226', 'zone': '2014'},
    {'commune': '73227', 'zone': '2014'},
    {'commune': '73228', 'zone': '2014'},
    {'commune': '73229', 'zone': '2014'},
    {'commune': '73230', 'zone': '2014'},
    {'commune': '73231', 'zone': '2010'},
    {'commune': '73232', 'zone': '2014'},
    {'commune': '73233', 'zone': '2014'},
    {'commune': '73234', 'zone': '2014'},
    {'commune': '73235', 'zone': '2014'},
    {'commune': '73236', 'zone': '2014'},
    {'commune': '73237', 'zone': '2010'},
    {'commune': '73240', 'zone': '2012'},
    {'commune': '73241', 'zone': '2012'},
    {'commune': '73242', 'zone': '2014'},
    {'commune': '73243', 'zone': '2012'},
    {'commune': '73245', 'zone': '2014'},
    {'commune': '73246', 'zone': '2014'},
    {'commune': '73247', 'zone': '2012'},
    {'commune': '73248', 'zone': '2010'},
    {'commune': '73249', 'zone': '2012'},
    {'commune': '73250', 'zone': '2010'},
    {'commune': '73252', 'zone': '2010'},
    {'commune': '73253', 'zone': '2010'},
    {'commune': '73254', 'zone': '2014'},
    {'commune': '73255', 'zone': '2010'},
    {'commune': '73256', 'zone': '2010'},
    {'commune': '73257', 'zone': '2014'},
    {'commune': '73258', 'zone': '2010'},
    {'commune': '73259', 'zone': '2010'},
    {'commune': '73261', 'zone': '2010'},
    {'commune': '73262', 'zone': '2014'},
    {'commune': '73263', 'zone': '2014'},
    {'commune': '73265', 'zone': '2014'},
    {'commune': '73267', 'zone': '2014'},
    {'commune': '73268', 'zone': '2010'},
    {'commune': '73269', 'zone': '2014'},
    {'commune': '73270', 'zone': '2012'},
    {'commune': '73271', 'zone': '2014'},
    {'commune': '73272', 'zone': '2010'},
    {'commune': '73273', 'zone': '2014'},
    {'commune': '73274', 'zone': '2014'},
    {'commune': '73275', 'zone': '2014'},
    {'commune': '73276', 'zone': '2014'},
    {'commune': '73277', 'zone': '2014'},
    {'commune': '73278', 'zone': '2010'},
    {'commune': '73280', 'zone': '2014'},
    {'commune': '73281', 'zone': '2012'},
    {'commune': '73282', 'zone': '2014'},
    {'commune': '73283', 'zone': '2012'},
    {'commune': '73284', 'zone': '2010'},
    {'commune': '73285', 'zone': '2010'},
    {'commune': '73286', 'zone': '2014'},
    {'commune': '73288', 'zone': '2012'},
    {'commune': '73289', 'zone': '2014'},
    {'commune': '73290', 'zone': '2014'},
    {'commune': '73292', 'zone': '2012'},
    {'commune': '73293', 'zone': '2014'},
    {'commune': '73294', 'zone': '2014'},
    {'commune': '73296', 'zone': '2014'},
    {'commune': '73297', 'zone': '2012'},
    {'commune': '73298', 'zone': '2010'},
    {'commune': '73299', 'zone': '2014'},
    {'commune': '73300', 'zone': '2012'},
    {'commune': '73301', 'zone': '2014'},
    {'commune': '73302', 'zone': '2014'},
    {'commune': '73303', 'zone': '2012'},
    {'commune': '73304', 'zone': '2014'},
    {'commune': '73306', 'zone': '2010'},
    {'commune': '73307', 'zone': '2010'},
    {'commune': '73308', 'zone': '2012'},
    {'commune': '73309', 'zone': '2014'},
    {'commune': '73310', 'zone': '2012'},
    {'commune': '73311', 'zone': '2014'},
    {'commune': '73312', 'zone': '2012'},
    {'commune': '73313', 'zone': '2014'},
    {'commune': '73314', 'zone': '2014'},
    {'commune': '73315', 'zone': '2014'},
    {'commune': '73316', 'zone': '2014'},
    {'commune': '73317', 'zone': '2014'},
    {'commune': '73318', 'zone': '2014'},
    {'commune': '73320', 'zone': '2010'},
    {'commune': '73322', 'zone': '2014'},
    {'commune': '73323', 'zone': '2014'},
    {'commune': '73324', 'zone': '2014'},
    {'commune': '73326', 'zone': '2012'},
    {'commune': '73327', 'zone': '2014'},
    {'commune': '73328', 'zone': '2012'},
    {'commune': '73329', 'zone': '2012'},
    {'commune': '73330', 'zone': '2014'},
    {'commune': '74001', 'zone': '2015'},
    {'commune': '74002', 'zone': '2012'},
    {'commune': '74003', 'zone': '2015'},
    {'commune': '74004', 'zone': '2015'},
    {'commune': '74005', 'zone': '2001'},
    {'commune': '74006', 'zone': '2015'},
    {'commune': '74007', 'zone': '2008'},
    {'commune': '74009', 'zone': '2015'},
    {'commune': '74010', 'zone': '2012'},
    {'commune': '74012', 'zone': '2001'},
    {'commune': '74013', 'zone': '2001'},
    {'commune': '74014', 'zone': '2008'},
    {'commune': '74015', 'zone': '2001'},
    {'commune': '74016', 'zone': '2001'},
    {'commune': '74018', 'zone': '2008'},
    {'commune': '74019', 'zone': '2012'},
    {'commune': '74020', 'zone': '2001'},
    {'commune': '74021', 'zone': '2001'},
    {'commune': '74024', 'zone': '2008'},
    {'commune': '74025', 'zone': '2001'},
    {'commune': '74026', 'zone': '2015'},
    {'commune': '74027', 'zone': '2015'},
    {'commune': '74029', 'zone': '2015'},
    {'commune': '74030', 'zone': '2015'},
    {'commune': '74031', 'zone': '2001'},
    {'commune': '74032', 'zone': '2015'},
    {'commune': '74033', 'zone': '2015'},
    {'commune': '74034', 'zone': '2015'},
    {'commune': '74035', 'zone': '2012'},
    {'commune': '74036', 'zone': '2015'},
    {'commune': '74037', 'zone': '2015'},
    {'commune': '74038', 'zone': '2015'},
    {'commune': '74040', 'zone': '2001'},
    {'commune': '74041', 'zone': '2015'},
    {'commune': '74042', 'zone': '2008'},
    {'commune': '74043', 'zone': '2001'},
    {'commune': '74044', 'zone': '2001'},
    {'commune': '74045', 'zone': '2015'},
    {'commune': '74046', 'zone': '2012'},
    {'commune': '74048', 'zone': '2001'},
    {'commune': '74049', 'zone': '2008'},
    {'commune': '74050', 'zone': '2015'},
    {'commune': '74051', 'zone': '2015'},
    {'commune': '74052', 'zone': '2015'},
    {'commune': '74053', 'zone': '2001'},
    {'commune': '74054', 'zone': '2015'},
    {'commune': '74055', 'zone': '2015'},
    {'commune': '74056', 'zone': '2008'},
    {'commune': '74057', 'zone': '2015'},
    {'commune': '74058', 'zone': '2015'},
    {'commune': '74059', 'zone': '2008'},
    {'commune': '74060', 'zone': '2015'},
    {'commune': '74061', 'zone': '2012'},
    {'commune': '74062', 'zone': '2015'},
    {'commune': '74063', 'zone': '2015'},
    {'commune': '74064', 'zone': '2008'},
    {'commune': '74065', 'zone': '2015'},
    {'commune': '74066', 'zone': '2015'},
    {'commune': '74067', 'zone': '2012'},
    {'commune': '74068', 'zone': '2015'},
    {'commune': '74069', 'zone': '2001'},
    {'commune': '74070', 'zone': '2001'},
    {'commune': '74071', 'zone': '2015'},
    {'commune': '74072', 'zone': '2015'},
    {'commune': '74073', 'zone': '2015'},
    {'commune': '74074', 'zone': '2001'},
    {'commune': '74075', 'zone': '2015'},
    {'commune': '74076', 'zone': '2015'},
    {'commune': '74077', 'zone': '2015'},
    {'commune': '74078', 'zone': '2015'},
    {'commune': '74079', 'zone': '2015'},
    {'commune': '74080', 'zone': '2015'},
    {'commune': '74081', 'zone': '2008'},
    {'commune': '74082', 'zone': '2001'},
    {'commune': '74083', 'zone': '2008'},
    {'commune': '74085', 'zone': '2008'},
    {'commune': '74086', 'zone': '2015'},
    {'commune': '74087', 'zone': '2008'},
    {'commune': '74088', 'zone': '2015'},
    {'commune': '74089', 'zone': '2008'},
    {'commune': '74090', 'zone': '2008'},
    {'commune': '74091', 'zone': '2015'},
    {'commune': '74094', 'zone': '2001'},
    {'commune': '74095', 'zone': '2015'},
    {'commune': '74096', 'zone': '2015'},
    {'commune': '74097', 'zone': '2015'},
    {'commune': '74098', 'zone': '2015'},
    {'commune': '74099', 'zone': '2008'},
    {'commune': '74100', 'zone': '2015'},
    {'commune': '74101', 'zone': '2001'},
    {'commune': '74102', 'zone': '2015'},
    {'commune': '74103', 'zone': '2008'},
    {'commune': '74104', 'zone': '2015'},
    {'commune': '74105', 'zone': '2001'},
    {'commune': '74106', 'zone': '2001'},
    {'commune': '74107', 'zone': '2015'},
    {'commune': '74108', 'zone': '2012'},
    {'commune': '74109', 'zone': '2015'},
    {'commune': '74111', 'zone': '2015'},
    {'commune': '74112', 'zone': '2012'},
    {'commune': '74114', 'zone': '2015'},
    {'commune': '74116', 'zone': '2008'},
    {'commune': '74117', 'zone': '2012'},
    {'commune': '74118', 'zone': '2001'},
    {'commune': '74119', 'zone': '2015'},
    {'commune': '74121', 'zone': '2001'},
    {'commune': '74122', 'zone': '2015'},
    {'commune': '74123', 'zone': '2012'},
    {'commune': '74124', 'zone': '2001'},
    {'commune': '74126', 'zone': '2001'},
    {'commune': '74127', 'zone': '2015'},
    {'commune': '74128', 'zone': '2015'},
    {'commune': '74129', 'zone': '2015'},
    {'commune': '74130', 'zone': '2015'},
    {'commune': '74131', 'zone': '2015'},
    {'commune': '74134', 'zone': '2015'},
    {'commune': '74135', 'zone': '2015'},
    {'commune': '74136', 'zone': '2015'},
    {'commune': '74137', 'zone': '2015'},
    {'commune': '74138', 'zone': '2015'},
    {'commune': '74139', 'zone': '2015'},
    {'commune': '74140', 'zone': '2015'},
    {'commune': '74141', 'zone': '2012'},
    {'commune': '74142', 'zone': '2012'},
    {'commune': '74143', 'zone': '2008'},
    {'commune': '74144', 'zone': '2001'},
    {'commune': '74145', 'zone': '2001'},
    {'commune': '74146', 'zone': '2015'},
    {'commune': '74147', 'zone': '2015'},
    {'commune': '74148', 'zone': '2015'},
    {'commune': '74150', 'zone': '2001'},
    {'commune': '74151', 'zone': '2015'},
    {'commune': '74152', 'zone': '2012'},
    {'commune': '74153', 'zone': '2001'},
    {'commune': '74154', 'zone': '2015'},
    {'commune': '74155', 'zone': '2015'},
    {'commune': '74156', 'zone': '2001'},
    {'commune': '74157', 'zone': '2001'},
    {'commune': '74158', 'zone': '2001'},
    {'commune': '74159', 'zone': '2008'},
    {'commune': '74160', 'zone': '2015'},
    {'commune': '74161', 'zone': '2012'},
    {'commune': '74162', 'zone': '2015'},
    {'commune': '74163', 'zone': '2001'},
    {'commune': '74164', 'zone': '2008'},
    {'commune': '74165', 'zone': '2012'},
    {'commune': '74166', 'zone': '2015'},
    {'commune': '74167', 'zone': '2012'},
    {'commune': '74168', 'zone': '2015'},
    {'commune': '74169', 'zone': '2008'},
    {'commune': '74170', 'zone': '2015'},
    {'commune': '74171', 'zone': '2001'},
    {'commune': '74172', 'zone': '2015'},
    {'commune': '74173', 'zone': '2008'},
    {'commune': '74174', 'zone': '2015'},
    {'commune': '74175', 'zone': '2015'},
    {'commune': '74176', 'zone': '2015'},
    {'commune': '74177', 'zone': '2015'},
    {'commune': '74178', 'zone': '2015'},
    {'commune': '74179', 'zone': '2015'},
    {'commune': '74180', 'zone': '2001'},
    {'commune': '74183', 'zone': '2015'},
    {'commune': '74184', 'zone': '2015'},
    {'commune': '74185', 'zone': '2001'},
    {'commune': '74186', 'zone': '2012'},
    {'commune': '74188', 'zone': '2015'},
    {'commune': '74189', 'zone': '2008'},
    {'commune': '74190', 'zone': '2015'},
    {'commune': '74191', 'zone': '2015'},
    {'commune': '74192', 'zone': '2015'},
    {'commune': '74193', 'zone': '2001'},
    {'commune': '74194', 'zone': '2012'},
    {'commune': '74195', 'zone': '2015'},
    {'commune': '74196', 'zone': '2008'},
    {'commune': '74197', 'zone': '2001'},
    {'commune': '74198', 'zone': '2015'},
    {'commune': '74200', 'zone': '2015'},
    {'commune': '74201', 'zone': '2001'},
    {'commune': '74202', 'zone': '2015'},
    {'commune': '74203', 'zone': '2015'},
    {'commune': '74205', 'zone': '2015'},
    {'commune': '74206', 'zone': '2001'},
    {'commune': '74208', 'zone': '2008'},
    {'commune': '74209', 'zone': '2015'},
    {'commune': '74210', 'zone': '2001'},
    {'commune': '74211', 'zone': '2001'},
    {'commune': '74212', 'zone': '2008'},
    {'commune': '74213', 'zone': '2012'},
    {'commune': '74215', 'zone': '2008'},
    {'commune': '74216', 'zone': '2001'},
    {'commune': '74218', 'zone': '2015'},
    {'commune': '74219', 'zone': '2015'},
    {'commune': '74220', 'zone': '2001'},
    {'commune': '74221', 'zone': '2008'},
    {'commune': '74222', 'zone': '2015'},
    {'commune': '74223', 'zone': '2015'},
    {'commune': '74224', 'zone': '2008'},
    {'commune': '74225', 'zone': '2012'},
    {'commune': '74226', 'zone': '2015'},
    {'commune': '74228', 'zone': '2015'},
    {'commune': '74229', 'zone': '2001'},
    {'commune': '74231', 'zone': '2015'},
    {'commune': '74232', 'zone': '2015'},
    {'commune': '74233', 'zone': '2012'},
    {'commune': '74234', 'zone': '2012'},
    {'commune': '74235', 'zone': '2015'},
    {'commune': '74236', 'zone': '2008'},
    {'commune': '74237', 'zone': '2015'},
    {'commune': '74238', 'zone': '2015'},
    {'commune': '74239', 'zone': '2015'},
    {'commune': '74240', 'zone': '2015'},
    {'commune': '74241', 'zone': '2015'},
    {'commune': '74242', 'zone': '2012'},
    {'commune': '74243', 'zone': '2001'},
    {'commune': '74244', 'zone': '2008'},
    {'commune': '74249', 'zone': '2015'},
    {'commune': '74250', 'zone': '2008'},
    {'commune': '74252', 'zone': '2008'},
    {'commune': '74253', 'zone': '2008'},
    {'commune': '74254', 'zone': '2012'},
    {'commune': '74255', 'zone': '2012'},
    {'commune': '74256', 'zone': '2008'},
    {'commune': '74257', 'zone': '2015'},
    {'commune': '74258', 'zone': '2015'},
    {'commune': '74259', 'zone': '2015'},
    {'commune': '74260', 'zone': '2001'},
    {'commune': '74261', 'zone': '2015'},
    {'commune': '74262', 'zone': '2001'},
    {'commune': '74263', 'zone': '2001'},
    {'commune': '74264', 'zone': '2008'},
    {'commune': '74265', 'zone': '2015'},
    {'commune': '74266', 'zone': '2008'},
    {'commune': '74267', 'zone': '2012'},
    {'commune': '74269', 'zone': '2015'},
    {'commune': '74271', 'zone': '2015'},
    {'commune': '74272', 'zone': '2015'},
    {'commune': '74273', 'zone': '2015'},
    {'commune': '74275', 'zone': '2015'},
    {'commune': '74276', 'zone': '2015'},
    {'commune': '74278', 'zone': '2008'},
    {'commune': '74279', 'zone': '2015'},
    {'commune': '74280', 'zone': '2015'},
    {'commune': '74281', 'zone': '2001'},
    {'commune': '74282', 'zone': '2015'},
    {'commune': '74283', 'zone': '2015'},
    {'commune': '74284', 'zone': '2015'},
    {'commune': '74285', 'zone': '2015'},
    {'commune': '74286', 'zone': '2015'},
    {'commune': '74287', 'zone': '2015'},
    {'commune': '74288', 'zone': '2001'},
    {'commune': '74289', 'zone': '2015'},
    {'commune': '74290', 'zone': '2008'},
    {'commune': '74291', 'zone': '2015'},
    {'commune': '74292', 'zone': '2015'},
    {'commune': '74293', 'zone': '2001'},
    {'commune': '74294', 'zone': '2015'},
    {'commune': '74295', 'zone': '2015'},
    {'commune': '74296', 'zone': '2001'},
    {'commune': '74297', 'zone': '2015'},
    {'commune': '74298', 'zone': '2001'},
    {'commune': '74299', 'zone': '2015'},
    {'commune': '74301', 'zone': '2015'},
    {'commune': '74302', 'zone': '2015'},
    {'commune': '74303', 'zone': '2015'},
    {'commune': '74304', 'zone': '2015'},
    {'commune': '74305', 'zone': '2001'},
    {'commune': '74306', 'zone': '2015'},
    {'commune': '74307', 'zone': '2015'},
    {'commune': '74308', 'zone': '2015'},
    {'commune': '74309', 'zone': '2001'},
    {'commune': '74310', 'zone': '2015'},
    {'commune': '74311', 'zone': '2015'},
    {'commune': '74312', 'zone': '2008'},
    {'commune': '74313', 'zone': '2015'},
    {'commune': '74314', 'zone': '2001'},
    {'commune': '74315', 'zone': '2001'}
]