"""Ajout region

Revision ID: 1c2343422336
Revises: 08cc65297d89
Create Date: 2021-04-06 16:33:20.517672

"""
from alembic import op
import sqlalchemy as sa
import requests


# revision identifiers, used by Alembic.
revision = '1c2343422336'
down_revision = '08cc65297d89'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    region_table = op.create_table('region',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('nom', sa.String(), nullable=True),
        sa.Column('code', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        schema='indice_schema'
    )

    r = requests.get('https://geo.api.gouv.fr/regions?fields=nom,code', headers={"Accept": "application/json"})
    op.bulk_insert(region_table, r.json())


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('region', schema='indice_schema')
