/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.ImageStreamer;
import injector.InjectorContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.micromanager.PropertyMap;
import org.micromanager.data.Image;
import org.micromanager.data.Processor;
import org.micromanager.data.ProcessorContext;

public class InjectorProcessor
implements Processor {
    private final InjectorContext context;
    private final PropertyMap property_map;
    private final ImageStreamer image_streamer;
    int counter = 0;
    private Image current_image;
    private Image tiff_image;
    private long last_time;

    public InjectorProcessor(PropertyMap pm, InjectorContext context) {
        this.context = context;
        this.property_map = pm;
        this.image_streamer = context.streamer;
        this.last_time = System.currentTimeMillis();
    }

    public void processImage(Image image, ProcessorContext pc) {
        ++this.counter;
        if (this.counter % 100 == 0) {
            long time = System.currentTimeMillis() - this.last_time;
            double FPS = 100000.0 / (double)time;
            this.context.app.logs().logDebugMessage(String.format("100 images processed in %d milliseconds. (%4.2f FPS)", time, FPS));
            this.last_time = System.currentTimeMillis();
        }
        try {
            this.current_image = this.image_streamer.getNextImage(image.getCoords());
            if (this.current_image == null) {
                pc.outputImage(image);
            } else {
                pc.outputImage(this.current_image);
            }
            return;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(InjectorProcessor.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }
}

