# marax-server-sdk
Marax Server SDK to send transactional events from client server to marax server

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.3.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import marax_server_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import marax_server_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import marax_server_sdk
from marax_server_sdk.rest import ApiException
from pprint import pprint

configuration = marax_server_sdk.Configuration()
# Configure API key authorization: ApiKeyAuth
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# Defining host is optional and default to https://<client-name>.marax.ai
configuration.host = "https://<client-name>.marax.ai"
# Enter a context with an instance of the API client
with marax_server_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = marax_server_sdk.RewardApi(api_client)
    client = '123-12312-sdf-dwa' # str | Id of the client obtained from MARS dashboard
request_body = marax_server_sdk.RequestBody() # RequestBody | Details of transactional event (optional)

    try:
        # Perform reward post-processing
        api_response = api_instance.process_event(client, request_body=request_body)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling RewardApi->process_event: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://&lt;client-name&gt;.marax.ai*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*RewardApi* | [**process_event**](docs/RewardApi.md#process_event) | **POST** /reward/v1/{client}/post-process | Perform reward post-processing


## Documentation For Models

 - [RequestBody](docs/RequestBody.md)
 - [RequestBodyProperties](docs/RequestBodyProperties.md)
 - [RequestBodyPropertiesFulfillment](docs/RequestBodyPropertiesFulfillment.md)
 - [RequestBodyPropertiesProducts](docs/RequestBodyPropertiesProducts.md)
 - [RequestBodyPropertiesReward](docs/RequestBodyPropertiesReward.md)
 - [RequestBodyPropertiesTotalCartPrice](docs/RequestBodyPropertiesTotalCartPrice.md)
 - [RequestBodyPropertiesTotalDiscount](docs/RequestBodyPropertiesTotalDiscount.md)
 - [RequestBodyPropertiesTotalOrderPrice](docs/RequestBodyPropertiesTotalOrderPrice.md)
 - [Response200](docs/Response200.md)
 - [Response400](docs/Response400.md)
 - [Response500](docs/Response500.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

team@marax.ai


