from Retro3D import *


###############################################################################
#
###############################################################################
class Matrix:


    ###############################################################################
    #
    ###############################################################################
    @staticmethod
    def Translate(pos):
        
        return np.array([[1, 0, 0, 0],
                         [0, 1, 0, 0],
                         [0, 0, 1, 0],
                         [pos.x, pos.y, pos.z, 1]])



    ###############################################################################
    #
    ###############################################################################
    @staticmethod
    def Scale(s):

        return np.array([[s, 0, 0, 0],
                         [0, s, 0, 0],
                         [0, 0, s, 0],
                         [0, 0, 0, 1]])


    ###############################################################################
    #
    ###############################################################################
    @staticmethod
    def RotateX(a):

        return np.array([[1, 0, 0, 0],
                         [0, math.cos(a), math.sin(a), 0],
                         [0, -math.sin(a), math.cos(a), 0],
                         [0, 0, 0, 1]])


    ###############################################################################
    #
    ###############################################################################
    @staticmethod
    def RotateY(a):

        return np.array([[math.cos(a), 0, -math.sin(a), 0],
                         [0, 1, 0, 0],
                         [math.sin(a), 0, math.cos(a), 0],
                         [0, 0, 0, 1]])


    ###############################################################################
    #
    ###############################################################################
    @staticmethod
    def RotateZ(a):

        return np.array([[math.cos(a), math.sin(a), 0, 0],
                         [-math.sin(a), math.cos(a), 0, 0],
                         [0, 0, 1, 0],
                         [0, 0, 0, 1]])


