# pywisetransfer

An unofficial, experimental Python client library for the [TransferWise API](https://api-docs.transferwise.com).

:warning: The classes, functions and interfaces that this library provides are very much in-development and prone to change.

## Installation

```bash
# Within your project directory
poetry add pywisetransfer
```

## Usage

### API Requests

```python
import pywisetransfer

pywisetransfer.api_key = "your-api-key-here"
# pywisetransfer.environment = "live"

client = pywisetransfer.Client()

for profile in client.profiles.list():
    accounts = client.borderless_accounts.list(profile_id=profile.id)
    for account in accounts:
        currencies = [balance.currency for balance in account.balances]
        print(f"AccountID={account.id}, Currencies={currencies}")
```

### Webhook signature verification

```python
import pywisetransfer
from pywisetransfer.webhooks import verify_signature

# pywisetransfer.environment = "live"

payload = b"webhook-request-body-here"
signature = "webhook-signature-data-here"

valid = verify_signature(payload, signature)
print(f"Valid webhook signature: {valid}")

```

## Run tests

```bash
# Within the pywisetransfer working directory
poetry install
poetry run pytest --forked
```
