# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.30
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class InvoiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def adjust_invoice_item(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Adjust an invoice item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_invoice_item(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoiceItem body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.adjust_invoice_item_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.adjust_invoice_item_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
            return data

    def adjust_invoice_item_with_http_info(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Adjust an invoice item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_invoice_item_with_http_info(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoiceItem body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'invoice_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method adjust_invoice_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `adjust_invoice_item`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `adjust_invoice_item`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `adjust_invoice_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def commit_invoice(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Perform the invoice status transition from DRAFT to COMMITTED  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.commit_invoice(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.commit_invoice_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.commit_invoice_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def commit_invoice_with_http_info(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Perform the invoice status transition from DRAFT to COMMITTED  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.commit_invoice_with_http_info(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method commit_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `commit_invoice`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `commit_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/commitInvoice', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_external_charges(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create external charge(s)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_external_charges(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param bool auto_commit:
        :param list[str] plugin_property:
        :return: list[InvoiceItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_external_charges_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_external_charges_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
            return data

    def create_external_charges_with_http_info(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create external charge(s)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_external_charges_with_http_info(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param bool auto_commit:
        :param list[str] plugin_property:
        :return: list[InvoiceItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'account_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'auto_commit', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_charges" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_external_charges`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_external_charges`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_external_charges`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'auto_commit' in params:
            query_params.append(('autoCommit', params['auto_commit']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/charges/{accountId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoiceItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_future_invoice(self, account_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Trigger an invoice generation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_future_invoice(account_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: (required)
        :param str x_killbill_created_by: (required)
        :param date target_date:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_future_invoice_with_http_info(account_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.create_future_invoice_with_http_info(account_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def create_future_invoice_with_http_info(self, account_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Trigger an invoice generation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_future_invoice_with_http_info(account_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: (required)
        :param str x_killbill_created_by: (required)
        :param date target_date:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'x_killbill_created_by', 'target_date', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_future_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_future_invoice`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_future_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in params:
            query_params.append(('accountId', params['account_id']))  # noqa: E501
        if 'target_date' in params:
            query_params.append(('targetDate', params['target_date']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_instant_payment(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Trigger a payment for invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instant_payment(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoicePayment body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool external_payment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instant_payment_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instant_payment_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
            return data

    def create_instant_payment_with_http_info(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Trigger a payment for invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instant_payment_with_http_info(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoicePayment body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool external_payment:
        :param list[str] control_plugin_name:
        :param list[str] plugin_property:
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'invoice_id', 'x_killbill_reason', 'x_killbill_comment', 'external_payment', 'control_plugin_name', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instant_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_instant_payment`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_instant_payment`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `create_instant_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'external_payment' in params:
            query_params.append(('externalPayment', params['external_payment']))  # noqa: E501
        if 'control_plugin_name' in params:
            query_params.append(('controlPluginName', params['control_plugin_name']))  # noqa: E501
            collection_formats['controlPluginName'] = 'multi'  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/payments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvoicePayment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_invoice_custom_fields(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Add custom fields to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_custom_fields(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
            return data

    def create_invoice_custom_fields_with_http_info(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Add custom fields to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'invoice_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_invoice_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_invoice_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_invoice_custom_fields`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `create_invoice_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/customFields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_invoice_tags(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Add tags to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_tags(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_invoice_tags_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_invoice_tags_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
            return data

    def create_invoice_tags_with_http_info(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Add tags to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_tags_with_http_info(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'invoice_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_invoice_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_invoice_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_invoice_tags`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `create_invoice_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_migration_invoice(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create a migration invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_migration_invoice(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date target_date:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_migration_invoice_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_migration_invoice_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
            return data

    def create_migration_invoice_with_http_info(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create a migration invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_migration_invoice_with_http_info(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date target_date:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'account_id', 'x_killbill_reason', 'x_killbill_comment', 'target_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_migration_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_migration_invoice`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_migration_invoice`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_migration_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []
        if 'target_date' in params:
            query_params.append(('targetDate', params['target_date']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/migration/{accountId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tax_items(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create tax items  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_items(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool auto_commit:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[InvoiceItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tax_items_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tax_items_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
            return data

    def create_tax_items_with_http_info(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Create tax items  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_items_with_http_info(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[InvoiceItem] body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool auto_commit:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[InvoiceItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'account_id', 'x_killbill_reason', 'x_killbill_comment', 'auto_commit', 'requested_date', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tax_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_tax_items`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_tax_items`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_tax_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []
        if 'auto_commit' in params:
            query_params.append(('autoCommit', params['auto_commit']))  # noqa: E501
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/taxes/{accountId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoiceItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cba(self, invoice_id, invoice_item_id, account_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a CBA item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cba(invoice_id, invoice_item_id, account_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str invoice_item_id: (required)
        :param str account_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cba_with_http_info(invoice_id, invoice_item_id, account_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cba_with_http_info(invoice_id, invoice_item_id, account_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_cba_with_http_info(self, invoice_id, invoice_item_id, account_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a CBA item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cba_with_http_info(invoice_id, invoice_item_id, account_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str invoice_item_id: (required)
        :param str account_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'invoice_item_id', 'account_id', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cba" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `delete_cba`")  # noqa: E501
        # verify the required parameter 'invoice_item_id' is set
        if ('invoice_item_id' not in params or
                params['invoice_item_id'] is None):
            raise ValueError("Missing the required parameter `invoice_item_id` when calling `delete_cba`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_cba`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_cba`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501
        if 'invoice_item_id' in params:
            path_params['invoiceItemId'] = params['invoice_item_id']  # noqa: E501

        query_params = []
        if 'account_id' in params:
            query_params.append(('accountId', params['account_id']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/{invoiceItemId}/cba', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_invoice_custom_fields(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_custom_fields(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_invoice_custom_fields_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_invoice_custom_fields_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_invoice_custom_fields_with_http_info(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_custom_fields_with_http_info(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'x_killbill_created_by', 'custom_field', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_invoice_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `delete_invoice_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_invoice_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'custom_field' in params:
            query_params.append(('customField', params['custom_field']))  # noqa: E501
            collection_formats['customField'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/customFields', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_invoice_tags(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_tags(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_invoice_tags_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_invoice_tags_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_invoice_tags_with_http_info(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_tags_with_http_info(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'x_killbill_created_by', 'tag_def', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_invoice_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `delete_invoice_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_invoice_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'tag_def' in params:
            query_params.append(('tagDef', params['tag_def']))  # noqa: E501
            collection_formats['tagDef'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_dry_run_invoice(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Generate a dryRun invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_dry_run_invoice(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoiceDryRun body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date target_date:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_dry_run_invoice_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_dry_run_invoice_with_http_info(body, x_killbill_created_by, account_id, **kwargs)  # noqa: E501
            return data

    def generate_dry_run_invoice_with_http_info(self, body, x_killbill_created_by, account_id, **kwargs):  # noqa: E501
        """Generate a dryRun invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_dry_run_invoice_with_http_info(body, x_killbill_created_by, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoiceDryRun body: (required)
        :param str x_killbill_created_by: (required)
        :param str account_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date target_date:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'account_id', 'x_killbill_reason', 'x_killbill_comment', 'target_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_dry_run_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `generate_dry_run_invoice`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `generate_dry_run_invoice`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `generate_dry_run_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in params:
            query_params.append(('accountId', params['account_id']))  # noqa: E501
        if 'target_date' in params:
            query_params.append(('targetDate', params['target_date']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/dryRun', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_catalog_translation(self, locale, **kwargs):  # noqa: E501
        """Retrieves the catalog translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalog_translation(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_catalog_translation_with_http_info(locale, **kwargs)  # noqa: E501
        else:
            (data) = self.get_catalog_translation_with_http_info(locale, **kwargs)  # noqa: E501
            return data

    def get_catalog_translation_with_http_info(self, locale, **kwargs):  # noqa: E501
        """Retrieves the catalog translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_catalog_translation_with_http_info(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_catalog_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if ('locale' not in params or
                params['locale'] is None):
            raise ValueError("Missing the required parameter `locale` when calling `get_catalog_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/catalogTranslation/{locale}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve an invoice by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve an invoice by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'with_children_items', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'with_children_items' in params:
            query_params.append(('withChildrenItems', params['with_children_items']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_as_html(self, invoice_id, **kwargs):  # noqa: E501
        """Render an invoice as HTML  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_as_html(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_as_html_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_as_html_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_as_html_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Render an invoice as HTML  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_as_html_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_as_html" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice_as_html`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/html', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_audit_logs_with_history(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_audit_logs_with_history(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_audit_logs_with_history_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_audit_logs_with_history_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_audit_logs_with_history_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_audit_logs_with_history_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_by_item_id(self, item_id, **kwargs):  # noqa: E501
        """Retrieve an invoice by invoice item id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_by_item_id(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_by_item_id_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_by_item_id_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_by_item_id_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Retrieve an invoice by invoice item id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_by_item_id_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'with_children_items', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_by_item_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `get_invoice_by_item_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []
        if 'with_children_items' in params:
            query_params.append(('withChildrenItems', params['with_children_items']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/byItemId/{itemId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_by_number(self, invoice_number, **kwargs):  # noqa: E501
        """Retrieve an invoice by number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_by_number(invoice_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_number: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_by_number_with_http_info(invoice_number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_by_number_with_http_info(invoice_number, **kwargs)  # noqa: E501
            return data

    def get_invoice_by_number_with_http_info(self, invoice_number, **kwargs):  # noqa: E501
        """Retrieve an invoice by number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_by_number_with_http_info(invoice_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_number: (required)
        :param bool with_children_items:
        :param str audit:
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_number', 'with_children_items', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_by_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_number' is set
        if ('invoice_number' not in params or
                params['invoice_number'] is None):
            raise ValueError("Missing the required parameter `invoice_number` when calling `get_invoice_by_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_number' in params:
            path_params['invoiceNumber'] = params['invoice_number']  # noqa: E501

        query_params = []
        if 'with_children_items' in params:
            query_params.append(('withChildrenItems', params['with_children_items']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/byNumber/{invoiceNumber}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_custom_fields(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_custom_fields(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_custom_fields_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_custom_fields_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_custom_fields_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_custom_fields_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_mp_template(self, locale, **kwargs):  # noqa: E501
        """Retrieves the manualPay invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_mp_template(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_mp_template_with_http_info(locale, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_mp_template_with_http_info(locale, **kwargs)  # noqa: E501
            return data

    def get_invoice_mp_template_with_http_info(self, locale, **kwargs):  # noqa: E501
        """Retrieves the manualPay invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_mp_template_with_http_info(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_mp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if ('locale' not in params or
                params['locale'] is None):
            raise ValueError("Missing the required parameter `locale` when calling `get_invoice_mp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/manualPayTemplate/{locale}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_tags(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_tags(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_tags_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_tags_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_tags_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve invoice tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_tags_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'included_deleted', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_template(self, **kwargs):  # noqa: E501
        """Retrieves the invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_template(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_template_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_template_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_invoice_template_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieves the invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_template_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_template" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/template', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_translation(self, locale, **kwargs):  # noqa: E501
        """Retrieves the invoice translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_translation(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_translation_with_http_info(locale, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_translation_with_http_info(locale, **kwargs)  # noqa: E501
            return data

    def get_invoice_translation_with_http_info(self, locale, **kwargs):  # noqa: E501
        """Retrieves the invoice translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_translation_with_http_info(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if ('locale' not in params or
                params['locale'] is None):
            raise ValueError("Missing the required parameter `locale` when calling `get_invoice_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/translation/{locale}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoices(self, **kwargs):  # noqa: E501
        """List invoices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoices(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_invoices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_invoices_with_http_info(self, **kwargs):  # noqa: E501
        """List invoices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoices" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/pagination', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Invoice]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments_for_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve payments associated with an invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param str audit:
        :return: list[InvoicePayment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payments_for_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payments_for_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_payments_for_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve payments associated with an invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param bool with_plugin_info:
        :param bool with_attempts:
        :param str audit:
        :return: list[InvoicePayment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'with_plugin_info', 'with_attempts', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_for_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_payments_for_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'with_attempts' in params:
            query_params.append(('withAttempts', params['with_attempts']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoicePayment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_invoice_custom_fields(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Modify custom fields to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_invoice_custom_fields(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, **kwargs)  # noqa: E501
            return data

    def modify_invoice_custom_fields_with_http_info(self, body, x_killbill_created_by, invoice_id, **kwargs):  # noqa: E501
        """Modify custom fields to invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_invoice_custom_fields_with_http_info(body, x_killbill_created_by, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str invoice_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'invoice_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_invoice_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_invoice_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `modify_invoice_custom_fields`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `modify_invoice_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_invoices(self, search_key, **kwargs):  # noqa: E501
        """Search invoices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_invoices(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_invoices_with_http_info(search_key, **kwargs)  # noqa: E501
        else:
            (data) = self.search_invoices_with_http_info(search_key, **kwargs)  # noqa: E501
            return data

    def search_invoices_with_http_info(self, search_key, **kwargs):  # noqa: E501
        """Search invoices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_invoices_with_http_info(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_key', 'offset', 'limit', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_invoices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_key' is set
        if ('search_key' not in params or
                params['search_key'] is None):
            raise ValueError("Missing the required parameter `search_key` when calling `search_invoices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'search_key' in params:
            path_params['searchKey'] = params['search_key']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/search/{searchKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Invoice]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_catalog_translation(self, body, x_killbill_created_by, locale, **kwargs):  # noqa: E501
        """Upload the catalog translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_catalog_translation(body, x_killbill_created_by, locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str locale: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_catalog_translation_with_http_info(body, x_killbill_created_by, locale, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_catalog_translation_with_http_info(body, x_killbill_created_by, locale, **kwargs)  # noqa: E501
            return data

    def upload_catalog_translation_with_http_info(self, body, x_killbill_created_by, locale, **kwargs):  # noqa: E501
        """Upload the catalog translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_catalog_translation_with_http_info(body, x_killbill_created_by, locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str locale: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'locale', 'x_killbill_reason', 'x_killbill_comment', 'delete_if_exists']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_catalog_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_catalog_translation`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_catalog_translation`")  # noqa: E501
        # verify the required parameter 'locale' is set
        if ('locale' not in params or
                params['locale'] is None):
            raise ValueError("Missing the required parameter `locale` when calling `upload_catalog_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []
        if 'delete_if_exists' in params:
            query_params.append(('deleteIfExists', params['delete_if_exists']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/catalogTranslation/{locale}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_invoice_mp_template(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Upload the manualPay invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_mp_template(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_invoice_mp_template_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_invoice_mp_template_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def upload_invoice_mp_template_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Upload the manualPay invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_mp_template_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'delete_if_exists']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_invoice_mp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_invoice_mp_template`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_invoice_mp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delete_if_exists' in params:
            query_params.append(('deleteIfExists', params['delete_if_exists']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/manualPayTemplate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_invoice_template(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Upload the invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_template(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_invoice_template_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_invoice_template_with_http_info(body, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def upload_invoice_template_with_http_info(self, body, x_killbill_created_by, **kwargs):  # noqa: E501
        """Upload the invoice template for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_template_with_http_info(body, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment', 'delete_if_exists']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_invoice_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_invoice_template`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_invoice_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delete_if_exists' in params:
            query_params.append(('deleteIfExists', params['delete_if_exists']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/html'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/html'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/template', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_invoice_translation(self, body, x_killbill_created_by, locale, **kwargs):  # noqa: E501
        """Upload the invoice translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_translation(body, x_killbill_created_by, locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str locale: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_invoice_translation_with_http_info(body, x_killbill_created_by, locale, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_invoice_translation_with_http_info(body, x_killbill_created_by, locale, **kwargs)  # noqa: E501
            return data

    def upload_invoice_translation_with_http_info(self, body, x_killbill_created_by, locale, **kwargs):  # noqa: E501
        """Upload the invoice translation for the tenant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_invoice_translation_with_http_info(body, x_killbill_created_by, locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: (required)
        :param str x_killbill_created_by: (required)
        :param str locale: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param bool delete_if_exists:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'locale', 'x_killbill_reason', 'x_killbill_comment', 'delete_if_exists']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_invoice_translation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upload_invoice_translation`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `upload_invoice_translation`")  # noqa: E501
        # verify the required parameter 'locale' is set
        if ('locale' not in params or
                params['locale'] is None):
            raise ValueError("Missing the required parameter `locale` when calling `upload_invoice_translation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []
        if 'delete_if_exists' in params:
            query_params.append(('deleteIfExists', params['delete_if_exists']))  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/translation/{locale}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def void_invoice(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Perform the action of voiding an invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_invoice(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.void_invoice_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.void_invoice_with_http_info(invoice_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def void_invoice_with_http_info(self, invoice_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Perform the action of voiding an invoice  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.void_invoice_with_http_info(invoice_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: (required)
        :param str x_killbill_created_by: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'x_killbill_created_by', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method void_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `void_invoice`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `void_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/invoices/{invoiceId}/voidInvoice', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
