# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.30
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class PaymentMethodApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_payment_method_custom_fields(self, body, x_killbill_created_by, payment_method_id, **kwargs):  # noqa: E501
        """Add custom fields to payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_method_custom_fields(body, x_killbill_created_by, payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_method_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, **kwargs)  # noqa: E501
            return data

    def create_payment_method_custom_fields_with_http_info(self, body, x_killbill_created_by, payment_method_id, **kwargs):  # noqa: E501
        """Add custom fields to payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_method_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_method_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment_method_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payment_method_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_payment_method_custom_fields`")  # noqa: E501
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `create_payment_method_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}/customFields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payment_method(self, payment_method_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_method(payment_method_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str x_killbill_created_by: (required)
        :param bool delete_default_pm_with_auto_pay_off:
        :param bool force_default_pm_deletion:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payment_method_with_http_info(payment_method_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payment_method_with_http_info(payment_method_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_payment_method_with_http_info(self, payment_method_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Delete a payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_method_with_http_info(payment_method_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str x_killbill_created_by: (required)
        :param bool delete_default_pm_with_auto_pay_off:
        :param bool force_default_pm_deletion:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_method_id', 'x_killbill_created_by', 'delete_default_pm_with_auto_pay_off', 'force_default_pm_deletion', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payment_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `delete_payment_method`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_payment_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []
        if 'delete_default_pm_with_auto_pay_off' in params:
            query_params.append(('deleteDefaultPmWithAutoPayOff', params['delete_default_pm_with_auto_pay_off']))  # noqa: E501
        if 'force_default_pm_deletion' in params:
            query_params.append(('forceDefaultPmDeletion', params['force_default_pm_deletion']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_payment_method_custom_fields(self, payment_method_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_method_custom_fields(payment_method_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_payment_method_custom_fields_with_http_info(payment_method_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_payment_method_custom_fields_with_http_info(payment_method_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_payment_method_custom_fields_with_http_info(self, payment_method_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_payment_method_custom_fields_with_http_info(payment_method_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_method_id', 'x_killbill_created_by', 'custom_field', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_payment_method_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `delete_payment_method_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_payment_method_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []
        if 'custom_field' in params:
            query_params.append(('customField', params['custom_field']))  # noqa: E501
            collection_formats['customField'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}/customFields', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_method(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve a payment method by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param bool included_deleted:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: PaymentMethod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_method_with_http_info(payment_method_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_method_with_http_info(payment_method_id, **kwargs)  # noqa: E501
            return data

    def get_payment_method_with_http_info(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve a payment method by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_with_http_info(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param bool included_deleted:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: PaymentMethod
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_method_id', 'included_deleted', 'with_plugin_info', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_method" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `get_payment_method`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentMethod',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_method_audit_logs_with_history(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve payment method audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_audit_logs_with_history(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_method_audit_logs_with_history_with_http_info(payment_method_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_method_audit_logs_with_history_with_http_info(payment_method_id, **kwargs)  # noqa: E501
            return data

    def get_payment_method_audit_logs_with_history_with_http_info(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve payment method audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_audit_logs_with_history_with_http_info(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_method_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_method_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `get_payment_method_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_method_by_key(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a payment method by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_by_key(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool included_deleted:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: PaymentMethod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_method_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_method_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
            return data

    def get_payment_method_by_key_with_http_info(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a payment method by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_by_key_with_http_info(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool included_deleted:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: PaymentMethod
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_key', 'included_deleted', 'with_plugin_info', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_method_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_key' is set
        if ('external_key' not in params or
                params['external_key'] is None):
            raise ValueError("Missing the required parameter `external_key` when calling `get_payment_method_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_key' in params:
            query_params.append(('externalKey', params['external_key']))  # noqa: E501
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentMethod',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_method_custom_fields(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve payment method custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_custom_fields(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_method_custom_fields_with_http_info(payment_method_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_method_custom_fields_with_http_info(payment_method_id, **kwargs)  # noqa: E501
            return data

    def get_payment_method_custom_fields_with_http_info(self, payment_method_id, **kwargs):  # noqa: E501
        """Retrieve payment method custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_method_custom_fields_with_http_info(payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str payment_method_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_method_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_method_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `get_payment_method_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment_methods(self, **kwargs):  # noqa: E501
        """List payment methods  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_methods(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[PaymentMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payment_methods_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_payment_methods_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_payment_methods_with_http_info(self, **kwargs):  # noqa: E501
        """List payment methods  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_methods_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[PaymentMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'plugin_name', 'with_plugin_info', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment_methods" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'plugin_name' in params:
            query_params.append(('pluginName', params['plugin_name']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/pagination', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PaymentMethod]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_payment_method_custom_fields(self, body, x_killbill_created_by, payment_method_id, **kwargs):  # noqa: E501
        """Modify custom fields to payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_payment_method_custom_fields(body, x_killbill_created_by, payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_method_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, **kwargs)  # noqa: E501
            return data

    def modify_payment_method_custom_fields_with_http_info(self, body, x_killbill_created_by, payment_method_id, **kwargs):  # noqa: E501
        """Modify custom fields to payment method  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_payment_method_custom_fields_with_http_info(body, x_killbill_created_by, payment_method_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str payment_method_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'payment_method_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_payment_method_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_payment_method_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `modify_payment_method_custom_fields`")  # noqa: E501
        # verify the required parameter 'payment_method_id' is set
        if ('payment_method_id' not in params or
                params['payment_method_id'] is None):
            raise ValueError("Missing the required parameter `payment_method_id` when calling `modify_payment_method_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_method_id' in params:
            path_params['paymentMethodId'] = params['payment_method_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/{paymentMethodId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_payment_methods(self, search_key, **kwargs):  # noqa: E501
        """Search payment methods  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_payment_methods(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[PaymentMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_payment_methods_with_http_info(search_key, **kwargs)  # noqa: E501
        else:
            (data) = self.search_payment_methods_with_http_info(search_key, **kwargs)  # noqa: E501
            return data

    def search_payment_methods_with_http_info(self, search_key, **kwargs):  # noqa: E501
        """Search payment methods  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_payment_methods_with_http_info(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str plugin_name:
        :param bool with_plugin_info:
        :param list[str] plugin_property:
        :param str audit:
        :return: list[PaymentMethod]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_key', 'offset', 'limit', 'plugin_name', 'with_plugin_info', 'plugin_property', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_payment_methods" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_key' is set
        if ('search_key' not in params or
                params['search_key'] is None):
            raise ValueError("Missing the required parameter `search_key` when calling `search_payment_methods`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'search_key' in params:
            path_params['searchKey'] = params['search_key']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'plugin_name' in params:
            query_params.append(('pluginName', params['plugin_name']))  # noqa: E501
        if 'with_plugin_info' in params:
            query_params.append(('withPluginInfo', params['with_plugin_info']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/paymentMethods/search/{searchKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PaymentMethod]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
