# PyStark

> A star ⭐ from you means a lot

An add-on extension to [Pyrogram](https://pypi.org/project/Pyrogram) for absolute beginners, to create telegram bots more easily.


## Documentation

Read the Documentation : https://pystark.codes/

## What's the main purpose?

There are some things that are common in most of the telegram bots. This library simplifies the development process by generating boilerplate code and easing the overall creation.

## Features

1. **Addons** - Any project using `pystark` can enable in-built addons that come with pystark. For example, default addons automatically add some commands like */start*, */help*, */about* and */id*.

   Of course that can be turned off using [project settings](https://pystark.codes/start/settings)

2. **Databases** - There are in-built functions that help in using databases. The databases include `postgres`, `redis`, `tinydb` and `telegramdb`
 
    To know more about using databases in pystark - [Click Here](https://pystark.codes/topics/using-databases/)

3. **Boilerplate Code** - You can generate a boilerplate with all the files you will need using our command line utility. Optionally, you can generate it with added Heroku Support (app.json, Procfile, etc.).

   To know more, about generating a boilerplate - [Click Here](https://pystark.codes/start/boilerplate/)

4. **Easy-To-Use** - There are multiple things that make this library easy-to-use.
   
- Start the bot using only 2-lines of code.

```python
from pystark import Stark

Stark().activate()
```

- Easy-to-use methods and decorators.

- Ability to customize everything.

- And much more.

## Credits

- [Dan](https://github.com/delivrance) for his [Pyrogram](https://github.com/pyrogram/pyrogram) Library on top of which **pystark** works.

## Community and Support

PyStark Telegram Updates - **[pystark](https://t.me/pystark)**

Telegram Channel - **[StarkBots](https://t.me/StarkBots)**

Telegram Chat - **[StarkBotsChat](https://t.me/StarkBotsChat)**

## Copyright and License

- Copyright (C) 2021-2022 **Stark Bots** <<https://github.com/StarkBotsIndustries>>

- Licensed under the terms of [GNU General Public License v3 or later (GPLv3+)](https://github.com/StarkBotsIndustries/PyStark/blob/master/LICENSE)
