# PyStark - Python add-on extension to Pyrogram
# Copyright (C) 2021-2022 Stark Bots <https://github.com/StarkBotsIndustries>
#
# This file is part of PyStark.
#
# PyStark is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# PyStark is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyStark. If not, see <https://www.gnu.org/licenses/>.


from pystark.database.sql import Base
from sqlalchemy import Column, BigInteger, String


class Bans(Base):
    __tablename__ = "bans"
    __table_args__ = {'extend_existing': True}
    user_id = Column(BigInteger, primary_key=True)
    reason = Column(String, nullable=True)

    def __init__(self, user_id, reason=None):
        self.user_id = user_id
        self.reason = reason
