from ..base_node import BaseNode
from ...core import socket_types as socket_types

from ...core.Constants import Colors

class MultiplyFloat(BaseNode):
    def __init__(self, scene, x=0, y=0):
        super().__init__(scene, title_background_color=Colors.multiply_float, x=x, y=y)
        self.change_title("0.0")

        self.input_01 = self.add_input(socket_types.FloatSocketType(self), "A")
        self.input_02 = self.add_input(socket_types.FloatSocketType(self), "B")
        self.output_float = self.add_output(socket_types.FloatSocketType(self), "out")

        self.input_01.set_initial_value(1.0)
        self.input_02.set_initial_value(1.0)

        self.add_label("Multiply")
        self.lbl_result = self.add_label("0")
        self.btn_add_input = self.add_button("Add input", clicked_function=self.add_new_input)

        self.inputs = [self.input_01, self.input_02]

        self.set_help_text("Multipies up all the inputs")


    def add_new_input(self):
        next_letter = chr(ord(self.inputs[-1].name) + 1)
        input = self.add_input(socket_types.FloatSocketType(self), next_letter)
        input.set_initial_value(1.0)
        self.inputs.append(input)

        self.set_help_text("Multipies up all the inputs")


    def compute(self, force=False):
        if self.is_dirty():
            result = 1.0

            for each in self.inputs:
                each.fetch_connected_value()
                input_value = each.get_value()

                result = result * input_value

            self.output_float.set_value(result)
            self.lbl_result.setText(str(result))

            super().compute(force=force)
            self.set_dirty(False)

            self.title.setPlainText(str(result))
            self.reposition_title()