# 基于nvidia-smi的GPU信息单机采集器 

------



> * 目标
> * 程序制式
> * 技术基础
> * 使用说明
> * 备注

### 1. 目标
在日常开发、调试、测试中，会流连于若干的服务器，有些时候，我们可以依赖于监控设施来记录、反馈、查看、回溯GPU相关的信息，但是很不幸，更多的时候，并没有一套监控机制能够随叫随到，我们只是想运行若干分钟且统计若干分钟，切换一台机器、部署一个服务、运行起来，统计一下。那么，少年，来一个简短的小程序/小工具，拥有它，畅游所有Linux服务器并随时统计你的GPU信息吧。

### 2. 程序制式
Python文件

### 3. 技术基础

- Basic and decent CPython, both python 2 and python 3.

- Nvidia drivers. 

### 4. 使用说明

```
usage: gpu_standalone_listener.py [-h] --d d [--l [l]]

Process some important options

optional arguments:
  -h, --help  show this help message and exit
  --d d       duration(s) of statistics
  --l [l]     delay or interval of sampler, in second
  
d为必填参数，单位是秒，意为采集的持续时间;
l为选填参数，单位是秒，意为采集延迟或间隔，默认为1s，l应<=d，确保至少采集一次，且nvidia-smi底层毫秒级采集实时性和准确性就较差，因此以秒为基础数量。

```
需要安装nvidia驱动，并可以正常使用nvidia-smi

```
> python gpu_standalone_listener.py --d 30 --l 1
```

或者直接安装python包：

```
> pip install glistener
> glistener --d 30 --l 1
```

样例输出：

```

[root@localhost data]# python gpu_standalone_listener.py --d 30 --l 1

==================================================
统计 30s, 间隔 1s 

GPU Numbers: 8
Device: Tesla T4
Driver Version: 410.104
--------------------------------------------------
GPU:  0
GPU平均利用率: 76.46%
GPU显存平均利用: 5736.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 91.00%
GPU最小利用率: 27.00%
GPU中位数利用率: 85.00%
GPU众数利用率: 88.00%
--------------------------------------------------
--------------------------------------------------
GPU:  1
GPU平均利用率: 73.65%
GPU显存平均利用: 5059.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 84.00%
GPU最小利用率: 17.00%
GPU中位数利用率: 81.00%
GPU众数利用率: 82.00%
--------------------------------------------------
--------------------------------------------------
GPU:  2
GPU平均利用率: 0.00%
GPU显存平均利用: 4154.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 0.00%
GPU最小利用率: 0.00%
GPU中位数利用率: 0.00%
GPU众数利用率: 0.00%
--------------------------------------------------
--------------------------------------------------
GPU:  3
GPU平均利用率: 87.92%
GPU显存平均利用: 8608.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 93.00%
GPU最小利用率: 62.00%
GPU中位数利用率: 89.50%
GPU众数利用率: 89.00%
--------------------------------------------------
--------------------------------------------------
GPU:  4
GPU平均利用率: 0.00%
GPU显存平均利用: 2710.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 0.00%
GPU最小利用率: 0.00%
GPU中位数利用率: 0.00%
GPU众数利用率: 0.00%
--------------------------------------------------
--------------------------------------------------
GPU:  5
GPU平均利用率: 19.73%
GPU显存平均利用: 815.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 23.00%
GPU最小利用率: 14.00%
GPU中位数利用率: 21.00%
GPU众数利用率: 21.00%
--------------------------------------------------
--------------------------------------------------
GPU:  6
GPU平均利用率: 3.62%
GPU显存平均利用: 785.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 22.00%
GPU最小利用率: 0.00%
GPU中位数利用率: 0.00%
GPU众数利用率: 0.00%
--------------------------------------------------
--------------------------------------------------
GPU:  7
GPU平均利用率: 0.12%
GPU显存平均利用: 839.00 MB
GPU显存: 15079.0 MB
GPU最大利用率: 1.00%
GPU最小利用率: 0.00%
GPU中位数利用率: 0.00%
GPU众数利用率: 0.00%
--------------------------------------------------
==================================================
```

### 5. 备注

- 采用了兼容Python 2和Python 3的语法，适合于所有主流的且支持nvidia driver的Linux发行版
- 一个文件，一个目的，只做一件事
- 随时拷贝随时运行，copy it & run it & feel it

------

leefyi@126.com
15012852770


