## BaseModelAdmin

- Model management base class

### Inherit from base class

- #### [SQLModelCrud](../../crud/SQLModelCrud)

### fields

#### list_display

List of fields that need to be displayed for bulk query.

- Support SQLModel model field, SQLModel model, current model database table field name
- Support current model fields, and other model fields.
- Support amis type: TableColumn
- Support sqlalchemy Label type: can be constructed by `LabelField` method.
    - For example: `User.name.label('nickname')`, `LabelField(User.name.label('nickname'),Field(None,title='User nickname'))`
- Default: `self.schema_list.__fields__.values()`

#### list_filter

- Batch query filter form field list
- Support amis type: FormItem
- Support sqlalchemy Label type: can be constructed by `LabelField` method.
- Default: `self.schema_filter.__fields__.values()`

#### list_per_page

- Batch query the amount of data per page, the default is: 15

#### search_fields

- A list of fields in the table that support text fuzzy search, the default is: []

#### update_fields

- A list of fields that can be edited in the table, the default is: []

#### bulk_update_fields

- A list of fields that support batch editing in the table, the default is: []

#### link_model_fields

- Batch query the field list of many-to-many associations that need to be linked, the default is: []. That is, the association list fields are not recognized by default.

#### link_model_forms

- Batch query the many-to-many associated field form list that needs to be linked, which is generated by default based on `self.link_model_fields`.

#### enable_bulk_create

- Whether to enable batch creation, the default is: False

### method

#### get_list_display

- Returns the list of fields displayed by the table list.

```python
async def get_list_display(
    self,
    request: Request
) -> List[Union[SQLModelListField, TableCRUD.Column]]
```

#### get_list_filter

- Returns the list of fields filtered by the table list query.

```python
async def get_list_filter(self, request: Request) -> List[Union[SQLModelListField, FormItem]]
```

#### get_list_column

Returns the `amis` `TableColumn` object for the table column fields.

- Reference: [Table table](https://baidu.gitee.io/amis/zh-CN/components/table#Column configuration attribute table)

```python
async def get_list_column(
    self, request: Request,
    modelfield: ModelField
) -> TableColumn
```

#### get_list_columns

Returns a list of `amis` `TableColumn` objects for table column fields.

```python
async def get_list_columns(self, request: Request) -> List[TableCRUD.Column]
```

#### get_list_filter_api

- Returns the AmisAPI object of the list filter filter form.

```python
async def get_list_filter_api(self, request: Request) -> AmisAPI
```

#### get_list_table

- Returns the `amis` `TableCRUD` object of the page.
- Reference: [CRUD CRUD](https://baidu.gitee.io/amis/zh-CN/components/crud)
  , [Table](https://baidu.gitee.io/amis/zh-CN/components/table)

```python
async def get_list_table(self, request: Request) -> TableCRUD
```

---

#### get_form_item

- Returns the `amis` `FormItem` object of the page's form fields.
- Reference: [FormItem ordinary form item (gitee.io)](https://baidu.gitee.io/amis/zh-CN/components/form/formitem)

```python
async def get_form_item(
    self, request: Request,
    modelfield: ModelField,
    action: CrudEnum
) -> Union[FormItem, SchemaNode]
```

#### get_form_item_on_foreign_key

- Returns the `amis` `FormItem` object for the `foreign_key` field of the page form.

```python
async def get_form_item_on_foreign_key(
    self,
    modelfield: ModelField
) -> Union[Service, SchemaNode]
```

#### get_link_model_forms

- Returns a many-to-many associated field form list.

```python
def get_link_model_forms(self) -> List[LinkModelForm]
```

#### get_list_filter_form

- Return to list filter filter form.

```python
async def get_list_filter_form(self, request: Request) -> Form
```

#### get_create_form

- Return to add model data form.

```python
async def get_create_form(self, request: Request, bulk: bool = False) -> Form
```

#### get_update_form

- Return to update model data form.

```python
async def get_update_form(self, request: Request, bulk: bool = False) -> Form
```

---

#### get_create_action

- Returns the `amis Action` object for the new model data to execute the action.
- Reference: [Action Action Button](https://baidu.gitee.io/amis/zh-CN/components/action?page=1#popbox)

```python
async def get_create_action(self, request: Request, bulk: bool = False) -> Optional[Action]
```

#### get_update_action

- Returns the `amis Action` object that updates the model data to perform the action.
- Reference: [Action Action Button](https://baidu.gitee.io/amis/zh-CN/components/action?page=1#popbox)

```python
async def get_update_action(self, request: Request, bulk: bool = False) -> Optional[Action]
```

#### get_delete_action

- Returns the `amis Action` object that deletes the model data to perform the action.
- Reference: [Action Action Button](https://baidu.gitee.io/amis/zh-CN/components/action?page=1#popbox)

```python
async def get_delete_action(self, request: Request, bulk: bool = False) -> Optional[Action]
```

#### get_actions_on_header_toolbar

- Return to the top toolbar of the list table to perform the action list.

```python
async def get_actions_on_header_toolbar(self, request: Request) -> List[Action]
```

#### get_actions_on_item

- Return list table data single item operation to perform action list.

```python
async def get_actions_on_item(self, request: Request) -> List[Action]
```

#### get_actions_on_bulk

- Return list table data batch operation to perform action list.

```python
async def get_actions_on_bulk(self, request: Request) -> List[Action]
```

## ModelAdmin

- Model management

### Inherit from base class

- #### [PageAdmin](../PageAdmin)

- #### [BaseModelAdmin](#BaseModelAdmin)

### fields

#### bind_model

Whether to bind the model management page to the model, default: `True`

- If set to `True`, it can be obtained through `AdminSite.get_model_admin`.

- In models with foreign key associations, the default `FormItem` (TablePicker) will use the first management page corresponding to the bound model.

##ModelAdmin data control core field/method diagram

- A: always affects the final value.

- O?: Numerical? indicates priority.

    - The construction scheme with the lowest numerical value is preferred as the final value.
    - Self overridden by overload will be directly adopted as the final value.

```mermaid
graph LR

	subgraph Read
		model--O1-->schema_read-->route_read:Response(ReadApiResponse)
		subgraph Selector
            model.->fields
            pk_name--A-->fields
            exclude--A-->fields
    	end
	end
	
	subgraph Create
        schema_create-->get_create_form-->create_form(AmisCreateForm)
        create_fields--O1-->schema_create-->route_create-->create_api_body(CreateApiRequest)
    end
    
	subgraph Update
		schema_update-->get_update_form-->update_form(AmisUpdateForm)
		update_fields--O1-->schema_update-->route_update-->update_api_body(UpdateApiRequest)
		readonly_fields--A-->schema_update
	end
	
	subgraph List
		fields-->_select_entities-->get_select
        fields-->schema_list-->list_api_response(ListApiResponse)
		list_display-->get_list_display-->get_list_columns-->list_columns(AmisListColumns)
		subgraph route_list
            get_select
            calc_filter_clause
            schema_list
            schema_filter
		end
        list_display--A-->fields--O2-->list_filter-->_filter_entities-->calc_filter_clause
        list_display--O1-->list_filter-->schema_filter-->route_list_body(ListApiRequest)
        subgraph Filter
        	search_fields--A-->list_filter-->get_list_filter-->get_list_filter_form-->list_filter_form(AmisListFilterForm)
        end
	end
	
```