# Multi-language

The multilingual support of `FastAPI-Amis-Admin` is divided into multilingual for the internal components of `Amis` on the front end and multilingual for the constant text on the back end.

- The default built-in support languages are: `en_US`, `zh_CN`. For other language extensions, please refer to [Amis Multilanguage](https://aisuda.bce.baidu.com/amis/zh-CN/docs/extend/i18n).
- From version 0.1.1 onwards, try setting the environment variable `LANGUAGE`/`LANG` > OS default language > English `en_US`.
- You can freely switch the language by adding the following code to the top of the project entry file. For example:

```python linenums="1" hl_lines="1 2"
from fastapi_amis_admin import i18n
i18n.set_language(language='zh_CN')

from fastapi_amis_admin.admin import AdminSite,Settings

from fastapi_amis_admin.amis.components import PageSchema

# Create AdminSite instance
site = AdminSite(settings=admin.Settings(database_url_async='sqlite+aiosqlite:///amisadmin.db'))

# Register the admin class
@site.register_admin
class GitHubIframeAdmin(admin:)
    # Set the page menu information
    page_schema = PageSchema(label='AmisIframeAdmin', icon='fa fa-github')
    # Set the jump link
    src = 'https://github.com/amisadmin/fastapi_amis_admin'
```