# 多语言

`FastAPI-Amis-Admin`的多语言支持分为前端`Amis`内部组件的多语言,以及后端常量文本的多语言.

- 系统默认内置支持语言有:`en_US`,`zh_CN`.其他语言拓展,参考[Amis多语言](https://aisuda.bce.baidu.com/amis/zh-CN/docs/extend/i18n).
- 从 0.1.1 版本开始系统默认语言依次尝试设置环境变量`LANGUAGE`/`LANG` > 操作系统默认语言 > 英文`en_US`.
- 可通过在项目入口文件顶部添加如下代码,进行自由切换语言.例如:

```python  linenums="1" hl_lines="1 2"
from fastapi_amis_admin import i18n
i18n.set_language(language='zh_CN')

from fastapi_amis_admin.admin import AdminSite,Settings

from fastapi_amis_admin.amis.components import PageSchema

# 创建AdminSite实例
site = AdminSite(settings=admin.Settings(database_url_async='sqlite+aiosqlite:///amisadmin.db'))

# 注册管理类
@site.register_admin
class GitHubIframeAdmin(admin.IframeAdmin):
    # 设置页面菜单信息
    page_schema = PageSchema(label='AmisIframeAdmin', icon='fa fa-github')
    # 设置跳转链接
    src = 'https://github.com/amisadmin/fastapi_amis_admin'
```