"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_athena_1 = require("@aws-cdk/aws-athena");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = core_1.Stack.of(node).resolve(node.workGroupConfiguration);
        if (workGroupConfiguration == undefined) {
            const workGroupConfigurationUpdates = core_1.Stack.of(node).resolve(node.workGroupConfigurationUpdates);
            if (workGroupConfigurationUpdates == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const resultConfigurationUpdates = core_1.Stack.of(node).resolve(workGroupConfigurationUpdates.resultConfigurationUpdates);
            if (resultConfigurationUpdates != undefined) {
                const removeEncryptionConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, resultConfigurationUpdates.removeEncryptionConfiguration);
                const encryptionConfiguration = core_1.Stack.of(node).resolve(resultConfigurationUpdates.encryptionConfiguration);
                const enforceWorkGroupConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, workGroupConfigurationUpdates.enforceWorkGroupConfiguration);
                if (removeEncryptionConfiguration &&
                    encryptionConfiguration == undefined) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
                else if (encryptionConfiguration != undefined &&
                    !enforceWorkGroupConfiguration) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        else {
            const enforceWorkGroupConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, workGroupConfiguration.enforceWorkGroupConfiguration);
            if (!enforceWorkGroupConfiguration) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const resultConfiguration = core_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
            if (resultConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const encryptionConfiguration = core_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
            if (encryptionConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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