"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_autoscaling_1 = require("@aws-cdk/aws-autoscaling");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        const classicLBs = core_1.Stack.of(node).resolve(node.loadBalancerNames);
        const otherLBs = core_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = nag_rules_1.NagRules.resolveIfPrimitive(node, node.healthCheckType);
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
            else {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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