"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_kinesisanalytics_1 = require("@aws-cdk/aws-kinesisanalytics");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * Kinesis Data Analytics Flink Applications have checkpointing enabled
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_kinesisanalytics_1.CfnApplicationV2) {
        if (node.runtimeEnvironment.toLowerCase().startsWith('flink')) {
            const applicationConfiguration = core_1.Stack.of(node).resolve(node.applicationConfiguration);
            if (applicationConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const flinkApplicationConfiguration = core_1.Stack.of(node).resolve(applicationConfiguration.flinkApplicationConfiguration);
            if (flinkApplicationConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const checkpointConfiguration = core_1.Stack.of(node).resolve(flinkApplicationConfiguration.checkpointConfiguration);
            if (checkpointConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            if (nag_rules_1.NagRules.resolveIfPrimitive(node, checkpointConfiguration.configurationType) == 'CUSTOM') {
                const enabled = nag_rules_1.NagRules.resolveIfPrimitive(node, checkpointConfiguration.checkpointingEnabled);
                if (!enabled) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiS2luZXNpc0RhdGFBbmFseXRpY3NGbGlua0NoZWNrcG9pbnRpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcnVsZXMva2luZXNpcy9LaW5lc2lzRGF0YUFuYWx5dGljc0ZsaW5rQ2hlY2twb2ludGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLCtCQUE2QjtBQUM3Qix3RUFBaUU7QUFDakUsd0NBQW1EO0FBQ25ELCtDQUE4RDtBQUU5RDs7O0dBR0c7QUFDSCxrQkFBZSxNQUFNLENBQUMsY0FBYyxDQUNsQyxDQUFDLElBQWlCLEVBQXFCLEVBQUU7SUFDdkMsSUFBSSxJQUFJLFlBQVksdUNBQWdCLEVBQUU7UUFDcEMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxFQUFFLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQzdELE1BQU0sd0JBQXdCLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3JELElBQUksQ0FBQyx3QkFBd0IsQ0FDOUIsQ0FBQztZQUNGLElBQUksd0JBQXdCLElBQUksU0FBUyxFQUFFO2dCQUN6QyxPQUFPLDZCQUFpQixDQUFDLGFBQWEsQ0FBQzthQUN4QztZQUNELE1BQU0sNkJBQTZCLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQzFELHdCQUF3QixDQUFDLDZCQUE2QixDQUN2RCxDQUFDO1lBQ0YsSUFBSSw2QkFBNkIsSUFBSSxTQUFTLEVBQUU7Z0JBQzlDLE9BQU8sNkJBQWlCLENBQUMsYUFBYSxDQUFDO2FBQ3hDO1lBQ0QsTUFBTSx1QkFBdUIsR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FDcEQsNkJBQTZCLENBQUMsdUJBQXVCLENBQ3RELENBQUM7WUFDRixJQUFJLHVCQUF1QixJQUFJLFNBQVMsRUFBRTtnQkFDeEMsT0FBTyw2QkFBaUIsQ0FBQyxhQUFhLENBQUM7YUFDeEM7WUFDRCxJQUNFLG9CQUFRLENBQUMsa0JBQWtCLENBQ3pCLElBQUksRUFDSix1QkFBdUIsQ0FBQyxpQkFBaUIsQ0FDMUMsSUFBSSxRQUFRLEVBQ2I7Z0JBQ0EsTUFBTSxPQUFPLEdBQUcsb0JBQVEsQ0FBQyxrQkFBa0IsQ0FDekMsSUFBSSxFQUNKLHVCQUF1QixDQUFDLG9CQUFvQixDQUM3QyxDQUFDO2dCQUNGLElBQUksQ0FBQyxPQUFPLEVBQUU7b0JBQ1osT0FBTyw2QkFBaUIsQ0FBQyxhQUFhLENBQUM7aUJBQ3hDO2FBQ0Y7U0FDRjtRQUNELE9BQU8sNkJBQWlCLENBQUMsU0FBUyxDQUFDO0tBQ3BDO1NBQU07UUFDTCxPQUFPLDZCQUFpQixDQUFDLGNBQWMsQ0FBQztLQUN6QztBQUNILENBQUMsRUFDRCxNQUFNLEVBQ04sRUFBRSxLQUFLLEVBQUUsWUFBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUNsQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBwYXJzZSB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgQ2ZuQXBwbGljYXRpb25WMiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzYW5hbHl0aWNzJztcbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgTmFnUnVsZUNvbXBsaWFuY2UsIE5hZ1J1bGVzIH0gZnJvbSAnLi4vLi4vbmFnLXJ1bGVzJztcblxuLyoqXG4gKiBLaW5lc2lzIERhdGEgQW5hbHl0aWNzIEZsaW5rIEFwcGxpY2F0aW9ucyBoYXZlIGNoZWNrcG9pbnRpbmcgZW5hYmxlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IE9iamVjdC5kZWZpbmVQcm9wZXJ0eShcbiAgKG5vZGU6IENmblJlc291cmNlKTogTmFnUnVsZUNvbXBsaWFuY2UgPT4ge1xuICAgIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuQXBwbGljYXRpb25WMikge1xuICAgICAgaWYgKG5vZGUucnVudGltZUVudmlyb25tZW50LnRvTG93ZXJDYXNlKCkuc3RhcnRzV2l0aCgnZmxpbmsnKSkge1xuICAgICAgICBjb25zdCBhcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgICAgIG5vZGUuYXBwbGljYXRpb25Db25maWd1cmF0aW9uXG4gICAgICAgICk7XG4gICAgICAgIGlmIChhcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgcmV0dXJuIE5hZ1J1bGVDb21wbGlhbmNlLk5PTl9DT01QTElBTlQ7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgZmxpbmtBcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgICAgIGFwcGxpY2F0aW9uQ29uZmlndXJhdGlvbi5mbGlua0FwcGxpY2F0aW9uQ29uZmlndXJhdGlvblxuICAgICAgICApO1xuICAgICAgICBpZiAoZmxpbmtBcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgcmV0dXJuIE5hZ1J1bGVDb21wbGlhbmNlLk5PTl9DT01QTElBTlQ7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgY2hlY2twb2ludENvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgICAgIGZsaW5rQXBwbGljYXRpb25Db25maWd1cmF0aW9uLmNoZWNrcG9pbnRDb25maWd1cmF0aW9uXG4gICAgICAgICk7XG4gICAgICAgIGlmIChjaGVja3BvaW50Q29uZmlndXJhdGlvbiA9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICByZXR1cm4gTmFnUnVsZUNvbXBsaWFuY2UuTk9OX0NPTVBMSUFOVDtcbiAgICAgICAgfVxuICAgICAgICBpZiAoXG4gICAgICAgICAgTmFnUnVsZXMucmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgICAgICAgbm9kZSxcbiAgICAgICAgICAgIGNoZWNrcG9pbnRDb25maWd1cmF0aW9uLmNvbmZpZ3VyYXRpb25UeXBlXG4gICAgICAgICAgKSA9PSAnQ1VTVE9NJ1xuICAgICAgICApIHtcbiAgICAgICAgICBjb25zdCBlbmFibGVkID0gTmFnUnVsZXMucmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgICAgICAgbm9kZSxcbiAgICAgICAgICAgIGNoZWNrcG9pbnRDb25maWd1cmF0aW9uLmNoZWNrcG9pbnRpbmdFbmFibGVkXG4gICAgICAgICAgKTtcbiAgICAgICAgICBpZiAoIWVuYWJsZWQpIHtcbiAgICAgICAgICAgIHJldHVybiBOYWdSdWxlQ29tcGxpYW5jZS5OT05fQ09NUExJQU5UO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgICAgcmV0dXJuIE5hZ1J1bGVDb21wbGlhbmNlLkNPTVBMSUFOVDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIE5hZ1J1bGVDb21wbGlhbmNlLk5PVF9BUFBMSUNBQkxFO1xuICAgIH1cbiAgfSxcbiAgJ25hbWUnLFxuICB7IHZhbHVlOiBwYXJzZShfX2ZpbGVuYW1lKS5uYW1lIH1cbik7XG4iXX0=