"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_msk_1 = require("@aws-cdk/aws-msk");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * MSK clusters use TLS communication between brokers
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = core_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = core_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const inCluster = nag_rules_1.NagRules.resolveIfPrimitive(node, encryptionInTransit.inCluster);
                if (inCluster === false) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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