"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_rds_1 = require("@aws-cdk/aws-rds");
const core_1 = require("@aws-cdk/core");
const nag_rules_1 = require("../../nag-rules");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(nag_rules_1.NagRules.resolveIfPrimitive(node, node.engine));
        const dbLogs = JSON.stringify(core_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery')))
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade')))
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace')))
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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