from ...__init__ import Generator
import random
import math


# Handles degrees in quadrant one
def gen_func(angles=[0, 30, 45, 60, 90],
             functions=["sin", "cos", "tan"],
             format='string'):
    angle = random.choice(angles)
    function = random.choice(functions)

    problem = f"What is {function}({angle})?"

    expression = 'math.' + function + '(math.radians(angle))'
    result_fraction_map = {
        0.0: "0",
        0.5: "1/2",
        0.71: "1/√2",
        0.87: "√3/2",
        1.0: "1",
        0.58: "1/√3",
        1.73: "√3"
    }

    solution = result_fraction_map[round(eval(expression), 2)] if round(
        eval(expression), 2) <= 99999 else "∞"  # for handling the ∞ condition

    if format == 'string':
        return problem, solution
    elif format == 'latex':
        return "Latex unavailable"
    else:
        return function, angle, solution


basic_trigonometry = Generator(
    "Trigonometric Values", 57, gen_func,
    ["angles=[0, 30, 45, 60, 90]", "functions=['sin', 'cos', 'tan']"])
