<a id="types-aiobotocore-codebuild"></a>

# types-aiobotocore-codebuild

[![PyPI - types-aiobotocore-codebuild](https://img.shields.io/pypi/v/types-aiobotocore-codebuild.svg?color=blue)](https://pypi.org/project/types-aiobotocore-codebuild)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/types-aiobotocore-codebuild.svg?color=blue)](https://pypi.org/project/types-aiobotocore-codebuild)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/types-aiobotocore-codebuild?color=blue)](https://pypistats.org/packages/types-aiobotocore-codebuild)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[aiobotocore.CodeBuild 2.3.4](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/codebuild.html#CodeBuild)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.7.2](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[types-aiobotocore](https://pypi.org/project/types-aiobotocore/) page and in
[types-aiobotocore-codebuild docs](https://youtype.github.io/types_aiobotocore_docs/types_aiobotocore_codebuild/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [types-aiobotocore-codebuild](#types-aiobotocore-codebuild)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `CodeBuild`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `types-aiobotocore` for `CodeBuild` service.

```bash
# install with aiobotocore type annotations
python -m pip install 'types-aiobotocore[codebuild]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'types-aiobotocore-lite[codebuild]'


# standalone installation
python -m pip install types-aiobotocore-codebuild
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y types-aiobotocore-codebuild
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `types-aiobotocore[codebuild]` in your environment:

```bash
python -m pip install 'types-aiobotocore[codebuild]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `aiobotocore` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `types-aiobotocore-lite[codebuild]` in your environment:

```bash
python -m pip install 'types-aiobotocore-lite[codebuild]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `types-aiobotocore` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `types-aiobotocore` with services you use in your environment:

```bash
python -m pip install 'types-aiobotocore[codebuild]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed
  `types-aiobotocore`

Type checking should now work. No explicit type annotations required, write
your `aiobotocore` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `types-aiobotocore[codebuild]` with services you use in your
  environment:

```bash
python -m pip install 'types-aiobotocore[codebuild]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `aiobotocore` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `types-aiobotocore[codebuild]` in your environment:

```bash
python -m pip install 'types-aiobotocore[codebuild]'`
```

Type checking should now work. No explicit type annotations required, write
your `aiobotocore` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `types-aiobotocore[codebuild]` in your environment:

```bash
python -m pip install 'types-aiobotocore[codebuild]'
```

Optionally, you can install `types-aiobotocore` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `aiobotocore` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CodeBuildClient` provides annotations for
`session.create_client("codebuild")`.

```python
from aiobotocore.session import get_session

from types_aiobotocore_codebuild import CodeBuildClient

session = get_session()
async with session.create_client("codebuild") as client:
    client: CodeBuildClient
    # now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`types_aiobotocore_codebuild.paginator` module contains type annotations for
all paginators.

````python
from aiobotocore.session import get_session

from types_aiobotocore_codebuild import CodeBuildClient
from types_aiobotocore_codebuild.paginator import (
    DescribeCodeCoveragesPaginator,
    DescribeTestCasesPaginator,
    ListBuildBatchesPaginator,
    ListBuildBatchesForProjectPaginator,
    ListBuildsPaginator,
    ListBuildsForProjectPaginator,
    ListProjectsPaginator,
    ListReportGroupsPaginator,
    ListReportsPaginator,
    ListReportsForReportGroupPaginator,
    ListSharedProjectsPaginator,
    ListSharedReportGroupsPaginator,
)

session = get_session()
async with session.create_client("codebuild") as client:
    client: CodeBuildClient

    # Explicit type annotations are optional here
    # Type should be correctly discovered by mypy and IDEs
    # VSCode requires explicit type annotations
        describe_code_coverages_paginator: DescribeCodeCoveragesPaginator = client.get_paginator("describe_code_coverages")
        describe_test_cases_paginator: DescribeTestCasesPaginator = client.get_paginator("describe_test_cases")
        list_build_batches_paginator: ListBuildBatchesPaginator = client.get_paginator("list_build_batches")
        list_build_batches_for_project_paginator: ListBuildBatchesForProjectPaginator = client.get_paginator("list_build_batches_for_project")
        list_builds_paginator: ListBuildsPaginator = client.get_paginator("list_builds")
        list_builds_for_project_paginator: ListBuildsForProjectPaginator = client.get_paginator("list_builds_for_project")
        list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
        list_report_groups_paginator: ListReportGroupsPaginator = client.get_paginator("list_report_groups")
        list_reports_paginator: ListReportsPaginator = client.get_paginator("list_reports")
        list_reports_for_report_group_paginator: ListReportsForReportGroupPaginator = client.get_paginator("list_reports_for_report_group")
        list_shared_projects_paginator: ListSharedProjectsPaginator = client.get_paginator("list_shared_projects")
        list_shared_report_groups_paginator: ListSharedReportGroupsPaginator = client.get_paginator("list_shared_report_groups")
    ```







### Literals

`types_aiobotocore_codebuild.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from types_aiobotocore_codebuild.literals import (
    ArtifactNamespaceType,
    ArtifactPackagingType,
    ArtifactsTypeType,
    AuthTypeType,
    BatchReportModeTypeType,
    BucketOwnerAccessType,
    BuildBatchPhaseTypeType,
    BuildPhaseTypeType,
    CacheModeType,
    CacheTypeType,
    ComputeTypeType,
    CredentialProviderTypeType,
    DescribeCodeCoveragesPaginatorName,
    DescribeTestCasesPaginatorName,
    EnvironmentTypeType,
    EnvironmentVariableTypeType,
    FileSystemTypeType,
    ImagePullCredentialsTypeType,
    LanguageTypeType,
    ListBuildBatchesForProjectPaginatorName,
    ListBuildBatchesPaginatorName,
    ListBuildsForProjectPaginatorName,
    ListBuildsPaginatorName,
    ListProjectsPaginatorName,
    ListReportGroupsPaginatorName,
    ListReportsForReportGroupPaginatorName,
    ListReportsPaginatorName,
    ListSharedProjectsPaginatorName,
    ListSharedReportGroupsPaginatorName,
    LogsConfigStatusTypeType,
    PlatformTypeType,
    ProjectSortByTypeType,
    ProjectVisibilityTypeType,
    ReportCodeCoverageSortByTypeType,
    ReportExportConfigTypeType,
    ReportGroupSortByTypeType,
    ReportGroupStatusTypeType,
    ReportGroupTrendFieldTypeType,
    ReportPackagingTypeType,
    ReportStatusTypeType,
    ReportTypeType,
    RetryBuildBatchTypeType,
    ServerTypeType,
    SharedResourceSortByTypeType,
    SortOrderTypeType,
    SourceAuthTypeType,
    SourceTypeType,
    StatusTypeType,
    WebhookBuildTypeType,
    WebhookFilterTypeType,
    CodeBuildServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    RegionName,
)

def check_value(value: ArtifactNamespaceType) -> bool:
    ...
````

### Typed dictionaries

`types_aiobotocore_codebuild.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from types_aiobotocore_codebuild.type_defs import (
    BatchDeleteBuildsInputRequestTypeDef,
    BuildNotDeletedTypeDef,
    ResponseMetadataTypeDef,
    BatchGetBuildBatchesInputRequestTypeDef,
    BatchGetBuildsInputRequestTypeDef,
    BatchGetProjectsInputRequestTypeDef,
    BatchGetReportGroupsInputRequestTypeDef,
    BatchGetReportsInputRequestTypeDef,
    BatchRestrictionsTypeDef,
    BuildArtifactsTypeDef,
    BuildBatchFilterTypeDef,
    PhaseContextTypeDef,
    ProjectCacheTypeDef,
    ProjectFileSystemLocationTypeDef,
    ProjectSourceVersionTypeDef,
    VpcConfigTypeDef,
    BuildStatusConfigTypeDef,
    ResolvedArtifactTypeDef,
    DebugSessionTypeDef,
    ExportedEnvironmentVariableTypeDef,
    NetworkInterfaceTypeDef,
    CloudWatchLogsConfigTypeDef,
    CodeCoverageReportSummaryTypeDef,
    CodeCoverageTypeDef,
    ProjectArtifactsTypeDef,
    TagTypeDef,
    WebhookFilterTypeDef,
    DeleteBuildBatchInputRequestTypeDef,
    DeleteProjectInputRequestTypeDef,
    DeleteReportGroupInputRequestTypeDef,
    DeleteReportInputRequestTypeDef,
    DeleteResourcePolicyInputRequestTypeDef,
    DeleteSourceCredentialsInputRequestTypeDef,
    DeleteWebhookInputRequestTypeDef,
    PaginatorConfigTypeDef,
    DescribeCodeCoveragesInputRequestTypeDef,
    TestCaseFilterTypeDef,
    TestCaseTypeDef,
    EnvironmentImageTypeDef,
    EnvironmentVariableTypeDef,
    GetReportGroupTrendInputRequestTypeDef,
    ReportGroupTrendStatsTypeDef,
    ReportWithRawDataTypeDef,
    GetResourcePolicyInputRequestTypeDef,
    GitSubmodulesConfigTypeDef,
    ImportSourceCredentialsInputRequestTypeDef,
    InvalidateProjectCacheInputRequestTypeDef,
    ListBuildsForProjectInputRequestTypeDef,
    ListBuildsInputRequestTypeDef,
    ListProjectsInputRequestTypeDef,
    ListReportGroupsInputRequestTypeDef,
    ReportFilterTypeDef,
    ListSharedProjectsInputRequestTypeDef,
    ListSharedReportGroupsInputRequestTypeDef,
    SourceCredentialsInfoTypeDef,
    S3LogsConfigTypeDef,
    ProjectBadgeTypeDef,
    RegistryCredentialTypeDef,
    SourceAuthTypeDef,
    PutResourcePolicyInputRequestTypeDef,
    S3ReportExportConfigTypeDef,
    TestReportSummaryTypeDef,
    RetryBuildBatchInputRequestTypeDef,
    RetryBuildInputRequestTypeDef,
    StopBuildBatchInputRequestTypeDef,
    StopBuildInputRequestTypeDef,
    UpdateProjectVisibilityInputRequestTypeDef,
    BatchDeleteBuildsOutputTypeDef,
    DeleteBuildBatchOutputTypeDef,
    DeleteSourceCredentialsOutputTypeDef,
    GetResourcePolicyOutputTypeDef,
    ImportSourceCredentialsOutputTypeDef,
    ListBuildBatchesForProjectOutputTypeDef,
    ListBuildBatchesOutputTypeDef,
    ListBuildsForProjectOutputTypeDef,
    ListBuildsOutputTypeDef,
    ListProjectsOutputTypeDef,
    ListReportGroupsOutputTypeDef,
    ListReportsForReportGroupOutputTypeDef,
    ListReportsOutputTypeDef,
    ListSharedProjectsOutputTypeDef,
    ListSharedReportGroupsOutputTypeDef,
    PutResourcePolicyOutputTypeDef,
    UpdateProjectVisibilityOutputTypeDef,
    ProjectBuildBatchConfigTypeDef,
    ListBuildBatchesForProjectInputRequestTypeDef,
    ListBuildBatchesInputRequestTypeDef,
    BuildBatchPhaseTypeDef,
    BuildPhaseTypeDef,
    BuildSummaryTypeDef,
    DescribeCodeCoveragesOutputTypeDef,
    CreateWebhookInputRequestTypeDef,
    UpdateWebhookInputRequestTypeDef,
    WebhookTypeDef,
    DescribeCodeCoveragesInputDescribeCodeCoveragesPaginateTypeDef,
    ListBuildBatchesForProjectInputListBuildBatchesForProjectPaginateTypeDef,
    ListBuildBatchesInputListBuildBatchesPaginateTypeDef,
    ListBuildsForProjectInputListBuildsForProjectPaginateTypeDef,
    ListBuildsInputListBuildsPaginateTypeDef,
    ListProjectsInputListProjectsPaginateTypeDef,
    ListReportGroupsInputListReportGroupsPaginateTypeDef,
    ListSharedProjectsInputListSharedProjectsPaginateTypeDef,
    ListSharedReportGroupsInputListSharedReportGroupsPaginateTypeDef,
    DescribeTestCasesInputDescribeTestCasesPaginateTypeDef,
    DescribeTestCasesInputRequestTypeDef,
    DescribeTestCasesOutputTypeDef,
    EnvironmentLanguageTypeDef,
    GetReportGroupTrendOutputTypeDef,
    ListReportsForReportGroupInputListReportsForReportGroupPaginateTypeDef,
    ListReportsForReportGroupInputRequestTypeDef,
    ListReportsInputListReportsPaginateTypeDef,
    ListReportsInputRequestTypeDef,
    ListSourceCredentialsOutputTypeDef,
    LogsConfigTypeDef,
    LogsLocationTypeDef,
    ProjectEnvironmentTypeDef,
    ProjectSourceTypeDef,
    ReportExportConfigTypeDef,
    BuildGroupTypeDef,
    CreateWebhookOutputTypeDef,
    UpdateWebhookOutputTypeDef,
    EnvironmentPlatformTypeDef,
    BuildTypeDef,
    CreateProjectInputRequestTypeDef,
    ProjectTypeDef,
    StartBuildBatchInputRequestTypeDef,
    StartBuildInputRequestTypeDef,
    UpdateProjectInputRequestTypeDef,
    CreateReportGroupInputRequestTypeDef,
    ReportGroupTypeDef,
    ReportTypeDef,
    UpdateReportGroupInputRequestTypeDef,
    BuildBatchTypeDef,
    ListCuratedEnvironmentImagesOutputTypeDef,
    BatchGetBuildsOutputTypeDef,
    RetryBuildOutputTypeDef,
    StartBuildOutputTypeDef,
    StopBuildOutputTypeDef,
    BatchGetProjectsOutputTypeDef,
    CreateProjectOutputTypeDef,
    UpdateProjectOutputTypeDef,
    BatchGetReportGroupsOutputTypeDef,
    CreateReportGroupOutputTypeDef,
    UpdateReportGroupOutputTypeDef,
    BatchGetReportsOutputTypeDef,
    BatchGetBuildBatchesOutputTypeDef,
    RetryBuildBatchOutputTypeDef,
    StartBuildBatchOutputTypeDef,
    StopBuildBatchOutputTypeDef,
)

def get_structure() -> BatchDeleteBuildsInputRequestTypeDef:
    return {
      ...
    }
```

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for
`aiobotocore` updates. It delivers a drop-in type annotations for you and makes
sure that:

- All available `aiobotocore` services are covered.
- Each public class and method of every `aiobotocore` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

## What's new

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

## Versioning

`types-aiobotocore-codebuild` version is the same as related `aiobotocore`
version and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/)
format.

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

## Documentation

All services type annotations can be found in
[aiobotocore docs](https://youtype.github.io/types_aiobotocore_docs/types_aiobotocore_codebuild/)

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
