"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
The MIT License

Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""
import abc
import google.protobuf.empty_pb2
import grpc
import temporalio.api.testservice.v1.request_response_pb2

class TestServiceStub:
    """TestService API defines an interface supported only by the Temporal Test Server.
    It provides functionality needed or supported for testing purposes only.

    This is an EXPERIMENTAL API.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    LockTimeSkipping: grpc.UnaryUnaryMultiCallable[
        temporalio.api.testservice.v1.request_response_pb2.LockTimeSkippingRequest,
        temporalio.api.testservice.v1.request_response_pb2.LockTimeSkippingResponse,
    ]
    """LockTimeSkipping increments Time Locking Counter by one.

    If Time Locking Counter is positive, time skipping is locked (disabled).
    When time skipping is disabled, the time in test server is moving normally, with a real time pace.
    Test Server is typically started with locked time skipping and Time Locking Counter = 1.

    LockTimeSkipping and UnlockTimeSkipping calls are counted.
    """
    UnlockTimeSkipping: grpc.UnaryUnaryMultiCallable[
        temporalio.api.testservice.v1.request_response_pb2.UnlockTimeSkippingRequest,
        temporalio.api.testservice.v1.request_response_pb2.UnlockTimeSkippingResponse,
    ]
    """UnlockTimeSkipping decrements Time Locking Counter by one.

    If the counter reaches 0, it unlocks time skipping and fast forwards time.
    LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
    guarantee that time is going to be fast forwarded as another lock can be holding it.

    Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
    """
    Sleep: grpc.UnaryUnaryMultiCallable[
        temporalio.api.testservice.v1.request_response_pb2.SleepRequest,
        temporalio.api.testservice.v1.request_response_pb2.SleepResponse,
    ]
    """This call returns only when the Test Server Time advances by the specified duration.
    This is an EXPERIMENTAL API.
    """
    SleepUntil: grpc.UnaryUnaryMultiCallable[
        temporalio.api.testservice.v1.request_response_pb2.SleepUntilRequest,
        temporalio.api.testservice.v1.request_response_pb2.SleepResponse,
    ]
    """This call returns only when the Test Server Time advances to the specified timestamp.
    If the current Test Server Time is beyond the specified timestamp, returns immediately.
    This is an EXPERIMENTAL API.
    """
    UnlockTimeSkippingWithSleep: grpc.UnaryUnaryMultiCallable[
        temporalio.api.testservice.v1.request_response_pb2.SleepRequest,
        temporalio.api.testservice.v1.request_response_pb2.SleepResponse,
    ]
    """UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
    once the Test Server Time advances by the duration specified in the request.

    This call returns only when the Test Server Time advances by the specified duration.

    If it is called when Time Locking Counter is
      - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
      - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
      - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
    """
    GetCurrentTime: grpc.UnaryUnaryMultiCallable[
        google.protobuf.empty_pb2.Empty,
        temporalio.api.testservice.v1.request_response_pb2.GetCurrentTimeResponse,
    ]
    """GetCurrentTime returns the current Temporal Test Server time

    This time might not be equal to {@link System#currentTimeMillis()} due to time skipping.
    """

class TestServiceServicer(metaclass=abc.ABCMeta):
    """TestService API defines an interface supported only by the Temporal Test Server.
    It provides functionality needed or supported for testing purposes only.

    This is an EXPERIMENTAL API.
    """

    @abc.abstractmethod
    def LockTimeSkipping(
        self,
        request: temporalio.api.testservice.v1.request_response_pb2.LockTimeSkippingRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.LockTimeSkippingResponse:
        """LockTimeSkipping increments Time Locking Counter by one.

        If Time Locking Counter is positive, time skipping is locked (disabled).
        When time skipping is disabled, the time in test server is moving normally, with a real time pace.
        Test Server is typically started with locked time skipping and Time Locking Counter = 1.

        LockTimeSkipping and UnlockTimeSkipping calls are counted.
        """
    @abc.abstractmethod
    def UnlockTimeSkipping(
        self,
        request: temporalio.api.testservice.v1.request_response_pb2.UnlockTimeSkippingRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.UnlockTimeSkippingResponse:
        """UnlockTimeSkipping decrements Time Locking Counter by one.

        If the counter reaches 0, it unlocks time skipping and fast forwards time.
        LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
        guarantee that time is going to be fast forwarded as another lock can be holding it.

        Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
        """
    @abc.abstractmethod
    def Sleep(
        self,
        request: temporalio.api.testservice.v1.request_response_pb2.SleepRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.SleepResponse:
        """This call returns only when the Test Server Time advances by the specified duration.
        This is an EXPERIMENTAL API.
        """
    @abc.abstractmethod
    def SleepUntil(
        self,
        request: temporalio.api.testservice.v1.request_response_pb2.SleepUntilRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.SleepResponse:
        """This call returns only when the Test Server Time advances to the specified timestamp.
        If the current Test Server Time is beyond the specified timestamp, returns immediately.
        This is an EXPERIMENTAL API.
        """
    @abc.abstractmethod
    def UnlockTimeSkippingWithSleep(
        self,
        request: temporalio.api.testservice.v1.request_response_pb2.SleepRequest,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.SleepResponse:
        """UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
        once the Test Server Time advances by the duration specified in the request.

        This call returns only when the Test Server Time advances by the specified duration.

        If it is called when Time Locking Counter is
          - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
          - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
          - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
        """
    @abc.abstractmethod
    def GetCurrentTime(
        self,
        request: google.protobuf.empty_pb2.Empty,
        context: grpc.ServicerContext,
    ) -> temporalio.api.testservice.v1.request_response_pb2.GetCurrentTimeResponse:
        """GetCurrentTime returns the current Temporal Test Server time

        This time might not be equal to {@link System#currentTimeMillis()} due to time skipping.
        """

def add_TestServiceServicer_to_server(
    servicer: TestServiceServicer, server: grpc.Server
) -> None: ...
