"""Configure application-wide logging to the command-line.

Copyright (C) 2021 emerac

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

"""
import logging

# The level will be set and the handlers added by other functions.
logger = logging.getLogger(__name__)
formatter = logging.Formatter(
    "%(relativeCreated)6d %(levelname)-8s %(message)s"
)
stream_handler = logging.StreamHandler()
stream_handler.setFormatter(formatter)
null_handler = logging.NullHandler()
