
/* Chrysalide - Outil d'analyse de fichiers binaires
 * processor.c - équivalent Python du fichier "arch/arm/v7/processor.c"
 *
 * Copyright (C) 2017-2018 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "processor.h"


#include <pygobject.h>


#include <plugins/pychrysalide/helpers.h>


#include "../processor.h"
#include "../../v7/processor.h"



/******************************************************************************
*                                                                             *
*  Paramètres  : -                                                            *
*                                                                             *
*  Description : Fournit un accès à une définition de type à diffuser.        *
*                                                                             *
*  Retour      : Définition d'objet pour Python.                              *
*                                                                             *
*  Remarques   : -                                                            *
*                                                                             *
******************************************************************************/

PyTypeObject *get_python_armv7_processor_type(void)
{
    static PyMethodDef py_armv7_processor_methods[] = {
        { NULL }
    };

    static PyGetSetDef py_armv7_processor_getseters[] = {
        { NULL }
    };

    static PyTypeObject py_armv7_processor_type = {

        PyVarObject_HEAD_INIT(NULL, 0)

        .tp_name        = "pychrysalide.arch.arm.v7.ArmV7Processor",
        .tp_basicsize   = sizeof(PyGObject),

        .tp_flags       = Py_TPFLAGS_DEFAULT,

        .tp_doc         = "PyChrysalide processor for an ARMv7 architecture.",

        .tp_methods     = py_armv7_processor_methods,
        .tp_getset      = py_armv7_processor_getseters,

    };

    return &py_armv7_processor_type;

}


/******************************************************************************
*                                                                             *
*  Paramètres  : module = module dont la définition est à compléter.          *
*                                                                             *
*  Description : Prend en charge l'objet 'pychrysalide.arch.arm.ArmProcessor'.*
*                                                                             *
*  Retour      : Bilan de l'opération.                                        *
*                                                                             *
*  Remarques   : -                                                            *
*                                                                             *
******************************************************************************/

bool register_python_armv7_processor(PyObject *module)
{
    PyTypeObject *py_armv7_processor_type;  /* Type Python 'BinContent'    */
    PyObject *dict;                         /* Dictionnaire du module      */

    py_armv7_processor_type = get_python_armv7_processor_type();

    dict = PyModule_GetDict(module);

    if (!register_class_for_pygobject(dict, G_TYPE_ARMV7_PROCESSOR, py_armv7_processor_type, get_python_arm_processor_type()))
        return false;

    return true;

}
