
/* Chrysalide - Outil d'analyse de fichiers binaires
 * ##FILE## - traduction d'instructions ARMv7
 *
 * Copyright (C) 2017 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


@title QDADD

@id 133

@desc {

	Saturating Double and Add adds a doubled register value to another register value, and writes the result to the destination register. Both the doubling and the addition have their results saturated to the 32-bit signed integer range –231 ≤ x ≤ 231 – 1. If saturation occurs in either operation, it sets the Q flag in the APSR.

}

@encoding (T1) {

	@word 1 1 1 1 1 0 1 0 1 0 0 0 Rn(4) 1 1 1 1 Rd(4) 1 0 0 1 Rm(4)

	@syntax {

		@subid 413

		@conv {

			reg_D = Register(Rd)
			reg_M = Register(Rm)
			reg_N = Register(Rn)

		}

		@asm qdadd ?reg_D reg_M reg_N

	}

}

@encoding (A1) {

	@word cond(4) 0 0 0 1 0 1 0 0 Rn(4) Rd(4) 0 0 0 0 0 1 0 1 Rm(4)

	@syntax {

		@subid 414

		@conv {

			reg_D = Register(Rd)
			reg_M = Register(Rm)
			reg_N = Register(Rn)

		}

		@asm qdadd ?reg_D reg_M reg_N

		@rules {

			check g_arm_instruction_set_cond(cond)

		}

	}

}

