
/* Chrysalide - Outil d'analyse de fichiers binaires
 * format.h - prototypes pour le support du format BOOT.img
 *
 * Copyright (C) 2019 Cyrille Bagard
 *
 *  This file is part of Chrysalide.
 *
 *  Chrysalide is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Chrysalide is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Chrysalide.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef _PLUGINS_BOOTIMG_FORMAT_H
#define _PLUGINS_BOOTIMG_FORMAT_H


#include <glib-object.h>
#include <stdbool.h>


#include <analysis/content.h>


#include "bootimg-def.h"



#define G_TYPE_BOOTIMG_FORMAT            g_bootimg_format_get_type()
#define G_BOOTIMG_FORMAT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), G_TYPE_BOOTIMG_FORMAT, GBootImgFormat))
#define G_IS_BOOTIMG_FORMAT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), G_TYPE_BOOTIMG_FORMAT))
#define G_BOOTIMG_FORMAT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), G_TYPE_BOOTIMG_FORMAT, GBootImgFormatClass))
#define G_IS_BOOTIMG_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), G_TYPE_BOOTIMG_FORMAT))
#define G_BOOTIMG_FORMAT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), G_TYPE_BOOTIMG_FORMAT, GBootImgFormatClass))


/* Format d'image BOOT.img (instance) */
typedef struct _GBootImgFormat GBootImgFormat;

/* Format d'image BOOT.img (classe) */
typedef struct _GBootImgFormatClass GBootImgFormatClass;


/* Valide un contenu comme étant un format BOOT.img. */
bool check_bootimg_format(const GBinContent *);

/* Indique le type défini pour un format d'image BOOT.img. */
GType g_bootimg_format_get_type(void);

/* Prend en charge un nouveau format BOOT.img. */
GBootImgFormat *g_bootimg_format_new(GBinContent *);

/* Présente l'entête BOOT.img du format chargé. */
const boot_img_hdr *g_bootimg_format_get_header(const GBootImgFormat *);

/* Fournit le noyau inclus dans une image de démarrage. */
GBinContent *g_bootimg_format_get_kernel(const GBootImgFormat *);

/* Fournit le disque en RAM inclus dans une image de démarrage. */
GBinContent *g_bootimg_format_get_ramdisk(const GBootImgFormat *);



#endif  /* _PLUGINS_BOOTIMG_FORMAT_H */
