import os

# SIENA PACKAGE
PACKAGE_NAME_PYPI = "siena"
PACKAGE_NAME_GITHUB = "siena-nlp"
PACKAGE_VERSION = "1.0.0"

# SIENA SERVER
DEFAULT_SERVER_HOST = "localhost"
DEFAULT_SERVER_HOST_DEC = "0.0.0.0"
DEFAULT_SERVER_PORT = 6068
ASCII_LOGO = """
 █▀▀ ▀█▀ █▀▀ █▀▀▄ █▀▀▄
 ▀▀▄  █  █▀▀ █  █ █▄▄█
 ▀▀▀ ▀▀▀ ▀▀▀ ▀  ▀ ▀  ▀
"""

# RASA
DEFAULT_DATA_PATH = "./data"
YAML_EXTENSIONS = [".yml", ".yaml"]
DEFAULT_NLU_YAML_VERSION = "2.0"
DEFAULT_NLU_YAML_TAG = "nlu"
DEFAULT_VERSION_YAML_TAG = "version"
DEFAULT_NLU_INTENT_TAG = "intent"
DEFAULT_NLU_EXAMPLES_TAG = "examples"
DEFAULT_CASE_SENSITIVE_MODE = True


# FILE IO
class FilePermission:
    READ = "r"
    WRITE = "w"
    APPEND = "a"
    WRITE_PLUS = "w+"
    READ_PLUS = "r+"
    APPEND_PLUS = "a+"


class Encoding:
    UTF8 = "utf8"


# TERMINAL
class TermColor:
    # source:
    # https://pkg.go.dev/github.com/whitedevops/colors

    BOLD = "\033[1m"
    UNDERLINE = "\033[4m"
    END_C = "\033[0m"
    NONE_C = ""

    DEFAULT = "\033[39m"
    BLACK = "\033[30m"
    RED = "\033[31m"
    GREEN = "\033[32m"
    YELLOW = "\033[33m"
    BLUE = "\033[34m"
    MAGENTA = "\033[35m"
    CYAN = "\033[36m"
    LIGHTGRAY = "\033[37m"
    DARKGRAY = "\033[90m"
    LIGHTRED = "\033[91m"
    LIGHTGREEN = "\033[92m"
    LIGHTYELLOW = "\033[93m"
    LIGHTBLUE = "\033[94m"
    LIGHTMAGENTA = "\033[95m"
    LIGHTCYAN = "\033[96m"
    WHITE = "\033[97m"

    BDEFAULT = "\033[49m"
    BBLACK = "\033[40m"
    BRED = "\033[41m"
    BGREEN = "\033[42m"
    BYELLOW = "\033[43m"
    BBLUE = "\033[44m"
    BMAGENTA = "\033[45m"
    BCYAN = "\033[46m"
    BGRAY = "\033[47m"
    BDARKGRAY = "\033[100m"
    BLIGHTRED = "\033[101m"
    BLIGHTGREEN = "\033[102m"
    BLIGHTYELLOW = "\033[103m"
    BLIGHTBLUE = "\033[104m"
    BLIGHTMAGENTA = "\033[105m"
    BLIGHTCYAN = "\033[106m"
    BWHITE = "\033[107m"


class LoggingLevel:
    NOTSET = 0
    DEBUG = 10
    INFO = 20
    WARNING = 30
    ERROR = 40
    CRITICAL = 50
    QUIET = 60


class ServerEnv:
    STRICT_LOCAL = "strict_local"  # triggers server explanations without subprocess
    DEV = "dev"  # enables server debugging
    PROD = "prod"  # disables server debugging


class InterfaceType:
    INTERFACE_SERVER = "server"
    INTERFACE_NONE = ""


class SIENAConfig:
    ALL_KEYS = ['server_port']
    SUB_KEY_SERVER_HOST = 'server_host'
    SUB_KEY_SERVER_PORT = 'server_port'


# SIENA CORE
LOOKUP_DIR = "data"
UPLOAD_FOLDER = 'uploads'
ALLOWED_EXTENSIONS_NLU = {'yml', 'yaml'}
ALLOWED_EXTENSIONS_KNOWLEDGE = {'csv', 'CSV'}
SIENA_CACHE_PATH = "./siena_cache"
SIENA_KNOWLEDGE_BASE_PATH = os.path.join(SIENA_CACHE_PATH, "knowledge_base.csv")
SIENA_TEMP_KNOWLEDGE_BASE_PATH = os.path.join(SIENA_CACHE_PATH, "knowledge_base_temp.csv")
SIENA_IN_PROGRESS_PATH = os.path.join(SIENA_CACHE_PATH, "inprogress.SIENA")
SIENA_ENTITIES_PATH = os.path.join(SIENA_CACHE_PATH, "entities.SIENA")
SIENA_CONFIG_PATH = os.path.join(SIENA_CACHE_PATH, "config.SIENA")
SEP_TAG = "<sep>"
NEW_LINE_TAG = "\n"
UNDEFINED_TAG = "undefined"

VOWELS_MAPPER = {
    '': '',
    'අ': 'අ',
    'ආ': 'ආ',
    'ඇ': 'ඇ',
    'ඈ': 'ඈ',
    'ඉ': 'ඉ',
    'ඊ': 'ඊ',
    'උ': 'උ',
    'ඌ': 'ඌ',
    'ර්උ': 'ර්උ',
    'ර්ඌ': 'ර්ඌ',
    'ඖ': 'ඖ',
    'එ': 'එ',
    'ඒ': 'ඒ',
    'ඓ': 'ඓ',
    'ඔ': 'ඔ',
    'ඕ': 'ඕ',
    'අං': 'අං',
    'අඃ': 'අඃ',
    'ර්': 'ර්',
    'ර': 'ර්අ',
    'ය': 'ය්අ',
    'ක්': 'ක්',
    'ක': 'ක්අ',
    'කා': 'ක්ආ',
    'කැ': 'ක්ඇ',
    'කෑ': 'ක්ඈ',
    'කි': 'ක්ඉ',
    'කී': 'ක්ඊ',
    'කු': 'ක්උ',
    'කූ': 'ක්ඌ',
    'කෘ': 'ක්ර්උ',
    'කෲ': 'ක්ර්ඌ',
    'කෟ': 'ක්ඖ',
    'කෳ': 'ක්ඖ',
    'කෙ': 'ක්එ',
    'කේ': 'ක්ඒ',
    'කෛ': 'ක්ඓ',
    'කො': 'ක්ඔ',
    'කෝ': 'ක්ඕ',
    'කෞ': 'ක්ඖ',
    'කං': 'ක්අං',
    'කඃ': 'ක්අඃ',
    'ර්‍ක': 'ර්ක්',
    'ක්‍ර': 'ක්ර',
    'ක්‍ය': 'ක්ය',
    'ඛ්': 'ඛ්',
    'ඛ': 'ඛ්අ',
    'ඛා': 'ඛ්ආ',
    'ඛැ': 'ඛ්ඇ',
    'ඛෑ': 'ඛ්ඈ',
    'ඛි': 'ඛ්ඉ',
    'ඛී': 'ඛ්ඊ',
    'ඛු': 'ඛ්උ',
    'ඛූ': 'ඛ්ඌ',
    'ඛෘ': 'ඛ්ර්උ',
    'ඛෲ': 'ඛ්ර්ඌ',
    'ඛෟ': 'ඛ්ඖ',
    'ඛෳ': 'ඛ්ඖ',
    'ඛෙ': 'ඛ්එ',
    'ඛේ': 'ඛ්ඒ',
    'ඛෛ': 'ඛ්ඓ',
    'ඛො': 'ඛ්ඔ',
    'ඛෝ': 'ඛ්ඕ',
    'ඛෞ': 'ඛ්ඖ',
    'ඛං': 'ඛ්අං',
    'ඛඃ': 'ඛ්අඃ',
    'ර්‍ඛ': 'ර්ඛ්',
    'ඛ්‍ර': 'ඛ්ර',
    'ඛ්‍ය': 'ඛ්ය',
    'ග්': 'ග්',
    'ග': 'ග්අ',
    'ගා': 'ග්ආ',
    'ගැ': 'ග්ඇ',
    'ගෑ': 'ග්ඈ',
    'ගි': 'ග්ඉ',
    'ගී': 'ග්ඊ',
    'ගු': 'ග්උ',
    'ගූ': 'ග්ඌ',
    'ගෘ': 'ග්ර්උ',
    'ගෲ': 'ග්ර්ඌ',
    'ගෟ': 'ග්ඖ',
    'ගෳ': 'ග්ඖ',
    'ගෙ': 'ග්එ',
    'ගේ': 'ග්ඒ',
    'ගෛ': 'ග්ඓ',
    'ගො': 'ග්ඔ',
    'ගෝ': 'ග්ඕ',
    'ගෞ': 'ග්ඖ',
    'ගං': 'ග්අං',
    'ගඃ': 'ග්අඃ',
    'ර්‍ග': 'ර්ග්',
    'ග්‍ර': 'ග්ර',
    'ග්‍ය': 'ග්ය',
    'ඝ්': 'ඝ්',
    'ඝ': 'ඝ්අ',
    'ඝා': 'ඝ්ආ',
    'ඝැ': 'ඝ්ඇ',
    'ඝෑ': 'ඝ්ඈ',
    'ඝි': 'ඝ්ඉ',
    'ඝී': 'ඝ්ඊ',
    'ඝු': 'ඝ්උ',
    'ඝූ': 'ඝ්ඌ',
    'ඝෘ': 'ඝ්ර්උ',
    'ඝෲ': 'ඝ්ර්ඌ',
    'ඝෟ': 'ඝ්ඖ',
    'ඝෳ': 'ඝ්ඖ',
    'ඝෙ': 'ඝ්එ',
    'ඝේ': 'ඝ්ඒ',
    'ඝෛ': 'ඝ්ඓ',
    'ඝො': 'ඝ්ඔ',
    'ඝෝ': 'ඝ්ඕ',
    'ඝෞ': 'ඝ්ඖ',
    'ඝං': 'ඝ්අං',
    'ඝඃ': 'ඝ්අඃ',
    'ර්‍ඝ': 'ර්ඝ්',
    'ඝ්‍ර': 'ඝ්ර',
    'ඝ්‍ය': 'ඝ්ය',
    'ඞ්': 'ඞ්',
    'ඞ': 'ඞ්අ',
    'ඞා': 'ඞ්ආ',
    'ඞැ': 'ඞ්ඇ',
    'ඞෑ': 'ඞ්ඈ',
    'ඞි': 'ඞ්ඉ',
    'ඞී': 'ඞ්ඊ',
    'ඞු': 'ඞ්උ',
    'ඞූ': 'ඞ්ඌ',
    'ඞෘ': 'ඞ්ර්උ',
    'ඞෲ': 'ඞ්ර්ඌ',
    'ඞෟ': 'ඞ්ඖ',
    'ඞෳ': 'ඞ්ඖ',
    'ඞෙ': 'ඞ්එ',
    'ඞේ': 'ඞ්ඒ',
    'ඞෛ': 'ඞ්ඓ',
    'ඞො': 'ඞ්ඔ',
    'ඞෝ': 'ඞ්ඕ',
    'ඞෞ': 'ඞ්ඖ',
    'ඞං': 'ඞ්අං',
    'ඞඃ': 'ඞ්අඃ',
    'ර්‍ඞ': 'ර්ඞ්',
    'ඞ්‍ර': 'ඞ්ර',
    'ඞ්‍ය': 'ඞ්ය',
    'ඟ්': 'ඟ්',
    'ඟ': 'ඟ්අ',
    'ඟා': 'ඟ්ආ',
    'ඟැ': 'ඟ්ඇ',
    'ඟෑ': 'ඟ්ඈ',
    'ඟි': 'ඟ්ඉ',
    'ඟී': 'ඟ්ඊ',
    'ඟු': 'ඟ්උ',
    'ඟූ': 'ඟ්ඌ',
    'ඟෘ': 'ඟ්ර්උ',
    'ඟෲ': 'ඟ්ර්ඌ',
    'ඟෟ': 'ඟ්ඖ',
    'ඟෳ': 'ඟ්ඖ',
    'ඟෙ': 'ඟ්එ',
    'ඟේ': 'ඟ්ඒ',
    'ඟෛ': 'ඟ්ඓ',
    'ඟො': 'ඟ්ඔ',
    'ඟෝ': 'ඟ්ඕ',
    'ඟෞ': 'ඟ්ඖ',
    'ඟං': 'ඟ්අං',
    'ඟඃ': 'ඟ්අඃ',
    'ර්‍ඟ': 'ර්ඟ්',
    'ඟ්‍ර': 'ඟ්ර',
    'ඟ්‍ය': 'ඟ්ය',
    'ච්': 'ච්',
    'ච': 'ච්අ',
    'චා': 'ච්ආ',
    'චැ': 'ච්ඇ',
    'චෑ': 'ච්ඈ',
    'චි': 'ච්ඉ',
    'චී': 'ච්ඊ',
    'චු': 'ච්උ',
    'චූ': 'ච්ඌ',
    'චෘ': 'ච්ර්උ',
    'චෲ': 'ච්ර්ඌ',
    'චෟ': 'ච්ඖ',
    'චෳ': 'ච්ඖ',
    'චෙ': 'ච්එ',
    'චේ': 'ච්ඒ',
    'චෛ': 'ච්ඓ',
    'චො': 'ච්ඔ',
    'චෝ': 'ච්ඕ',
    'චෞ': 'ච්ඖ',
    'චං': 'ච්අං',
    'චඃ': 'ච්අඃ',
    'ර්‍ච': 'ර්ච්',
    'ච්‍ර': 'ච්ර',
    'ච්‍ය': 'ච්ය',
    'ඡ්': 'ඡ්',
    'ඡ': 'ඡ්අ',
    'ඡා': 'ඡ්ආ',
    'ඡැ': 'ඡ්ඇ',
    'ඡෑ': 'ඡ්ඈ',
    'ඡි': 'ඡ්ඉ',
    'ඡී': 'ඡ්ඊ',
    'ඡු': 'ඡ්උ',
    'ඡූ': 'ඡ්ඌ',
    'ඡෘ': 'ඡ්ර්උ',
    'ඡෲ': 'ඡ්ර්ඌ',
    'ඡෟ': 'ඡ්ඖ',
    'ඡෳ': 'ඡ්ඖ',
    'ඡෙ': 'ඡ්එ',
    'ඡේ': 'ඡ්ඒ',
    'ඡෛ': 'ඡ්ඓ',
    'ඡො': 'ඡ්ඔ',
    'ඡෝ': 'ඡ්ඕ',
    'ඡෞ': 'ඡ්ඖ',
    'ඡං': 'ඡ්අං',
    'ඡඃ': 'ඡ්අඃ',
    'ර්‍ඡ': 'ර්ඡ්',
    'ඡ්‍ර': 'ඡ්ර',
    'ඡ්‍ය': 'ඡ්ය',
    'ජ්': 'ජ්',
    'ජ': 'ජ්අ',
    'ජා': 'ජ්ආ',
    'ජැ': 'ජ්ඇ',
    'ජෑ': 'ජ්ඈ',
    'ජි': 'ජ්ඉ',
    'ජී': 'ජ්ඊ',
    'ජු': 'ජ්උ',
    'ජූ': 'ජ්ඌ',
    'ජෘ': 'ජ්ර්උ',
    'ජෲ': 'ජ්ර්ඌ',
    'ජෟ': 'ජ්ඖ',
    'ජෳ': 'ජ්ඖ',
    'ජෙ': 'ජ්එ',
    'ජේ': 'ජ්ඒ',
    'ජෛ': 'ජ්ඓ',
    'ජො': 'ජ්ඔ',
    'ජෝ': 'ජ්ඕ',
    'ජෞ': 'ජ්ඖ',
    'ජං': 'ජ්අං',
    'ජඃ': 'ජ්අඃ',
    'ර්‍ජ': 'ර්ජ්',
    'ජ්‍ර': 'ජ්ර',
    'ජ්‍ය': 'ජ්ය',
    'ඣ්': 'ඣ්',
    'ඣ': 'ඣ්අ',
    'ඣා': 'ඣ්ආ',
    'ඣැ': 'ඣ්ඇ',
    'ඣෑ': 'ඣ්ඈ',
    'ඣි': 'ඣ්ඉ',
    'ඣී': 'ඣ්ඊ',
    'ඣු': 'ඣ්උ',
    'ඣූ': 'ඣ්ඌ',
    'ඣෘ': 'ඣ්ර්උ',
    'ඣෲ': 'ඣ්ර්ඌ',
    'ඣෟ': 'ඣ්ඖ',
    'ඣෳ': 'ඣ්ඖ',
    'ඣෙ': 'ඣ්එ',
    'ඣේ': 'ඣ්ඒ',
    'ඣෛ': 'ඣ්ඓ',
    'ඣො': 'ඣ්ඔ',
    'ඣෝ': 'ඣ්ඕ',
    'ඣෞ': 'ඣ්ඖ',
    'ඣං': 'ඣ්අං',
    'ඣඃ': 'ඣ්අඃ',
    'ර්‍ඣ': 'ර්ඣ්',
    'ඣ්‍ර': 'ඣ්ර',
    'ඣ්‍ය': 'ඣ්ය',
    'ඤ්': 'ඤ්',
    'ඤ': 'ඤ්අ',
    'ඤා': 'ඤ්ආ',
    'ඤැ': 'ඤ්ඇ',
    'ඤෑ': 'ඤ්ඈ',
    'ඤි': 'ඤ්ඉ',
    'ඤී': 'ඤ්ඊ',
    'ඤු': 'ඤ්උ',
    'ඤූ': 'ඤ්ඌ',
    'ඤෘ': 'ඤ්ර්උ',
    'ඤෲ': 'ඤ්ර්ඌ',
    'ඤෟ': 'ඤ්ඖ',
    'ඤෳ': 'ඤ්ඖ',
    'ඤෙ': 'ඤ්එ',
    'ඤේ': 'ඤ්ඒ',
    'ඤෛ': 'ඤ්ඓ',
    'ඤො': 'ඤ්ඔ',
    'ඤෝ': 'ඤ්ඕ',
    'ඤෞ': 'ඤ්ඖ',
    'ඤං': 'ඤ්අං',
    'ඤඃ': 'ඤ්අඃ',
    'ර්‍ඤ': 'ර්ඤ්',
    'ඤ්‍ර': 'ඤ්ර',
    'ඤ්‍ය': 'ඤ්ය',
    'ඥ්': 'ඥ්',
    'ඥ': 'ඥ්අ',
    'ඥා': 'ඥ්ආ',
    'ඥැ': 'ඥ්ඇ',
    'ඥෑ': 'ඥ්ඈ',
    'ඥි': 'ඥ්ඉ',
    'ඥී': 'ඥ්ඊ',
    'ඥු': 'ඥ්උ',
    'ඥූ': 'ඥ්ඌ',
    'ඥෘ': 'ඥ්ර්උ',
    'ඥෲ': 'ඥ්ර්ඌ',
    'ඥෟ': 'ඥ්ඖ',
    'ඥෳ': 'ඥ්ඖ',
    'ඥෙ': 'ඥ්එ',
    'ඥේ': 'ඥ්ඒ',
    'ඥෛ': 'ඥ්ඓ',
    'ඥො': 'ඥ්ඔ',
    'ඥෝ': 'ඥ්ඕ',
    'ඥෞ': 'ඥ්ඖ',
    'ඥං': 'ඥ්අං',
    'ඥඃ': 'ඥ්අඃ',
    'ර්‍ඥ': 'ර්ඥ්',
    'ඥ්‍ර': 'ඥ්ර',
    'ඥ්‍ය': 'ඥ්ය',
    'ඦ්': 'ඦ්',
    'ඦ': 'ඦ්අ',
    'ඦා': 'ඦ්ආ',
    'ඦැ': 'ඦ්ඇ',
    'ඦෑ': 'ඦ්ඈ',
    'ඦි': 'ඦ්ඉ',
    'ඦී': 'ඦ්ඊ',
    'ඦු': 'ඦ්උ',
    'ඦූ': 'ඦ්ඌ',
    'ඦෘ': 'ඦ්ර්උ',
    'ඦෲ': 'ඦ්ර්ඌ',
    'ඦෟ': 'ඦ්ඖ',
    'ඦෳ': 'ඦ්ඖ',
    'ඦෙ': 'ඦ්එ',
    'ඦේ': 'ඦ්ඒ',
    'ඦෛ': 'ඦ්ඓ',
    'ඦො': 'ඦ්ඔ',
    'ඦෝ': 'ඦ්ඕ',
    'ඦෞ': 'ඦ්ඖ',
    'ඦං': 'ඦ්අං',
    'ඦඃ': 'ඦ්අඃ',
    'ර්‍ඦ': 'ර්ඦ්',
    'ඦ්‍ර': 'ඦ්ර',
    'ඦ්‍ය': 'ඦ්ය',
    'ට්': 'ට්',
    'ට': 'ට්අ',
    'ටා': 'ට්ආ',
    'ටැ': 'ට්ඇ',
    'ටෑ': 'ට්ඈ',
    'ටි': 'ට්ඉ',
    'ටී': 'ට්ඊ',
    'ටු': 'ට්උ',
    'ටූ': 'ට්ඌ',
    'ටෘ': 'ට්ර්උ',
    'ටෲ': 'ට්ර්ඌ',
    'ටෟ': 'ට්ඖ',
    'ටෳ': 'ට්ඖ',
    'ටෙ': 'ට්එ',
    'ටේ': 'ට්ඒ',
    'ටෛ': 'ට්ඓ',
    'ටො': 'ට්ඔ',
    'ටෝ': 'ට්ඕ',
    'ටෞ': 'ට්ඖ',
    'ටං': 'ට්අං',
    'ටඃ': 'ට්අඃ',
    'ර්‍ට': 'ර්ට්',
    'ට්‍ර': 'ට්ර',
    'ට්‍ය': 'ට්ය',
    'ඨ්': 'ඨ්',
    'ඨ': 'ඨ්අ',
    'ඨා': 'ඨ්ආ',
    'ඨැ': 'ඨ්ඇ',
    'ඨෑ': 'ඨ්ඈ',
    'ඨි': 'ඨ්ඉ',
    'ඨී': 'ඨ්ඊ',
    'ඨු': 'ඨ්උ',
    'ඨූ': 'ඨ්ඌ',
    'ඨෘ': 'ඨ්ර්උ',
    'ඨෲ': 'ඨ්ර්ඌ',
    'ඨෟ': 'ඨ්ඖ',
    'ඨෳ': 'ඨ්ඖ',
    'ඨෙ': 'ඨ්එ',
    'ඨේ': 'ඨ්ඒ',
    'ඨෛ': 'ඨ්ඓ',
    'ඨො': 'ඨ්ඔ',
    'ඨෝ': 'ඨ්ඕ',
    'ඨෞ': 'ඨ්ඖ',
    'ඨං': 'ඨ්අං',
    'ඨඃ': 'ඨ්අඃ',
    'ර්‍ඨ': 'ර්ඨ්',
    'ඨ්‍ර': 'ඨ්ර',
    'ඨ්‍ය': 'ඨ්ය',
    'ඩ්': 'ඩ්',
    'ඩ': 'ඩ්අ',
    'ඩා': 'ඩ්ආ',
    'ඩැ': 'ඩ්ඇ',
    'ඩෑ': 'ඩ්ඈ',
    'ඩි': 'ඩ්ඉ',
    'ඩී': 'ඩ්ඊ',
    'ඩු': 'ඩ්උ',
    'ඩූ': 'ඩ්ඌ',
    'ඩෘ': 'ඩ්ර්උ',
    'ඩෲ': 'ඩ්ර්ඌ',
    'ඩෟ': 'ඩ්ඖ',
    'ඩෳ': 'ඩ්ඖ',
    'ඩෙ': 'ඩ්එ',
    'ඩේ': 'ඩ්ඒ',
    'ඩෛ': 'ඩ්ඓ',
    'ඩො': 'ඩ්ඔ',
    'ඩෝ': 'ඩ්ඕ',
    'ඩෞ': 'ඩ්ඖ',
    'ඩං': 'ඩ්අං',
    'ඩඃ': 'ඩ්අඃ',
    'ර්‍ඩ': 'ර්ඩ්',
    'ඩ්‍ර': 'ඩ්ර',
    'ඩ්‍ය': 'ඩ්ය',
    'ඪ්': 'ඪ්',
    'ඪ': 'ඪ්අ',
    'ඪා': 'ඪ්ආ',
    'ඪැ': 'ඪ්ඇ',
    'ඪෑ': 'ඪ්ඈ',
    'ඪි': 'ඪ්ඉ',
    'ඪී': 'ඪ්ඊ',
    'ඪු': 'ඪ්උ',
    'ඪූ': 'ඪ්ඌ',
    'ඪෘ': 'ඪ්ර්උ',
    'ඪෲ': 'ඪ්ර්ඌ',
    'ඪෟ': 'ඪ්ඖ',
    'ඪෳ': 'ඪ්ඖ',
    'ඪෙ': 'ඪ්එ',
    'ඪේ': 'ඪ්ඒ',
    'ඪෛ': 'ඪ්ඓ',
    'ඪො': 'ඪ්ඔ',
    'ඪෝ': 'ඪ්ඕ',
    'ඪෞ': 'ඪ්ඖ',
    'ඪං': 'ඪ්අං',
    'ඪඃ': 'ඪ්අඃ',
    'ර්‍ඪ': 'ර්ඪ්',
    'ඪ්‍ර': 'ඪ්ර',
    'ඪ්‍ය': 'ඪ්ය',
    'ණ්': 'ණ්',
    'ණ': 'ණ්අ',
    'ණා': 'ණ්ආ',
    'ණැ': 'ණ්ඇ',
    'ණෑ': 'ණ්ඈ',
    'ණි': 'ණ්ඉ',
    'ණී': 'ණ්ඊ',
    'ණු': 'ණ්උ',
    'ණූ': 'ණ්ඌ',
    'ණෘ': 'ණ්ර්උ',
    'ණෲ': 'ණ්ර්ඌ',
    'ණෟ': 'ණ්ඖ',
    'ණෳ': 'ණ්ඖ',
    'ණෙ': 'ණ්එ',
    'ණේ': 'ණ්ඒ',
    'ණෛ': 'ණ්ඓ',
    'ණො': 'ණ්ඔ',
    'ණෝ': 'ණ්ඕ',
    'ණෞ': 'ණ්ඖ',
    'ණං': 'ණ්අං',
    'ණඃ': 'ණ්අඃ',
    'ර්‍ණ': 'ර්ණ්',
    'ණ්‍ර': 'ණ්ර',
    'ණ්‍ය': 'ණ්ය',
    'ඬ්': 'ඬ්',
    'ඬ': 'ඬ්අ',
    'ඬා': 'ඬ්ආ',
    'ඬැ': 'ඬ්ඇ',
    'ඬෑ': 'ඬ්ඈ',
    'ඬි': 'ඬ්ඉ',
    'ඬී': 'ඬ්ඊ',
    'ඬු': 'ඬ්උ',
    'ඬූ': 'ඬ්ඌ',
    'ඬෘ': 'ඬ්ර්උ',
    'ඬෲ': 'ඬ්ර්ඌ',
    'ඬෟ': 'ඬ්ඖ',
    'ඬෳ': 'ඬ්ඖ',
    'ඬෙ': 'ඬ්එ',
    'ඬේ': 'ඬ්ඒ',
    'ඬෛ': 'ඬ්ඓ',
    'ඬො': 'ඬ්ඔ',
    'ඬෝ': 'ඬ්ඕ',
    'ඬෞ': 'ඬ්ඖ',
    'ඬං': 'ඬ්අං',
    'ඬඃ': 'ඬ්අඃ',
    'ර්‍ඬ': 'ර්ඬ්',
    'ඬ්‍ර': 'ඬ්ර',
    'ඬ්‍ය': 'ඬ්ය',
    'ත්': 'ත්',
    'ත': 'ත්අ',
    'තා': 'ත්ආ',
    'තැ': 'ත්ඇ',
    'තෑ': 'ත්ඈ',
    'ති': 'ත්ඉ',
    'තී': 'ත්ඊ',
    'තු': 'ත්උ',
    'තූ': 'ත්ඌ',
    'තෘ': 'ත්ර්උ',
    'තෲ': 'ත්ර්ඌ',
    'තෟ': 'ත්ඖ',
    'තෳ': 'ත්ඖ',
    'තෙ': 'ත්එ',
    'තේ': 'ත්ඒ',
    'තෛ': 'ත්ඓ',
    'තො': 'ත්ඔ',
    'තෝ': 'ත්ඕ',
    'තෞ': 'ත්ඖ',
    'තං': 'ත්අං',
    'තඃ': 'ත්අඃ',
    'ර්‍ත': 'ර්ත්',
    'ත්‍ර': 'ත්ර',
    'ත්‍ය': 'ත්ය',
    'ථ්': 'ථ්',
    'ථ': 'ථ්අ',
    'ථා': 'ථ්ආ',
    'ථැ': 'ථ්ඇ',
    'ථෑ': 'ථ්ඈ',
    'ථි': 'ථ්ඉ',
    'ථී': 'ථ්ඊ',
    'ථු': 'ථ්උ',
    'ථූ': 'ථ්ඌ',
    'ථෘ': 'ථ්ර්උ',
    'ථෲ': 'ථ්ර්ඌ',
    'ථෟ': 'ථ්ඖ',
    'ථෳ': 'ථ්ඖ',
    'ථෙ': 'ථ්එ',
    'ථේ': 'ථ්ඒ',
    'ථෛ': 'ථ්ඓ',
    'ථො': 'ථ්ඔ',
    'ථෝ': 'ථ්ඕ',
    'ථෞ': 'ථ්ඖ',
    'ථං': 'ථ්අං',
    'ථඃ': 'ථ්අඃ',
    'ර්‍ථ': 'ර්ථ්',
    'ථ්‍ර': 'ථ්ර',
    'ථ්‍ය': 'ථ්ය',
    'ද්': 'ද්',
    'ද': 'ද්අ',
    'දා': 'ද්ආ',
    'දැ': 'ද්ඇ',
    'දෑ': 'ද්ඈ',
    'දි': 'ද්ඉ',
    'දී': 'ද්ඊ',
    'දු': 'ද්උ',
    'දූ': 'ද්ඌ',
    'දෘ': 'ද්ර්උ',
    'දෲ': 'ද්ර්ඌ',
    'දෟ': 'ද්ඖ',
    'දෳ': 'ද්ඖ',
    'දෙ': 'ද්එ',
    'දේ': 'ද්ඒ',
    'දෛ': 'ද්ඓ',
    'දො': 'ද්ඔ',
    'දෝ': 'ද්ඕ',
    'දෞ': 'ද්ඖ',
    'දං': 'ද්අං',
    'දඃ': 'ද්අඃ',
    'ර්‍ද': 'ර්ද්',
    'ද්‍ර': 'ද්ර',
    'ද්‍ය': 'ද්ය',
    'ධ්': 'ධ්',
    'ධ': 'ධ්අ',
    'ධා': 'ධ්ආ',
    'ධැ': 'ධ්ඇ',
    'ධෑ': 'ධ්ඈ',
    'ධි': 'ධ්ඉ',
    'ධී': 'ධ්ඊ',
    'ධු': 'ධ්උ',
    'ධූ': 'ධ්ඌ',
    'ධෘ': 'ධ්ර්උ',
    'ධෲ': 'ධ්ර්ඌ',
    'ධෟ': 'ධ්ඖ',
    'ධෳ': 'ධ්ඖ',
    'ධෙ': 'ධ්එ',
    'ධේ': 'ධ්ඒ',
    'ධෛ': 'ධ්ඓ',
    'ධො': 'ධ්ඔ',
    'ධෝ': 'ධ්ඕ',
    'ධෞ': 'ධ්ඖ',
    'ධං': 'ධ්අං',
    'ධඃ': 'ධ්අඃ',
    'ර්‍ධ': 'ර්ධ්',
    'ධ්‍ර': 'ධ්ර',
    'ධ්‍ය': 'ධ්ය',
    'න්': 'න්',
    'න': 'න්අ',
    'නා': 'න්ආ',
    'නැ': 'න්ඇ',
    'නෑ': 'න්ඈ',
    'නි': 'න්ඉ',
    'නී': 'න්ඊ',
    'නු': 'න්උ',
    'නූ': 'න්ඌ',
    'නෘ': 'න්ර්උ',
    'නෲ': 'න්ර්ඌ',
    'නෟ': 'න්ඖ',
    'නෳ': 'න්ඖ',
    'නෙ': 'න්එ',
    'නේ': 'න්ඒ',
    'නෛ': 'න්ඓ',
    'නො': 'න්ඔ',
    'නෝ': 'න්ඕ',
    'නෞ': 'න්ඖ',
    'නං': 'න්අං',
    'නඃ': 'න්අඃ',
    'ර්‍න': 'ර්න්',
    'න්‍ර': 'න්ර',
    'න්‍ය': 'න්ය',
    'ඳ්': 'ඳ්',
    'ඳ': 'ඳ්අ',
    'ඳා': 'ඳ්ආ',
    'ඳැ': 'ඳ්ඇ',
    'ඳෑ': 'ඳ්ඈ',
    'ඳි': 'ඳ්ඉ',
    'ඳී': 'ඳ්ඊ',
    'ඳු': 'ඳ්උ',
    'ඳූ': 'ඳ්ඌ',
    'ඳෘ': 'ඳ්ර්උ',
    'ඳෲ': 'ඳ්ර්ඌ',
    'ඳෟ': 'ඳ්ඖ',
    'ඳෳ': 'ඳ්ඖ',
    'ඳෙ': 'ඳ්එ',
    'ඳේ': 'ඳ්ඒ',
    'ඳෛ': 'ඳ්ඓ',
    'ඳො': 'ඳ්ඔ',
    'ඳෝ': 'ඳ්ඕ',
    'ඳෞ': 'ඳ්ඖ',
    'ඳං': 'ඳ්අං',
    'ඳඃ': 'ඳ්අඃ',
    'ර්‍ඳ': 'ර්ඳ්',
    'ඳ්‍ර': 'ඳ්ර',
    'ඳ්‍ය': 'ඳ්ය',
    'ප්': 'ප්',
    'ප': 'ප්අ',
    'පා': 'ප්ආ',
    'පැ': 'ප්ඇ',
    'පෑ': 'ප්ඈ',
    'පි': 'ප්ඉ',
    'පී': 'ප්ඊ',
    'පු': 'ප්උ',
    'පූ': 'ප්ඌ',
    'පෘ': 'ප්ර්උ',
    'පෲ': 'ප්ර්ඌ',
    'පෟ': 'ප්ඖ',
    'පෳ': 'ප්ඖ',
    'පෙ': 'ප්එ',
    'පේ': 'ප්ඒ',
    'පෛ': 'ප්ඓ',
    'පො': 'ප්ඔ',
    'පෝ': 'ප්ඕ',
    'පෞ': 'ප්ඖ',
    'පං': 'ප්අං',
    'පඃ': 'ප්අඃ',
    'ර්‍ප': 'ර්ප්',
    'ප්‍ර': 'ප්ර',
    'ප්‍ය': 'ප්ය',
    'ඵ්': 'ඵ්',
    'ඵ': 'ඵ්අ',
    'ඵා': 'ඵ්ආ',
    'ඵැ': 'ඵ්ඇ',
    'ඵෑ': 'ඵ්ඈ',
    'ඵි': 'ඵ්ඉ',
    'ඵී': 'ඵ්ඊ',
    'ඵු': 'ඵ්උ',
    'ඵූ': 'ඵ්ඌ',
    'ඵෘ': 'ඵ්ර්උ',
    'ඵෲ': 'ඵ්ර්ඌ',
    'ඵෟ': 'ඵ්ඖ',
    'ඵෳ': 'ඵ්ඖ',
    'ඵෙ': 'ඵ්එ',
    'ඵේ': 'ඵ්ඒ',
    'ඵෛ': 'ඵ්ඓ',
    'ඵො': 'ඵ්ඔ',
    'ඵෝ': 'ඵ්ඕ',
    'ඵෞ': 'ඵ්ඖ',
    'ඵං': 'ඵ්අං',
    'ඵඃ': 'ඵ්අඃ',
    'ර්‍ඵ': 'ර්ඵ්',
    'ඵ්‍ර': 'ඵ්ර',
    'ඵ්‍ය': 'ඵ්ය',
    'බ්': 'බ්',
    'බ': 'බ්අ',
    'බා': 'බ්ආ',
    'බැ': 'බ්ඇ',
    'බෑ': 'බ්ඈ',
    'බි': 'බ්ඉ',
    'බී': 'බ්ඊ',
    'බු': 'බ්උ',
    'බූ': 'බ්ඌ',
    'බෘ': 'බ්ර්උ',
    'බෲ': 'බ්ර්ඌ',
    'බෟ': 'බ්ඖ',
    'බෳ': 'බ්ඖ',
    'බෙ': 'බ්එ',
    'බේ': 'බ්ඒ',
    'බෛ': 'බ්ඓ',
    'බො': 'බ්ඔ',
    'බෝ': 'බ්ඕ',
    'බෞ': 'බ්ඖ',
    'බං': 'බ්අං',
    'බඃ': 'බ්අඃ',
    'ර්‍බ': 'ර්බ්',
    'බ්‍ර': 'බ්ර',
    'බ්‍ය': 'බ්ය',
    'භ්': 'භ්',
    'භ': 'භ්අ',
    'භා': 'භ්ආ',
    'භැ': 'භ්ඇ',
    'භෑ': 'භ්ඈ',
    'භි': 'භ්ඉ',
    'භී': 'භ්ඊ',
    'භු': 'භ්උ',
    'භූ': 'භ්ඌ',
    'භෘ': 'භ්ර්උ',
    'භෲ': 'භ්ර්ඌ',
    'භෟ': 'භ්ඖ',
    'භෳ': 'භ්ඖ',
    'භෙ': 'භ්එ',
    'භේ': 'භ්ඒ',
    'භෛ': 'භ්ඓ',
    'භො': 'භ්ඔ',
    'භෝ': 'භ්ඕ',
    'භෞ': 'භ්ඖ',
    'භං': 'භ්අං',
    'භඃ': 'භ්අඃ',
    'ර්‍භ': 'ර්භ්',
    'භ්‍ර': 'භ්ර',
    'භ්‍ය': 'භ්ය',
    'ම්': 'ම්',
    'ම': 'ම්අ',
    'මා': 'ම්ආ',
    'මැ': 'ම්ඇ',
    'මෑ': 'ම්ඈ',
    'මි': 'ම්ඉ',
    'මී': 'ම්ඊ',
    'මු': 'ම්උ',
    'මූ': 'ම්ඌ',
    'මෘ': 'ම්ර්උ',
    'මෲ': 'ම්ර්ඌ',
    'මෟ': 'ම්ඖ',
    'මෳ': 'ම්ඖ',
    'මෙ': 'ම්එ',
    'මේ': 'ම්ඒ',
    'මෛ': 'ම්ඓ',
    'මො': 'ම්ඔ',
    'මෝ': 'ම්ඕ',
    'මෞ': 'ම්ඖ',
    'මං': 'ම්අං',
    'මඃ': 'ම්අඃ',
    'ර්‍ම': 'ර්ම්',
    'ම්‍ර': 'ම්ර',
    'ම්‍ය': 'ම්ය',
    'ඹ්': 'ඹ්',
    'ඹ': 'ඹ්අ',
    'ඹා': 'ඹ්ආ',
    'ඹැ': 'ඹ්ඇ',
    'ඹෑ': 'ඹ්ඈ',
    'ඹි': 'ඹ්ඉ',
    'ඹී': 'ඹ්ඊ',
    'ඹු': 'ඹ්උ',
    'ඹූ': 'ඹ්ඌ',
    'ඹෘ': 'ඹ්ර්උ',
    'ඹෲ': 'ඹ්ර්ඌ',
    'ඹෟ': 'ඹ්ඖ',
    'ඹෳ': 'ඹ්ඖ',
    'ඹෙ': 'ඹ්එ',
    'ඹේ': 'ඹ්ඒ',
    'ඹෛ': 'ඹ්ඓ',
    'ඹො': 'ඹ්ඔ',
    'ඹෝ': 'ඹ්ඕ',
    'ඹෞ': 'ඹ්ඖ',
    'ඹං': 'ඹ්අං',
    'ඹඃ': 'ඹ්අඃ',
    'ර්‍ඹ': 'ර්ඹ්',
    'ඹ්‍ර': 'ඹ්ර',
    'ඹ්‍ය': 'ඹ්ය',
    'ය්': 'ය්',
    'යා': 'ය්ආ',
    'යැ': 'ය්ඇ',
    'යෑ': 'ය්ඈ',
    'යි': 'ය්ඉ',
    'යී': 'ය්ඊ',
    'යු': 'ය්උ',
    'යූ': 'ය්ඌ',
    'යෘ': 'ය්ර්උ',
    'යෲ': 'ය්ර්ඌ',
    'යෟ': 'ය්ඖ',
    'යෳ': 'ය්ඖ',
    'යෙ': 'ය්එ',
    'යේ': 'ය්ඒ',
    'යෛ': 'ය්ඓ',
    'යො': 'ය්ඔ',
    'යෝ': 'ය්ඕ',
    'යෞ': 'ය්ඖ',
    'යං': 'ය්අං',
    'යඃ': 'ය්අඃ',
    'ර්‍ය': 'ර්ය',
    'ය්‍ර': 'ය්ර',
    'ය්‍ය': 'ය්ය',
    'රා': 'ර්ආ',
    'රැ': 'ර්ඇ',
    'රෑ': 'ර්ඈ',
    'රි': 'ර්ඉ',
    'රී': 'ර්ඊ',
    'රු': 'ර්උ',
    'රූ': 'ර්ඌ',
    'රෘ': 'ර්ර්උ',
    'රෲ': 'ර්ර්ඌ',
    'රෟ': 'ර්ඖ',
    'රෳ': 'ර්ඖ',
    'රෙ': 'ර්එ',
    'රේ': 'ර්ඒ',
    'රෛ': 'ර්ඓ',
    'රො': 'ර්ඔ',
    'රෝ': 'ර්ඕ',
    'රෞ': 'ර්ඖ',
    'රං': 'ර්අං',
    'රඃ': 'ර්අඃ',
    'ර්‍ර': 'ර්ර',
    'ල්': 'ල්',
    'ල': 'ල්අ',
    'ලා': 'ල්ආ',
    'ලැ': 'ල්ඇ',
    'ලෑ': 'ල්ඈ',
    'ලි': 'ල්ඉ',
    'ලී': 'ල්ඊ',
    'ලු': 'ල්උ',
    'ලූ': 'ල්ඌ',
    'ලෘ': 'ල්ර්උ',
    'ලෲ': 'ල්ර්ඌ',
    'ලෟ': 'ල්ඖ',
    'ලෳ': 'ල්ඖ',
    'ලෙ': 'ල්එ',
    'ලේ': 'ල්ඒ',
    'ලෛ': 'ල්ඓ',
    'ලො': 'ල්ඔ',
    'ලෝ': 'ල්ඕ',
    'ලෞ': 'ල්ඖ',
    'ලං': 'ල්අං',
    'ලඃ': 'ල්අඃ',
    'ර්‍ල': 'ර්ල්',
    'ල්‍ර': 'ල්ර',
    'ල්‍ය': 'ල්ය',
    'ව්': 'ව්',
    'ව': 'ව්අ',
    'වා': 'ව්ආ',
    'වැ': 'ව්ඇ',
    'වෑ': 'ව්ඈ',
    'වි': 'ව්ඉ',
    'වී': 'ව්ඊ',
    'වු': 'ව්උ',
    'වූ': 'ව්ඌ',
    'වෘ': 'ව්ර්උ',
    'වෲ': 'ව්ර්ඌ',
    'වෟ': 'ව්ඖ',
    'වෳ': 'ව්ඖ',
    'වෙ': 'ව්එ',
    'වේ': 'ව්ඒ',
    'වෛ': 'ව්ඓ',
    'වො': 'ව්ඔ',
    'වෝ': 'ව්ඕ',
    'වෞ': 'ව්ඖ',
    'වං': 'ව්අං',
    'වඃ': 'ව්අඃ',
    'ර්‍ව': 'ර්ව්',
    'ව්‍ර': 'ව්ර',
    'ව්‍ය': 'ව්ය',
    'ශ්': 'ශ්',
    'ශ': 'ශ්අ',
    'ශා': 'ශ්ආ',
    'ශැ': 'ශ්ඇ',
    'ශෑ': 'ශ්ඈ',
    'ශි': 'ශ්ඉ',
    'ශී': 'ශ්ඊ',
    'ශු': 'ශ්උ',
    'ශූ': 'ශ්ඌ',
    'ශෘ': 'ශ්ර්උ',
    'ශෲ': 'ශ්ර්ඌ',
    'ශෟ': 'ශ්ඖ',
    'ශෳ': 'ශ්ඖ',
    'ශෙ': 'ශ්එ',
    'ශේ': 'ශ්ඒ',
    'ශෛ': 'ශ්ඓ',
    'ශො': 'ශ්ඔ',
    'ශෝ': 'ශ්ඕ',
    'ශෞ': 'ශ්ඖ',
    'ශං': 'ශ්අං',
    'ශඃ': 'ශ්අඃ',
    'ර්‍ශ': 'ර්ශ්',
    'ශ්‍ර': 'ශ්ර',
    'ශ්‍ය': 'ශ්ය',
    'ෂ්': 'ෂ්',
    'ෂ': 'ෂ්අ',
    'ෂා': 'ෂ්ආ',
    'ෂැ': 'ෂ්ඇ',
    'ෂෑ': 'ෂ්ඈ',
    'ෂි': 'ෂ්ඉ',
    'ෂී': 'ෂ්ඊ',
    'ෂු': 'ෂ්උ',
    'ෂූ': 'ෂ්ඌ',
    'ෂෘ': 'ෂ්ර්උ',
    'ෂෲ': 'ෂ්ර්ඌ',
    'ෂෟ': 'ෂ්ඖ',
    'ෂෳ': 'ෂ්ඖ',
    'ෂෙ': 'ෂ්එ',
    'ෂේ': 'ෂ්ඒ',
    'ෂෛ': 'ෂ්ඓ',
    'ෂො': 'ෂ්ඔ',
    'ෂෝ': 'ෂ්ඕ',
    'ෂෞ': 'ෂ්ඖ',
    'ෂං': 'ෂ්අං',
    'ෂඃ': 'ෂ්අඃ',
    'ර්‍ෂ': 'ර්ෂ්',
    'ෂ්‍ර': 'ෂ්ර',
    'ෂ්‍ය': 'ෂ්ය',
    'ස්': 'ස්',
    'ස': 'ස්අ',
    'සා': 'ස්ආ',
    'සැ': 'ස්ඇ',
    'සෑ': 'ස්ඈ',
    'සි': 'ස්ඉ',
    'සී': 'ස්ඊ',
    'සු': 'ස්උ',
    'සූ': 'ස්ඌ',
    'සෘ': 'ස්ර්උ',
    'සෲ': 'ස්ර්ඌ',
    'සෟ': 'ස්ඖ',
    'සෳ': 'ස්ඖ',
    'සෙ': 'ස්එ',
    'සේ': 'ස්ඒ',
    'සෛ': 'ස්ඓ',
    'සො': 'ස්ඔ',
    'සෝ': 'ස්ඕ',
    'සෞ': 'ස්ඖ',
    'සං': 'ස්අං',
    'සඃ': 'ස්අඃ',
    'ර්‍ස': 'ර්ස්',
    'ස්‍ර': 'ස්ර',
    'ස්‍ය': 'ස්ය',
    'හ්': 'හ්',
    'හ': 'හ්අ',
    'හා': 'හ්ආ',
    'හැ': 'හ්ඇ',
    'හෑ': 'හ්ඈ',
    'හි': 'හ්ඉ',
    'හී': 'හ්ඊ',
    'හු': 'හ්උ',
    'හූ': 'හ්ඌ',
    'හෘ': 'හ්ර්උ',
    'හෲ': 'හ්ර්ඌ',
    'හෟ': 'හ්ඖ',
    'හෳ': 'හ්ඖ',
    'හෙ': 'හ්එ',
    'හේ': 'හ්ඒ',
    'හෛ': 'හ්ඓ',
    'හො': 'හ්ඔ',
    'හෝ': 'හ්ඕ',
    'හෞ': 'හ්ඖ',
    'හං': 'හ්අං',
    'හඃ': 'හ්අඃ',
    'ර්‍හ': 'ර්හ්',
    'හ්‍ර': 'හ්ර',
    'හ්‍ය': 'හ්ය',
    'ළ්': 'ළ්',
    'ළ': 'ළ්අ',
    'ළා': 'ළ්ආ',
    'ළැ': 'ළ්ඇ',
    'ළෑ': 'ළ්ඈ',
    'ළි': 'ළ්ඉ',
    'ළී': 'ළ්ඊ',
    'ළු': 'ළ්උ',
    'ළූ': 'ළ්ඌ',
    'ළෘ': 'ළ්ර්උ',
    'ළෲ': 'ළ්ර්ඌ',
    'ළෟ': 'ළ්ඖ',
    'ළෳ': 'ළ්ඖ',
    'ළෙ': 'ළ්එ',
    'ළේ': 'ළ්ඒ',
    'ළෛ': 'ළ්ඓ',
    'ළො': 'ළ්ඔ',
    'ළෝ': 'ළ්ඕ',
    'ළෞ': 'ළ්ඖ',
    'ළං': 'ළ්අං',
    'ළඃ': 'ළ්අඃ',
    'ර්‍ළ': 'ර්ළ්',
    'ළ්‍ර': 'ළ්ර',
    'ළ්‍ය': 'ළ්ය',
    'ෆ්': 'ෆ්',
    'ෆ': 'ෆ්අ',
    'ෆා': 'ෆ්ආ',
    'ෆැ': 'ෆ්ඇ',
    'ෆෑ': 'ෆ්ඈ',
    'ෆි': 'ෆ්ඉ',
    'ෆී': 'ෆ්ඊ',
    'ෆු': 'ෆ්උ',
    'ෆූ': 'ෆ්ඌ',
    'ෆෘ': 'ෆ්ර්උ',
    'ෆෲ': 'ෆ්ර්ඌ',
    'ෆෟ': 'ෆ්ඖ',
    'ෆෳ': 'ෆ්ඖ',
    'ෆෙ': 'ෆ්එ',
    'ෆේ': 'ෆ්ඒ',
    'ෆෛ': 'ෆ්ඓ',
    'ෆො': 'ෆ්ඔ',
    'ෆෝ': 'ෆ්ඕ',
    'ෆෞ': 'ෆ්ඖ',
    'ෆං': 'ෆ්අං',
    'ෆඃ': 'ෆ්අඃ',
    'ර්‍ෆ': 'ර්ෆ්',
    'ෆ්‍ර': 'ෆ්ර',
    'ෆ්‍ය': 'ෆ්ය',
}

SUFFIXES_RAW = """අණු
අණි 
ආණ
ඉණ 
ඉණි 
උණු 
උණ 
අකු 
අක් 
අක 
අත් 
ආක් 
ආය 
ආහ 
උන් 
එකු 
එක් 
එන් 
එමි 
එමු 
ඒ 
ඒය 
ඔත් 
ඕය 
න
අ
අක්
ආ 
ක්
එක් 
ඕ 
අන්
ය 
ආ 
තත් 
ති 
තොත් 
ද්දි 
නවා 
නු 
න්නේ 
මි 
මින් 
මු 
යි 
අත් 
ඊය 
ඌ 
ඒ 
ඔත් 
ඉලි
ඊම් 
උම් 
එන් 
නවා 
එහි 
ඉ 
ති 
මි 
මු 
වල් 
වල 
ට 
ව 
ගේ 
ගෙන් 
ඉන් 
තොත් 
මින් 
ද්දී 
තත් 
න්ට 
එමි 
එමු 
ඒය 
ඊය 
ආය 
බර 
අනුකූල 
ජනක 
ගරුක 
දායක 
දායී
ආගේ
එකුගේ
අකගේ
අන්ගේ
ආට
අකට
අන්ට
අට
වලින්
එමි
එමු
ඔත්
තොත්
වතුන්
වතෙක්
වතා
බද
මය
සහගත
සම්පන්න
දායක
කළු
කර
ආත්ම්ක
ආත්මක
නීය
මුවා
තම
ඉති
අටු
බ
තා
අටි
මය
තර
ඊම
ඊමක්
ඊමෙන්
ඊමේ
වලට"""

# EN
EN_ALPHABET = "A a B b C c D d E e F f G g H h I i J j K k L l M m N n O o P p Q q R r S s T t U u V v W w X x Y y Z z"
# SIENA KB
COLUMN_NAME_BASE_WORD = "base_word"
COLUMN_NAME_ENTITY = "entity_name"
COLUMN_NAME_COUNT = "count"

# NLTK
NLTK_WORDNET = 'wordnet'
NLTK_PUNKT = 'punkt'
