
import coderedcms.blocks.base_blocks
import coderedcms.blocks.html_blocks
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.contrib.table_block.blocks
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.documents.blocks
import wagtail.embeds.blocks
import wagtail.images.blocks
import wagtail.snippets.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0059_apply_collection_ordering'),
        ('coderedcms', '0019_spelling_corrections'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ArticleIndexPage',
            fields=[
                ('coderedpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='coderedcms.CoderedPage')),
                ('body', wagtail.core.fields.StreamField([('hero', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.core.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.core.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], blank=True, null=True)),
                ('show_images', models.BooleanField(default=True, verbose_name='Show images')),
                ('show_captions', models.BooleanField(default=True)),
                ('show_meta', models.BooleanField(default=True, verbose_name='Show author and date info')),
                ('show_preview_text', models.BooleanField(default=True, verbose_name='Show preview text')),
            ],
            options={
                'verbose_name': 'Article Landing Page',
            },
            bases=('coderedcms.coderedpage',),
        ),
        migrations.CreateModel(
            name='FormPage',
            fields=[
                ('coderedpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='coderedcms.CoderedPage')),
                ('body', wagtail.core.fields.StreamField([('hero', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.core.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.core.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], blank=True, null=True)),
                ('to_address', models.CharField(blank=True, help_text='Optional - email form submissions to this address. Separate multiple addresses by comma.', max_length=255, verbose_name='Email form submissions to')),
                ('reply_address', models.CharField(blank=True, help_text='Optional - to reply to the submitter, specify the email field here. For example, if a form field above is labeled "Your Email", enter: {{ your_email }}', max_length=255, verbose_name='Reply-to address')),
                ('subject', models.CharField(blank=True, max_length=255, verbose_name='Subject')),
                ('save_to_database', models.BooleanField(default=True, help_text='Submissions are saved to database and can be exported at any time.', verbose_name='Save form submissions')),
                ('button_text', models.CharField(default='Submit', max_length=255, verbose_name='Button text')),
                ('button_style', models.CharField(blank=True, choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], default='btn-primary', max_length=255, verbose_name='Button style')),
                ('button_size', models.CharField(blank=True, choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], default='', max_length=255, verbose_name='Button Size')),
                ('button_css_class', models.CharField(blank=True, help_text='Custom CSS class applied to the submit button.', max_length=255, verbose_name='Button CSS class')),
                ('form_css_class', models.CharField(blank=True, help_text='Custom CSS class applied to <form> element.', max_length=255, verbose_name='Form CSS Class')),
                ('form_id', models.CharField(blank=True, help_text='Custom ID applied to <form> element.', max_length=255, verbose_name='Form ID')),
                ('form_golive_at', models.DateTimeField(blank=True, help_text='Date and time when the FORM goes live on the page.', null=True, verbose_name='Form go live date/time')),
                ('form_expire_at', models.DateTimeField(blank=True, help_text='Date and time when the FORM will no longer be available on the page.', null=True, verbose_name='Form expiry date/time')),
                ('spam_protection', models.BooleanField(default=True, help_text='When enabled, the CMS will filter out spam form submissions for this page.', verbose_name='Spam Protection')),
                ('thank_you_page', models.ForeignKey(blank=True, help_text='The page users are redirected to after submitting the form.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page', verbose_name='Thank you page')),
            ],
            options={
                'verbose_name': 'Form',
            },
            bases=('coderedcms.coderedpage', models.Model),
        ),
        migrations.CreateModel(
            name='WebPage',
            fields=[
                ('coderedpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='coderedcms.CoderedPage')),
                ('body', wagtail.core.fields.StreamField([('hero', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.core.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.core.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.core.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('row', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('coderedcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('coderedcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.core.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.core.blocks.StreamBlock([('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Web Page',
            },
            bases=('coderedcms.coderedpage',),
        ),
        migrations.CreateModel(
            name='FormPageField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('clean_name', models.CharField(blank=True, default='', help_text='Safe name of the form field, the label converted to ascii_snake_case', max_length=255, verbose_name='name')),
                ('label', models.CharField(help_text='The label of the form field', max_length=255, verbose_name='label')),
                ('required', models.BooleanField(default=True, verbose_name='required')),
                ('choices', models.TextField(blank=True, help_text='Comma separated list of choices. Only applicable in checkboxes, radio and dropdown.', verbose_name='choices')),
                ('default_value', models.CharField(blank=True, help_text='Default value. Comma separated values supported for checkboxes.', max_length=255, verbose_name='default value')),
                ('help_text', models.CharField(blank=True, max_length=255, verbose_name='help text')),
                ('field_type', models.CharField(choices=[('Text', (('singleline', 'Single line text'), ('multiline', 'Multi-line text'), ('email', 'Email'), ('number', 'Number - only allows integers'), ('url', 'URL'))), ('Choice', (('checkboxes', 'Checkboxes'), ('dropdown', 'Drop down'), ('radio', 'Radio buttons'), ('multiselect', 'Multiple select'), ('checkbox', 'Single checkbox'))), ('Date & Time', (('date', 'Date'), ('time', 'Time'), ('datetime', 'Date and time'))), ('File Upload', (('file', 'Secure File - login required to access uploaded files'),)), ('Other', (('hidden', 'Hidden field'),))], default='Single line text', max_length=16, verbose_name='field type')),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_fields', to='testapp.FormPage')),
            ],
            options={
                'ordering': ['sort_order'],
            },
        ),
        migrations.CreateModel(
            name='FormConfirmEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('to_address', models.CharField(blank=True, help_text='Separate multiple email addresses with commas.', max_length=255, verbose_name='To Addresses')),
                ('from_address', models.CharField(blank=True, help_text='For example: "sender@example.com" or "Sender Name <sender@example.com>" (without quotes).', max_length=255, verbose_name='From Address')),
                ('reply_address', models.CharField(blank=True, help_text='Separate multiple email addresses with commas.', max_length=255, verbose_name='Reply-To Address')),
                ('cc_address', models.CharField(blank=True, help_text='Separate multiple email addresses with commas.', max_length=255, verbose_name='CC')),
                ('bcc_address', models.CharField(blank=True, help_text='Separate multiple email addresses with commas.', max_length=255, verbose_name='BCC')),
                ('subject', models.CharField(blank=True, max_length=255, verbose_name='Subject')),
                ('body', models.TextField(blank=True, verbose_name='Body')),
                ('page', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='confirmation_emails', to='testapp.FormPage')),
            ],
            options={
                'verbose_name': 'CodeRed Email',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArticlePage',
            fields=[
                ('coderedpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='coderedcms.CoderedPage')),
                ('body', wagtail.core.fields.StreamField([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('card', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/card_block.html', 'Card'), ('coderedcms/blocks/card_head.html', 'Card with header'), ('coderedcms/blocks/card_foot.html', 'Card with footer'), ('coderedcms/blocks/card_head_foot.html', 'Card with header and footer'), ('coderedcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('coderedcms/blocks/card_img.html', 'Cover image - use image as background')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.core.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.core.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.core.blocks.StreamBlock([('Links', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.Carousel'))])), ('image_gallery', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', coderedcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('header', wagtail.core.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', coderedcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))])), ('image', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.core.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', wagtail.core.blocks.RawHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('automatic_download', wagtail.core.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.core.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.core.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('google_map', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('search', wagtail.core.blocks.CharBlock(help_text='Address or search term used to find your location on the map.', label='Search query', max_length=255, required=False)), ('map_title', wagtail.core.blocks.CharBlock(help_text='Map title for screen readers, ex: "Map to Goodale Park"', label='Map title', max_length=255, required=False)), ('place_id', wagtail.core.blocks.CharBlock(help_text='Requires API key to use place ID.', label='Google place ID', max_length=255, required=False)), ('map_zoom_level', wagtail.core.blocks.IntegerBlock(default=14, help_text='Requires API key to use zoom. 1: World, 5: Landmass/continent, 10: City, 15: Streets, 20: Buildings', label='Map zoom level', required=False))])), ('page_list', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagelist_block.html', 'General, simple list'), ('coderedcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('coderedcms/blocks/pagelist_article_media.html', 'Article, media format'), ('coderedcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('coderedcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('coderedcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.core.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', coderedcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.core.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.core.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default'), ('coderedcms/blocks/pagepreview_card.html', 'Card'), ('coderedcms/blocks/pagepreview_form.html', 'Form inputs')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.core.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.core.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.core.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.core.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.core.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.core.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.core.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.core.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.core.blocks.StreamBlock([('item', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.core.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.core.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.core.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.core.blocks.StructBlock([('settings', wagtail.core.blocks.StructBlock([('custom_template', wagtail.core.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.core.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.core.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('coderedcms.ReusableContent'))]))], blank=True, null=True)),
                ('caption', models.CharField(blank=True, max_length=255, verbose_name='Caption')),
                ('author_display', models.CharField(blank=True, help_text='Override how the author’s name displays on this article.', max_length=255, verbose_name='Display author as')),
                ('date_display', models.DateField(blank=True, null=True, verbose_name='Display publish date')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name': 'Article',
                'ordering': ['-first_published_at'],
            },
            bases=('coderedcms.coderedpage',),
        ),
    ]
