# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_prov_cfg import tCorrProvCfg

class dCorrProvCfgInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrProvCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  corrtype_id: str,
                  corrprov_id: str,
                  status: str,
                  notes: str,
                  activate: datetime.datetime,
                  deactivate: datetime.datetime,
                  cfg: dict,
                  modified_by: str,
                  tm_stamp: datetime.datetime) -> "dCorrProvCfgInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param corrtype_id: str
        :param corrprov_id: str
        :param status: str
        :param notes: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param cfg: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id
        self.irec.status = status
        self.irec.notes = notes
        self.irec.activate = activate
        self.irec.deactivate = deactivate
        self.irec.cfg = cfg
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tCorrProvCfg = None) -> "dCorrProvCfgInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("CorrProvCfgInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.CorrProvCfg (
  corrtype_id,
  corrprov_id,
  status,
  notes,
  activate,
  deactivate,
  cfg,
  modified_by,
  tm_stamp
) values (
  :corrtype_id,
  :corrprov_id,
  :status,
  :notes,
  :activate,
  :deactivate,
  :cfg,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("notes", self.irec.notes, str, 4096)
        self._dbstmnt.bind_in("activate", self.irec.activate, datetime.datetime)
        self._dbstmnt.bind_in("deactivate", self.irec.deactivate, datetime.datetime)
        self._dbstmnt.bind_in("cfg", self.irec.cfg, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        self.irec.id = self._dbcon.post_get_sequence(self._dbstmnt, "loco.CorrProvCfg", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

