# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_prov_cfg_key import tCorrProvCfgKey
from bs_loco.db.tables.corr_prov_cfg import tCorrProvCfg

class dCorrProvCfgLockOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrProvCfgKey()
        self.orec     = tCorrProvCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int) -> "dCorrProvCfgLockOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tCorrProvCfgKey = None) -> "dCorrProvCfgLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("CorrProvCfgLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  corrtype_id,
  corrprov_id,
  status,
  notes,
  activate,
  deactivate,
  cfg,
  modified_by,
  tm_stamp
from
  loco.CorrProvCfg
where
  id = :id for update nowait""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("corrprov_id", str, 16)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("notes", str, 4096)
        self._dbstmnt.bind_out("activate", datetime.datetime)
        self._dbstmnt.bind_out("deactivate", datetime.datetime)
        self._dbstmnt.bind_out("cfg", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.lock(self._dbstmnt)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.corrtype_id = self._dbstmnt.result[1]
        self.orec.corrprov_id = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.notes = self._dbstmnt.result[4]
        self.orec.activate = self._dbstmnt.result[5]
        self.orec.deactivate = self._dbstmnt.result[6]
        self.orec.cfg = self._dbstmnt.result[7]
        self.orec.modified_by = self._dbstmnt.result[8]
        self.orec.tm_stamp = self._dbstmnt.result[9]

        return True

    def fetch_all(self, outList: tCorrProvCfg.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

