# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_res import tNoRes

class dNoResInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoRes()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: str,
                  filename: str,
                  mimetype: str,
                  content: bytearray,
                  modified_by: str,
                  tm_stamp: datetime.datetime) -> "dNoResInsert":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param filename: str
        :param mimetype: str
        :param content: bytearray
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.filename = filename
        self.irec.mimetype = mimetype
        self.irec.content = content
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tNoRes = None) -> "dNoResInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("NoResInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.NoRes (
  id,
  filename,
  mimetype,
  content,
  modified_by,
  tm_stamp
) values (
  :id,
  :filename,
  :mimetype,
  :content,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)
        self._dbstmnt.bind_in("filename", self.irec.filename, str, 256)
        self._dbstmnt.bind_in("mimetype", self.irec.mimetype, str, 128)
        self._dbstmnt.bind_in("content", self.irec.content, bytearray)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

