# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_msg_req import tSnapMsgReq
from bs_loco.db.tables.snap_msg_req_key import tSnapMsgReqKey

from .snap_msg_req_lock_one import dSnapMsgReqLockOne
from .snap_msg_req_select_one import dSnapMsgReqSelectOne
from .snap_msg_req_update import dSnapMsgReqUpdate
from .snap_msg_req_insert import dSnapMsgReqInsert
from .snap_msg_req_delete_one import dSnapMsgReqDeleteOne

class dSnapMsgReq:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tSnapMsgReq()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tSnapMsgReqKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tSnapMsgReq, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tSnapMsgReqKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      valuedate: datetime.date,
                      notype_id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param valuedate: datetime.date
        :param notype_id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tSnapMsgReqKey()

        _key.valuedate = valuedate
        _key.notype_id = notype_id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tSnapMsgReqKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dSnapMsgReqLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dSnapMsgReq)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock SnapMsgReq record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), err_code = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tSnapMsgReqKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tSnapMsgReq) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tSnapMsgReqKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            valuedate: datetime.date,
                            notype_id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param valuedate: datetime.date
        :param notype_id: str
        :return: True if the row as selectd.
        """
        _key = tSnapMsgReqKey()

        _key.valuedate = valuedate
        _key.notype_id = notype_id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tSnapMsgReqKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dSnapMsgReqSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dSnapMsgReq":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dSnapMsgReq)")

        return self

    def select_one_with(self, _rec: tSnapMsgReq) -> "dSnapMsgReq":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dSnapMsgReq)")

        return self

    def select_one_deft(self,
                        valuedate: datetime.date,
                        notype_id: str) -> "dSnapMsgReq":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param valuedate: datetime.date
        :param notype_id: str
        """
        _key = tSnapMsgReqKey()

        _key.valuedate = valuedate
        _key.notype_id = notype_id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dSnapMsgReq)")

        return self

    def select_one_by_key(self, _key: tSnapMsgReqKey) -> "dSnapMsgReq":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dSnapMsgReq)")

        return self

    def update_deft(self,
                    valuedate: datetime.date,
                    notype_id: str,
                    tot_req: int,
                    tot_proc: int,
                    tot_cancelled: int,
                    tot_part_canc: int,
                    tot_msgs: int,
                    tot_msgs_sent: int,
                    tot_msgs_failed: int,
                    tot_msgs_retrys: int):
        """
        Update the record by setting all column values.

        :param valuedate: datetime.date
        :param notype_id: str
        :param tot_req: int
        :param tot_proc: int
        :param tot_cancelled: int
        :param tot_part_canc: int
        :param tot_msgs: int
        :param tot_msgs_sent: int
        :param tot_msgs_failed: int
        :param tot_msgs_retrys: int
        """
        self.rec.valuedate = valuedate
        self.rec.notype_id = notype_id
        self.rec.tot_req = tot_req
        self.rec.tot_proc = tot_proc
        self.rec.tot_cancelled = tot_cancelled
        self.rec.tot_part_canc = tot_part_canc
        self.rec.tot_msgs = tot_msgs
        self.rec.tot_msgs_sent = tot_msgs_sent
        self.rec.tot_msgs_failed = tot_msgs_failed
        self.rec.tot_msgs_retrys = tot_msgs_retrys

        self.update()

    def update(self, irec: tSnapMsgReq = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dSnapMsgReqUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    valuedate: datetime.date,
                    notype_id: str,
                    tot_req: int,
                    tot_proc: int,
                    tot_cancelled: int,
                    tot_part_canc: int,
                    tot_msgs: int,
                    tot_msgs_sent: int,
                    tot_msgs_failed: int,
                    tot_msgs_retrys: int):
        """
        Insert the record setting all column values.

        :param valuedate: datetime.date
        :param notype_id: str
        :param tot_req: int
        :param tot_proc: int
        :param tot_cancelled: int
        :param tot_part_canc: int
        :param tot_msgs: int
        :param tot_msgs_sent: int
        :param tot_msgs_failed: int
        :param tot_msgs_retrys: int
        """
        self.rec.valuedate = valuedate
        self.rec.notype_id = notype_id
        self.rec.tot_req = tot_req
        self.rec.tot_proc = tot_proc
        self.rec.tot_cancelled = tot_cancelled
        self.rec.tot_part_canc = tot_part_canc
        self.rec.tot_msgs = tot_msgs
        self.rec.tot_msgs_sent = tot_msgs_sent
        self.rec.tot_msgs_failed = tot_msgs_failed
        self.rec.tot_msgs_retrys = tot_msgs_retrys

        self.insert()

    def insert(self, irec: tSnapMsgReq = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dSnapMsgReqInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def delete_one_deft(self,
                        valuedate: datetime.date,
                        notype_id: str):
        """
        Delete one record by it's primary key columns.

        :param valuedate: datetime.date
        :param notype_id: str
        """
        _key = tSnapMsgReqKey()

        _key.valuedate = valuedate
        _key.notype_id = notype_id

        self.delete_one(_key)

    def delete_one(self, irec: tSnapMsgReqKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tSnapMsgReqKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dSnapMsgReqDeleteOne(self._dbcon) as _qry:
            _qry.exec(_key)

