# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ_cfg_key import tNoTemplCfgKey
from bs_loco.db.tables.no_templ_cfg import tNoTemplCfg

class dNoTemplCfgLockOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTemplCfgKey()
        self.orec     = tNoTemplCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int) -> "dNoTemplCfgLockOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tNoTemplCfgKey = None) -> "dNoTemplCfgLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoTemplCfgLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  notype_id,
  corrtype_id,
  status,
  activate,
  deactivate,
  templ,
  res_list,
  modified_by,
  tm_stamp
from
  loco.NoTemplCfg
where
  id = :id for update nowait""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("activate", datetime.datetime)
        self._dbstmnt.bind_out("deactivate", datetime.datetime)
        self._dbstmnt.bind_out("templ", dict)
        self._dbstmnt.bind_out("res_list", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.lock(self._dbstmnt)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.notype_id = self._dbstmnt.result[1]
        self.orec.corrtype_id = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.activate = self._dbstmnt.result[4]
        self.orec.deactivate = self._dbstmnt.result[5]
        self.orec.templ = self._dbstmnt.result[6]
        self.orec.res_list = self._dbstmnt.result[7]
        self.orec.modified_by = self._dbstmnt.result[8]
        self.orec.tm_stamp = self._dbstmnt.result[9]

        return True

    async def fetch_all(self, outList: tNoTemplCfg.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

