# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ_cfg import tNoTemplCfg

class dNoTemplCfgUpdate:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTemplCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        notype_id: str,
                        corrtype_id: str,
                        status: str,
                        activate: datetime.datetime,
                        deactivate: datetime.datetime,
                        templ: dict,
                        res_list: dict,
                        modified_by: str) -> "dNoTemplCfgUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.notype_id = notype_id
        self.irec.corrtype_id = corrtype_id
        self.irec.status = status
        self.irec.activate = activate
        self.irec.deactivate = deactivate
        self.irec.templ = templ
        self.irec.res_list = res_list
        self.irec.modified_by = modified_by

        return await self.exec()

    async def exec(self, irec: tNoTemplCfg = None) -> "dNoTemplCfgUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoTemplCfgUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.NoTemplCfg
set
  notype_id = :notype_id,
  corrtype_id = :corrtype_id,
  status = :status,
  activate = :activate,
  deactivate = :deactivate,
  templ = :templ,
  res_list = :res_list,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("activate", self.irec.activate, datetime.datetime)
        self._dbstmnt.bind_in("deactivate", self.irec.deactivate, datetime.datetime)
        self._dbstmnt.bind_in("templ", self.irec.templ, dict)
        self._dbstmnt.bind_in("res_list", self.irec.res_list, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

