# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ_key import tNoTemplKey
from bs_loco.db.tables.no_templ import tNoTempl

class dNoTemplLockOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoTemplKey()
        self.orec     = tNoTempl()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        notype_id: str,
                        corrtype_id: str) -> "dNoTemplLockOne":
        """
        Execute the query by setting all the inputs.

        :param notype_id: str
        :param corrtype_id: str
        :return: Self for convenience.
        """
        self.irec.notype_id = notype_id
        self.irec.corrtype_id = corrtype_id

        return await self.exec()

    async def exec(self, irec: tNoTemplKey = None) -> "dNoTemplLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoTemplLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  notype_id,
  corrtype_id,
  status,
  lastcfg_id,
  templ,
  res_list,
  modified_by,
  tm_stamp
from
  loco.NoTempl
where
  notype_id = :notype_id and
  corrtype_id = :corrtype_id for update nowait""")

        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)

        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("lastcfg_id", int, 8)
        self._dbstmnt.bind_out("templ", dict)
        self._dbstmnt.bind_out("res_list", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.lock(self._dbstmnt)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.notype_id = self._dbstmnt.result[0]
        self.orec.corrtype_id = self._dbstmnt.result[1]
        self.orec.status = self._dbstmnt.result[2]
        self.orec.lastcfg_id = self._dbstmnt.result[3]
        self.orec.templ = self._dbstmnt.result[4]
        self.orec.res_list = self._dbstmnt.result[5]
        self.orec.modified_by = self._dbstmnt.result[6]
        self.orec.tm_stamp = self._dbstmnt.result[7]

        return True

    async def fetch_all(self, outList: tNoTempl.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

