# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#

import copy
import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .corr_type_allow_key import tCorrTypeAllowKey

@dataclasses.dataclass
class tCorrTypeAllow(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    corrtype_id: str = dataclasses.field(default='', compare=True, hash=True)
    allow_id: str = dataclasses.field(default='', compare=True, hash=True)
    status: str = dataclasses.field(default='', compare=False)
    regex: str = dataclasses.field(default='', compare=False)
    modified_by: str = dataclasses.field(default='', compare=False)
    tm_stamp: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.corrtype_id = ''
        self.allow_id = ''
        self.status = ''
        self.regex = ''
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCorrTypeAllow'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("corrtype_id", self.corrtype_id)
        _w.write_string("allow_id", self.allow_id)
        _w.write_char("status", self.status)
        _w.write_string("regex", self.regex)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.corrtype_id = _r.read_string("corrtype_id")
        self.allow_id = _r.read_string("allow_id")
        self.status = _r.read_char("status")
        self.regex = _r.read_string("regex")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCorrTypeAllow"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.corrtype_id = rec.corrtype_id
        self.allow_id = rec.allow_id
        self.status = rec.status
        self.regex = rec.regex
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tCorrTypeAllow"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCorrTypeAllow"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tCorrTypeAllowKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tCorrTypeAllowKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("allow_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("allow_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        if key_only:
            return dvc

        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D']))
        dvc.add_targ("regex", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("regex", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D']))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCorrTypeAllow._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tCorrTypeAllowKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.corrtype_id = self.corrtype_id
        _key.allow_id = self.allow_id

    def _read_key(self, _key: tCorrTypeAllowKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.corrtype_id = _key.corrtype_id
        self.allow_id = _key.allow_id

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"

        value_active = "Active"
        value_disabled = "Disabled"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled

        @staticmethod
        def get_value(key):
            if key == tCorrTypeAllow.Status_Couplet.key_active:
                return tCorrTypeAllow.Status_Couplet.value_active

            if key == tCorrTypeAllow.Status_Couplet.key_disabled:
                return tCorrTypeAllow.Status_Couplet.value_disabled

            return ""

    class Regex_Couplet(dict):
        key_active = "A"
        key_disabled = "D"

        value_active = "Active"
        value_disabled = "Disabled"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled

        @staticmethod
        def get_value(key):
            if key == tCorrTypeAllow.Regex_Couplet.key_active:
                return tCorrTypeAllow.Regex_Couplet.value_active

            if key == tCorrTypeAllow.Regex_Couplet.key_disabled:
                return tCorrTypeAllow.Regex_Couplet.value_disabled

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = (x.corrtype_id > y.corrtype_id) - (x.corrtype_id < y.corrtype_id)

        if rc != 0:
            return rc

        rc = (x.allow_id > y.allow_id) - (x.allow_id < y.allow_id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCorrTypeAllow.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCorrTypeAllow()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCorrTypeAllow._cache_davs(dvc, for_ins, key_only)

