# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#

import copy
import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .msg_req_key import tMsgReqKey

@dataclasses.dataclass
class tMsgReq(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    id: int = dataclasses.field(default=0, compare=True, hash=True)
    notype_id: str = dataclasses.field(default='', compare=False)
    priority: int = dataclasses.field(default=0, compare=False)
    status: str = dataclasses.field(default='', compare=False)
    time_req: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)
    time_to_send: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)
    time_proc: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)
    msg_addr: typing.Optional[dict] = dataclasses.field(default=None, compare=False)
    msg_dict: typing.Optional[dict] = dataclasses.field(default=None, compare=False)
    cust_res: bool = dataclasses.field(default=False, compare=False)
    meta_data: typing.Optional[dict] = dataclasses.field(default=None, compare=False)
    modified_by: str = dataclasses.field(default='', compare=False)
    tm_stamp: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.notype_id = ''
        self.priority = 0
        self.status = ''
        self.time_req = None
        self.time_to_send = None
        self.time_proc = None
        self.msg_addr = None
        self.msg_dict = None
        self.cust_res = False
        self.meta_data = None
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tMsgReq'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_string("notype_id", self.notype_id)
        _w.write_int32("priority", self.priority)
        _w.write_char("status", self.status)
        _w.write_datetime("time_req", self.time_req)
        _w.write_datetime("time_to_send", self.time_to_send)
        _w.write_datetime("time_proc", self.time_proc)
        _w.write_json("msg_addr", self.msg_addr)
        _w.write_json("msg_dict", self.msg_dict)
        _w.write_bool("cust_res", self.cust_res)
        _w.write_json("meta_data", self.meta_data)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.notype_id = _r.read_string("notype_id")
        self.priority = _r.read_int32("priority")
        self.status = _r.read_char("status")
        self.time_req = _r.read_datetime("time_req")
        self.time_to_send = _r.read_datetime("time_to_send")
        self.time_proc = _r.read_datetime("time_proc")
        self.msg_addr = _r.read_json("msg_addr")
        self.msg_dict = _r.read_json("msg_dict")
        self.cust_res = _r.read_bool("cust_res")
        self.meta_data = _r.read_json("meta_data")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tMsgReq"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.notype_id = rec.notype_id
        self.priority = rec.priority
        self.status = rec.status
        self.time_req = rec.time_req
        self.time_to_send = rec.time_to_send
        self.time_proc = rec.time_proc
        self.msg_addr = rec.msg_addr
        self.msg_dict = rec.msg_dict
        self.cust_res = rec.cust_res
        self.meta_data = rec.meta_data
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tMsgReq"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tMsgReq"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tMsgReqKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tMsgReqKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("notype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("priority", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','B','R','C']))
        dvc.add_targ("time_req", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("time_to_send", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("msg_addr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("cust_res", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tMsgReq._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tMsgReqKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tMsgReqKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Status_Couplet(dict):
        key_pending = "P"
        key_busy = "B"
        key_processed = "R"
        key_cancelled = "C"

        value_pending = "Pending"
        value_busy = "Busy"
        value_processed = "Processed"
        value_cancelled = "Cancelled"

        def __init__(self):
            self[self.key_pending] = self.value_pending
            self[self.key_busy] = self.value_busy
            self[self.key_processed] = self.value_processed
            self[self.key_cancelled] = self.value_cancelled

        @staticmethod
        def get_value(key):
            if key == tMsgReq.Status_Couplet.key_pending:
                return tMsgReq.Status_Couplet.value_pending

            if key == tMsgReq.Status_Couplet.key_busy:
                return tMsgReq.Status_Couplet.value_busy

            if key == tMsgReq.Status_Couplet.key_processed:
                return tMsgReq.Status_Couplet.value_processed

            if key == tMsgReq.Status_Couplet.key_cancelled:
                return tMsgReq.Status_Couplet.value_cancelled

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tMsgReq.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tMsgReq()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tMsgReq._cache_davs(dvc, for_ins, key_only)

