# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#

import copy
import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .snap_prov_key import tSnapProvKey

@dataclasses.dataclass
class tSnapProv(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    valuedate: typing.Optional[datetime.date] = dataclasses.field(default=None, compare=True, hash=True)
    corrtype_id: str = dataclasses.field(default='', compare=True, hash=True)
    corrprov_id: str = dataclasses.field(default='', compare=True, hash=True)
    msg_sent: int = dataclasses.field(default=0, compare=False)
    msg_failed: int = dataclasses.field(default=0, compare=False)
    msg_retry: int = dataclasses.field(default=0, compare=False)
    avg_msg_time: float = dataclasses.field(default=0.0, compare=False)
    tot_msg_time: float = dataclasses.field(default=0.0, compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.valuedate = None
        self.corrtype_id = ''
        self.corrprov_id = ''
        self.msg_sent = 0
        self.msg_failed = 0
        self.msg_retry = 0
        self.avg_msg_time = 0.0
        self.tot_msg_time = 0.0

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tSnapProv'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_date("valuedate", self.valuedate)
        _w.write_string("corrtype_id", self.corrtype_id)
        _w.write_string("corrprov_id", self.corrprov_id)
        _w.write_int32("msg_sent", self.msg_sent)
        _w.write_int32("msg_failed", self.msg_failed)
        _w.write_int32("msg_retry", self.msg_retry)
        _w.write_double("avg_msg_time", self.avg_msg_time)
        _w.write_double("tot_msg_time", self.tot_msg_time)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.valuedate = _r.read_date("valuedate")
        self.corrtype_id = _r.read_string("corrtype_id")
        self.corrprov_id = _r.read_string("corrprov_id")
        self.msg_sent = _r.read_int32("msg_sent")
        self.msg_failed = _r.read_int32("msg_failed")
        self.msg_retry = _r.read_int32("msg_retry")
        self.avg_msg_time = _r.read_double("avg_msg_time")
        self.tot_msg_time = _r.read_double("tot_msg_time")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tSnapProv"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.valuedate = rec.valuedate
        self.corrtype_id = rec.corrtype_id
        self.corrprov_id = rec.corrprov_id
        self.msg_sent = rec.msg_sent
        self.msg_failed = rec.msg_failed
        self.msg_retry = rec.msg_retry
        self.avg_msg_time = rec.avg_msg_time
        self.tot_msg_time = rec.tot_msg_time

    def _write_pk(self, _key: "tSnapProv"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tSnapProv"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tSnapProvKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tSnapProvKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("valuedate", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("corrprov_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrprov_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        if key_only:
            return dvc

        dvc.add_targ("msg_sent", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("msg_failed", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("msg_retry", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("avg_msgTime", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("tot_msgTime", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tSnapProv._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tSnapProvKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.valuedate = self.valuedate
        _key.corrtype_id = self.corrtype_id
        _key.corrprov_id = self.corrprov_id

    def _read_key(self, _key: tSnapProvKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.valuedate = _key.valuedate
        self.corrtype_id = _key.corrtype_id
        self.corrprov_id = _key.corrprov_id

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = (x.valuedate > y.valuedate) - (x.valuedate < y.valuedate)

        if rc != 0:
            return rc

        rc = (x.corrtype_id > y.corrtype_id) - (x.corrtype_id < y.corrtype_id)

        if rc != 0:
            return rc

        rc = (x.corrprov_id > y.corrprov_id) - (x.corrprov_id < y.corrprov_id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tSnapProv.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tSnapProv()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tSnapProv._cache_davs(dvc, for_ins, key_only)

