# -*- coding: utf-8 -*-

"""
    pagarmecoreapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""


class UpdatePlanRequest(object):

    """Implementation of the 'UpdatePlanRequest' model.

    Request for updating a plan

    Attributes:
        name (string): Plan's name
        description (string): Description
        installments (list of int): Number os installments
        statement_descriptor (string): Text that will be shown on the credit
            card's statement
        currency (string): Currency
        interval (string): Interval
        interval_count (int): Interval count
        payment_methods (list of string): Payment methods accepted by the
            plan
        billing_type (string): Billing type
        status (string): Plan status
        shippable (bool): Indicates if the plan is shippable
        billing_days (list of int): Billing days accepted by the plan
        metadata (dict<object, string>): Metadata
        minimum_price (int): Minimum price
        trial_period_days (int): Number of trial period in days, where the
            customer will not be charged

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name":'name',
        "description":'description',
        "installments":'installments',
        "statement_descriptor":'statement_descriptor',
        "currency":'currency',
        "interval":'interval',
        "interval_count":'interval_count',
        "payment_methods":'payment_methods',
        "billing_type":'billing_type',
        "status":'status',
        "shippable":'shippable',
        "billing_days":'billing_days',
        "metadata":'metadata',
        "minimum_price":'minimum_price',
        "trial_period_days":'trial_period_days'
    }

    def __init__(self,
                 name=None,
                 description=None,
                 installments=None,
                 statement_descriptor=None,
                 currency=None,
                 interval=None,
                 interval_count=None,
                 payment_methods=None,
                 billing_type=None,
                 status=None,
                 shippable=None,
                 billing_days=None,
                 metadata=None,
                 minimum_price=None,
                 trial_period_days=None):
        """Constructor for the UpdatePlanRequest class"""

        # Initialize members of the class
        self.name = name
        self.description = description
        self.installments = installments
        self.statement_descriptor = statement_descriptor
        self.currency = currency
        self.interval = interval
        self.interval_count = interval_count
        self.payment_methods = payment_methods
        self.billing_type = billing_type
        self.status = status
        self.shippable = shippable
        self.billing_days = billing_days
        self.metadata = metadata
        self.minimum_price = minimum_price
        self.trial_period_days = trial_period_days


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get('name')
        description = dictionary.get('description')
        installments = dictionary.get('installments')
        statement_descriptor = dictionary.get('statement_descriptor')
        currency = dictionary.get('currency')
        interval = dictionary.get('interval')
        interval_count = dictionary.get('interval_count')
        payment_methods = dictionary.get('payment_methods')
        billing_type = dictionary.get('billing_type')
        status = dictionary.get('status')
        shippable = dictionary.get('shippable')
        billing_days = dictionary.get('billing_days')
        metadata = dictionary.get('metadata')
        minimum_price = dictionary.get('minimum_price')
        trial_period_days = dictionary.get('trial_period_days')

        # Return an object of this model
        return cls(name,
                   description,
                   installments,
                   statement_descriptor,
                   currency,
                   interval,
                   interval_count,
                   payment_methods,
                   billing_type,
                   status,
                   shippable,
                   billing_days,
                   metadata,
                   minimum_price,
                   trial_period_days)


