/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote.statements;

import java.net.http.HttpClient;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.remote.connections.RemoteEndpointConnection;
import org.apache.jena.jdbc.statements.JenaPreparedStatement;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTP;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTPBuilder;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class RemoteEndpointPreparedStatement
extends JenaPreparedStatement {
    private RemoteEndpointConnection remoteConn;
    private HttpClient client;

    public RemoteEndpointPreparedStatement(String sparql, RemoteEndpointConnection connection) throws SQLException {
        this(sparql, connection, null, 1003, 1000, 0, 2);
    }

    public RemoteEndpointPreparedStatement(String sparql, RemoteEndpointConnection connection, HttpClient client, int type, int fetchDir, int fetchSize, int holdability) throws SQLException {
        super(sparql, (JenaConnection)connection, type, fetchDir, fetchSize, holdability, false, 0);
        this.remoteConn = connection;
        this.client = client;
    }

    protected QueryExecution createQueryExecution(Query q) throws SQLException {
        if (this.remoteConn.getQueryEndpoint() == null) {
            throw new SQLException("This statement is backed by a write-only connection, read operations are not supported");
        }
        QueryExecutionHTTPBuilder exec = (QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)this.remoteConn.getQueryEndpoint()).query(q);
        if (this.client != null) {
            exec.httpClient(this.client);
        }
        if (this.remoteConn.getDefaultGraphURIs() != null) {
            this.remoteConn.getDefaultGraphURIs().forEach(arg_0 -> ((QueryExecutionHTTPBuilder)exec).addDefaultGraphURI(arg_0));
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            this.remoteConn.getNamedGraphURIs().forEach(arg_0 -> ((QueryExecutionHTTPBuilder)exec).addNamedGraphURI(arg_0));
        }
        if (this.remoteConn.getSelectResultsType() != null) {
            exec.acceptHeader(this.remoteConn.getSelectResultsType());
        }
        if (this.remoteConn.getModelResultsType() != null) {
            exec.acceptHeader(this.remoteConn.getModelResultsType());
        }
        return (QueryExecution)exec.build();
    }

    protected UpdateProcessor createUpdateProcessor(UpdateRequest u) {
        UpdateExecutionHTTPBuilder proc = (UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.service((String)this.remoteConn.getUpdateEndpoint()).update(u);
        if (this.client != null) {
            proc.httpClient(this.client);
        }
        if (this.remoteConn.getUsingGraphURIs() != null) {
            this.remoteConn.getUsingGraphURIs().forEach(arg_0 -> ((UpdateExecutionHTTPBuilder)proc).addUsingGraphURI(arg_0));
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            this.remoteConn.getNamedGraphURIs().forEach(arg_0 -> ((UpdateExecutionHTTPBuilder)proc).addUsingNamedGraphURI(arg_0));
        }
        return (UpdateProcessor)proc.build();
    }

    protected void beginTransaction(ReadWrite type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected void commitTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected void rollbackTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    protected boolean hasActiveTransaction() {
        return false;
    }
}

