/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.function.ByteComparator;
import cern.colt.function.CharComparator;
import cern.colt.function.DoubleComparator;
import cern.colt.function.FloatComparator;
import cern.colt.function.IntComparator;
import cern.colt.function.LongComparator;
import cern.colt.function.ShortComparator;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.FloatArrayList;
import java.util.Comparator;

public class Sorting {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected Sorting() {
    }

    public static int binarySearchFromTo(byte[] list, byte key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            byte midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(char[] list, char key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            char midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(double[] list, double key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            double midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(float[] list, float key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            float midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            int midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(long[] list, long key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            long midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(Object[] list, Object key, int from, int to, Comparator comparator) {
        while (from <= to) {
            int mid = (from + to) / 2;
            Object midVal = list[mid];
            int cmp = comparator.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(short[] list, short key, int from, int to) {
        while (from <= to) {
            int mid = (from + to) / 2;
            short midVal = list[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearchFromTo(int from, int to, IntComparator comp) {
        boolean dummy = false;
        while (from <= to) {
            int mid = (from + to) / 2;
            int comparison = comp.compare(0, mid);
            if (comparison < 0) {
                from = mid + 1;
                continue;
            }
            if (comparison > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    private static int lower_bound(int[] array, int first, int last, int x) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (array[middle] < x) {
                first = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return first;
    }

    private static int upper_bound(int[] array, int first, int last, int x) {
        int len = last - first;
        while (len > 0) {
            int half = len / 2;
            int middle = first + half;
            if (x < array[middle]) {
                len = half;
                continue;
            }
            first = middle + 1;
            len -= half + 1;
        }
        return first;
    }

    private static void inplace_merge(int[] array, int first, int middle, int last) {
        int secondCut;
        int firstCut;
        if (first >= middle || middle >= last) {
            return;
        }
        if (last - first == 2) {
            if (array[middle] < array[first]) {
                int tmp = array[first];
                array[first] = array[middle];
                array[middle] = tmp;
            }
            return;
        }
        if (middle - first > last - middle) {
            firstCut = first + (middle - first) / 2;
            secondCut = Sorting.lower_bound(array, middle, last, array[firstCut]);
        } else {
            secondCut = middle + (last - middle) / 2;
            firstCut = Sorting.upper_bound(array, first, middle, array[secondCut]);
        }
        int first2 = firstCut;
        int middle2 = middle;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int tmp;
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                tmp = array[first1];
                array[last1] = array[first1];
                array[first1++] = tmp;
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                tmp = array[first1];
                array[last1] = array[first1];
                array[first1++] = tmp;
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                tmp = array[first1];
                array[last1] = array[first1];
                array[first1++] = tmp;
            }
        }
        middle = firstCut + (secondCut - middle);
        Sorting.inplace_merge(array, first, firstCut, middle);
        Sorting.inplace_merge(array, middle, secondCut, last);
    }

    private static int med3(byte[] x, int a, int b, int c, ByteComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(char[] x, int a, int b, int c, CharComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(double[] x, int a, int b, int c, DoubleComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(float[] x, int a, int b, int c, FloatComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(long[] x, int a, int b, int c, LongComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(Object[] x, int a, int b, int c) {
        int ab = ((Comparable)x[a]).compareTo((Comparable)x[b]);
        int ac = ((Comparable)x[a]).compareTo((Comparable)x[c]);
        int bc = ((Comparable)x[b]).compareTo((Comparable)x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(Object[] x, int a, int b, int c, Comparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(short[] x, int a, int b, int c, ShortComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(byte[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        byte[] aux = (byte[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex);
    }

    public static void mergeSort(byte[] a, int fromIndex, int toIndex, ByteComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        byte[] aux = (byte[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(char[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        char[] aux = (char[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex);
    }

    public static void mergeSort(char[] a, int fromIndex, int toIndex, CharComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        char[] aux = (char[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(double[] a, int fromIndex, int toIndex) {
        Sorting.mergeSort2(a, fromIndex, toIndex);
    }

    public static void mergeSort(double[] a, int fromIndex, int toIndex, DoubleComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        double[] aux = (double[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(float[] a, int fromIndex, int toIndex) {
        Sorting.mergeSort2(a, fromIndex, toIndex);
    }

    public static void mergeSort(float[] a, int fromIndex, int toIndex, FloatComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        float[] aux = (float[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(int[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        int[] aux = (int[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex);
    }

    public static void mergeSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        int[] aux = (int[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(long[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        long[] aux = (long[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex);
    }

    public static void mergeSort(long[] a, int fromIndex, int toIndex, LongComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        long[] aux = (long[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    public static void mergeSort(short[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        short[] aux = (short[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex);
    }

    public static void mergeSort(short[] a, int fromIndex, int toIndex, ShortComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        short[] aux = (short[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, toIndex, c);
    }

    private static void mergeSort1(byte[] src, byte[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(byte[] src, byte[] dest, int low, int high, ByteComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(char[] src, char[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(char[] src, char[] dest, int low, int high, CharComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(double[] src, double[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(double[] src, double[] dest, int low, int high, DoubleComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(float[] src, float[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(float[] src, float[] dest, int low, int high, FloatComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(int[] src, int[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(int[] src, int[] dest, int low, int high, IntComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(long[] src, long[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(long[] src, long[] dest, int low, int high, LongComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(short[] src, short[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1] > dest[j]; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid);
        Sorting.mergeSort1(dest, src, mid, high);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
        }
    }

    private static void mergeSort1(short[] src, short[] dest, int low, int high, ShortComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Sorting.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        Sorting.mergeSort1(dest, src, low, mid, c);
        Sorting.mergeSort1(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort2(double[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                a[i] = a[--n];
                a[n] = Double.NaN;
                continue;
            }
            if (a[i] == 0.0 && Double.doubleToLongBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        double[] aux = (double[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, n);
        if (numNegZeros != 0) {
            int j = new DoubleArrayList(a).binarySearchFromTo(0.0, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0;
            }
        }
    }

    private static void mergeSort2(float[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                a[i] = a[--n];
                a[n] = Float.NaN;
                continue;
            }
            if (a[i] == 0.0f && Float.floatToIntBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        float[] aux = (float[])a.clone();
        Sorting.mergeSort1(aux, a, fromIndex, n);
        if (numNegZeros != 0) {
            int j = new FloatArrayList(a).binarySearchFromTo(0.0f, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0f) {
            }
            for (int k = 0; k < numNegZeros; ++k) {
                a[++j] = -0.0f;
            }
        }
    }

    public static void mergeSortInPlace(int[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        int length = toIndex - fromIndex;
        if (length < 7) {
            for (int i = fromIndex; i < toIndex; ++i) {
                for (int j = i; j > fromIndex && a[j - 1] > a[j]; --j) {
                    int tmp = a[j];
                    a[j] = a[j - 1];
                    a[j - 1] = tmp;
                }
            }
            return;
        }
        int mid = (fromIndex + toIndex) / 2;
        Sorting.mergeSortInPlace(a, fromIndex, mid);
        Sorting.mergeSortInPlace(a, mid, toIndex);
        if (a[mid - 1] <= a[mid]) {
            return;
        }
        Sorting.inplace_merge(a, fromIndex, mid, toIndex);
    }

    public static void quickSort(byte[] a, int fromIndex, int toIndex, ByteComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(char[] a, int fromIndex, int toIndex, CharComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(double[] a, int fromIndex, int toIndex, DoubleComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(float[] a, int fromIndex, int toIndex, FloatComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(long[] a, int fromIndex, int toIndex, LongComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(Object[] a) {
        Sorting.quickSort1(a, 0, a.length);
    }

    public static void quickSort(Object[] a, int fromIndex, int toIndex) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void quickSort(Object[] a, int fromIndex, int toIndex, Comparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    public static void quickSort(Object[] a, Comparator c) {
        Sorting.quickSort1(a, 0, a.length, c);
    }

    public static void quickSort(short[] a, int fromIndex, int toIndex, ShortComparator c) {
        Sorting.rangeCheck(a.length, fromIndex, toIndex);
        Sorting.quickSort1(a, fromIndex, toIndex - fromIndex, c);
    }

    private static void quickSort1(byte[] x, int off, int len, ByteComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        byte v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(char[] x, int off, int len, CharComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        char v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(double[] x, int off, int len, DoubleComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(float[] x, int off, int len, FloatComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(int[] x, int off, int len, IntComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(long[] x, int off, int len, LongComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(Object[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && ((Comparable)x[j - 1]).compareTo((Comparable)x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s);
                m = Sorting.med3(x, m - s, m, m + s);
                n = Sorting.med3(x, n - 2 * s, n - s, n);
            }
            m = Sorting.med3(x, l, m, n);
        }
        Comparable v = (Comparable)x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = ((Comparable)x[b]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = ((Comparable)x[c]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s);
        }
    }

    private static void quickSort1(Object[] x, int off, int len, Comparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        Object v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void quickSort1(short[] x, int off, int len, ShortComparator comp) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    Sorting.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sorting.med3(x, l, l + s, l + 2 * s, comp);
                m = Sorting.med3(x, m - s, m, m + s, comp);
                n = Sorting.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = Sorting.med3(x, l, m, n, comp);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    Sorting.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sorting.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sorting.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sorting.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sorting.quickSort1(x, off, s, comp);
        }
        if ((s = d - c) > 1) {
            Sorting.quickSort1(x, n - s, s, comp);
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(Object[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sorting.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }
}

