/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix1D;

public class DenseObjectMatrix1D
extends ObjectMatrix1D {
    protected Object[] elements;

    public DenseObjectMatrix1D(Object[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseObjectMatrix1D(int size) {
        this.setUp(size);
        this.elements = new Object[size];
    }

    protected DenseObjectMatrix1D(int size, Object[] elements, int zero, int stride) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public ObjectMatrix1D assign(Object[] values) {
        if (this.isNoView) {
            if (values.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
            }
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            super.assign(values);
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectFunction function) {
        int s = this.stride;
        int i = this.index(0);
        Object[] elems = this.elements;
        if (this.elements == null) {
            throw new InternalError();
        }
        int k = this.size;
        while (--k >= 0) {
            elems[i] = function.apply(elems[i]);
            i += s;
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectMatrix1D source) {
        if (!(source instanceof DenseObjectMatrix1D)) {
            return super.assign(source);
        }
        DenseObjectMatrix1D other = (DenseObjectMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            ObjectMatrix1D c = other.copy();
            if (!(c instanceof DenseObjectMatrix1D)) {
                return super.assign(source);
            }
            other = (DenseObjectMatrix1D)c;
        }
        Object[] elems = this.elements;
        Object[] otherElems = other.elements;
        if (this.elements == null || otherElems == null) {
            throw new InternalError();
        }
        int s = this.stride;
        int ys = other.stride;
        int index = this.index(0);
        int otherIndex = other.index(0);
        int k = this.size;
        while (--k >= 0) {
            elems[index] = otherElems[otherIndex];
            index += s;
            otherIndex += ys;
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectMatrix1D y, ObjectObjectFunction function) {
        if (!(y instanceof DenseObjectMatrix1D)) {
            return super.assign(y, function);
        }
        DenseObjectMatrix1D other = (DenseObjectMatrix1D)y;
        this.checkSize(y);
        Object[] elems = this.elements;
        Object[] otherElems = other.elements;
        if (this.elements == null || otherElems == null) {
            throw new InternalError();
        }
        int s = this.stride;
        int ys = other.stride;
        int index = this.index(0);
        int otherIndex = other.index(0);
        int k = this.size;
        while (--k >= 0) {
            elems[index] = function.apply(elems[index], otherElems[otherIndex]);
            index += s;
            otherIndex += ys;
        }
        return this;
    }

    @Override
    public Object getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D otherMatrix = (SelectedDenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D otherMatrix = (DenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    public ObjectMatrix1D like(int size) {
        return new DenseObjectMatrix1D(size);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int index, Object value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    @Override
    public void swap(ObjectMatrix1D other) {
        DenseObjectMatrix1D y;
        if (!(other instanceof DenseObjectMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseObjectMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        Object[] elems = this.elements;
        Object[] otherElems = y.elements;
        if (this.elements == null || otherElems == null) {
            throw new InternalError();
        }
        int s = this.stride;
        int ys = y.stride;
        int index = this.index(0);
        int otherIndex = y.index(0);
        int k = this.size;
        while (--k >= 0) {
            Object tmp = elems[index];
            elems[index] = otherElems[otherIndex];
            otherElems[otherIndex] = tmp;
            index += s;
            otherIndex += ys;
        }
    }

    @Override
    public void toArray(Object[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseObjectMatrix1D(this.elements, offsets);
    }
}

