/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix3D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class SparseDoubleMatrix3D
extends DoubleMatrix3D {
    protected AbstractIntDoubleMap elements;

    public SparseDoubleMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseDoubleMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix3D(int slices, int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(slices, rows, columns);
        this.elements = new OpenIntDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseDoubleMatrix3D(int slices, int rows, int columns, AbstractIntDoubleMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix3D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public double getQuick(int slice, int row, int column) {
        return this.elements.get(this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        if (other instanceof SelectedSparseDoubleMatrix3D) {
            SelectedSparseDoubleMatrix3D otherMatrix = (SelectedSparseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix3D) {
            SparseDoubleMatrix3D otherMatrix = (SparseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new SparseDoubleMatrix3D(slices, rows, columns);
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseDoubleMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    public void setQuick(int slice, int row, int column, double value) {
        int index = this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        if (value == 0.0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDoubleMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

