/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;
import cern.colt.matrix.linalg.SeqBlas;
import cern.colt.matrix.linalg.Smp;

public class SmpBlas
implements Blas {
    public static Blas smpBlas = SeqBlas.seqBlas;
    protected Blas seqBlas;
    protected Smp smp;
    protected int maxThreads;
    protected static int NN_THRESHOLD = 30000;

    protected SmpBlas(int maxThreads, Blas seqBlas) {
        this.seqBlas = seqBlas;
        this.maxThreads = maxThreads;
        this.smp = new Smp(maxThreads);
    }

    public static void allocateBlas(int maxThreads, Blas seqBlas) {
        if (smpBlas instanceof SmpBlas) {
            SmpBlas s = (SmpBlas)smpBlas;
            if (s.maxThreads == maxThreads && s.seqBlas == seqBlas) {
                return;
            }
        }
        smpBlas = maxThreads <= 1 ? seqBlas : new SmpBlas(maxThreads, seqBlas);
    }

    @Override
    public void assign(DoubleMatrix2D A, final DoubleFunction function) {
        this.run(A, false, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                SmpBlas.this.seqBlas.assign(AA, function);
                return 0.0;
            }
        });
    }

    @Override
    public void assign(DoubleMatrix2D A, DoubleMatrix2D B, final DoubleDoubleFunction function) {
        this.run(A, B, false, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                SmpBlas.this.seqBlas.assign(AA, BB, function);
                return 0.0;
            }
        });
    }

    @Override
    public double dasum(DoubleMatrix1D x) {
        return this.seqBlas.dasum(x);
    }

    @Override
    public void daxpy(double alpha, DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.daxpy(alpha, x, y);
    }

    @Override
    public void daxpy(double alpha, DoubleMatrix2D A, DoubleMatrix2D B) {
        this.seqBlas.daxpy(alpha, A, B);
    }

    @Override
    public void dcopy(DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.dcopy(x, y);
    }

    @Override
    public void dcopy(DoubleMatrix2D A, DoubleMatrix2D B) {
        this.seqBlas.dcopy(A, B);
    }

    @Override
    public double ddot(DoubleMatrix1D x, DoubleMatrix1D y) {
        return this.seqBlas.ddot(x, y);
    }

    @Override
    public void dgemm(final boolean transposeA, final boolean transposeB, final double alpha, DoubleMatrix2D A, DoubleMatrix2D B, final double beta, DoubleMatrix2D C) {
        if (transposeA) {
            this.dgemm(false, transposeB, alpha, A.viewDice(), B, beta, C);
            return;
        }
        if (transposeB) {
            this.dgemm(transposeA, false, alpha, A, B.viewDice(), beta, C);
            return;
        }
        int m = A.rows();
        int n = A.columns();
        int p = B.columns();
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + A.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + A.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (A == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)m * (long)n * (long)p;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)this.maxThreads);
        boolean splitB = p >= noOfTasks;
        int width = splitB ? p : m;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            this.seqBlas.dgemm(transposeA, transposeB, alpha, A, B, beta, C);
            return;
        }
        int span = width / noOfTasks;
        final FJTask[] subTasks = new FJTask[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            DoubleMatrix2D CC;
            DoubleMatrix2D BB;
            DoubleMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = A;
                BB = B.viewPart(0, offset, n, span);
                CC = C.viewPart(0, offset, m, span);
            } else {
                AA = A.viewPart(offset, 0, span, n);
                BB = B;
                CC = C.viewPart(offset, 0, span, p);
            }
            subTasks[i] = new FJTask(){

                public void run() {
                    SmpBlas.this.seqBlas.dgemm(transposeA, transposeB, alpha, AA, BB, beta, CC);
                }
            };
        }
        try {
            this.smp.taskGroup.invoke((Runnable)new FJTask(){

                public void run() {
                    4.coInvoke((FJTask[])subTasks);
                }
            });
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
    }

    @Override
    public void dgemv(final boolean transposeA, final double alpha, DoubleMatrix2D A, final DoubleMatrix1D x, final double beta, DoubleMatrix1D y) {
        if (transposeA) {
            this.dgemv(false, alpha, A.viewDice(), x, beta, y);
            return;
        }
        int m = A.rows();
        int n = A.columns();
        long flops = 2L * (long)m * (long)n;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)this.maxThreads);
        int width = A.rows();
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            this.seqBlas.dgemv(transposeA, alpha, A, x, beta, y);
            return;
        }
        int span = width / noOfTasks;
        final FJTask[] subTasks = new FJTask[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            final DoubleMatrix2D AA = A.viewPart(offset, 0, span, n);
            final DoubleMatrix1D yy = y.viewPart(offset, span);
            subTasks[i] = new FJTask(){

                public void run() {
                    SmpBlas.this.seqBlas.dgemv(transposeA, alpha, AA, x, beta, yy);
                }
            };
        }
        try {
            this.smp.taskGroup.invoke((Runnable)new FJTask(){

                public void run() {
                    6.coInvoke((FJTask[])subTasks);
                }
            });
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
    }

    @Override
    public void dger(double alpha, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A) {
        this.seqBlas.dger(alpha, x, y, A);
    }

    @Override
    public double dnrm2(DoubleMatrix1D x) {
        return this.seqBlas.dnrm2(x);
    }

    @Override
    public void drot(DoubleMatrix1D x, DoubleMatrix1D y, double c, double s) {
        this.seqBlas.drot(x, y, c, s);
    }

    @Override
    public void drotg(double a, double b, double[] rotvec) {
        this.seqBlas.drotg(a, b, rotvec);
    }

    @Override
    public void dscal(double alpha, DoubleMatrix1D x) {
        this.seqBlas.dscal(alpha, x);
    }

    @Override
    public void dscal(double alpha, DoubleMatrix2D A) {
        this.seqBlas.dscal(alpha, A);
    }

    @Override
    public void dswap(DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.dswap(x, y);
    }

    @Override
    public void dswap(DoubleMatrix2D A, DoubleMatrix2D B) {
        this.seqBlas.dswap(A, B);
    }

    @Override
    public void dsymv(boolean isUpperTriangular, double alpha, DoubleMatrix2D A, DoubleMatrix1D x, double beta, DoubleMatrix1D y) {
        this.seqBlas.dsymv(isUpperTriangular, alpha, A, x, beta, y);
    }

    @Override
    public void dtrmv(boolean isUpperTriangular, boolean transposeA, boolean isUnitTriangular, DoubleMatrix2D A, DoubleMatrix1D x) {
        this.seqBlas.dtrmv(isUpperTriangular, transposeA, isUnitTriangular, A, x);
    }

    @Override
    public int idamax(DoubleMatrix1D x) {
        return this.seqBlas.idamax(x);
    }

    protected double[] run(DoubleMatrix2D A, DoubleMatrix2D B, boolean collectResults, Matrix2DMatrix2DFunction fun) {
        double[] results;
        DoubleMatrix2D[][] blocks = this.smp.splitBlockedNN(A, B, NN_THRESHOLD, A.rows() * A.columns());
        int b = blocks != null ? blocks[0].length : 1;
        double[] dArray = results = collectResults ? new double[b] : null;
        if (blocks == null) {
            double result = fun.apply(A, B);
            if (collectResults) {
                results[0] = result;
            }
            return results;
        }
        this.smp.run(blocks[0], blocks[1], results, fun);
        return results;
    }

    protected double[] run(DoubleMatrix2D A, boolean collectResults, Matrix2DMatrix2DFunction fun) {
        double[] results;
        DoubleMatrix2D[] blocks = this.smp.splitBlockedNN(A, NN_THRESHOLD, A.rows() * A.columns());
        int b = blocks != null ? blocks.length : 1;
        double[] dArray = results = collectResults ? new double[b] : null;
        if (blocks == null) {
            double result = fun.apply(A, null);
            if (collectResults) {
                results[0] = result;
            }
            return results;
        }
        this.smp.run(blocks, null, results, fun);
        return results;
    }

    public void stats() {
        if (this.smp != null) {
            this.smp.stats();
        }
    }

    private double xsum(DoubleMatrix2D A) {
        double[] sums = this.run(A, true, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                return AA.zSum();
            }
        });
        double sum = 0.0;
        int i = sums.length;
        while (--i >= 0) {
            sum += sums[i];
        }
        return sum;
    }
}

