/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;

public class LeftJoin
extends BinaryTupleOperator {
    private ValueExpr condition;

    public LeftJoin() {
    }

    public LeftJoin(TupleExpr leftArg, TupleExpr rightArg) {
        super(leftArg, rightArg);
    }

    public LeftJoin(TupleExpr leftArg, TupleExpr rightArg, ValueExpr condition) {
        this(leftArg, rightArg);
        this.setCondition(condition);
    }

    public ValueExpr getCondition() {
        return this.condition;
    }

    public void setCondition(ValueExpr condition) {
        if (condition != null) {
            condition.setParentNode(this);
        }
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(16);
        bindingNames.addAll(this.getLeftArg().getBindingNames());
        bindingNames.addAll(this.getRightArg().getBindingNames());
        return bindingNames;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        return this.getLeftArg().getAssuredBindingNames();
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.condition != null) {
            this.condition.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.condition == current) {
            this.setCondition((ValueExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LeftJoin && super.equals(other)) {
            ValueExpr oCond = ((LeftJoin)other).getCondition();
            return this.nullEquals(this.condition, oCond);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ "LeftJoin".hashCode();
        if (this.hasCondition()) {
            result ^= this.getCondition().hashCode();
        }
        return result;
    }

    @Override
    public LeftJoin clone() {
        LeftJoin clone = (LeftJoin)super.clone();
        if (this.hasCondition()) {
            clone.setCondition(this.getCondition().clone());
        }
        return clone;
    }
}

