/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public final class OntologyUtils {
    private static final String AXIOM_CANNOT_BE_NULL = "axiom cannot be null";
    private static final String ONTOLOGIES_CANNOT_BE_NULL = "ontologies cannot be null";

    private OntologyUtils() {
    }

    public static boolean containsUnreferencedEntity(OWLOntology ontology, OWLClassExpression desc) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        OWLAPIPreconditions.checkNotNull(desc, "desc cannot be null");
        return desc.signature().anyMatch(e -> !ontology.containsEntityInSignature((OWLEntity)e) && !OntologyUtils.thingOrNothing(e));
    }

    protected static boolean thingOrNothing(OWLEntity entity) {
        return entity.isOWLClass() && (entity.isTopEntity() || entity.isBottomEntity());
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom axiom, Stream<OWLOntology> ontologies) {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        OWLAPIPreconditions.checkNotNull(axiom, AXIOM_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull(ontologies, ONTOLOGIES_CANNOT_BE_NULL);
        ontologies.filter(o -> o.containsAxiom(axiom)).forEach(ont -> {
            modifiedOnts.add((OWLOntology)ont);
            ont.remove(axiom);
        });
        return modifiedOnts;
    }

    @Deprecated
    public static void addAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
        OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        OWLAPIPreconditions.checkNotNull(axiom, AXIOM_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull(ontologies, ONTOLOGIES_CANNOT_BE_NULL);
        OntologyUtils.addAxiom(axiom, ontologies.stream());
    }

    public static void addAxiom(OWLAxiom axiom, Stream<OWLOntology> ontologies) {
        OWLAPIPreconditions.checkNotNull(axiom, AXIOM_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull(ontologies, ONTOLOGIES_CANNOT_BE_NULL);
        ontologies.forEach(o -> o.add(axiom));
    }
}

