/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.oboformat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIOwl2Obo;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.writer.OBOFormatWriter;
import org.semanticweb.owlapi.io.OWLRenderer;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OBOFormatRenderer
implements OWLRenderer {
    public static void render(OWLOntology ontology, Writer writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        try {
            OBOFormatWriter.NameProvider nameProvider;
            boolean hasImports;
            OWLAPIOwl2Obo translator = new OWLAPIOwl2Obo(ontology.getOWLOntologyManager());
            OBODoc result = translator.convert(ontology);
            boolean bl = hasImports = !OWLAPIStreamUtils.asList(ontology.imports()).isEmpty();
            if (hasImports) {
                final OBOFormatWriter.OBODocNameProvider primary = new OBOFormatWriter.OBODocNameProvider(result);
                final OBOFormatWriter.OWLOntologyNameProvider secondary = new OBOFormatWriter.OWLOntologyNameProvider(ontology, primary.getDefaultOboNamespace());
                nameProvider = new OBOFormatWriter.NameProvider(){

                    @Override
                    @Nullable
                    public String getName(String id) {
                        String name = primary.getName(id);
                        if (name != null) {
                            return name;
                        }
                        return secondary.getName(id);
                    }

                    @Override
                    @Nullable
                    public String getDefaultOboNamespace() {
                        return primary.getDefaultOboNamespace();
                    }
                };
            } else {
                nameProvider = new OBOFormatWriter.OBODocNameProvider(result);
            }
            OBOFormatWriter oboFormatWriter = new OBOFormatWriter();
            oboFormatWriter.setCheckStructure(format.getParameter((Serializable)((Object)"obo.validation"), Boolean.TRUE));
            oboFormatWriter.write(result, (Writer)new PrintWriter(new BufferedWriter(writer)), nameProvider);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    public void render(OWLOntology ontology, OutputStream os) throws OWLOntologyStorageException {
        OBOFormatRenderer.render(ontology, new OutputStreamWriter(os), ontology.getNonnullFormat());
    }
}

