/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.io.IOException;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFXMLParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new RDFXMLDocumentFormatFactory();
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        try {
            final RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
            RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(@Nullable String prefix, @Nullable String uri) throws SAXException {
                    super.startPrefixMapping(prefix, uri);
                    if (prefix != null && uri != null) {
                        format.setPrefix(prefix, uri);
                    }
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, configuration);
            consumer.setIRIProvider(parser);
            consumer.setOntologyFormat(format);
            InputSource is = this.getInputSource(documentSource, configuration);
            parser.parse(is, consumer);
            return format;
        }
        catch (IOException | OWLOntologyInputSourceException | RDFParserException | SAXException e) {
            throw new OWLRDFXMLParserException(e);
        }
    }
}

