/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredClassAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class InferredSubClassAxiomGenerator
extends InferredClassAxiomGenerator<OWLSubClassOfAxiom> {
    @Override
    protected void addAxioms(OWLClass entity, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLSubClassOfAxiom> result) {
        OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        if (reasoner.isSatisfiable(entity)) {
            reasoner.getSuperClasses((OWLClassExpression)entity, true).entities().forEach(sup -> result.add(dataFactory.getOWLSubClassOfAxiom(entity, (OWLClassExpression)sup)));
        } else {
            result.add(dataFactory.getOWLSubClassOfAxiom(entity, dataFactory.getOWLNothing()));
        }
    }

    @Override
    public String getLabel() {
        return "Subclasses";
    }
}

